/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.types.alertlocs;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.types.AlertLocation;
import com.aem.shelp.proxy.types.Machine;
import com.aem.shelp.proxy.types.filters.MachineFilter;
import com.aem.shelp.proxy.types.filters.SimpleMachineFilter;
import com.aem.shelp.proxy.types.interfaces.MachineRegistryInterface;
import com.aem.shelp.tech.utils.filters.FilterLogicUtil;
import java.util.ArrayList;
import utils.message.Message;

public class MachineFilterAloc
extends AlertLocation {
    public static final Object ID = "MachineFilterAloc";
    private MachineFilter[] filters = new MachineFilter[0];
    private SimpleMachineFilter simpleMachineFilter;

    public void setFilters(MachineFilter[] filters, SimpleMachineFilter simpleMachineFilter) {
        this.filters = filters;
        this.simpleMachineFilter = simpleMachineFilter;
    }

    public MachineFilter[] getFiltersAdvanced() {
        return this.filters;
    }

    public SimpleMachineFilter getFilterSimple() {
        return this.simpleMachineFilter;
    }

    @Override
    public boolean isServerLocated() {
        return false;
    }

    @Override
    public String[] getTargetMachines(MachineRegistryInterface macreg, ArrayList<Machine> allMachines, long round) {
        ArrayList<Machine> shown = FilterLogicUtil.getShownMachines(this.filters, this.simpleMachineFilter, allMachines);
        String[] ids = new String[shown.size()];
        for (int i = 0; i < ids.length; ++i) {
            ids[i] = shown.get(i).getMachineID();
        }
        return ids;
    }

    @Override
    public void toMessage(Message m) {
        super.toMessage(m);
        if (this.filters == null) {
            m.append((Message)null);
        } else {
            m.append(MachineFilter.toMessage(this.filters));
        }
        if (this.simpleMachineFilter == null) {
            m.append((Message)null);
        } else {
            m.append(SimpleMachineFilter.toMessage(this.simpleMachineFilter));
        }
    }

    @Override
    public void fromMessage(Message m) {
        super.fromMessage(m);
        this.filters = MachineFilter.filtersFromMessage(m.getNextMessage());
        if (this.version >= 14) {
            this.simpleMachineFilter = SimpleMachineFilter.fromMessage(m.getNextMessage());
        }
    }

    @Override
    public String getMachineSummary() {
        return Language.get("MACHINE_PICKER_FILTER");
    }
}

