/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.types;

import utils.string.CharStack;
import utils.xml.XML14Util;

public class TypeUtil {
    public static void append(StringBuffer xml, String tag, String content, int indent) {
        if (content != null) {
            for (int i = 0; i < indent; ++i) {
                xml.append("\t");
            }
            xml.append("<").append(tag).append(">").append(XML14Util.escape((String)content)).append("</").append(tag).append(">\n");
        }
    }

    public static void append(StringBuffer xml, String tag, boolean content, int indent) {
        for (int i = 0; i < indent; ++i) {
            xml.append("\t");
        }
        xml.append("<").append(tag).append(">").append(Boolean.toString(content)).append("</").append(tag).append(">\n");
    }

    public static void append(StringBuffer xml, String tag, String content, String id, int indent) {
        if (content != null) {
            for (int i = 0; i < indent; ++i) {
                xml.append("\t");
            }
            xml.append("<").append(tag).append(" id=\"").append(id).append("\">").append(XML14Util.escape((String)content)).append("</").append(tag).append(">\n");
        }
    }

    public static void append(StringBuffer xml, String tag, long content, int indent) {
        for (int i = 0; i < indent; ++i) {
            xml.append("\t");
        }
        xml.append("<").append(tag).append(">").append(Long.toString(content)).append("</").append(tag).append(">\n");
    }

    public static void fromXML(String xml, XMLListener listener) {
        TypeUtil.fromXML(xml, listener, true);
    }

    public static void fromXML(String xml, XMLListener listener, boolean popRoot) {
        CharStack stack = new CharStack(xml);
        String rootTag = null;
        if (popRoot) {
            rootTag = stack.popXmlElementStart();
            stack.popXmlElementEnd();
        }
        String element = stack.popXmlElementStart();
        String attributeName = stack.popXmlAttributeName();
        String attributeValue = null;
        if (attributeName != null && attributeName.length() > 0) {
            attributeValue = stack.popXmlAttributeValue();
        }
        stack.popXmlElementEnd();
        while (!stack.isEmpty() && element != null && !element.equals(rootTag)) {
            if (!element.startsWith("/")) {
                if (attributeName == null) {
                    listener.handleXMLElement(element, stack.popXmlSubTree(true), null);
                } else {
                    listener.handleXMLElement(element, stack.popXmlSubTree(true), attributeValue);
                }
            }
            element = stack.popXmlElementStart();
            attributeName = stack.popXmlAttributeName();
            if (stack.isEmpty()) continue;
            if (attributeName != null && attributeName.length() > 0) {
                attributeValue = stack.popXmlAttributeValue();
            }
            stack.popXmlElementEnd();
        }
    }

    public static String getTabString(int tabCount) {
        if (tabCount == 0) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < tabCount; ++i) {
            buffer.append("\t");
        }
        return buffer.toString();
    }

    static interface XMLListener {
        public void handleXMLElement(String var1, String var2, String var3);
    }
}

