/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.types;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.types.AbstractSession;
import com.aem.shelp.proxy.types.Customer;
import com.aem.shelp.proxy.types.TypeUtil;
import java.util.Properties;
import java.util.Random;
import utils.message.Message;

public class SupportSession
extends AbstractSession {
    public static final String[] testTechnicianNames = new String[]{"Splinter", "Leonardo", "Raphael", "Donatello", "Michaelangelo"};

    public SupportSession(Customer customer) {
        super(customer);
        this.setSessionID(customer.getCustomerID());
    }

    public SupportSession() {
        this(new Customer(0));
    }

    @Override
    public Message toMessage() {
        Message m = new Message(0);
        super.toMessage(m);
        return m;
    }

    public Customer getCustomer() {
        return (Customer)super.getRemoteMachine();
    }

    public static String[] toString(SupportSession[] sessions) {
        String[] result = new String[sessions.length];
        for (int i = 0; i < sessions.length; ++i) {
            result[i] = sessions[i].toString();
        }
        return result;
    }

    @Override
    public String toString() {
        return super.toString();
    }

    public String getValue(String key, boolean ignoreCase) {
        Customer customer = this.getCustomer();
        String result = customer.getValue(key, ignoreCase);
        if (result != null) {
            return result;
        }
        if (ignoreCase ? key.equalsIgnoreCase("TECHNICIAN") || key.equalsIgnoreCase(Language.get("TECHNICIAN")) : key.equals("TECHNICIAN") || key.equals(Language.get("TECHNICIAN"))) {
            return super.getTechnicianDisplayName();
        }
        return null;
    }

    public static SupportSession createTestSession() {
        Customer customer = Customer.createTestCustomer();
        SupportSession session = new SupportSession(customer);
        Random r = new Random();
        String displayName = testTechnicianNames[r.nextInt(testTechnicianNames.length)];
        String username = displayName.replace(' ', '_').toLowerCase();
        session.setTechnicianDisplayName(displayName);
        session.setTechnicianUsername(username);
        session.setDuration(r.nextInt(300000));
        session.setSessionID(System.currentTimeMillis() + "" + r.nextInt());
        session.setStartTime(System.currentTimeMillis() - (long)r.nextInt());
        session.setPostSessionChat("Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.\n\n\nLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.\n\n\nLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.\n\n\nLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.\n\n\nLorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.");
        session.setPostSessionComments("Lorem ipsum dolor sit amet, consectetur adipisicing elit, sed do eiusmod tempor incididunt ut labore et dolore magna aliqua. Ut enim ad minim veniam, quis nostrud exercitation ullamco laboris nisi ut aliquip ex ea commodo consequat. Duis aute irure dolor in reprehenderit in voluptate velit esse cillum dolore eu fugiat nulla pariatur. Excepteur sint occaecat cupidatat non proident, sunt in culpa qui officia deserunt mollit anim id est laborum.");
        return session;
    }

    @Override
    public String getDescription() {
        Customer customer = this.getCustomer();
        return customer.getUsefulHumanReadableName();
    }

    @Override
    public String getAdditionalDescription() {
        return "";
    }

    @Override
    public String getRootTag() {
        return "SupportSession";
    }

    public static SupportSession fromXML(String xml) {
        SupportSession session = new SupportSession(new Customer(0));
        TypeUtil.fromXML(xml, session);
        return session;
    }

    @Override
    public void toProperties(Properties properties) {
        super.toProperties(properties);
    }
}

