/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.techclient;

import com.aem.shelp.common.IPC;
import com.aem.shelp.common.properties.SessionProperties;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.tech.TechHelpUIArguments;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import jwrapper.jwutils.JWSockIPC;
import jwrapper.jwutils.JWSockIPCListener;
import utils.message.BasicSTTransactionClient;
import utils.message.BasicSTTransactionServer;
import utils.message.MTTransactionServer;
import utils.message.Message;
import utils.message.TransactionListener;
import utils.message.TransactionServerListener;
import utils.switches.Switches;

public class TechClientIPCHandler
extends Thread
implements JWSockIPCListener,
TransactionListener,
TransactionServerListener {
    private Properties populatedProperties;
    private JWSockIPC ipc;
    private TechClient tc;
    private TechClient.HeadlessMessageListener messageListener;
    private BasicSTTransactionClient transactionClient;

    public TechClientIPCHandler(TechClient tc, Properties populatedProperties, TechClient.PortForwardRequest portForwardRequest) throws IOException {
        super("TechClientIPCHandler");
        this.populatedProperties = populatedProperties;
        this.tc = tc;
        if (portForwardRequest != null) {
            this.messageListener = portForwardRequest.messageListener;
            this.messageListener.registerIPCHandler(this);
        }
        this.start();
    }

    @Override
    public void run() {
        try {
            System.out.println("[TechClientIPCHandler] Starting up IPC to TechHelpUI");
            this.ipc = JWSockIPC.connectParent((Properties)this.populatedProperties);
            this.ipc.setupMultipleChannels();
        }
        catch (Throwable t) {
            System.out.println("[TechClientIPCHandler] Unable to start up IPC comms.");
            t.printStackTrace();
            return;
        }
        this.ipc.setupPingsAndReportClosure((JWSockIPCListener)this, (short)999, 20000L);
        InputStream sockIn = this.ipc.getInChannel(IPC.SESSION_UI_IPC_MESSAGE_CHANNEL);
        OutputStream sockOut = this.ipc.getOutChannel(IPC.SESSION_UI_IPC_MESSAGE_CHANNEL);
        new BasicSTTransactionServer(sockIn, sockOut, this);
        if (Switches.SH_tabbedSessions && !Switches.SH_sessionsInTechUiProcess) {
            sockIn = this.ipc.getInChannel(IPC.SESSION_UI_IPC_LAUNCH_CHANNEL);
            sockOut = this.ipc.getOutChannel(IPC.SESSION_UI_IPC_LAUNCH_CHANNEL);
            this.transactionClient = new BasicSTTransactionClient(sockIn, sockOut);
        }
    }

    public boolean isConnected() {
        return this.ipc != null;
    }

    public void ipcClosed() {
        System.out.println("[TechClientIPCHandler] IPC Closed.");
        this.die();
    }

    private void die() {
        try {
            if (this.ipc != null) {
                this.ipc.close();
            }
        }
        catch (Throwable throwable) {
        }
        finally {
            this.ipc = null;
        }
        try {
            this.messageListener.sessionClosed();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public Message doTransaction(Message m) {
        Message ret;
        try {
            switch (m.getType()) {
                case 4096: {
                    ret = new Message(1);
                    System.out.println("[TechClientIPCHandler] Got session properties over IPC.");
                    byte[] session = m.getNextByteArray();
                    if (session != null && session.length > 0) {
                        SessionProperties.INSTANCE.reinitFrom(session);
                    }
                    break;
                }
                case 4097: {
                    try {
                        ret = this.tc.getProxyEntireMachineGroupList();
                        ret.setType(4097);
                    }
                    catch (Exception e) {
                        ret = new Message(-1);
                        e.printStackTrace();
                    }
                    break;
                }
                case 4098: {
                    String message = m.getNextString();
                    this.messageListener.newMessage(message);
                    ret = new Message(1);
                    break;
                }
                case 4103: {
                    System.out.println("[TechClientIPCHandler] Received new session token");
                    byte[] newToken = m.getNextByteArray();
                    this.tc.overwriteSessionID(newToken);
                    ret = new Message(1);
                    break;
                }
                case 4099: {
                    this.messageListener.sessionConnected();
                    ret = new Message(1);
                    break;
                }
                case 4100: {
                    this.messageListener.setLocalPort(m.getNextInt());
                    ret = new Message(1);
                    break;
                }
                case 4101: {
                    String password = this.messageListener.getMachinePassword();
                    ret = new Message(1);
                    ret.append(password);
                    break;
                }
                default: {
                    ret = new Message(-1);
                    break;
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            ret = new Message(-1);
        }
        return ret;
    }

    @Override
    public void serverEnding(MTTransactionServer server, TransactionListener tl) {
        this.die();
    }

    public void launchSession(TechHelpUIArguments args) throws IOException {
        Message m = new Message(4102);
        m.append(args.getSerialisedProperties());
        this.transactionClient.doTransaction(m);
    }
}

