/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.logging.targets.notifytech;

import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.ServerNotificationUtil;
import com.aem.shelp.proxy.common.Notification;
import com.aem.shelp.proxy.common.ProxyServerAPI;
import com.aem.shelp.proxy.logging.alerts.LocatedAlertLogEvent;
import com.aem.shelp.proxy.logging.targets.notifytech.NotifyTechTargetUI;
import java.util.ArrayList;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import utils.loggingframework.events.LogEvent;
import utils.loggingframework.targets.AbstractTarget;
import utils.loggingframework.targets.LocatableTarget;
import utils.loggingframework.targets.TargetUI;
import utils.loggingframework.targets.VariableUtil;
import utils.message.Message;
import utils.xml.XML14Util;

public class NotifyTechTarget
extends AbstractTarget
implements LocatableTarget {
    public static final String ID = "NotifyTechTarget";
    private int[] techniciansToNotify;
    private String[] technicianNames;
    private int[] groupsToNotify;
    private String[] groupNames;
    private boolean notifyAllTechnicians;
    public boolean perMachine;
    private String title = null;
    private String message = null;
    private static ProxyServerAPI proxyServerAPI;

    public static void setProxyServerAPI(ProxyServerAPI proxyServerAPI) {
        NotifyTechTarget.proxyServerAPI = proxyServerAPI;
    }

    public String[] getGroupNames() {
        return this.groupNames;
    }

    public String[] getTechNames() {
        return this.technicianNames;
    }

    public boolean notifyAllTechs() {
        return this.notifyAllTechnicians;
    }

    public int[] notifyGroups() {
        return this.groupsToNotify;
    }

    public int[] notifyTechs() {
        return this.techniciansToNotify;
    }

    public void setNotify(boolean notifyAllTechs, int[] techniciansToNotify, int[] groupsToNotify, String[] techNames, String[] groupNames) {
        this.notifyAllTechnicians = notifyAllTechs;
        this.techniciansToNotify = techniciansToNotify;
        this.groupsToNotify = groupsToNotify;
        this.technicianNames = techNames;
        this.groupNames = groupNames;
    }

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String getName() {
        return Language.get("NOTIFY_TECH_TARGET_NAME");
    }

    @Override
    public String getDescription() {
        return Language.get("NOTIFY_TECH_TARGET_DESC");
    }

    private static boolean isEmpty(String[] array) {
        if (array == null) {
            return true;
        }
        for (String s : array) {
            if (s == null || s.length() <= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public String getTargetSummary() {
        boolean hasContents;
        if (this.notifyAllTechnicians) {
            return this.getName() + " [" + Language.get("ALL_TECHNICIANS") + "]";
        }
        StringBuilder buffer = new StringBuilder();
        buffer.append(this.getName());
        boolean bl = hasContents = !NotifyTechTarget.isEmpty(this.technicianNames) || !NotifyTechTarget.isEmpty(this.groupNames);
        if (hasContents) {
            buffer.append(" [");
            boolean first = true;
            if (this.technicianNames != null) {
                for (String name : this.technicianNames) {
                    if (!first) {
                        buffer.append(", ");
                    }
                    first = false;
                    buffer.append(name);
                }
            }
            if (this.groupNames != null) {
                for (String name : this.groupNames) {
                    if (!first) {
                        buffer.append(", ");
                    }
                    first = false;
                    buffer.append(name);
                }
            }
            buffer.append("]");
        }
        return buffer.toString();
    }

    @Override
    public void logEvent(LogEvent event) throws Exception {
        Notification n;
        String message = VariableUtil.getSubstitutedText(this.message, event);
        String title = VariableUtil.getSubstitutedText(this.title, event);
        if (event instanceof LocatedAlertLogEvent) {
            LocatedAlertLogEvent lale = (LocatedAlertLogEvent)event;
            n = ServerNotificationUtil.getAlertNotification(title, message, lale.alert.getID(), lale.remoteMachine.getMachineID());
        } else {
            n = ServerNotificationUtil.getEventNotification(title, message, event.getID());
        }
        if (this.notifyAllTechnicians) {
            proxyServerAPI.notifyAllTechs(n);
        } else {
            proxyServerAPI.notifyTechsAndGroups(n, this.groupsToNotify, this.techniciansToNotify);
        }
    }

    @Override
    public boolean isAvailableTarget() {
        return true;
    }

    @Override
    public TargetUI getTargetUI() {
        return new NotifyTechTargetUI();
    }

    @Override
    protected void fromMessage(byte version, Message m) {
        this.notifyAllTechnicians = m.getNextBoolean();
        this.techniciansToNotify = m.getNextIntArray();
        this.groupsToNotify = m.getNextIntArray();
        this.technicianNames = m.getNextStringArray();
        this.groupNames = m.getNextStringArray();
        this.title = m.getNextString();
        this.message = m.getNextString();
        if (m.hasNext()) {
            this.perMachine = m.getNextBoolean();
        }
    }

    @Override
    public void toMessage(Message m) {
        super.toMessage(m);
        m.append(this.notifyAllTechnicians);
        m.append(this.techniciansToNotify);
        m.append(this.groupsToNotify);
        m.append(this.technicianNames);
        m.append(this.groupNames);
        m.append(this.title);
        m.append(this.message);
        m.append(this.perMachine);
    }

    @Override
    protected void saveToXML(StringBuffer buffer, int indent) {
        int i;
        buffer.append(XML14Util.getIndent((int)indent)).append("<").append(this.getID()).append(">\n");
        buffer.append(XML14Util.getIndent((int)(indent + 1))).append("<NotifyAllTechnicians>").append(this.notifyAllTechnicians).append("</NotifyAllTechnicians>\n");
        XML14Util.appendTextNode((StringBuffer)buffer, (int)(indent + 1), (String)"Title", (String)this.title);
        XML14Util.appendTextNode((StringBuffer)buffer, (int)(indent + 1), (String)"Message", (String)this.message);
        buffer.append(XML14Util.getIndent((int)(indent + 1))).append("<NotifyAllTechnicians>").append(this.notifyAllTechnicians).append("</NotifyAllTechnicians>\n");
        if (this.groupsToNotify != null) {
            buffer.append(XML14Util.getIndent((int)(indent + 1))).append("<GroupIDs>");
            for (i = 0; i < this.groupsToNotify.length; ++i) {
                if (i > 0) {
                    buffer.append(",");
                }
                buffer.append(i);
            }
            buffer.append("</GroupIDs>\n");
        }
        if (this.techniciansToNotify != null) {
            buffer.append(XML14Util.getIndent((int)(indent + 1))).append("<TechIDs>");
            for (i = 0; i < this.techniciansToNotify.length; ++i) {
                if (i > 0) {
                    buffer.append(",");
                }
                buffer.append(i);
            }
            buffer.append("</TechIDs>\n");
        }
        if (this.technicianNames != null) {
            buffer.append(XML14Util.getIndent((int)(indent + 1))).append("<TechNames>");
            for (String s : this.technicianNames) {
                XML14Util.appendTextNode((StringBuffer)buffer, (int)(indent + 2), (String)"TechName", (String)s);
            }
            buffer.append("</TechNames>\n");
        }
        if (this.groupNames != null) {
            buffer.append(XML14Util.getIndent((int)(indent + 1))).append("<GroupNames>");
            for (String s : this.groupNames) {
                XML14Util.appendTextNode((StringBuffer)buffer, (int)(indent + 2), (String)"GroupName", (String)s);
            }
            buffer.append("</GroupNames>\n");
        }
        XML14Util.appendTextNode((StringBuffer)buffer, (int)(indent + 1), (String)"runPerMachine", (String)("" + this.perMachine));
        buffer.append(XML14Util.getIndent((int)indent)).append("</").append(this.getID()).append(">\n");
    }

    private static int[] intSequenceToArray(String sequence) {
        if (sequence == null || sequence.length() == 0) {
            return new int[0];
        }
        String[] integerStrings = sequence.split(",");
        int[] result = new int[integerStrings.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = Integer.parseInt(integerStrings[i]);
        }
        return result;
    }

    @Override
    protected void loadFromXML(Element root) {
        this.notifyAllTechnicians = Boolean.parseBoolean(XML14Util.getChildText((Element)root, (String)"NotifyAllTechnicians", (String)"false"));
        String groupIDs = XML14Util.getChildText((Element)root, (String)"GroupIDs", null);
        this.groupsToNotify = NotifyTechTarget.intSequenceToArray(groupIDs);
        String techIDs = XML14Util.getChildText((Element)root, (String)"TechIDs", null);
        this.techniciansToNotify = NotifyTechTarget.intSequenceToArray(techIDs);
        this.title = XML14Util.getChildText((Element)root, (String)"Title", null);
        this.message = XML14Util.getChildText((Element)root, (String)"Message", null);
        ArrayList<String> result = new ArrayList<String>();
        Element child = XML14Util.getChild((Element)root, (String)"GroupNames");
        ArrayList groupNameResults = XML14Util.getChildrenByName((Element)child, (String)"GroupName");
        for (Object e : groupNameResults) {
            result.add(XML14Util.getTextContent((Node)e));
        }
        this.groupNames = result.toArray(new String[0]);
        result.clear();
        child = XML14Util.getChild((Element)root, (String)"TechNames");
        ArrayList techNameResults = XML14Util.getChildrenByName((Element)child, (String)"TechName");
        for (Element e : techNameResults) {
            result.add(XML14Util.getTextContent((Node)e));
        }
        this.technicianNames = result.toArray(new String[0]);
        try {
            this.perMachine = XML14Util.getChildText((Element)root, (String)"runPerMachine", null).equalsIgnoreCase("true");
        }
        catch (Throwable t) {
            this.perMachine = false;
        }
    }

    public void setMessage(String text) {
        this.message = text;
    }

    public void setTitle(String text) {
        this.title = text;
    }

    public String getMessage() {
        return this.message;
    }

    public String getTitle() {
        return this.title;
    }

    @Override
    public boolean runPerMachineIsOptional() {
        return true;
    }

    @Override
    public boolean runPerMachine() {
        return this.perMachine;
    }

    @Override
    public void setRunPerMachine(boolean b) {
        this.perMachine = b;
    }
}

