/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.logging.access;

import com.aem.sgateway.SGGroupUtil;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.logging.SimpleHelpLogEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.io.File;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.JLabel;
import javax.swing.JPanel;
import utils.loggingframework.events.LogEvent;
import utils.xml.XML14Util;

public class RemoteMachineOfflineExtended
extends SimpleHelpLogEvent {
    public static final String ID = "RemoteMachineOfflineExt";
    public String remoteMachine;
    public String machineName;
    public String machineGroups;
    public String sourceIpAddress;
    public long offlineDuration;

    @Override
    public String getID() {
        return ID;
    }

    @Override
    public String getDisplayName() {
        return Language.DEFLANG.getString("EVENT_MACHINE_OFFLINE_EXT_NAME");
    }

    @Override
    public String getDescription() {
        return "A remote access machine is no longer responding (extended duration).";
    }

    @Override
    public String getLogText() {
        return "[" + this.getEventID() + "] Remote machine has been offline for an extended period: " + this.remoteMachine;
    }

    @Override
    public File getEmailTemplateFile() {
        return new File("templates/access/remote_machine_offline_ext");
    }

    @Override
    public String getEventID() {
        return ID;
    }

    public static RemoteMachineOfflineExtended createEvent(String remoteMachine, String sourceIPAddress) {
        RemoteMachineOfflineExtended event = new RemoteMachineOfflineExtended();
        event.remoteMachine = remoteMachine;
        event.machineName = SGGroupUtil.getMachineName(remoteMachine);
        event.machineGroups = SGGroupUtil.getGroupsString(remoteMachine);
        event.sourceIpAddress = sourceIPAddress;
        return event;
    }

    @Override
    public JPanel generateExtraConfigPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new JLabel("Test"), "East");
        return panel;
    }

    @Override
    protected void toXML(StringBuffer buffer, int indent) {
        buffer.append(XML14Util.getIndent((int)indent)).append("<").append(this.getID()).append(">\n");
        super.addToXML(buffer, indent + 1);
        XML14Util.appendTextNode((StringBuffer)buffer, (int)(indent + 1), (String)"remoteMachine", (String)this.remoteMachine);
        if (this.machineName != null && this.machineName.length() > 0) {
            XML14Util.appendTextNode((StringBuffer)buffer, (int)(indent + 1), (String)"machineName", (String)this.machineName);
        }
        if (this.machineGroups != null && this.machineGroups.length() > 0) {
            XML14Util.appendTextNode((StringBuffer)buffer, (int)(indent + 1), (String)"machineGroups", (String)this.machineGroups);
        }
        if (this.sourceIpAddress != null && this.sourceIpAddress.length() > 0) {
            XML14Util.appendTextNode((StringBuffer)buffer, (int)(indent + 1), (String)"sourceIpAddress", (String)this.sourceIpAddress);
        }
        buffer.append(XML14Util.getIndent((int)indent)).append("</").append(this.getID()).append(">\n");
    }

    @Override
    protected void toProperties(Properties properties) {
        super.toProperties(properties);
        this.safePut(properties, "remoteMachine", this.remoteMachine);
        this.safePut(properties, "sourceIpAddress", this.sourceIpAddress);
        this.safePut(properties, "machineName", this.machineName);
        this.safePut(properties, "machineGroups", this.machineGroups);
    }

    @Override
    public void appendVariables(ArrayList<LogEvent.LogEventVariable> variableList) {
        super.appendVariables(variableList);
        variableList.add(new LogEvent.LogEventVariable("remoteMachine", null, this.remoteMachine));
        variableList.add(new LogEvent.LogEventVariable("sourceIpAddress", null, this.sourceIpAddress));
        variableList.add(new LogEvent.LogEventVariable("machineName", null, this.machineName));
        variableList.add(new LogEvent.LogEventVariable("machineGroups", null, this.machineGroups));
    }
}

