/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy.common;

import com.aem.shelp.proxy.common.notifications.AlertErrorNotification;
import com.aem.shelp.proxy.common.notifications.AlertNotification;
import com.aem.shelp.proxy.common.notifications.ReportNotification;
import java.util.Random;
import utils.message.Message;

public class Notification {
    private static final byte VERSION = 0;
    public static final byte SERVER_NOTIFICATION = 0;
    public static final byte SERVER_NOTIFICATION_RELEASE = 0;
    public static final byte SERVER_NOTIFICATION_SUPPORT_FINISHED = 1;
    public static final byte SERVER_NOTIFICATION_SUPPORT_OUT_OF_SESSIONS = 2;
    public static final byte SERVER_NOTIFICATION_ALERT_LIMIT_EXCEEDED = 3;
    public static final byte SERVER_NOTIFICATION_MEMORY_WARNING = 4;
    public static final byte SERVER_NOTIFICATION_MEMORY_ERROR = 5;
    public static final byte BROADCAST_NOTIFICATION = 1;
    public static final byte ACTION_NOTIFICATION = 2;
    public static final byte ACTION_NOTIFICATION_ALERT = 0;
    public static final byte ACTION_NOTIFICATION_LOGGING_FRAMEWORK = 1;
    public static final byte REPORT_NOTIFICATION = 3;
    public static final byte MESSAGE_NOTIFICATION = 4;
    public static final byte ERROR_NOTIFICATION = 5;
    public static final byte ERROR_NOTIFICATION_ALERT = 1;
    public byte type;
    public byte subtype;
    public long timestamp;
    public boolean read = false;
    public String title;
    public String message;
    public NotificationMetadata metadata;

    public boolean hasMetadata() {
        return this.metadata != null;
    }

    public boolean isSameTypeAs(Notification notification) {
        return this.type == notification.type && this.subtype == notification.subtype;
    }

    public boolean keepOneOfTheseNotificationsMax() {
        return this.type == 0 && this.subtype == 0 || this.type == 0 && this.subtype == 1;
    }

    public boolean equals(Object o) {
        if (o == null || !(o instanceof Notification)) {
            return false;
        }
        Notification n = (Notification)o;
        return n.type == this.type && n.subtype == this.subtype && n.timestamp == this.timestamp && n.title.equals(this.title) && n.message.equals(this.message);
    }

    private static Notification getNewNotification(byte type, byte subtype) {
        Notification n = type == 5 && subtype == 1 ? new AlertErrorNotification() : (type == 3 ? new ReportNotification() : (type == 2 && subtype == 0 ? new AlertNotification() : new Notification()));
        n.type = type;
        n.subtype = subtype;
        return n;
    }

    protected void loadMetadataFrom(Message m) {
        this.metadata = null;
    }

    protected Notification() {
    }

    public Notification(byte type, byte subtype, long timestamp, String title, String message, NotificationMetadata metadata) {
        this.type = type;
        this.subtype = subtype;
        this.timestamp = timestamp;
        this.title = title;
        this.message = message;
        this.metadata = metadata;
    }

    public static final Notification[] createTestNotifications() {
        return Notification.createTestNotifications(10);
    }

    public static final Notification[] createTestNotifications(int count) {
        Random r = new Random();
        Notification[] result = new Notification[count];
        for (int i = 0; i < count; ++i) {
            String message = "This is a sample message that is relatively long, so it will test out the truncation situation. This is a sample message that is relatively long, so it will test out the truncation situation.";
            result[i] = new Notification(0, 0, System.currentTimeMillis() - (long)(i * r.nextInt(3600000)), "Test Message " + i + " - This is a long title for testing. " + Math.abs(r.nextLong()), message, null);
            result[i].read = r.nextBoolean();
            result[i] = Notification.fromMessage(result[i].toMessage());
        }
        return result;
    }

    public Message toMessage() {
        Message m = new Message(10022000);
        m.append((byte)0);
        m.append(this.type);
        m.append(this.subtype);
        m.append(this.timestamp);
        m.append(this.read);
        if (this.title != null) {
            m.append(this.title);
        } else {
            m.append("");
        }
        if (this.message != null) {
            m.append(this.message);
        } else {
            m.append("");
        }
        if (this.metadata != null) {
            m.append(true);
            m.append(this.metadata.toMessage());
        } else {
            m.append(false);
        }
        return m;
    }

    public static Notification fromMessage(Message m) {
        byte version = m.getNextByte();
        byte type = m.getNextByte();
        byte subtype = m.getNextByte();
        Notification n = Notification.getNewNotification(type, subtype);
        n.timestamp = m.getNextLong();
        n.read = m.getNextBoolean();
        n.title = m.getNextString();
        n.message = m.getNextString();
        if (m.getNextBoolean()) {
            Message metadataMessage = m.getNextMessage();
            n.loadMetadataFrom(metadataMessage);
        }
        return n;
    }

    public boolean isReportNotification() {
        return this.type == 3;
    }

    public boolean isSupportFinishedNotification() {
        return this.type == 0 && this.subtype == 1;
    }

    public boolean isNewReleaseNotification() {
        return this.type == 0 && this.subtype == 0;
    }

    public boolean isMemoryErrorNotification() {
        return this.type == 0 && this.subtype == 5;
    }

    public boolean isMemoryWarningNotification() {
        return this.type == 0 && this.subtype == 4;
    }

    public boolean isAlertLimitExceeded() {
        return this.type == 0 && this.subtype == 3;
    }

    public boolean isAlertNotification() {
        return this.type == 2 && this.subtype == 0;
    }

    public boolean isAlertErrorNotification() {
        return this.type == 5 && this.subtype == 1;
    }

    public boolean isEventNotification() {
        return this.type == 2 && this.subtype == 1;
    }

    public boolean isBroadcastNotification() {
        return this.type == 1;
    }

    public static interface NotificationMetadata {
        public Message toMessage();

        public void fromMessage(Message var1);
    }
}

