/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.proxy;

import com.aem.sgateway.SimpleGatewayConfig;
import com.aem.shelp.proxy.techclient.TechClient;
import utils.message.Message;

public class MiniClient {
    TechClient client;
    String miniSessionID;
    boolean loginRequired;
    String sgServiceVersion;

    public MiniClient(TechClient client, String miniSessionID, String sgServiceVersion) throws Exception {
        this.client = client;
        this.miniSessionID = miniSessionID;
        this.sgServiceVersion = sgServiceVersion;
        Message m = new Message(30000);
        m = this.doTransaction(m);
        this.loginRequired = (Boolean)m.get(0);
    }

    public boolean isSgServiceVersionOrLater(int major, int minor) {
        String version = this.sgServiceVersion;
        try {
            String smajor = version.substring(0, version.indexOf(46));
            String sminor = version.substring(version.indexOf(46) + 1);
            int maj = Integer.parseInt(smajor);
            int min = Integer.parseInt(sminor);
            return maj >= major && min >= minor;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    private Message doTransaction(Message m) throws Exception {
        return this.client.doMiniClientTransaction(m, this.miniSessionID);
    }

    public SimpleGatewayConfig fetchSgConfig() throws Exception {
        Message m = new Message(25000);
        m = this.doTransaction(m);
        byte[] dat = (byte[])m.get(0);
        return new SimpleGatewayConfig(dat);
    }

    public void storeSgConfig(SimpleGatewayConfig config) throws Exception {
        boolean is37 = this.isSgServiceVersionOrLater(3, 7);
        if (is37) {
            System.out.println("Remote SG service is v3.7 or greater");
        } else {
            System.out.println("Remote SG service is pre-v3.7");
        }
        byte[] dat = config.save(is37);
        System.out.println("Sending " + dat.length + " bytes of SG config");
        Message m = new Message(26000);
        m.append(dat);
        m = this.doTransaction(m);
        System.out.println("Config sent OK");
    }

    public boolean isSGv3Installation() throws Exception {
        Message m = new Message(31400);
        m = this.doTransaction(m);
        return (Boolean)m.get(0);
    }

    public void doSGv4Install() throws Exception {
        Message m = new Message(31100);
        m = this.doTransaction(m);
    }

    public void doSGv4Uninstall() throws Exception {
        Message m = new Message(31500);
        m = this.doTransaction(m);
    }

    public boolean isElevated() throws Exception {
        Message m = new Message(31200);
        m = this.doTransaction(m);
        return (Boolean)m.get(0);
    }

    public void doElevate(String user, String pass) throws Exception {
        Message m = new Message(31300);
        m.append(user);
        m.append(pass);
        m = this.doTransaction(m);
    }

    public boolean doLogin(String password) throws Exception {
        Message m = new Message(31000);
        m.append(password);
        m = this.doTransaction(m);
        return (Boolean)m.get(0);
    }

    public boolean isLoginRequired() {
        return this.loginRequired;
    }

    public void close() {
        try {
            this.doTransaction(new Message(27000));
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }
}

