/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.mdupload.transports;

import com.aem.nodelink.utils.SafeClock;
import com.aem.shelp.mdupload.LossyClient;
import com.aem.shelp.mdupload.LossyTransport;
import com.aem.shelp.mdupload.MessageTooLargeException;
import utils.message.Message;

public class SwitchableLossyTransport
implements LossyTransport {
    LossyTransport main;
    LossyTransport alt;
    LossyTransport current;
    long useAltUntil = 0L;

    public SwitchableLossyTransport(LossyTransport main, LossyTransport alt) {
        this.main = main;
        this.alt = alt;
        this.current = main;
    }

    public static boolean trySwitchAlt(LossyTransport check, long ms) {
        if (check instanceof SwitchableLossyTransport) {
            SwitchableLossyTransport swt = (SwitchableLossyTransport)check;
            swt.useAltFor(ms);
            return true;
        }
        return false;
    }

    public static boolean isUsingAlt(LossyTransport check) {
        if (check instanceof SwitchableLossyTransport) {
            SwitchableLossyTransport swt = (SwitchableLossyTransport)check;
            return swt.current == swt.alt;
        }
        return false;
    }

    public void useAltFor(long ms) {
        this.useAltUntil = SafeClock.currentTimeMillis() + ms;
        this.current = this.alt;
    }

    private void checkReset() {
        if (SafeClock.currentTimeMillis() > this.useAltUntil) {
            this.current = this.main;
        }
    }

    @Override
    public Object getLargeSendLock() {
        this.checkReset();
        return this.current.getLargeSendLock();
    }

    @Override
    public boolean providesGuaranteedDelivery() {
        this.checkReset();
        return this.current.providesGuaranteedDelivery();
    }

    @Override
    public void sendMessage(LossyClient client, Message message) throws MessageTooLargeException {
        this.checkReset();
        this.current.sendMessage(client, message);
    }

    @Override
    public String getUnderlyingProtocolDescription() {
        this.checkReset();
        return this.current.getUnderlyingProtocolDescription();
    }
}

