/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.mdupload;

import bcutil.BCUtil;
import bcutil.BCUtilHandshakeMessenger;
import bcutil.ReplaceableByteArrayInputStream;
import com.aem.CentralDebugging;
import com.aem.ServerManagement;
import com.aem.shelp.common.PC;
import com.aem.shelp.mdupload.LossyClient;
import com.aem.shelp.mdupload.LossyTransport;
import com.aem.shelp.mdupload.SecMsgDecryptionError;
import com.aem.shelp.mdupload.SecureMessengerDB;
import com.aem.shelp.mdupload.SecureMessengerListener;
import com.aem.shelp.mdupload.ServerNotRespondingException;
import com.aem.utils.zip.GZIPer;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import utils.ddebug.DDLog;
import utils.message.Message;
import utils.message.MessageUtils;
import utils.progtools.OnDemandThreadPool;
import utils.progtools.TimeUtil;
import utils.progtools.arrays.ArrayPrinter;
import utils.string.HexData;
import utils.switches.Switches;

public class SecureMessenger
extends Thread
implements BCUtilHandshakeMessenger {
    static int VER = 2;
    Object assoc_LOCK = new Object();
    HashMap assoc = new HashMap();
    private static final int HANDSHAKE_RESPONSE_TIMEOUT = 60000;
    BCUtil bcutil;
    LossyClient lossy;
    LossyTransport transport;
    String myName;
    long lastUsed = System.currentTimeMillis();
    long lastSaved = System.currentTimeMillis() - TimeUtil.getRandomHourFraction() * 2L;
    Long myRoutingID;
    String myMessengerID;
    long serverInstanceID;
    private static boolean COMPRESS = false;
    SecureMessengerListener listener;
    private Exception setupFailure;
    private boolean isHandshakeClient = false;
    private String returnChannelID;
    private static final OnDemandThreadPool setupTP1 = new OnDemandThreadPool("SecMsgNegotiations", 1, 1, 10);
    private static final OnDemandThreadPool setupTP5 = new OnDemandThreadPool("SecMsgNegotiations", 5, 2, 5);
    private static final OnDemandThreadPool setupTP50 = new OnDemandThreadPool("SecMsgNegotiations", 50, 10, 5);
    private static final Object pool_LOCK = new Object();
    private static OnDemandThreadPool pool;
    private static final Object print_LOCK;
    private static long lastFullPrintout;
    private static long dropped;
    private static int printRequired;
    private static int droppedRunning;
    private final ReplaceableByteArrayInputStream setupBin = new ReplaceableByteArrayInputStream(new byte[0]);
    private final ByteArrayOutputStream setupBout = new ByteArrayOutputStream();
    private boolean serverProcessing = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getAssociated(String key) {
        Object object = this.assoc_LOCK;
        synchronized (object) {
            return this.assoc.get(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAssociated(String key, Object obj) {
        Object object = this.assoc_LOCK;
        synchronized (object) {
            this.assoc.put(key, obj);
        }
    }

    public LossyTransport getUnderlyingTransport() {
        return this.transport;
    }

    private void updateLastUsed() {
        this.lastUsed = System.currentTimeMillis();
        if (this.lastUsed - this.lastSaved > 14400000L) {
            SecureMessengerDB.saveSecureMessenger(this);
            this.lastSaved = System.currentTimeMillis();
        }
    }

    public static void compressAllSends(boolean b) {
        COMPRESS = b;
    }

    public static SecureMessenger createSecureMessengerAsClient(BCUtil bcutil, LossyClient lossy, LossyTransport transport, String messengerID, SecureMessengerListener listener, String returnChannelID) throws Exception {
        SecureMessenger sm = new SecureMessenger(bcutil, lossy, transport, returnChannelID, messengerID);
        sm.setupAsClient(listener, messengerID);
        return sm;
    }

    public static boolean canSetupNow() {
        return SecureMessenger.getSetupTP().canRun();
    }

    public static SecureMessenger createSecureMessengerAsServerAsync(BCUtil bcutil, LossyClient lossy, LossyTransport transport, String messengerID, SecureMessengerListener listener, Long setupConversation) {
        SecureMessenger sm = new SecureMessenger(bcutil, lossy, transport, null, messengerID);
        sm.setupAsyncAsServer(setupConversation, listener, messengerID);
        return sm;
    }

    SecureMessenger() {
    }

    private SecureMessenger(BCUtil bcutil, LossyClient lossy, LossyTransport transport, String returnChannelID, String myName) {
        this.bcutil = bcutil;
        this.lossy = lossy;
        this.transport = transport;
        this.returnChannelID = returnChannelID;
        this.myName = "'" + myName + "'";
    }

    public boolean isReady() {
        return this.bcutil.canSendSecureData();
    }

    private Long setupAsClient(SecureMessengerListener listener, String myMessengerID) throws Exception {
        this.listener = listener;
        this.myMessengerID = myMessengerID;
        this.isHandshakeClient = true;
        this.run();
        if (this.setupFailure != null) {
            throw this.setupFailure;
        }
        return this.myRoutingID;
    }

    private static OnDemandThreadPool getSetupTP() {
        if (CentralDebugging.PX_SERIALISE_SECMSG_SETUPS) {
            return setupTP1;
        }
        if (CentralDebugging.PX_LIMIT_SECMSG_SETUPS) {
            return setupTP5;
        }
        return setupTP50;
    }

    private Long setupAsyncAsServer(Long conversation, SecureMessengerListener listener, String myMessengerID) {
        this.listener = listener;
        this.myRoutingID = conversation;
        this.myMessengerID = myMessengerID;
        if (CentralDebugging.RENEGOTIATION_TRACING) {
            System.out.println("[Server SecMsg Reneg] Server adding new SecMsg " + myMessengerID + " to DB");
        }
        SecureMessengerDB.secureMessengerCreated(this.myRoutingID, this);
        if (CentralDebugging.RENEGOTIATION_TRACING) {
            System.out.println("[Server SecMsg Reneg] Server starting negotiations for new SecMsg " + myMessengerID);
        }
        if (!SecureMessenger.getSetupTP().runAsync((Runnable)this) && CentralDebugging.RENEGOTIATION_TRACING) {
            System.out.println("[Server SecMsg Reneg] SecMsg negotation was unable to start (too many setups)");
        }
        System.out.println("[SecMsg " + this.myName + "] Renegotiation started, " + SecureMessenger.getSetupTP().getLiveCount() + " running");
        return this.myRoutingID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createThreadPoolForNonBlocking(int threads, int maxBuffered) {
        Object object = pool_LOCK;
        synchronized (object) {
            if (pool == null) {
                pool = new OnDemandThreadPool("SecureMessagingSendNBPool", threads, maxBuffered, 5);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void droppedMessage(Message message) {
        if (CentralDebugging.SECMSG_SHOW_ALL_DROPPED) {
            System.out.println("[SecMsg] Had to drop message " + message);
            Object object = print_LOCK;
            synchronized (object) {
                if (++droppedRunning >= 20) {
                    new Exception("Dropped Message Trace for " + message).printStackTrace();
                    droppedRunning = 0;
                }
            }
        }
    }

    public void secureSendNoBlock(Message message) {
        if (ServerManagement.isServerJVM()) {
            if (!pool.runAsync((Runnable)new MessageSend(this, message))) {
                SecureMessenger.printPoolFullWarning();
                this.droppedMessage(message);
            }
        } else {
            this.doSendSecure(message, null);
        }
    }

    public void secureSend(Message message) {
        if (ServerManagement.isServerJVM()) {
            if (!pool.runAsync((Runnable)new MessageSend(this, message))) {
                SecureMessenger.printPoolFullWarning();
                this.droppedMessage(message);
            }
        } else {
            this.doSendSecure(message, null);
        }
    }

    private static void ddlogMsg(SecureMessenger secmsg, String type, Message sendMsg, byte[] sendDat, LossyTransport transport, Long conversation) {
        if (CentralDebugging.DDEBUG_PROXYSERVER_SECMSG) {
            String sb = type + " secure message:" + '\n' + "\tMessage: " + sendMsg + '\n' + "\tEncrypt: " + ArrayPrinter.createIdentifyingHash(sendDat) + '\n' + "\tTranspt: " + transport + '\n' + "\tSecMsg:  " + secmsg + '\n' + "\tConv:    " + conversation + '\n';
            DDLog.log(secmsg, sb);
        }
    }

    public void secureSendNoBlock(Message message, Long conv) {
        if (ServerManagement.isServerJVM()) {
            if (!pool.runAsync((Runnable)new MessageSend(this, message, conv))) {
                SecureMessenger.printPoolFullWarning();
                this.droppedMessage(message);
            }
        } else {
            this.doSendSecure(message, conv);
        }
    }

    public void secureSend(Message message, Long conv) {
        if (ServerManagement.isServerJVM()) {
            if (!pool.runAsync((Runnable)new MessageSend(this, message, conv))) {
                SecureMessenger.printPoolFullWarning();
                this.droppedMessage(message);
            }
        } else {
            this.doSendSecure(message, conv);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void printPoolFullWarning() {
        Object object = print_LOCK;
        synchronized (object) {
            long T = System.currentTimeMillis();
            if (T > lastFullPrintout + 5000L) {
                System.out.println("[SecMsg] Dropped x" + ++dropped + " outgoing messages (" + pool.getStats() + ")");
                lastFullPrintout = T;
                dropped = 0L;
                printRequired = 200;
            } else {
                ++dropped;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doSendSecure(Message message, Long conv) {
        this.updateLastUsed();
        byte[] data = MessageUtils.messageToBytes((Message)message);
        if (printRequired > 0 && CentralDebugging.SECMSG_SHOW_OVERLOAD) {
            Object object = print_LOCK;
            synchronized (object) {
                --printRequired;
                if (data.length > 400) {
                    System.out.println("[SecMsg] Load info, asked to send LARGE (" + data.length + ") " + message);
                } else {
                    System.out.println("[SecMsg] Load info, asked to send (" + data.length + ") " + message);
                }
                if (printRequired % 10 == 0) {
                    new Exception("Message Trace for (" + data.length + ") " + message).printStackTrace();
                }
            }
        }
        int msgType = 274596432;
        if (COMPRESS && data.length > 400) {
            try {
                byte[] tmp = new GZIPer().compress(data);
                if (tmp.length < data.length) {
                    data = tmp;
                    msgType = 274596444;
                }
            }
            catch (IOException x) {
                x.printStackTrace();
                return;
            }
        }
        try {
            data = this.bcutil.wrap(data);
        }
        catch (IOException x) {
            x.printStackTrace();
            return;
        }
        Message m = new Message(msgType);
        m.append(data);
        m.append(this.myRoutingID);
        if (conv == null) {
            byte[] tosend = MessageUtils.messageToBytes((Message)m);
            SecureMessenger.ddlogMsg(this, "Sending", message, tosend, this.transport, conv);
            this.lossy.sendGuaranteed(this.transport, tosend);
        } else {
            byte[] tosend = MessageUtils.messageToBytes((Message)m);
            SecureMessenger.ddlogMsg(this, "Sending", message, tosend, this.transport, conv);
            this.lossy.sendGuaranteed(this.transport, tosend, conv);
        }
    }

    public Message transactSecure(Message message) throws IOException, SecMsgDecryptionError {
        return this.transactSecure(message, null);
    }

    private Message transactSecure(Message message, Long conv) throws IOException, SecMsgDecryptionError {
        byte[] ret;
        byte[] tosend;
        this.updateLastUsed();
        Message m = new Message(274596432);
        byte[] data = MessageUtils.messageToBytes((Message)message);
        if (COMPRESS && data.length > 400) {
            try {
                byte[] tmp = new GZIPer().compress(data);
                if (tmp.length < data.length) {
                    data = tmp;
                    m.setType(274596444);
                }
            }
            catch (IOException x) {
                x.printStackTrace();
                return null;
            }
        }
        try {
            data = this.bcutil.wrap(data);
        }
        catch (IOException x) {
            x.printStackTrace();
            return null;
        }
        m.append(data);
        m.append(this.myRoutingID);
        if (CentralDebugging.LOSSY_PRINT_USER_MESSAGES || CentralDebugging.LOSSY_PRINT_ALL_MESSAGES) {
            System.out.println("[SecureMessenger] sending (g-trans) message " + message.toPretty(PC.REFS));
        }
        if (conv == null) {
            tosend = MessageUtils.messageToBytes((Message)m);
            SecureMessenger.ddlogMsg(this, "Transacting", message, tosend, this.transport, conv);
            ret = this.lossy.transactGuaranteed(this.transport, tosend);
        } else {
            tosend = MessageUtils.messageToBytes((Message)m);
            SecureMessenger.ddlogMsg(this, "Transacting", message, tosend, this.transport, conv);
            ret = this.lossy.transactGuaranteed(this.transport, tosend, conv);
        }
        if (ret == null) {
            if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                DDLog.log(this, "No response to message " + message);
            }
            return null;
        }
        m = MessageUtils.bytesToMessage((byte[])ret);
        if (m.getType() == 274596505) {
            throw new SecMsgDecryptionError();
        }
        byte[] data2 = (byte[])m.get(0);
        ByteArrayInputStream bin = new ByteArrayInputStream(data2);
        DataInputStream din = new DataInputStream(bin);
        try {
            data2 = this.bcutil.unwrap(din);
        }
        catch (Throwable x) {
            throw new SecMsgDecryptionError();
        }
        if (m.getType() == 274596444) {
            data2 = new GZIPer().decompress(data2);
        }
        try {
            Message recv = MessageUtils.bytesToMessage((byte[])data2);
            if (recv == null) {
                throw new IOException("No message found after unwrapping");
            }
            return recv;
        }
        catch (IOException x) {
            x.printStackTrace();
            return null;
        }
    }

    private void handleSecureMessage(Message m, Long respondConv, Object source) throws IOException, SecMsgDecryptionError {
        Message recv;
        this.updateLastUsed();
        byte[] data = (byte[])m.get(0);
        ByteArrayInputStream bin = new ByteArrayInputStream(data);
        DataInputStream din = new DataInputStream(bin);
        try {
            data = this.bcutil.unwrap(din);
        }
        catch (Throwable t) {
            throw new SecMsgDecryptionError();
        }
        if (m.getType() == 274596444) {
            data = new GZIPer().decompress(data);
        }
        if ((recv = MessageUtils.bytesToMessage((byte[])data)) == null) {
            throw new IOException("No message found after unwrapping");
        }
        SecureMessenger.ddlogMsg(this, "Unwrapped", recv, data, this.transport, respondConv);
        if (CentralDebugging.LOSSY_PRINT_USER_MESSAGES || CentralDebugging.LOSSY_PRINT_ALL_MESSAGES) {
            System.out.println("[SecureMessenger] received (unprompted) message " + recv.toPretty(PC.REFS));
        }
        this.listener.incomingSecureMessage(this, this.myMessengerID, recv, respondConv, source);
    }

    public static void handleIncomingSecureMessage(byte[] data, LossyTransport respond, Long respondConversation, boolean updateSecMsgOutgoingTransport, Object source) throws IOException, SecMsgDecryptionError {
        Message m = MessageUtils.bytesToMessage((byte[])data);
        Long routingID = (Long)m.peek();
        SecureMessenger sm = SecureMessengerDB.fetchSecureMessengerForRoutingID(routingID);
        SecureMessenger.ddlogMsg(sm, "Incoming", m, data, respond, respondConversation);
        if (sm != null) {
            if (CentralDebugging.SECMSG_HANDLING) {
                System.out.println("Passing on secure message " + m);
            }
            try {
                if (updateSecMsgOutgoingTransport) {
                    sm.transport = respond;
                }
                sm.handleSecureMessage(m, respondConversation, source);
            }
            catch (SecMsgDecryptionError x) {
                System.out.println("[SecMsg] Secure messenger " + sm.myMessengerID + " could not decrypt message for route " + routingID + ", will clear for renegotiation");
                SecureMessengerDB.clearSecureMessenger(sm.myMessengerID, "secmsg was unable to decrypt an incoming message " + x);
                throw x;
            }
            catch (Exception x) {
                if (CentralDebugging.DDEBUG_PROXYSERVER_SECMSG) {
                    DDLog.log(routingID, "@" + routingID + " : FAILED to interpret secure message from " + respondConversation + " with " + sm);
                }
                IOException xx = new IOException("SecureMessenger " + sm + " was unable to interpret message");
                xx.initCause(x);
                throw xx;
            }
        } else {
            if (CentralDebugging.DDEBUG_PROXYSERVER_SECMSG) {
                DDLog.log(routingID, "SecMsg not found for routing ID " + routingID);
            }
            throw new SecMsgDecryptionError("SecureMessenger id " + routingID + " not found");
        }
    }

    public static void handleIncomingSecurityNegotiation(byte[] data, LossyTransport respond, Long respondConversation, boolean updateSecMsgOutgoingTransport) {
        SecureMessenger sm;
        if (CentralDebugging.LOSSY_SECURITY) {
            System.out.println("[SecureMsg] Incoming security message for " + respondConversation);
        }
        if ((sm = SecureMessengerDB.fetchSecureMessengerForRoutingID(respondConversation)) != null) {
            if (CentralDebugging.LOSSY_SECURITY) {
                System.out.println("[SecureMsg] Passing on to relevant SecureMessenger");
            }
            try {
                if (updateSecMsgOutgoingTransport) {
                    sm.transport = respond;
                }
                sm.handleSecurityMessage(data, respond, respondConversation);
            }
            catch (IOException x) {
                x.printStackTrace();
            }
        } else if (CentralDebugging.LOSSY_SECURITY) {
            System.out.println("[SecureMsg] SecureMessenger not found for " + respondConversation);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block20: {
            this.setupFailure = null;
            try {
                long T_all = System.currentTimeMillis();
                if (CentralDebugging.SECMSG_VERBOSE_HANDSHAKE) {
                    System.out.println("[SecureMsg " + this.myName + "] Renegotiating " + this.myName + " secure messaging");
                }
                this.serverInstanceID = 0L;
                if (this.isHandshakeClient) {
                    byte[] tmp;
                    this.myRoutingID = this.lossy.createConversation();
                    System.out.println("[SecureMsg " + this.myName + "] Client " + this.returnChannelID + " asking to renegotiate security with " + this.myMessengerID + " for " + this.myRoutingID);
                    Message m = new Message(274596353);
                    m.append(this.returnChannelID);
                    SecureMessengerDB.secureMessengerCreated(this.myRoutingID, this);
                    if (CentralDebugging.DEBUG_SECMSG_INITIAL_CHAT) {
                        System.out.println("[SecmsgInitial] Secmsg sending renegotiate X additional message");
                    }
                    if ((tmp = this.lossy.transactLossy(this.transport, MessageUtils.messageToBytes((Message)m), 60000, this.myRoutingID)) == null && Switches.SH_retryOnceOnNegotiationIoFailure) {
                        tmp = this.lossy.transactLossy(this.transport, MessageUtils.messageToBytes((Message)m), 60000, this.myRoutingID);
                    }
                    if (tmp == null) {
                        throw new ServerNotRespondingException();
                    }
                    m = MessageUtils.bytesToMessage((byte[])tmp);
                    if (CentralDebugging.LOSSY_SECURITY) {
                        System.out.println("[SecureMsg " + this.myName + "] Received response " + m);
                    }
                    if (m.getType() == 274596445) {
                        System.out.println("[SecureMsg " + this.myName + "] Server says TOO BUSY right now, we will wait");
                        throw new IOException("Unable to renegotiate security (Server TOO BUSY right now): " + m);
                    }
                    if (m.getType() != 274596354) {
                        System.out.println("[SecureMsg " + this.myName + "] Server refused to renegotiate security " + m);
                        throw new IOException("Unable to renegotiate security: " + m);
                    }
                    this.serverInstanceID = m.getAsLong(0);
                    System.out.println("[SecureMsg " + this.myName + "] Server says OK to renegotiate security (serv inst " + this.serverInstanceID + "), starting handshake");
                }
                if (CentralDebugging.SECMSG_VERBOSE_HANDSHAKE) {
                    System.out.println("[SecureMsg " + this.myName + "] Starting BCUtil handshake now");
                }
                this.bcutil.handshake((InputStream)this.setupBin, (OutputStream)this.setupBout, this.isHandshakeClient, (BCUtilHandshakeMessenger)this);
                if (CentralDebugging.SECMSG_VERBOSE_HANDSHAKE) {
                    System.out.println("[SecureMsg " + this.myName + "] BCUtil handshake completed successfully, messenger ready");
                }
                T_all = System.currentTimeMillis() - T_all;
                if (CentralDebugging.SECMSG_VERBOSE_HANDSHAKE) {
                    System.out.println("[SecureMsg " + this.myName + "] Secure messaging for " + this.myName + " (inst " + this.serverInstanceID + ") ready (" + T_all + "ms), saving...");
                }
                if (CentralDebugging.SECMSG_VERBOSE_HANDSHAKE) {
                    System.out.println("[SecMsg " + this.myName + "] Renegotiation complete, " + SecureMessenger.getSetupTP().getLiveCount() + " running");
                }
                SecureMessengerDB.saveSecureMessenger(this);
                if (this.serverInstanceID != 0L) {
                    SecureMessengerDB.replaceBCUtilForRemoteInstance(this.serverInstanceID, this);
                }
            }
            catch (Exception x) {
                this.setupFailure = x;
                System.out.println("[SecMsg " + this.myName + "] Renegotiation failed, " + (SecureMessenger.getSetupTP().getLiveCount() - 1) + " running");
                if (this.bcutil.didClientFailDuringPubkeyCheck()) {
                    System.out.println("[SecureMsg] BCUtil handshake to " + this.myMessengerID + " failed during pubkey check");
                }
                if (x instanceof ServerNotRespondingException) {
                    System.out.println("[SecureMsg] server not responding to request - server may be too old?");
                    break block20;
                }
                if (this.isHandshakeClient) {
                    x.printStackTrace();
                    break block20;
                }
                System.out.println("[SecureMsg] BCUtil handshake failed " + x);
                x.printStackTrace();
            }
        }
    }

    public void clientSendAndReceive() throws IOException {
        byte[] tosend = this.setupBout.toByteArray();
        this.setupBout.reset();
        Message m = new Message(274596355);
        m.append(tosend);
        byte[] raw = this.lossy.transactGuaranteed(this.transport, MessageUtils.messageToBytes((Message)m), this.myRoutingID, 60000L);
        if (raw == null && Switches.SH_retryOnceOnNegotiationIoFailure) {
            raw = this.lossy.transactGuaranteed(this.transport, MessageUtils.messageToBytes((Message)m), this.myRoutingID, 60000L);
        }
        if (raw == null) {
            throw new IOException("[SecureMessenger] failed to handshake - server did not respond");
        }
        m = MessageUtils.bytesToMessage((byte[])raw);
        if (m == null) {
            throw new IOException("[SecureMessenger] failed to handshake - server did not respond with valid message (" + raw.length + ")");
        }
        if (m.length() == 0) {
            throw new IOException("[SecureMessenger] failed to handshake - unexpected message " + m);
        }
        byte[] toresp = (byte[])m.get(0);
        this.setupBin.reset(toresp);
    }

    private void handleSecurityMessage(byte[] data, LossyTransport respond, Long respondConversation) throws IOException {
        Message m = MessageUtils.bytesToMessage((byte[])data);
        byte[] payload = (byte[])m.pop();
        this.setupBin.reset(payload);
        if (CentralDebugging.LOSSY_SECURITY) {
            System.out.println("[SecureMsg] BCUtil renegotiation message came in to server, marking for processing by BCUtil now...");
        }
        this.serverProcessing = true;
        long t_Quit = System.currentTimeMillis() + 60000L;
        while (this.serverProcessing) {
            try {
                Thread.sleep(10L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (System.currentTimeMillis() > t_Quit) {
                throw new IOException("[SecureMessenger] failed to handshake - internal processor did not respond");
            }
            if (this.setupFailure == null) continue;
            IOException xx = new IOException("[SecureMessenger] failed to handshake - " + this.setupFailure);
            xx.initCause(this.setupFailure);
            throw xx;
        }
        if (CentralDebugging.LOSSY_SECURITY) {
            System.out.println("[SecureMsg] Response ready, sending now...");
        }
        byte[] tosend = this.setupBout.toByteArray();
        this.setupBout.reset();
        m = new Message(274596355);
        m.append(tosend);
        this.lossy.sendGuaranteed(this.transport, MessageUtils.messageToBytes((Message)m), respondConversation);
    }

    public void serverReceive() throws IOException {
        if (CentralDebugging.LOSSY_SECURITY) {
            System.out.println("[SecureMsg] Waiting for incoming server message...");
        }
        long t_Quit = System.currentTimeMillis() + 60000L;
        while (!this.serverProcessing) {
            try {
                Thread.sleep(20L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (System.currentTimeMillis() > t_Quit) {
                throw new IOException("[SecureMessenger] failed to handshake - client did not respond");
            }
            if (this.setupFailure == null) continue;
            IOException xx = new IOException("[SecureMessenger] failed to handshake - " + this.setupFailure);
            xx.initCause(this.setupFailure);
            throw xx;
        }
        if (CentralDebugging.LOSSY_SECURITY) {
            System.out.println("[SecureMsg] Got server message, processing now");
        }
    }

    @Override
    public String toString() {
        byte[][] id = this.bcutil.getIdentifyingHash();
        return "SecMsg(" + this.myName + "/ID:" + this.myMessengerID + "/^" + this.myRoutingID + ") (E:" + HexData.byteArrayToHexString((byte[])id[0]) + " / D:" + HexData.byteArrayToHexString((byte[])id[1]) + ")";
    }

    public void serverRespond() {
        this.serverProcessing = false;
    }

    public void removedFromCache(Object key, Object value) {
    }

    static {
        print_LOCK = new Object();
        lastFullPrintout = 0L;
        dropped = 0L;
        printRequired = 0;
        droppedRunning = 0;
    }

    static class MessageSend
    implements Runnable {
        SecureMessenger secmsg;
        Message m;
        Long conv;

        public MessageSend(SecureMessenger secmsg, Message m) {
            this.secmsg = secmsg;
            this.m = m;
        }

        public MessageSend(SecureMessenger secmsg, Message m, Long conv) {
            this.secmsg = secmsg;
            this.m = m;
            this.conv = conv;
        }

        @Override
        public void run() {
            if (this.conv != null) {
                this.secmsg.doSendSecure(this.m, this.conv);
            } else {
                this.secmsg.doSendSecure(this.m, null);
            }
        }
    }
}

