/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.mdupload;

import com.aem.CentralDebugging;
import com.aem.ServerManagement;
import com.aem.nodelink.utils.SafeClock;
import com.aem.shelp.common.PC;
import com.aem.shelp.mdupload.LossyMessageHandler;
import com.aem.shelp.mdupload.LossyTransport;
import com.aem.shelp.mdupload.LossyUtils;
import com.aem.shelp.mdupload.MessageTooLargeException;
import com.aem.shelp.mdupload.TransmissionControlMechanism;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import utils.ddebug.DDLog;
import utils.message.Message;
import utils.message.MessageUtils;
import utils.progtools.Cache;
import utils.progtools.OnDemandThreadPool;
import utils.progtools.TimeoutMap;
import utils.progtools.TimeoutMapListener;
import utils.stream.ByteArrayUtils;
import utils.switches.Switches;

public class LossyClient {
    public static int LOSSY_SINGLE_MESSAGE_X = 22217216;
    public static int LOSSY_SINGLE_GUARANTEED_MESSAGE_X = 22217217;
    public static int LOSSY_GUARANTEED_MESSAGE_PART_X = 22217219;
    public boolean SIMULATE_MESSAGE_LOSS = false;
    public boolean VERBOSE_NOTHREAD_RESEND = false;
    public static int GUARANTEEED_MESSAGE_RESEND = 300;
    public static int STD_TIMEOUT = 25000;
    public static int LARGE_MESSAGE_GIVE_UP_TIMEOUT;
    public static int MAINTENANCE_TIMEOUT;
    public static int RESPONSE_TIMEOUT;
    SecureRandom sr;
    LossyMessageHandler handler;
    Object rtt_LOCK = new Object();
    long rtt;
    static TimeoutMap.NoKeyTimeoutMap<Resend> resends;
    Object listeners_LOCK = new Object();
    long totalCleared = 0L;
    long listenersCleared = SafeClock.currentTimeMillis();
    HashMap<Long, ResponseListener> listeners = new HashMap();
    Object seen_LOCK = new Object();
    Cache seen = new Cache("LossyClient", 20000);
    static Object pool_LOCK;
    static OnDemandThreadPool procPool;
    static OnDemandThreadPool ackPool;
    static long pool_checked;
    static Object queries_LOCK;
    static HashMap<Processor, Processor> queries;
    static long checkPoolAfter;
    static long lastPoolCheck;
    static int dumpNo;
    static long lastCountPrint;
    long nextMaintenance = System.currentTimeMillis() + (long)MAINTENANCE_TIMEOUT;
    Object large_LOCK = new Object();
    HashMap<Long, LargeMessage> large = new HashMap();
    long bpersecMin = 1000L;
    long bpersecInitial = 10000L;
    long bpersecMax = 10000000L;
    long bpersecCur = this.bpersecInitial;
    long lastBigSend;
    TransmissionControlMechanism prevTcm;

    public LossyClient() {
        LossyClient.createThreadPoolForNonBlocking(50, 500);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void rttMeasured(long time) {
        Object object = this.rtt_LOCK;
        synchronized (object) {
            if (this.rtt == 0L) {
                this.rtt = time;
            } else {
                if (time < 1L) {
                    time = 1L;
                }
                if (time < 10000L) {
                    this.rtt = (long)((double)this.rtt * 0.75 + (double)time * 0.25);
                }
            }
        }
    }

    public void init(LossyMessageHandler handler, SecureRandom sr) {
        this.handler = handler;
        this.sr = sr;
    }

    private String printUser(Message m) {
        try {
            return m.getType() + " :: " + MessageUtils.bytesToMessage((byte[])((byte[])m.get(0))).toPretty(PC.REFS);
        }
        catch (Exception x) {
            return m.getType() + "";
        }
    }

    public void appendUnique(Message m) {
        Integer id = new Integer(this.sr.nextInt());
        m.append(id);
    }

    public void popUnique(Message m) {
        m.pop();
    }

    public static void appendTransient(Message m) {
        m.append(SafeClock.currentTimeMillis());
    }

    public static void popTransient(Message m) {
        m.pop();
    }

    public Long createConversation() {
        Long transactionConversation = new Long(Math.abs(this.sr.nextLong()));
        return transactionConversation;
    }

    public Long createAckConversation() {
        Long transactionConversation = new Long(-Math.abs(this.sr.nextLong()));
        return transactionConversation;
    }

    private void aboutToWait() {
    }

    public void sendGuaranteed(LossyTransport transport, byte[] message) {
        Long transactionConversation = this.createConversation();
        this.sendGuaranteed(transport, message, transactionConversation);
    }

    private void verify(byte[] dat) {
    }

    private void doAckedSend(LossyTransport transport, Message m, Long conversation, Long ack) {
        this.doAckedSend(transport, m, conversation, ack, 1, GUARANTEEED_MESSAGE_RESEND);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAckedSend(LossyTransport transport, Message m, Long conversation, Long ack, int attempt, int resendWait) {
        BlockWaitResponseListener ackl = new BlockWaitResponseListener(ack);
        boolean waitForAck = true;
        if (!this.SIMULATE_MESSAGE_LOSS || Math.random() < 0.65) {
            try {
                LossyClient.appendTransient(m);
                try {
                    transport.sendMessage(this, m);
                }
                finally {
                    LossyClient.popTransient(m);
                }
                if (CentralDebugging.LOSSY_PRINT_USER_MESSAGES && conversation > 0L || CentralDebugging.LOSSY_PRINT_ALL_MESSAGES) {
                    System.out.println("[LossyClient] sent (g) message " + this.printUser(m) + " on " + conversation + " (A:" + ack + ")");
                }
            }
            catch (MessageTooLargeException x) {
                this.sendLargeMessageWithID(transport, conversation, m);
                waitForAck = false;
            }
        } else if (CentralDebugging.LOSSY_PRINT_ALL_MESSAGES || this.VERBOSE_NOTHREAD_RESEND) {
            System.out.println("[LossyClient] simulating loss of message " + m);
        }
        if (waitForAck) {
            Resend resend = new Resend(transport, m, conversation, ack, attempt, resendWait, ackl);
            resends.add(resend, resendWait, resend);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendGuaranteed(LossyTransport transport, byte[] message, Long conversation) {
        this.aboutToWait();
        if (transport.providesGuaranteedDelivery()) {
            this.sendLossy(transport, message, conversation);
            return;
        }
        Long ack = this.createAckConversation();
        Message m = new Message(LOSSY_SINGLE_GUARANTEED_MESSAGE_X);
        m.append(message);
        m.append(ack);
        m.append(conversation);
        long T_quit = System.currentTimeMillis() + (long)STD_TIMEOUT;
        boolean acked = false;
        this.appendUnique(m);
        if (Switches.SH_1671_lossyNoThreadsOnGuaranteed) {
            this.doAckedSend(transport, m, conversation, ack);
        } else {
            try {
                long GWAIT = GUARANTEEED_MESSAGE_RESEND;
                do {
                    BlockWaitResponseListener ackl;
                    block18: {
                        ackl = new BlockWaitResponseListener(ack);
                        if (!this.SIMULATE_MESSAGE_LOSS || Math.random() < 0.65) {
                            try {
                                LossyClient.appendTransient(m);
                                try {
                                    this.verify(message);
                                    transport.sendMessage(this, m);
                                }
                                finally {
                                    LossyClient.popTransient(m);
                                }
                                if (CentralDebugging.LOSSY_PRINT_USER_MESSAGES && conversation > 0L || CentralDebugging.LOSSY_PRINT_ALL_MESSAGES) {
                                    System.out.println("[LossyClient] sent (g) message " + this.printUser(m) + " on " + conversation + " (A:" + ack + ")");
                                }
                                break block18;
                            }
                            catch (MessageTooLargeException x) {
                                this.sendLargeMessageWithID(transport, conversation, m);
                                acked = true;
                                break;
                            }
                        }
                        if (CentralDebugging.LOSSY_PRINT_ALL_MESSAGES) {
                            System.out.println("[LossyClient] dropping message " + m);
                        }
                    }
                    if (ackl.waitForMessage(GWAIT, true) != null) {
                        acked = true;
                        break;
                    }
                    GWAIT *= 2L;
                } while (System.currentTimeMillis() < T_quit);
            }
            finally {
                this.popUnique(m);
            }
            if (!acked) {
                System.out.println("[LossyClient] Failed to send guaranteed message to " + transport);
            }
        }
    }

    public byte[] transactGuaranteed(LossyTransport transport, byte[] message) {
        Long transactionConversation = this.createConversation();
        return this.transactGuaranteed(transport, message, transactionConversation);
    }

    public byte[] transactGuaranteed(LossyTransport transport, byte[] message, Long conversation) {
        return this.transactGuaranteed(transport, message, conversation, STD_TIMEOUT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] transactGuaranteed(LossyTransport transport, byte[] message, Long conversation, long transactionTimeout) {
        if (transport.providesGuaranteedDelivery()) {
            return this.transactLossy(transport, message, (int)transactionTimeout, conversation);
        }
        this.aboutToWait();
        Long ack = this.createAckConversation();
        Message m = new Message(LOSSY_SINGLE_GUARANTEED_MESSAGE_X);
        m.append(message);
        m.append(ack);
        m.append(conversation);
        BlockWaitResponseListener respl = new BlockWaitResponseListener(conversation);
        long T_quit = System.currentTimeMillis() + transactionTimeout;
        boolean acked = false;
        this.appendUnique(m);
        try {
            long GWAIT = GUARANTEEED_MESSAGE_RESEND;
            do {
                BlockWaitResponseListener ackl;
                block16: {
                    ackl = new BlockWaitResponseListener(ack);
                    if (!this.SIMULATE_MESSAGE_LOSS || Math.random() < 0.65) {
                        try {
                            LossyClient.appendTransient(m);
                            try {
                                this.verify(message);
                                transport.sendMessage(this, m);
                            }
                            finally {
                                LossyClient.popTransient(m);
                            }
                            if (CentralDebugging.LOSSY_PRINT_USER_MESSAGES && conversation > 0L || CentralDebugging.LOSSY_PRINT_ALL_MESSAGES) {
                                System.out.println("[LossyClient] sent (g-trans) message " + this.printUser(m) + " on " + conversation + " (A:" + ack + ")");
                            }
                            break block16;
                        }
                        catch (MessageTooLargeException x) {
                            this.sendLargeMessageWithID(transport, conversation, m);
                            acked = true;
                            break;
                        }
                    }
                    if (CentralDebugging.LOSSY_PRINT_ALL_MESSAGES) {
                        System.out.println("[LossyClient] dropping message " + m);
                    }
                }
                if (ackl.waitForMessage(GWAIT, true) != null) {
                    acked = true;
                    break;
                }
                GWAIT *= 2L;
            } while (System.currentTimeMillis() < T_quit);
        }
        finally {
            this.popUnique(m);
        }
        if (!acked) {
            System.out.println("[LossyClient] Failed to send guaranteed message to " + transport);
            return null;
        }
        return respl.waitForMessage(transactionTimeout, false);
    }

    public void sendLossy(LossyTransport transport, byte[] message) {
        Long transactionConversation = this.createConversation();
        this.sendLossy(transport, message, transactionConversation);
    }

    public void sendLossy(LossyTransport transport, byte[] message, Long conversation) {
        this.sendLossy(transport, message, conversation, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendLossy(LossyTransport transport, byte[] message, Long conversation, boolean ack) {
        Message m = new Message(LOSSY_SINGLE_MESSAGE_X);
        m.append(ack);
        m.append(message);
        m.append(conversation);
        this.appendUnique(m);
        try {
            LossyClient.appendTransient(m);
            try {
                if (!ack) {
                    this.verify(message);
                }
                transport.sendMessage(this, m);
            }
            finally {
                LossyClient.popTransient(m);
            }
            if (CentralDebugging.LOSSY_PRINT_USER_MESSAGES && conversation > 0L || CentralDebugging.LOSSY_PRINT_ALL_MESSAGES) {
                if (ack) {
                    System.out.println("[LossyClient] sent (l-ack) message " + this.printUser(m) + " on " + conversation);
                } else {
                    System.out.println("[LossyClient] sent (l) message " + this.printUser(m) + " on " + conversation);
                }
            }
        }
        catch (MessageTooLargeException x) {
            this.sendLargeMessageWithID(transport, conversation, m);
        }
        finally {
            this.popUnique(m);
        }
    }

    public byte[] transactLossy(LossyTransport transport, byte[] message, int timeoutMS) {
        Long transactionConversation = this.createConversation();
        return this.transactLossy(transport, message, timeoutMS, transactionConversation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] transactLossy(LossyTransport transport, byte[] message, int timeoutMS, Long conversation) {
        this.aboutToWait();
        Message m = new Message(LOSSY_SINGLE_MESSAGE_X);
        m.append(false);
        m.append(message);
        m.append(conversation);
        BlockWaitResponseListener respl = new BlockWaitResponseListener(conversation);
        this.appendUnique(m);
        try {
            LossyClient.appendTransient(m);
            try {
                this.verify(message);
                transport.sendMessage(this, m);
            }
            finally {
                LossyClient.popTransient(m);
            }
            if (CentralDebugging.LOSSY_PRINT_USER_MESSAGES && conversation > 0L || CentralDebugging.LOSSY_PRINT_ALL_MESSAGES) {
                System.out.println("[LossyClient] sent (l-trans) message " + this.printUser(m) + " on " + conversation);
            }
        }
        catch (MessageTooLargeException x) {
            this.sendLargeMessageWithID(transport, conversation, m);
        }
        finally {
            this.popUnique(m);
        }
        return respl.waitForMessage(timeoutMS, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int responseListenerMapSize() {
        Object object = this.listeners_LOCK;
        synchronized (object) {
            return this.listeners.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createThreadPoolForNonBlocking(int threads, int maxBuffered) {
        Object object = pool_LOCK;
        synchronized (object) {
            if (procPool == null) {
                procPool = new OnDemandThreadPool("LossyClientProcessorPool", threads, maxBuffered, 5);
                ackPool = threads < 50 ? new OnDemandThreadPool("LossyClientAckPool", 5, maxBuffered, 5) : (threads < 100 ? new OnDemandThreadPool("LossyClientAckPool", 10, maxBuffered, 5) : new OnDemandThreadPool("LossyClientAckPool", 20, maxBuffered, 5));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void checkPoolForDelays() {
        block13: {
            try {
                Object[] all;
                int qsize;
                if (!ServerManagement.isServerJVM()) {
                    return;
                }
                if (System.currentTimeMillis() - lastPoolCheck <= checkPoolAfter) break block13;
                Object object = queries_LOCK;
                synchronized (object) {
                    qsize = queries.size();
                }
                int delayed = 0;
                long maxDelay = 0L;
                if (qsize <= 0) break block13;
                lastPoolCheck = System.currentTimeMillis();
                Object object2 = queries_LOCK;
                synchronized (object2) {
                    all = queries.values().toArray();
                }
                long tnow = SafeClock.currentTimeMillis();
                for (int i = 0; i < all.length; ++i) {
                    Processor pp = (Processor)all[i];
                    Thread wd = pp.th;
                    long taken = tnow - pp.started;
                    if (taken <= 2000L) continue;
                    ++delayed;
                    if (taken > maxDelay) {
                        maxDelay = taken;
                    }
                    if (pp.printedDelay) continue;
                    pp.printedDelay = true;
                    StringBuffer sb = new StringBuffer();
                    sb.append("[LC Threading] *** LC Thread Delayed: (" + wd.getName() + ") alive=" + wd.isAlive() + " taken=" + taken + "ms\n");
                    StackTraceElement[] stack = wd.getStackTrace();
                    for (int k = 0; k < stack.length; ++k) {
                        sb.append("\tat " + stack[k] + "\n");
                    }
                    System.out.println(sb.toString());
                }
                if (delayed > 0 && System.currentTimeMillis() > lastCountPrint + 10000L) {
                    lastCountPrint = System.currentTimeMillis();
                    System.out.println("[LC Threading] " + delayed + " delayed threads (" + maxDelay + "ms)");
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    private boolean isACK(Message m) {
        if (m.getType() == LOSSY_SINGLE_MESSAGE_X) {
            return (Boolean)m.get(m.length() - 5);
        }
        return false;
    }

    public void lossyMessageReceived(LossyTransport transport, Message m, Object source) {
        if (this.isACK(m)) {
            if (!ackPool.runAsync((Runnable)new Processor(transport, m, source))) {
                System.out.println("[LossyClient] ***Warning - Dropped incoming ack, pool is full");
            }
        } else {
            if (!procPool.runAsync((Runnable)new Processor(transport, m, source))) {
                System.out.println("[LossyClient] ***Warning - Dropped incoming message, pool is full");
            }
            LossyClient.checkPoolForDelays();
            if (SafeClock.currentTimeMillis() > pool_checked + 1000L) {
                pool_checked = SafeClock.currentTimeMillis();
                procPool.runAsync((Runnable)new Clearer(pool_checked + 7000L));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processMessageReceived(LossyTransport transport, Message m, Object source) {
        Object ack;
        if (CentralDebugging.DDEBUG_PROXYSERVER_MESSAGING) {
            DDLog.log("Lossy Messaging", "Lossy Message Received");
        }
        if (CentralDebugging.LOSSY_PRINT_ALL_MESSAGES) {
            System.out.println("[LossyClient] incoming raw message " + m);
        }
        boolean isACK = this.isACK(m);
        int type = m.getType();
        Long originTime = (Long)m.pop();
        Integer messageID = (Integer)m.pop();
        Long conversation = (Long)m.pop();
        if (!LossyUtils.isCurrentProtocol(type)) {
            return;
        }
        if (type == LOSSY_SINGLE_GUARANTEED_MESSAGE_X || type == LOSSY_GUARANTEED_MESSAGE_PART_X) {
            ack = (Long)m.pop();
            byte[] ackData = new byte[8];
            ByteArrayUtils.writeLong((byte[])ackData, (int)0, (long)originTime);
            this.sendLossy(transport, ackData, (Long)ack, true);
        }
        if (!isACK) {
            ack = this.seen_LOCK;
            synchronized (ack) {
                if (this.seen.getFromCache((Object)messageID) != null) {
                    return;
                }
                this.seen.addToCache((Object)messageID, (Object)messageID);
            }
        }
        if (type == LOSSY_SINGLE_MESSAGE_X || type == LOSSY_SINGLE_GUARANTEED_MESSAGE_X) {
            ResponseListener listener;
            byte[] data = (byte[])m.pop();
            if (CentralDebugging.LOSSY_PRINT_USER_MESSAGES && conversation > 0L || CentralDebugging.LOSSY_PRINT_ALL_MESSAGES) {
                System.out.println("[LossyClient] received incoming message " + this.printUser(m) + " (ID:" + messageID + ") on " + conversation);
            }
            Object object = this.listeners_LOCK;
            synchronized (object) {
                listener = this.listeners.get(conversation);
            }
            if (listener != null) {
                if (CentralDebugging.LOSSY_PRINT_ALL_MESSAGES) {
                    System.out.println("[LossyClient] incoming message " + this.printUser(m) + " passed to registered listener");
                }
                listener.received(data);
            } else if (isACK) {
                if (CentralDebugging.LOSSY_PRINT_ALL_MESSAGES) {
                    System.out.println("[LossyClient] incoming message " + this.printUser(m) + " is stray ack");
                }
            } else {
                if (CentralDebugging.LOSSY_PRINT_ALL_MESSAGES) {
                    System.out.println("[LossyClient] incoming message " + this.printUser(m) + " passed to general handler");
                }
                this.handler.handleAsyncMessage(data, transport, conversation, source);
            }
        } else if (type == LOSSY_GUARANTEED_MESSAGE_PART_X) {
            LargeMessage lm;
            byte[] dat = (byte[])m.get(0);
            int start = m.getAsInt(1);
            int len = m.getAsInt(2);
            int blocksTotal = m.getAsInt(3);
            Long largeMessageID = (Long)m.get(4);
            int blockIndex = m.length() >= 6 ? m.getAsInt(5) : start / 440;
            if (CentralDebugging.LOSSY_PRINT_ALL_MESSAGES || CentralDebugging.LOSSY_PRINT_LARGE_MESSAGES) {
                System.out.println("[LossyClient] message part (" + conversation + ") " + start + " +" + dat.length);
            }
            Object object = this.large_LOCK;
            synchronized (object) {
                lm = this.large.get(largeMessageID);
                if (lm == null) {
                    lm = new LargeMessage();
                    lm.data = new byte[len];
                    lm.blocksOK = new int[blocksTotal];
                    this.large.put(largeMessageID, lm);
                }
                lm.lastUsed = System.currentTimeMillis();
                System.arraycopy(dat, 0, lm.data, start, dat.length);
                lm.blocksOK[blockIndex] = 1;
                int blocksLeft = 0;
                for (int z = 0; z < lm.blocksOK.length; ++z) {
                    if (lm.blocksOK[z] != 0) continue;
                    ++blocksLeft;
                }
                if (blocksLeft == 0) {
                    if (CentralDebugging.LOSSY_PRINT_ALL_MESSAGES || CentralDebugging.LOSSY_PRINT_LARGE_MESSAGES) {
                        System.out.println("[LossyClient] large message (" + conversation + ") is complete");
                    }
                    this.large.remove(largeMessageID);
                } else {
                    if (CentralDebugging.LOSSY_PRINT_ALL_MESSAGES || CentralDebugging.LOSSY_PRINT_LARGE_MESSAGES) {
                        System.out.println("[LossyClient] large message (" + conversation + ") has " + blocksLeft + " blocks left");
                    }
                    lm = null;
                }
            }
            if (lm != null) {
                Message message = MessageUtils.bytesToMessage((byte[])lm.data);
                if (CentralDebugging.LOSSY_PRINT_ALL_MESSAGES || CentralDebugging.LOSSY_PRINT_LARGE_MESSAGES) {
                    System.out.println("[LossyClient] large message (" + conversation + ") is " + message);
                }
                this.processMessageReceived(transport, message, source);
            }
        }
        long Tnow = System.currentTimeMillis();
        if (Tnow > this.nextMaintenance) {
            this.nextMaintenance = Tnow + (long)MAINTENANCE_TIMEOUT;
            Object object = this.large_LOCK;
            synchronized (object) {
                ArrayList<Long> prune = new ArrayList<Long>(50);
                for (Long key : this.large.keySet()) {
                    LargeMessage val = this.large.get(key);
                    if (Tnow - val.lastUsed <= (long)LARGE_MESSAGE_GIVE_UP_TIMEOUT) continue;
                    if (CentralDebugging.LOSSY_PRINT_ALL_MESSAGES) {
                        System.out.println("[LossyClient] pruning old large message (" + key + ")");
                    }
                    prune.add(key);
                }
                for (int i = 0; i < prune.size(); ++i) {
                    Long key = (Long)prune.get(i);
                    this.large.remove(key);
                }
            }
        }
    }

    private void checkBpersec() {
        if (this.lastBigSend == 0L) {
            this.lastBigSend = SafeClock.currentTimeMillis();
        } else {
            long T = SafeClock.currentTimeMillis();
            long delta = T - this.lastBigSend;
            if (delta > 1800000L) {
                System.out.println("[LossyClient] resetting bpersec (+" + delta + ")");
                this.bpersecCur = this.bpersecInitial;
            }
            this.lastBigSend = T;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendLargeMessageWithID(LossyTransport transport, Long conversation, Message msg) {
        System.out.println("[LossyClient] sending large message " + this.printUser(msg) + " on " + conversation);
        Object object = transport.getLargeSendLock();
        synchronized (object) {
            byte[] data;
            LossyClient.appendTransient(msg);
            try {
                data = MessageUtils.messageToBytes((Message)msg);
            }
            finally {
                LossyClient.popTransient(msg);
            }
            int BLOCK = 430;
            int blocks = data.length / BLOCK + (data.length % BLOCK == 0 ? 0 : 1);
            if (CentralDebugging.LOSSY_PRINT_ALL_MESSAGES) {
                System.out.println("Data len " + data.length + " blocks = " + blocks);
            }
            if (CentralDebugging.DDEBUG_PROXYSERVER_LOSSY_LARGE) {
                DDLog.log(transport, "Sending large message " + data.length);
            }
            Long uniqueMessageID = this.createAckConversation();
            ArrayList<BlockSend> all = new ArrayList<BlockSend>();
            for (int i = 0; i < blocks; ++i) {
                int start = i * BLOCK;
                int end = Math.min((i + 1) * BLOCK, data.length);
                byte[] dat = new byte[end - start];
                System.arraycopy(data, start, dat, 0, dat.length);
                Long blockConversation = this.createAckConversation();
                Long ackConversation = this.createAckConversation();
                Message part = new Message(LOSSY_GUARANTEED_MESSAGE_PART_X);
                part.append(dat);
                part.append(start);
                part.append(data.length);
                part.append(blocks);
                part.append(uniqueMessageID);
                part.append(i);
                part.append(ackConversation);
                part.append(blockConversation);
                if (CentralDebugging.DDEBUG_PROXYSERVER_LOSSY_LARGE) {
                    DDLog.log(transport, "Creating BlockSend " + start + " +" + data.length);
                }
                this.appendUnique(part);
                if (Switches.SH_1671_lossyNoThreadsOnGuaranteedInclLarge) {
                    this.doAckedSend(transport, part, blockConversation, ackConversation);
                    continue;
                }
                BlockSend bs = new BlockSend(part, ackConversation);
                all.add(bs);
            }
            if (Switches.SH_1671_lossyNoThreadsOnGuaranteedInclLarge) {
                return;
            }
            long MSG_SIZE = 500L;
            double SEND_MS = this.rtt * 2L;
            SEND_MS = Math.max(SEND_MS, 200.0);
            SEND_MS = Math.min(SEND_MS, 3000.0);
            long RESEND_MS = (long)(SEND_MS * 2.0);
            long blocksPerSec = this.bpersecCur / MSG_SIZE;
            int BLOCKS_PER_SET = (int)((double)blocksPerSec * (SEND_MS / 1000.0));
            if (BLOCKS_PER_SET < 1) {
                BLOCKS_PER_SET = 1;
            }
            long lastAck = System.currentTimeMillis();
            TransmissionControlMechanism tcm = new TransmissionControlMechanism();
            if (this.prevTcm != null) {
                tcm.importFrom(this.prevTcm);
            }
            this.prevTcm = tcm;
            int SleepFor = 65;
            int SleepEvery = 100;
            long TNextSleep = SafeClock.currentTimeMillis() + (long)SleepEvery;
            int toSend = (int)tcm.nextToSend(MSG_SIZE, 1000L);
            while (toSend < all.size()) {
                BlockSend bs = (BlockSend)all.get(toSend);
                bs.listener = new TcmResponseListener(bs.ackConversation, tcm, toSend);
                try {
                    if (CentralDebugging.DDEBUG_PROXYSERVER_LOSSY_LARGE) {
                        DDLog.log(transport, "Sending block " + toSend + " of " + all.size() + " (lrg:" + uniqueMessageID + ") (" + all.size() + " remaining) ");
                    }
                    LossyClient.appendTransient(bs.tosend);
                    try {
                        transport.sendMessage(this, bs.tosend);
                        if (CentralDebugging.DDEBUG_PROXYSERVER_LOSSY_LARGE) {
                            DDLog.log(transport, "Sent block " + toSend + " of " + all.size() + " (lrg:" + uniqueMessageID + ")");
                        }
                    }
                    finally {
                        LossyClient.popTransient(bs.tosend);
                    }
                }
                catch (MessageTooLargeException x) {
                    x.printStackTrace();
                }
                if (SafeClock.currentTimeMillis() > TNextSleep) {
                    try {
                        Thread.sleep(SleepFor);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    TNextSleep = SafeClock.currentTimeMillis() + (long)SleepEvery;
                }
                toSend = (int)tcm.nextToSend(MSG_SIZE, 1000L);
            }
            if (CentralDebugging.LOSSY_PRINT_ALL_MESSAGES) {
                System.out.println("Large message sent");
            }
        }
    }

    static {
        MAINTENANCE_TIMEOUT = LARGE_MESSAGE_GIVE_UP_TIMEOUT = 30000;
        RESPONSE_TIMEOUT = 180000;
        resends = new TimeoutMap.NoKeyTimeoutMap(100);
        pool_LOCK = new Object();
        pool_checked = 0L;
        queries_LOCK = new Object();
        queries = new HashMap();
        checkPoolAfter = 500L;
        lastPoolCheck = 0L;
        dumpNo = 1;
        lastCountPrint = 0L;
    }

    class BlockSend {
        Long ackConversation;
        Message tosend;
        ResponseListener listener;
        long expectAckBy;

        public BlockSend(Message part, Long ackConversation) {
            this.tosend = part;
            this.ackConversation = ackConversation;
        }
    }

    abstract class ResponseListener {
        long created;
        Long conversation;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public ResponseListener(Long conversation) {
            this.conversation = conversation;
            this.created = SafeClock.currentTimeMillis();
            Object object = LossyClient.this.listeners_LOCK;
            synchronized (object) {
                this.clearTimedOut();
                if (CentralDebugging.LOSSY_PRINT_ALL_MESSAGES) {
                    System.out.println("Listening on " + conversation);
                }
                LossyClient.this.listeners.put(conversation, this);
            }
        }

        public boolean isTimedOut() {
            return SafeClock.currentTimeMillis() > this.created + (long)RESPONSE_TIMEOUT;
        }

        private void clearTimedOut() {
            long T = SafeClock.currentTimeMillis();
            if (T > LossyClient.this.listenersCleared + 90000L) {
                Object[] keys;
                LossyClient.this.listenersCleared = T;
                int cleared = 0;
                for (Object okey : keys = LossyClient.this.listeners.keySet().toArray()) {
                    Long key = (Long)okey;
                    ResponseListener rl = LossyClient.this.listeners.get(key);
                    if (!rl.isTimedOut()) continue;
                    LossyClient.this.listeners.remove(key);
                    ++cleared;
                }
                LossyClient.this.totalCleared += (long)cleared;
                if (cleared > 0) {
                    System.out.println("[LossyClient] Cleared response listeners cl=" + cleared + "/tot=" + LossyClient.this.totalCleared + "/cur=" + LossyClient.this.listeners.size());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void stopListening() {
            Object object = LossyClient.this.listeners_LOCK;
            synchronized (object) {
                LossyClient.this.listeners.remove(this.conversation);
            }
        }

        public abstract void received(byte[] var1);
    }

    class BlockWaitResponseListener
    extends ResponseListener {
        byte[] m;
        Object LOCK;

        public BlockWaitResponseListener(Long conversation) {
            super(conversation);
            this.LOCK = new Object();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void received(byte[] m) {
            this.m = m;
            Object object = this.LOCK;
            synchronized (object) {
                this.LOCK.notifyAll();
            }
        }

        public byte[] getResponseAndClose() {
            this.stopListening();
            return this.m;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public byte[] waitForMessage(long timeoutMS, boolean isACK) {
            try {
                Object object = this.LOCK;
                synchronized (object) {
                    if (this.m == null && timeoutMS > 0L) {
                        try {
                            this.LOCK.wait(timeoutMS);
                        }
                        catch (InterruptedException x) {
                            x.printStackTrace();
                        }
                    }
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            this.stopListening();
            if (isACK && this.m != null && this.m.length == 8) {
                long T = SafeClock.currentTimeMillis();
                long O = ByteArrayUtils.readLong((byte[])this.m, (int)0);
                long RTT = T - O;
                LossyClient.this.rttMeasured(RTT);
            }
            return this.m;
        }
    }

    class TcmResponseListener
    extends ResponseListener {
        TransmissionControlMechanism tcm;
        int myIndex;

        public TcmResponseListener(Long conversation, TransmissionControlMechanism tcm, int index) {
            super(conversation);
            this.tcm = tcm;
            this.myIndex = index;
        }

        @Override
        public void received(byte[] m) {
            this.tcm.ackReceived(this.myIndex);
            this.stopListening();
        }
    }

    class LargeMessage {
        long lastUsed;
        Object LOCK = new Object();
        byte[] data;
        int[] blocksOK;

        LargeMessage() {
        }
    }

    class Processor
    implements Runnable {
        LossyTransport transport;
        Message m;
        long started;
        Thread th;
        boolean printedDelay = false;
        Object source;

        public Processor(LossyTransport transport, Message m, Object source) {
            this.transport = transport;
            this.m = m;
            this.started = SafeClock.currentTimeMillis();
            this.source = source;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object;
            this.th = Thread.currentThread();
            try {
                object = queries_LOCK;
                synchronized (object) {
                    queries.put(this, this);
                }
                LossyClient.this.processMessageReceived(this.transport, this.m, this.source);
            }
            catch (Throwable x) {
                System.out.println("[Lossy] Bad LC Message (" + x + "): " + this.m);
                x.printStackTrace();
            }
            finally {
                object = queries_LOCK;
                synchronized (object) {
                    queries.remove(this);
                }
            }
        }
    }

    class Clearer
    implements Runnable {
        long clearAt;

        public Clearer(long t) {
            this.clearAt = t;
        }

        @Override
        public void run() {
            if (SafeClock.currentTimeMillis() > this.clearAt) {
                System.out.println("[LossyClient] ***Warning - pool is too old, clearing");
                procPool.clearAll();
            }
        }
    }

    class Resend
    implements TimeoutMapListener<String, Resend> {
        BlockWaitResponseListener ackl;
        LossyTransport transport;
        Message m;
        Long conversation;
        Long ack;
        int attempt = 0;
        int resendWait = 0;

        public Resend(LossyTransport transport, Message m, Long conversation, Long ack, int attempt, int resendWait, BlockWaitResponseListener ackl) {
            this.transport = transport;
            this.m = m;
            this.conversation = conversation;
            this.ack = ack;
            this.attempt = attempt;
            this.resendWait = resendWait;
            this.ackl = ackl;
        }

        @Override
        public void objectTimedOut(String key, Resend val) {
            if (this.ackl.getResponseAndClose() == null) {
                this.resendWait *= 2;
                if (this.resendWait > STD_TIMEOUT) {
                    System.out.println("[LossyClient] Failed to send guaranteed message to " + this.transport);
                } else {
                    if (LossyClient.this.VERBOSE_NOTHREAD_RESEND) {
                        System.out.println("[LossyClient] Resending message and waiting for " + this.resendWait + ", nothread acks: " + resends.size() + ", response waits: " + LossyClient.this.responseListenerMapSize());
                    }
                    LossyClient.this.doAckedSend(this.transport, this.m, this.conversation, this.ack, this.attempt, this.resendWait);
                }
            }
        }
    }
}

