/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.images;

import com.aem.shelp.common.Language;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.SimpleHelpLookAndFeel;

public class LicenseIcon {
    public static ImageIcon getLicenseIcon(int sessions, boolean isTrial) {
        BufferedImage image = new BufferedImage(SimpleHelpLookAndFeel.scale((int)48), SimpleHelpLookAndFeel.scale((int)48), 2);
        Graphics2D g2d = image.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        g2d.setColor(SHStyle.PANEL_BACKGROUND_WHITE);
        g2d.fillRect(0, 0, image.getWidth(), image.getHeight());
        g2d.setColor(SHStyle.EXAMPLE_TEXT_COLOR_LIGHTEST);
        g2d.drawRect(0, 0, image.getWidth() - 1, image.getHeight() - 1);
        String stringSessions = Integer.toString(sessions);
        if (sessions == 10000) {
            stringSessions = Language.get("UNLIMITED");
        }
        int trialYHeight = 0;
        if (isTrial) {
            g2d.setColor(SHStyle.ERROR_TEXT_COLOR);
            String trialText = Language.get("TRIAL");
            float size = SimpleHelpLookAndFeel.scale((float)14.0f);
            Font font = g2d.getFont().deriveFont(1, size);
            g2d.setFont(font);
            FontMetrics fontMetrics = g2d.getFontMetrics();
            while (fontMetrics.stringWidth(trialText) > image.getWidth()) {
                font = font.deriveFont(size -= 2.0f);
                g2d.setFont(font);
                fontMetrics = g2d.getFontMetrics();
            }
            int width = fontMetrics.stringWidth(trialText);
            int x = (image.getWidth() - width) / 2;
            int y = image.getWidth() - fontMetrics.getDescent();
            trialYHeight = fontMetrics.getHeight() + 4;
            g2d.drawString(trialText, x, y);
        }
        float size = SimpleHelpLookAndFeel.scale((float)40.0f);
        Font font = g2d.getFont().deriveFont(size);
        g2d.setColor(SHStyle.EXAMPLE_TEXT_COLOR_DARKER);
        TextLayout tl = new TextLayout(stringSessions, font, g2d.getFontRenderContext());
        Rectangle2D bounds = tl.getBounds();
        int widthBound = SimpleHelpLookAndFeel.scale((int)38);
        if (sessions == 10000) {
            widthBound = SimpleHelpLookAndFeel.scale((int)46);
        }
        int heightBound = SimpleHelpLookAndFeel.scale((int)44);
        if (isTrial) {
            heightBound -= trialYHeight;
        }
        while (bounds.getWidth() > (double)widthBound || bounds.getHeight() > (double)heightBound) {
            font = font.deriveFont(size -= SimpleHelpLookAndFeel.scale((float)1.0f));
            tl = new TextLayout(stringSessions, font, g2d.getFontRenderContext());
            bounds = tl.getBounds();
        }
        g2d.setFont(font);
        FontMetrics fontMetrics = g2d.getFontMetrics();
        int width = fontMetrics.stringWidth(stringSessions);
        int x = (image.getWidth() - width) / 2;
        int y = isTrial ? (image.getWidth() - fontMetrics.getHeight() - trialYHeight) / 2 + fontMetrics.getAscent() : (image.getWidth() - fontMetrics.getHeight()) / 2 + fontMetrics.getAscent();
        g2d.drawString(stringSessions, x, y);
        g2d.dispose();
        return new ImageIcon(image);
    }
}

