/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.common.toolbox;

import com.aem.shelp.common.Language;

public class InterpretterOption {
    public final String id;
    private String interpretterName;
    public String interpretterCommand;
    public static final InterpretterOption[] WINDOWS_INTERPRETTERS = new InterpretterOption[]{new InterpretterOption("id_bat", "Batch Script", "cmd.exe /c ${SCRIPT}"), new InterpretterOption("id_ps", "PowerShell Script", "PowerShell.exe -ExecutionPolicy Bypass -NoLogo -NonInteractive -WindowStyle Hidden -file ${SCRIPT}"), new InterpretterOption("id_vbs", "Visual Basic Script", "wscript.exe ${SCRIPT}"), new InterpretterOption("", Language.get("TOOLBOX_CUSTOM_INTERPRETTER") + "...", "")};
    public static final InterpretterOption[] LINUX_INTERPRETTERS = new InterpretterOption[]{new InterpretterOption("id_bash", "Bash Script", "/bin/bash ${SCRIPT}"), new InterpretterOption("id_perl", "Perl Script", "perl ${SCRIPT}"), new InterpretterOption("id_python", "Python Script", "python ${SCRIPT}"), new InterpretterOption("id_ruby", "Ruby Script", "ruby ${SCRIPT}"), new InterpretterOption("id_sh", "Shell Script", "/bin/sh ${SCRIPT}"), new InterpretterOption("", Language.get("TOOLBOX_CUSTOM_INTERPRETTER") + "...", "")};
    public static final InterpretterOption[] MACOS_INTERPRETTERS = new InterpretterOption[]{new InterpretterOption("id_bash", "Bash Script", "/bin/bash ${SCRIPT}"), new InterpretterOption("id_osa", "OSA Script", "osascript -e ${SCRIPT}"), new InterpretterOption("id_perl", "Perl Script", "perl ${SCRIPT}"), new InterpretterOption("id_python", "Python Script", "python ${SCRIPT}"), new InterpretterOption("id_ruby", "Ruby Script", "ruby ${SCRIPT}"), new InterpretterOption("id_sh", "Shell Script", "/bin/sh ${SCRIPT}"), new InterpretterOption("", Language.get("TOOLBOX_CUSTOM_INTERPRETTER") + "...", "")};

    public InterpretterOption(String id, String name, String command) {
        this.id = id;
        this.interpretterName = name;
        this.interpretterCommand = command;
    }

    public String toString() {
        return this.interpretterName;
    }

    public boolean isCustom() {
        return this.id == null || this.id.length() == 0;
    }

    public static String getBestGuessExtensionFor(String scriptInterpretterCommand, String id) {
        if (scriptInterpretterCommand != null) {
            String lcCommand = scriptInterpretterCommand.toLowerCase();
            if (lcCommand.contains("cmd.exe")) {
                return "bat";
            }
            if (lcCommand.contains("powershell")) {
                return "ps1";
            }
            if (lcCommand.contains("/bash") || lcCommand.contains("/sh")) {
                return "sh";
            }
            if (lcCommand.contains("osascript")) {
                return "osa";
            }
            if (lcCommand.contains("wscript.exe") || lcCommand.contains("cscript.exe")) {
                return "vbs";
            }
            if (lcCommand.contains("ruby")) {
                return "rb";
            }
            if (lcCommand.contains("perl")) {
                return "pl";
            }
        }
        return null;
    }

    public String getBestGuessSyntax() {
        if (this.interpretterCommand != null) {
            String lcCommand = this.interpretterCommand.toLowerCase();
            if (lcCommand.contains("cmd.exe")) {
                return "text/bat";
            }
            if (lcCommand.contains("powershell")) {
                return "text/plain";
            }
            if (lcCommand.contains("/bash") || lcCommand.contains("/sh")) {
                return "text/unix";
            }
            if (lcCommand.contains("osascript")) {
                return "text/actionscript";
            }
            if (lcCommand.contains("wscript.exe") || lcCommand.contains("cscript.exe")) {
                return "text/vb";
            }
            if (lcCommand.contains("perl")) {
                return "text/perl";
            }
            if (lcCommand.contains("ruby")) {
                return "text/ruby";
            }
        }
        return "text/plain";
    }
}

