/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.common.properties;

import com.aem.shelp.common.properties.SessionProperties;
import com.aem.shelp.common.properties.TechProperties;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import javax.swing.JFrame;

public class WindowBoundsUtil {
    public static DesiredWindowBounds getDesiredWindowBounds() {
        String windowSizeOption = TechProperties.INSTANCE.getProp(TechProperties.PROP_WINDOW_SIZE);
        int option = 0;
        System.out.println("[WindowBoundsUtil] Window size option is " + windowSizeOption);
        try {
            option = Integer.parseInt(windowSizeOption);
        }
        catch (Throwable t) {
            windowSizeOption = null;
        }
        if (windowSizeOption != null) {
            DesiredWindowBounds bounds = new DesiredWindowBounds();
            switch (option) {
                case 0: {
                    bounds.isMaximized = true;
                    break;
                }
                case 1: {
                    bounds.targetSize = WindowBoundsUtil.getWindowSizeAsPercentageOfScreen(0.8);
                    break;
                }
                case 2: {
                    bounds.targetSize = WindowBoundsUtil.getWindowSizeAsPercentageOfScreen(0.7);
                    break;
                }
                case 3: {
                    bounds.targetSize = WindowBoundsUtil.getWindowSizeAsPercentageOfScreen(0.6);
                    break;
                }
                case 4: {
                    bounds.targetSize = WindowBoundsUtil.getWindowSizeAsPercentageOfScreen(0.5);
                    break;
                }
                case 5: {
                    Rectangle previousSize = SessionProperties.getPreviousWindowSize(SessionProperties.INSTANCE.getMyProperties());
                    System.out.println("[WindowBoundsUtil] Previous size is " + previousSize);
                    if (previousSize == null) break;
                    bounds.targetSize = new Dimension(previousSize.width, previousSize.height);
                    break;
                }
                case 6: {
                    Rectangle previousSize = SessionProperties.getPreviousWindowSize(SessionProperties.INSTANCE.getMyProperties());
                    System.out.println("[WindowBoundsUtil] Previous size is " + previousSize);
                    if (previousSize == null) break;
                    bounds.targetBounds = previousSize;
                    break;
                }
            }
            return bounds;
        }
        return null;
    }

    private static Dimension getWindowSizeAsPercentageOfScreen(double percentage) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Rectangle screenBounds = ge.getDefaultScreenDevice().getDefaultConfiguration().getBounds();
        Dimension screenSize = screenBounds.getSize();
        Dimension orig = screenBounds.getSize();
        screenSize.width = (int)((double)screenSize.width * percentage);
        screenSize.height = (int)((double)screenSize.height * percentage);
        System.out.println("[GUI] " + percentage + " % of " + orig + " is " + screenSize);
        return screenSize;
    }

    public static class DesiredWindowBounds {
        private boolean isMaximized = false;
        private Rectangle targetBounds = null;
        private Dimension targetSize = null;

        private boolean safeEquals(Object o1, Object o2) {
            if (o1 == null && o2 == null) {
                return true;
            }
            if (o1 == null || o2 == null) {
                return false;
            }
            return o1.equals(o2);
        }

        public boolean equals(Object o) {
            if (!(o instanceof DesiredWindowBounds)) {
                return false;
            }
            DesiredWindowBounds bounds = (DesiredWindowBounds)o;
            return bounds.isMaximized == this.isMaximized && this.safeEquals(bounds.targetBounds, this.targetBounds) && this.safeEquals(bounds.targetSize, this.targetSize);
        }

        public String toString() {
            if (this.isMaximized) {
                return "DesiredWindowBounds (1): Maximized";
            }
            if (this.targetBounds != null) {
                return "DesiredWindowBounds (2): " + this.targetBounds;
            }
            return "DesiredWindowBounds (3): " + this.targetSize;
        }

        public void applyToWindow(JFrame frame) {
            if (this.isMaximized) {
                frame.setExtendedState(6);
            } else if (this.targetBounds != null) {
                frame.setBounds(this.targetBounds);
            } else {
                if (this.targetSize != null) {
                    frame.setSize(this.targetSize);
                }
                frame.setLocationRelativeTo(null);
            }
        }

        public String getStringRepresentation() {
            if (this.isMaximized) {
                return "-1,-1,-1,-1";
            }
            if (this.targetBounds != null) {
                return this.targetBounds.x + "," + this.targetBounds.y + "," + this.targetBounds.width + "," + this.targetBounds.height;
            }
            if (this.targetSize != null) {
                return "-1,-1," + this.targetSize.width + "," + this.targetSize.height;
            }
            return null;
        }

        public static DesiredWindowBounds fromStringRepresentation(String rep) {
            if (rep == null) {
                return null;
            }
            DesiredWindowBounds windowBounds = new DesiredWindowBounds();
            String[] bounds = rep.split("\\,");
            Rectangle size = new Rectangle(Integer.parseInt(bounds[0]), Integer.parseInt(bounds[1]), Integer.parseInt(bounds[2]), Integer.parseInt(bounds[3]));
            if (size.x == -1 && size.y == -1 && size.width == -1 && size.height == -1) {
                windowBounds.isMaximized = true;
            } else if (size.x == -1 && size.y == -1) {
                windowBounds.targetSize = new Dimension(size.width, size.height);
            } else {
                windowBounds.targetBounds = size;
            }
            return windowBounds;
        }
    }
}

