/*
 * Decompiled with CFR 0.152.
 */
package com.aem.shelp.common;

import com.aem.sgateway.SimpleGatewayConfig;
import com.aem.shelp.proxy.types.MachineName;
import java.util.Properties;
import jwrapper.jwutils.JWSystem;
import jwrapper.updater.JWLaunchProperties;
import utils.string.HexData;
import utils.string.StringUtil;

public class SGParameters {
    public static final String PROP_SILENT_INSTALL = "sg_silent_install";
    public static final String PROP_SILENT_UNINSTALL = "sg_silent_uninstall";
    public static final String PROP_SILENT_INSTALL_CONFIG_XML = "sg_silent_install_config_xml";
    public static final String ARG0_SILENT_INSTALL = "silent";
    public static final String ARG0_SILENT_UNINSTALL = "uninstall";
    public static final String PROP_INSTALL_SHORTCUTS = "sg_install_shortcuts";
    public static final String NAME = "sg_name";
    public static final String GROUP = "sg_group";
    public static final String SERVER = "sg_servers";
    public static final String PERMISSION_MONITOR = "sg_monitor";
    public static final String PERMISSION_SCRIPT = "sg_script";
    public static final String PERMISSION_REQUEST = "sg_confirm";
    public static final String PERMISSION_REQUEST_TIMEOUT = "sg_confirm_timeout";
    public static final String PASSWORD = "sg_password";
    public static final String PROXY_SERVER = "sg_proxy";
    public static final String[] HEX_PARAMETERS = new String[]{"sg_name", "sg_group", "sg_servers", "sg_password", "sg_proxy"};
    public static final String[] STRING_PARAMETERS = new String[]{"sg_monitor", "sg_script", "sg_confirm", "sg_confirm_timeout", "sg_silent_install", "sg_install_shortcuts"};

    private static String getLaunchPropertyForParam(String param) {
        if (!param.startsWith("sg_")) {
            param = param.equals(ARG0_SILENT_INSTALL) ? PROP_SILENT_INSTALL : (param.equals("shortcuts") ? PROP_INSTALL_SHORTCUTS : "sg_" + param);
        }
        return param;
    }

    public static boolean writeShortcuts() {
        String property = JWLaunchProperties.getProperty((String)PROP_INSTALL_SHORTCUTS);
        boolean installShortcuts = StringUtil.stringToBoolean((String)property, (boolean)true);
        return installShortcuts;
    }

    public static void setLaunchProperty(Properties lprops, String param, String value) {
        String prop = SGParameters.getLaunchPropertyForParam(param);
        if (prop == null) {
            return;
        }
        for (String parameter : HEX_PARAMETERS) {
            if (!parameter.equals(prop)) continue;
            String hexValue = HexData.stringToHexString((String)value);
            lprops.put(prop, hexValue);
            System.out.println("[SGParameters] Set hex " + prop + "=" + hexValue);
            return;
        }
        for (String parameter : STRING_PARAMETERS) {
            if (!parameter.equals(prop)) continue;
            lprops.put(prop, value);
            System.out.println("[SGParameters] Set prop " + prop + "=" + value);
            if (prop.equals(PROP_SILENT_INSTALL)) {
                lprops.put("show_no_ui", "true");
                System.out.println("[SGParameters] Set silent");
            }
            return;
        }
    }

    private static final Boolean getBooleanProperty(String property, Properties specificLaunchProperties) {
        String prop = specificLaunchProperties == null ? JWSystem.getAppLaunchProperty((String)property) : specificLaunchProperties.getProperty(property);
        if (prop != null && prop.length() > 0) {
            if (Boolean.parseBoolean(prop) || prop.equals("yes") || prop.equals("on")) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return null;
    }

    private static final String getStringProperty(String property, Properties specificLaunchProperties) {
        String hexProp = specificLaunchProperties == null ? JWSystem.getAppLaunchProperty((String)property) : specificLaunchProperties.getProperty(property);
        if (hexProp != null && hexProp.length() > 0) {
            return HexData.hexStringToString((String)hexProp);
        }
        return null;
    }

    private static final String getProperty(String property, Properties specificLaunchProperties) {
        String stringValue = specificLaunchProperties == null ? JWSystem.getAppLaunchProperty((String)property) : specificLaunchProperties.getProperty(property);
        if (stringValue != null && stringValue.length() > 0) {
            return stringValue;
        }
        return null;
    }

    public static void stripSGConfigLaunchProperties(Properties lprops) {
        lprops.setProperty(NAME, "");
        lprops.setProperty(GROUP, "");
        lprops.setProperty(SERVER, "");
        lprops.setProperty(PERMISSION_MONITOR, "");
        lprops.setProperty(PERMISSION_SCRIPT, "");
        lprops.setProperty(PERMISSION_REQUEST, "");
        lprops.setProperty(PERMISSION_REQUEST_TIMEOUT, "");
        lprops.setProperty(PASSWORD, "");
        lprops.setProperty(PROXY_SERVER, "");
        lprops.setProperty(PROP_SILENT_INSTALL, "false");
        lprops.setProperty(PROP_SILENT_INSTALL_CONFIG_XML, "");
        lprops.setProperty(PROP_INSTALL_SHORTCUTS, "");
    }

    public static void updateSGConfigWithLaunchProperties(SimpleGatewayConfig config) {
        SGParameters.updateSGConfigWithLaunchProperties(config, null);
    }

    public static void updateSGConfigWithLaunchProperties(SimpleGatewayConfig config, Properties specificLaunchProperties) {
        String name = SGParameters.getStringProperty(NAME, specificLaunchProperties);
        String group = SGParameters.getStringProperty(GROUP, specificLaunchProperties);
        String servers = SGParameters.getStringProperty(SERVER, specificLaunchProperties);
        String password = SGParameters.getStringProperty(PASSWORD, specificLaunchProperties);
        String proxy = SGParameters.getStringProperty(PROXY_SERVER, specificLaunchProperties);
        Boolean canMonitor = SGParameters.getBooleanProperty(PERMISSION_MONITOR, specificLaunchProperties);
        Boolean canScript = SGParameters.getBooleanProperty(PERMISSION_SCRIPT, specificLaunchProperties);
        Boolean mustRequest = SGParameters.getBooleanProperty(PERMISSION_REQUEST, specificLaunchProperties);
        long timeout = 0L;
        try {
            String tmp = SGParameters.getProperty(PERMISSION_REQUEST_TIMEOUT, specificLaunchProperties);
            if (tmp != null) {
                timeout = Long.parseLong(tmp);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        MachineName newName = MachineName.extractFromNameWithGroup(config.getName());
        if (name != null && name.length() > 0) {
            newName.setName(name);
        }
        if (group != null && group.length() > 0) {
            newName.setGroup(group.split("\\/"));
        }
        config.setName(newName.toString());
        if (servers != null && servers.length() > 0) {
            config.setURLs(servers.split(","));
        }
        if (password != null && password.length() > 0) {
            config.setPassword(password);
        }
        if (canMonitor != null) {
            config.setAllowMonitoring(canMonitor);
        }
        if (mustRequest != null) {
            config.setRequireSessionConfirmation(mustRequest, timeout);
        }
        if (canScript != null) {
            config.setAllowScripting(canScript);
        }
        if (proxy != null && proxy.length() > 0) {
            int colonIndex;
            String userBit = null;
            String serverBit = null;
            int atIndex = proxy.indexOf(64);
            if (atIndex == -1) {
                serverBit = proxy;
            } else {
                userBit = proxy.substring(0, atIndex);
                serverBit = proxy.substring(atIndex + 1);
            }
            if (userBit != null) {
                colonIndex = userBit.indexOf(58);
                if (colonIndex == -1) {
                    config.setProxyUser(userBit);
                } else {
                    config.setProxyUser(userBit.substring(0, colonIndex));
                    config.setProxyPass(userBit.substring(colonIndex + 1));
                }
            }
            if (serverBit != null) {
                colonIndex = serverBit.indexOf(58);
                if (colonIndex == -1) {
                    config.setProxyHost(serverBit);
                } else {
                    config.setProxyHost(serverBit.substring(0, colonIndex));
                    try {
                        config.setProxyPort(Integer.parseInt(serverBit.substring(colonIndex + 1)));
                    }
                    catch (NumberFormatException x) {
                        x.printStackTrace();
                    }
                }
            }
        }
    }
}

