/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sgateway.mdupload;

import com.aem.CentralDebugging;
import com.aem.sgateway.genstore.GenStoreProvider;
import com.aem.sgateway.genstore.ServiceGenStore;
import com.aem.sgateway.mdupload.MonitoringBroadcastListener;
import com.aem.sgateway.mdupload.MonitoringMessages;
import com.aem.shelp.common.Language;
import com.aem.shelp.common.PC;
import com.aem.shelp.common.toolbox.ToolBoxItem;
import com.aem.shelp.common.toolbox.ToolBoxResult;
import com.aem.shelp.common.toolbox.ToolBoxStatus;
import com.aem.shelp.common.toolbox.ToolResourceLocator;
import com.aem.shelp.common.toolbox.server.ToolBoxRunner;
import com.aem.shelp.proxy.types.Alert;
import com.aem.shelp.proxy.types.AlertInput;
import com.aem.shelp.proxy.types.GlobalEvents;
import com.aem.shelp.proxy.types.TrackedAlert;
import com.aem.shelp.proxy.types.alerts.ResourceSerialiser;
import com.aem.shelp.util.OneClock;
import com.aem.shelp.util.ScreenDimension;
import com.aem.shelp.util.notifications.StandaloneNotification;
import com.aem.tests.Testing;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.awt.image.RGBImageFilter;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Properties;
import javax.imageio.ImageIO;
import jwrapper.hidden.JWNativeAPI;
import jwrapper.jwutils.JWSockIPC;
import jwrapper.jwutils.JWSockIPCListener;
import jwrapper.jwutils.JWSystem;
import utils.ddebug.DDLog;
import utils.message.Message;
import utils.message.MessageUtils;
import utils.osstats.LoadAverageUtil;
import utils.osstats.OsStats;
import utils.osstats.Stats;
import utils.osstats.av.SecurityProduct;
import utils.osstats.sort.DiskSpaceComparator;
import utils.osstats.sort.ProcessStatComparator;
import utils.ostools.OS;
import utils.progtools.OnDemandThreadPool;
import utils.progtools.TimeoutMap;
import utils.progtools.TimeoutMapListener;
import utils.progtools.net.URLParser;
import utils.software.OSSoftwareUtil;
import utils.software.types.software.Software;
import utils.swing.aa.AntiAliasingEnforcer;
import utils.swing.images.ColorSnapFilter;
import utils.swing.images.ImageHelper;
import utils.switches.Switches;
import utils.udp.Acculog;

public class SimpleGatewayMonitoring
implements JWSockIPCListener {
    private static final short CHANNEL_BROADCAST = 1;
    private static final short CHANNEL_REQUESTS = 2;
    private JWSockIPC ipc;
    private MonitoringBroadcastListener broadcast;
    private BroadcastReader breader;
    private boolean monitoringOn = false;
    ClockSend curClockSend = null;
    private final Object REQ_LOCK = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOn(Object ddlogID, boolean on, MonitoringBroadcastListener broadcast) throws Exception {
        try {
            Object object = this.REQ_LOCK;
            synchronized (object) {
                if (on) {
                    if (!this.isOn()) {
                        System.out.println("[Monitoring] Starting monitoring");
                        this.broadcast = broadcast;
                        Properties lprops = new Properties();
                        lprops.setProperty("launch_in_session", "true");
                        lprops.setProperty("show_no_ui", "true");
                        if (Testing.amTesting()) {
                            lprops.remove("launch_in_session");
                            lprops.remove("launch_in_specific_session");
                            lprops.setProperty("procpri_low", "true");
                        }
                        System.out.println("[Monitoring] Initialising IPC");
                        JWSockIPC.setupForIPC((Properties)lprops, (boolean)true);
                        System.out.println("[Monitoring] Forking monitoring process");
                        JWSystem.forkVirtualApp((String)"Remote Access Monitoring", (Properties)lprops, (String[])new String[0], (boolean)false, (boolean)true);
                        this.ipc = JWSockIPC.connectParent((Properties)lprops);
                        if (CentralDebugging.DDEBUG_ON) {
                            DDLog.alias(ddlogID, this.ipc.getRawUnencryptedSocket().getLocalSocketAddress());
                        }
                        System.out.println("[Monitoring] Setting up mutliple channels");
                        this.ipc.setupMultipleChannels();
                        this.ipc.setupPingsAndReportClosure((JWSockIPCListener)this, (short)999, 20000L);
                        this.monitoringOn = true;
                        this.breader = new BroadcastReader();
                        this.breader.start();
                    }
                } else {
                    System.out.println("[Monitoring] Ending monitoring");
                    this.terminateMonitoringConnection();
                }
            }
        }
        catch (Exception xx) {
            try {
                this.ipc.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.ipc = null;
            throw xx;
        }
    }

    private void terminateMonitoringConnection() {
        System.out.println("[Monitoring] Terminating monitoring connection");
        if (this.ipc != null) {
            this.ipc.close();
        }
        this.ipc = null;
        try {
            this.breader.interrupt();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isOn() {
        return this.ipc != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendAlerts(ArrayList<Alert> glo, ToolResourceLocator locator) {
        Object object = this.REQ_LOCK;
        synchronized (object) {
            OutputStream out = this.ipc.getOutChannel((short)2);
            Message m = new Message(1589731349);
            for (Alert ai : glo) {
                m.append(ResourceSerialiser.alertToMessage(ai));
            }
            m.append(locator.toMessage());
            try {
                MessageUtils.writeMessage((OutputStream)out, (Message)m);
            }
            catch (IOException x) {
                x.printStackTrace();
                System.out.println("[Monitoring] Unable to send alerts to monitor, will terminate monitoring connection");
                this.terminateMonitoringConnection();
            }
        }
    }

    public void sendClockAsync(String server, long clock) {
        if (this.curClockSend == null) {
            this.curClockSend = new ClockSend(server, clock);
            this.curClockSend.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendClock(String server, long clock) {
        Object object = this.REQ_LOCK;
        synchronized (object) {
            OutputStream out = this.ipc.getOutChannel((short)2);
            Message m = new Message(1589727266);
            m.append(server);
            m.append(clock);
            try {
                MessageUtils.writeMessage((OutputStream)out, (Message)m);
            }
            catch (IOException x) {
                x.printStackTrace();
                System.out.println("[Monitoring] Unable to send clock to monitor, will terminate monitoring connection");
                this.terminateMonitoringConnection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestPopup(String title, String contents) {
        Object object = this.REQ_LOCK;
        synchronized (object) {
            OutputStream out = this.ipc.getOutChannel((short)2);
            Message m = new Message(1589727267);
            m.append(title);
            m.append(contents);
            try {
                MessageUtils.writeMessage((OutputStream)out, (Message)m);
            }
            catch (IOException x) {
                x.printStackTrace();
                System.out.println("[Monitoring] Unable to send popup request to monitor, will terminate monitoring connection");
                this.terminateMonitoringConnection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestStateDump() {
        Object object = this.REQ_LOCK;
        synchronized (object) {
            OutputStream out = this.ipc.getOutChannel((short)2);
            Message m = new Message(1589727265);
            try {
                MessageUtils.writeMessage((OutputStream)out, (Message)m);
            }
            catch (IOException x) {
                x.printStackTrace();
                System.out.println("[Monitoring] Unable to send state dump request to monitor, will terminate monitoring connection");
                this.terminateMonitoringConnection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forwardRequest(Message message) {
        Object object = this.REQ_LOCK;
        synchronized (object) {
            OutputStream out = this.ipc.getOutChannel((short)2);
            try {
                MessageUtils.writeMessage((OutputStream)out, (Message)message);
            }
            catch (IOException x) {
                x.printStackTrace();
                System.out.println("[Monitoring] Unable to forward request to monitor, will terminate monitoring connection");
                this.terminateMonitoringConnection();
            }
        }
    }

    public void ipcClosed() {
        System.out.println("[Monitoring] WARNING: Monitoring process failed...");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        try {
            Acculog.setJVM("RAMonitoring");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        CentralDebugging.loadDebugSettings("SimpleGatewayMonitoring", false);
        if (Switches.SH_1559_centralClock) {
            OneClock.startClockThread();
        }
        Alert.setReadOnlyAlerts(true);
        try {
            JWSockIPC ipc = JWSockIPC.connectChild();
            System.out.println("[Monitoring] Beginning IPC");
            ipc.setupMultipleChannels();
            System.out.println("[Monitoring] Setting up SG Monitor");
            SimpleGatewayMonitor sgm = new SimpleGatewayMonitor(ipc);
            System.out.println("[Monitoring] Setting up IPC to report pings and closure");
            ipc.setupPingsAndReportClosure((JWSockIPCListener)sgm, (short)999, 20000L);
            try {
                Language.loadTranslations();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            System.out.println("[Monitoring] Starting monitoring");
            sgm.startup();
            System.out.println("[Monitoring] Started monitoring");
        }
        finally {
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {}
        }
    }

    static class SimpleGatewayMonitor
    implements JWSockIPCListener,
    GenStoreProvider {
        int requestedScreen = 0;
        final JWSockIPC ipc;
        RequestReader rreader;
        DataCollection dcoll;
        final Object storedAlerts_LOCK = new Object();
        HashMap<String, Alert> storedAlerts = new HashMap();
        private final long TOOL_MAX_TIMEOUT = 86400000L;
        private final Object toolMapLock = new Object();
        private TimeoutMap<Long, ToolBoxRunner.ToolBoxRun> toolMap = new TimeoutMap();
        private TimeoutMapListener<Long, ToolBoxRunner.ToolBoxRun> timeoutMapListener = new TimeoutMapListener<Long, ToolBoxRunner.ToolBoxRun>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void objectTimedOut(Long key, ToolBoxRunner.ToolBoxRun val) {
                Object object = SimpleGatewayMonitor.this.toolMapLock;
                synchronized (object) {
                    val.cancelJob();
                }
            }
        };
        final Object BR_LOCK = new Object();
        OnDemandThreadPool rrodp = new OnDemandThreadPool("SGMonitoringRunRespond", 5, 10, 5);
        Object popups_LOCK = new Object();
        ArrayList<PopupTracker> popups = new ArrayList();
        Robot robot = null;
        boolean sendDetailsImmediate = true;
        boolean sendThumbnailsImmediate = true;
        boolean sendBigScreenImmediate = true;
        private Software software = null;
        private static final long SOFTWARE_MIN_DELAY = 1800000L;
        boolean sendSoftwareImmediate = true;
        private long softwareRequested;
        long sendThumbnailsUntil = 0L;
        long sendDetailsUntil = 0L;

        public SimpleGatewayMonitor(JWSockIPC ipc) {
            this.ipc = ipc;
            ServiceGenStore.setup(this);
        }

        public void ipcClosed() {
            System.out.println("[RA Monitor] IPC closed, shutting down");
            System.exit(0);
        }

        public void die(String reason) {
            System.out.println("[RA Monitor] Exiting (" + reason + ")");
            this.ipcClosed();
        }

        public void startup() {
            if (CentralDebugging.DDEBUG_ON) {
                DDLog.setProcess("Monitoring");
                DDLog.alias(this.ipc, this.ipc.getRawUnencryptedSocket().getRemoteSocketAddress());
                DDLog.log(this.ipc, "Monitoring process started");
            }
            this.rreader = new RequestReader();
            this.dcoll = new DataCollection();
            this.rreader.start();
            this.dcoll.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void broadcast(Message m) {
            try {
                Object object = this.BR_LOCK;
                synchronized (object) {
                    OutputStream out = this.ipc.getOutChannel((short)1);
                    if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                        DDLog.log(this.ipc, "Broadcasting message " + m);
                    }
                    System.out.println("[Monitoring] Broadcasting message " + m.toPretty(PC.REFS));
                    MessageUtils.writeMessage((OutputStream)out, (Message)m);
                }
            }
            catch (IOException x) {
                x.printStackTrace();
                this.die("Failed to send monitoring data");
            }
        }

        @Override
        public void sendBulkData(Message message) {
            Message wrapper = new Message(1589706800);
            wrapper.append(message);
            this.broadcast(wrapper);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Message processRequest(Message request, String serverHTTPAddressMaybeNull, boolean allowCancel, long cancellationID, ToolBoxRunner.ToolBoxStatusListener toolBoxStatusListener) {
            int type;
            System.out.println("[Monitoring] Incoming request " + request.toPretty(PC.REFS));
            if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                DDLog.log(this.ipc, "Incoming forwarded monitoring request " + request);
            }
            if ((type = request.getType()) == 1589727237) {
                this.dcoll.sendDetails();
            } else if (type == 1589727238) {
                this.dcoll.sendThumbnailInfo(false);
            } else if (type == 1589727249) {
                this.dcoll.sendBigScreen();
            } else if (type == 1589706780) {
                Message toProcess = request.getNextMessage();
                long responseID = request.getNextLong();
                long techID = request.getNextLong();
                String messengerID = request.getNextString();
                String serverAddress = request.getNextString();
                RunRespond rr = new RunRespond(toProcess, responseID, techID, messengerID, serverAddress);
                if (toProcess.getType() == 1589727253 && Switches.SH_XXXX_paralleliseToolRuns) {
                    this.rrodp.runAsync((Runnable)rr);
                } else {
                    rr.run();
                }
            } else if (type == 1589727273) {
                ToolBoxRunner.ToolBoxRun runningJob;
                long cancelID = request.getNextLong();
                System.out.println("[SimpleGatewayMonitor] Asked to terminate job with ID " + cancelID);
                Object techID = this.toolMapLock;
                synchronized (techID) {
                    runningJob = this.toolMap.remove(cancelID);
                }
                if (runningJob != null) {
                    runningJob.cancelJob();
                }
            } else {
                if (type == 1589727253) {
                    Message toolBoxToRun = request.getNextMessage();
                    String serverAddress = null;
                    if (request.hasNext()) {
                        serverAddress = request.getNextString();
                    }
                    if (serverHTTPAddressMaybeNull == null) {
                        serverHTTPAddressMaybeNull = serverAddress;
                    }
                    ToolBoxItem item = new ToolBoxItem();
                    item.fromMessage(toolBoxToRun);
                    System.out.println("[SimpleGatewayMonitor] Asked to run a tool " + item);
                    URLParser parser = new URLParser(serverHTTPAddressMaybeNull);
                    String hostname = parser.getHostname();
                    int port = parser.getPort(true);
                    ToolBoxRunner.ToolBoxRun runningTool = ToolBoxRunner.launchToolBoxItem(item, hostname, port, toolBoxStatusListener);
                    Object rr = this.toolMapLock;
                    synchronized (rr) {
                        this.toolMap.put(cancellationID, runningTool, 86400000L, this.timeoutMapListener);
                    }
                    ToolBoxResult result = ToolBoxRunner.blockForToolBoxResult(runningTool, toolBoxStatusListener);
                    if (result == null) {
                        return null;
                    }
                    return result.toMessage();
                }
                if (type == 1589727256) {
                    boolean next = request.getNextBoolean();
                    boolean big = request.getNextBoolean();
                    this.requestedScreen = next ? ++this.requestedScreen : --this.requestedScreen;
                    int screenCount = ScreenDimension.detectScreenDimensions(true).length;
                    if (this.requestedScreen < 0) {
                        this.requestedScreen = screenCount - 1;
                    }
                    if (this.requestedScreen >= screenCount) {
                        this.requestedScreen = 0;
                    }
                    this.dcoll.sendThumbnailInfo(true);
                    if (big) {
                        this.dcoll.sendBigScreen();
                    }
                } else if (type == 1589727266) {
                    String server = request.getNextString();
                    long clock = request.getNextLong();
                    System.out.println("[SimpleGatewayMonitor] Server " + server + " centralised time is " + OneClock.translate(clock));
                } else if (type == 1589727267) {
                    String title = request.getNextString();
                    String contents = request.getNextString();
                    System.out.println("[StateDump] Popup requested:\n Heading: " + title + "\n " + contents);
                    try {
                        AntiAliasingEnforcer.tryToSetAllFontsAntialiased();
                    }
                    catch (Throwable screenCount) {
                        // empty catch block
                    }
                    PopupTracker tracker = new PopupTracker();
                    StandaloneNotification note = new StandaloneNotification(null, title, contents, tracker);
                    tracker.setStandaloneNotification(note);
                } else if (type == 1589727265) {
                    System.out.println("[StateDump] State dump requested");
                    ArrayList<AlertInput> list = GlobalEvents.get().getAllAlerts();
                    for (AlertInput input : list) {
                        if (input instanceof Alert) {
                            Alert alert = (Alert)input;
                            System.out.println("[StateDump] Alert: " + alert);
                            continue;
                        }
                        System.out.println("[StateDump] Non-Alert: " + input);
                    }
                } else if (type == 1589731349) {
                    System.out.println("[Alerts] New alerts list from SG service, fullList=(always), items=" + request.length() + ", stored=" + this.storedAlerts.size());
                    ArrayList<AlertInput> glo = new ArrayList<AlertInput>();
                    try {
                        ToolResourceLocator.loadSingletonFrom((Message)request.pop());
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    Object object = this.storedAlerts_LOCK;
                    synchronized (object) {
                        HashMap<String, Alert> newStoredAlerts = new HashMap<String, Alert>();
                        for (int i = 0; i < request.length(); ++i) {
                            Message amsg = request.getNextMessage();
                            try {
                                Alert existing;
                                Alert newalert = ResourceSerialiser.alertFromMessage(amsg);
                                if (CentralDebugging.SG_ALERTS) {
                                    System.out.println("[Alerts] Alert: " + newalert.getName() + " (" + newalert.getID() + ") clock=" + newalert.getModifiedClock());
                                }
                                if (CentralDebugging.SG_ALERTS_MSGS) {
                                    System.out.println("[Alerts] -- " + amsg.toPretty(PC.REFS));
                                }
                                if ((existing = this.storedAlerts.get(newalert.getID())) != null) {
                                    if (CentralDebugging.SG_ALERTS) {
                                        System.out.println("[Alerts] Merging state from " + existing.getName() + " (" + existing.getID() + ") clock=" + existing.getModifiedClock());
                                    } else {
                                        System.out.println("[Alerts] No existing state to merge with this alert, this is a brand new alert");
                                    }
                                    newalert.copyTriggeredStateFrom(existing);
                                } else if (Switches.SH_2210_initialiseNewAlertsAsReset) {
                                    newalert.initialiseNewTriggeredState();
                                }
                                newalert.storeTriggeredStateInto(newStoredAlerts);
                                glo.add(newalert);
                                continue;
                            }
                            catch (Exception x) {
                                System.out.println("[Alerts] Problem deserialising alert: " + x);
                                x.printStackTrace();
                            }
                        }
                        this.storedAlerts = newStoredAlerts;
                    }
                    System.out.println("[Alerts] Accepted " + glo.size() + " alerts from SG service");
                    glo.add(new AlertReporter());
                    GlobalEvents.get().setAllAlerts(glo);
                } else if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                    DDLog.log(this.ipc, "UNKNOWN forwarded monitoring request " + request);
                }
            }
            return null;
        }

        class DataCollection
        extends Thread {
            Stats stats = null;
            final Object LOCK = new Object();
            final long DATA_PERIOD = 120000L;
            LoadAverageUtil cpuLoadAverage = new LoadAverageUtil();
            LoadAverageUtil memLoadAverage = new LoadAverageUtil();
            public boolean statsAlreadyUpdated = false;
            public boolean statsAlreadyUpdatedLight = false;
            int initialConsoleSession;
            int failedConsoleChecks = 0;
            Message testing_cachedThumb;
            Message testing_cachedBigShot;

            DataCollection() {
            }

            public void sendSoftware() {
                if (SimpleGatewayMonitor.this.software == null || System.currentTimeMillis() - SimpleGatewayMonitor.this.softwareRequested > 1800000L) {
                    SimpleGatewayMonitor.this.sendSoftwareImmediate = true;
                    SimpleGatewayMonitor.this.softwareRequested = System.currentTimeMillis();
                    if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                        DDLog.log(SimpleGatewayMonitor.this.ipc, "Asked to send Software");
                    }
                    System.out.println("[Monitoring] Asked to send Software");
                    this.wakeNow();
                }
            }

            public void sendDetails() {
                if (System.currentTimeMillis() - SimpleGatewayMonitor.this.sendDetailsUntil > 120000L) {
                    SimpleGatewayMonitor.this.sendDetailsImmediate = true;
                }
                if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                    DDLog.log(SimpleGatewayMonitor.this.ipc, "Asked to send detailed info +120s");
                }
                System.out.println("[Monitoring] Asked to send detailed info +120s");
                SimpleGatewayMonitor.this.sendDetailsUntil = System.currentTimeMillis() + 120000L;
                if (SimpleGatewayMonitor.this.sendDetailsImmediate) {
                    this.wakeNow();
                }
                System.out.println("[Monitoring] Will ask self to send thumbnail info too...");
                this.sendThumbnailInfo(false);
            }

            public void sendThumbnailInfo(boolean now) {
                if (now || System.currentTimeMillis() - SimpleGatewayMonitor.this.sendThumbnailsUntil > 120000L) {
                    SimpleGatewayMonitor.this.sendThumbnailsImmediate = true;
                }
                if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                    DDLog.log(SimpleGatewayMonitor.this.ipc, "Asked to send thumbnail info +120s");
                }
                System.out.println("[Monitoring] Asked to send thumbnail info +120s");
                SimpleGatewayMonitor.this.sendThumbnailsUntil = System.currentTimeMillis() + 120000L;
                if (SimpleGatewayMonitor.this.sendThumbnailsImmediate) {
                    this.wakeNow();
                }
            }

            public void sendBigScreen() {
                SimpleGatewayMonitor.this.sendBigScreenImmediate = true;
                if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                    DDLog.log(SimpleGatewayMonitor.this.ipc, "Asked to send Big Screenshot");
                }
                this.wakeNow();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void wakeNow() {
                Object object = this.LOCK;
                synchronized (object) {
                    this.LOCK.notifyAll();
                }
            }

            private void updateStatsLight() {
                if (this.stats == null) {
                    if (Testing.amTesting()) {
                        System.out.println("[Monitoring] ***WARNING*** Creating new stats?");
                    }
                    this.stats = OsStats.getOsStats((boolean)Testing.amTesting(), (boolean)false);
                }
                if (this.stats != null && (this.statsAlreadyUpdated || this.statsAlreadyUpdatedLight)) {
                    return;
                }
                if (CentralDebugging.SG_MONITORING_SOURCE) {
                    System.out.println("[Monitoring] Collecting new light stats now...");
                }
                this.stats.updateLight();
                this.statsAlreadyUpdatedLight = true;
                this.cpuLoadAverage.addSample(System.currentTimeMillis(), this.stats.getCpuUsagePercent());
                this.memLoadAverage.addSample(System.currentTimeMillis(), this.stats.getMemoryUsedPercent());
            }

            private void updateStats() {
                if (this.stats == null) {
                    if (Testing.amTesting()) {
                        System.out.println("[Monitoring] ***WARNING*** Creating new stats?");
                    }
                    this.stats = OsStats.getOsStats((boolean)Testing.amTesting(), (boolean)false);
                }
                if (this.stats != null && !this.statsAlreadyUpdated) {
                    if (CentralDebugging.SG_MONITORING_SOURCE) {
                        System.out.println("[Monitoring] Collecting new stats now...");
                    }
                    this.stats.update();
                    this.cpuLoadAverage.addSample(System.currentTimeMillis(), this.stats.getCpuUsagePercent());
                    this.memLoadAverage.addSample(System.currentTimeMillis(), this.stats.getMemoryUsedPercent());
                    this.statsAlreadyUpdated = true;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    System.out.println("[Monitoring] Starting data collection now");
                    if (OS.isWindows()) {
                        this.initialConsoleSession = JWNativeAPI.getInstance().getTsConsoleSessionId();
                    }
                    this.statsAlreadyUpdated = false;
                    this.stats = OsStats.getOsStats();
                    long next2s = System.currentTimeMillis() + 2000L;
                    long next10s = System.currentTimeMillis() + 10000L;
                    long next30s = System.currentTimeMillis() + 30000L;
                    long next1m = System.currentTimeMillis() + 60000L;
                    long next5m = System.currentTimeMillis() + 300000L;
                    long next30m = System.currentTimeMillis() + 1800000L;
                    long next1hr = System.currentTimeMillis() + 3600000L;
                    long next4hr = System.currentTimeMillis() + 14400000L;
                    long next8hr = System.currentTimeMillis() + 28800000L;
                    long next24hr = System.currentTimeMillis() + 86400000L;
                    try {
                        SimpleGatewayMonitor.this.robot = new Robot();
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    Object t = this.LOCK;
                    synchronized (t) {
                        if (!(SimpleGatewayMonitor.this.sendSoftwareImmediate || SimpleGatewayMonitor.this.sendDetailsImmediate || SimpleGatewayMonitor.this.sendThumbnailsImmediate || SimpleGatewayMonitor.this.sendBigScreenImmediate)) {
                            this.LOCK.wait((int)(Math.random() * 30000.0));
                        }
                    }
                    while (true) {
                        try {
                            while (true) {
                                long T;
                                if (Testing.amTesting()) {
                                    this.stats = OsStats.getOsStats((boolean)true, (boolean)false);
                                    System.out.println("[Monitoring] Populating stats " + this.stats.hashCode() + " with fake data");
                                    this.statsAlreadyUpdated = true;
                                    System.out.println("[Monitoring] Stats fake data done, cpu=" + this.stats.getCpuUsagePercent());
                                } else {
                                    this.statsAlreadyUpdated = false;
                                }
                                t = this.LOCK;
                                synchronized (t) {
                                    if (!(SimpleGatewayMonitor.this.sendSoftwareImmediate || SimpleGatewayMonitor.this.sendDetailsImmediate || SimpleGatewayMonitor.this.sendThumbnailsImmediate || SimpleGatewayMonitor.this.sendBigScreenImmediate)) {
                                        this.LOCK.wait(2500L);
                                    }
                                }
                                if (SimpleGatewayMonitor.this.sendBigScreenImmediate) {
                                    SimpleGatewayMonitor.this.sendBigScreenImmediate = false;
                                    if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                                        DDLog.log(SimpleGatewayMonitor.this.ipc, "Will send Big Screenshot now");
                                    }
                                    this.sendScreenshot(SimpleGatewayMonitor.this.requestedScreen, false);
                                }
                                if (SimpleGatewayMonitor.this.sendDetailsImmediate) {
                                    SimpleGatewayMonitor.this.sendDetailsImmediate = false;
                                    this.sendScreenshot(SimpleGatewayMonitor.this.requestedScreen, true);
                                    this.sendOsDetailedStats();
                                }
                                if (SimpleGatewayMonitor.this.sendThumbnailsImmediate) {
                                    SimpleGatewayMonitor.this.sendThumbnailsImmediate = false;
                                    this.sendOsBasicStats();
                                    this.sendScreenshot(SimpleGatewayMonitor.this.requestedScreen, true);
                                }
                                if (SimpleGatewayMonitor.this.sendSoftwareImmediate) {
                                    SimpleGatewayMonitor.this.sendSoftwareImmediate = false;
                                    this.uploadSoftware();
                                }
                                if ((T = System.currentTimeMillis()) > next2s) {
                                    this.every2sec();
                                    next2s = System.currentTimeMillis() + 2000L;
                                }
                                if (T > next10s) {
                                    if (CentralDebugging.SG_MONITORING_SOURCE) {
                                        System.out.println("[SimpleGatewayMonitoring] ++++++ 10s Monitoring Upload");
                                    }
                                    if (GlobalEvents.get().hasAlerts()) {
                                        if (Testing.amTesting()) {
                                            this.stats = OsStats.getOsStats((boolean)true, (boolean)false);
                                            this.statsAlreadyUpdated = true;
                                        } else {
                                            this.updateStats();
                                        }
                                    }
                                    GlobalEvents.get().machineStats(this.stats);
                                    this.every10sec();
                                    next10s = System.currentTimeMillis() + 10000L;
                                }
                                if (T > next30s) {
                                    if (CentralDebugging.SG_MONITORING_SOURCE) {
                                        System.out.println("[SimpleGatewayMonitoring] ++++++ 30s Monitoring Upload");
                                    }
                                    this.every30sec();
                                    next30s = System.currentTimeMillis() + 30000L;
                                }
                                if (T > next1m) {
                                    if (CentralDebugging.SG_MONITORING_SOURCE) {
                                        System.out.println("[SimpleGatewayMonitoring] ++++++ 1m Monitoring Upload");
                                    }
                                    if (!Testing.amTesting()) {
                                        ArrayList<SecurityProduct> secs = SecurityProduct.getAVProducts();
                                        for (SecurityProduct sec : secs) {
                                            System.out.println("SecProd: " + sec);
                                        }
                                        GlobalEvents.get().securityStats(secs);
                                    }
                                    this.every1min();
                                    next1m = System.currentTimeMillis() + 60000L;
                                }
                                if (T > next5m) {
                                    if (CentralDebugging.SG_MONITORING_SOURCE) {
                                        System.out.println("[SimpleGatewayMonitoring] ++++++ 5m Monitoring Upload");
                                    }
                                    this.every5min();
                                    next5m = System.currentTimeMillis() + 300000L;
                                }
                                if (T > next30m) {
                                    if (CentralDebugging.SG_MONITORING_SOURCE) {
                                        System.out.println("[SimpleGatewayMonitoring] ++++++ 30m Monitoring Upload");
                                    }
                                    this.every30min();
                                    next30m = System.currentTimeMillis() + 1800000L;
                                }
                                if (T > next1hr) {
                                    if (CentralDebugging.SG_MONITORING_SOURCE) {
                                        System.out.println("[SimpleGatewayMonitoring] ++++++ 1h Monitoring Upload");
                                    }
                                    this.every1hr();
                                    next1hr = System.currentTimeMillis() + 3600000L;
                                }
                                if (T > next4hr) {
                                    if (CentralDebugging.SG_MONITORING_SOURCE) {
                                        System.out.println("[SimpleGatewayMonitoring] ++++++ 4h Monitoring Upload");
                                    }
                                    this.every4hr();
                                    next4hr = System.currentTimeMillis() + 14400000L;
                                }
                                if (T > next8hr) {
                                    if (CentralDebugging.SG_MONITORING_SOURCE) {
                                        System.out.println("[SimpleGatewayMonitoring] ++++++ 8h Monitoring Upload");
                                    }
                                    this.every8hr();
                                    next8hr = System.currentTimeMillis() + 28800000L;
                                }
                                if (T <= next24hr) continue;
                                if (CentralDebugging.SG_MONITORING_SOURCE) {
                                    System.out.println("[SimpleGatewayMonitoring] ++++++ 24h Monitoring Upload");
                                }
                                this.every24hr();
                                next24hr = System.currentTimeMillis() + 86400000L;
                            }
                        }
                        catch (Exception x) {
                            x.printStackTrace();
                            continue;
                        }
                        break;
                    }
                }
                catch (Throwable x) {
                    x.printStackTrace();
                    SimpleGatewayMonitor.this.die("Severe error in DataCollection");
                    return;
                }
            }

            public void every2sec() {
                if (Switches.SH_moreFrequentCpuData && System.currentTimeMillis() < SimpleGatewayMonitor.this.sendThumbnailsUntil) {
                    this.sendOsBasicStats();
                }
            }

            public void every10sec() {
                if (!Switches.SH_moreFrequentCpuData && System.currentTimeMillis() < SimpleGatewayMonitor.this.sendThumbnailsUntil) {
                    this.sendOsBasicStats();
                    this.sendLoadAverages();
                }
                if (OS.isWindows()) {
                    int consoleSession = JWNativeAPI.getInstance().getTsConsoleSessionId();
                    if (consoleSession != this.initialConsoleSession) {
                        ++this.failedConsoleChecks;
                        if (this.failedConsoleChecks == 2) {
                            System.out.println("[Monitoring] Console session has changed from " + this.initialConsoleSession + " to " + consoleSession + ", requesting a restart of monitoring process");
                            Message m = new Message(1589727269);
                            SimpleGatewayMonitor.this.broadcast(m);
                        }
                    } else {
                        this.failedConsoleChecks = 0;
                    }
                }
            }

            public void every30sec() {
                long tNow = System.currentTimeMillis();
                if (tNow < SimpleGatewayMonitor.this.sendDetailsUntil) {
                    this.sendScreenshot(SimpleGatewayMonitor.this.requestedScreen, true);
                    this.sendOsDetailedStats();
                } else if (tNow < SimpleGatewayMonitor.this.sendThumbnailsUntil) {
                    this.sendScreenshot(SimpleGatewayMonitor.this.requestedScreen, true);
                }
                if (CentralDebugging.PX_GENSTORE_TESTAPI) {
                    Message m = new Message();
                    m.append(new Date() + " Hello from the monitoring process!");
                    ServiceGenStore.INSTANCE.sendBulkData(m);
                }
            }

            public void every1min() {
                if (Switches.SH_1446_sendBatchedHostnameUptime) {
                    this.sendBatchedInfrequent();
                } else {
                    this.sendHostname();
                }
                if (System.currentTimeMillis() >= SimpleGatewayMonitor.this.sendThumbnailsUntil) {
                    this.sendLoadAverages();
                }
            }

            private void uploadSoftware() {
                if (Switches.SH_softwareStore) {
                    System.out.println("[SimpleGatewayMonitoring] Sending software store");
                    try {
                        SimpleGatewayMonitor.this.software = OSSoftwareUtil.getOSSoftware();
                        System.out.println("[SimpleGatewayMonitoring] Store is of type " + SimpleGatewayMonitor.this.software.getClass().getName());
                        Message softwareData = OSSoftwareUtil.toMessage(SimpleGatewayMonitor.this.software);
                        Message m = new Message(1589727280);
                        m.append(softwareData);
                        ServiceGenStore.INSTANCE.sendBulkData(m);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            }

            public void every5min() {
                this.sendOsInfo();
            }

            public void every30min() {
            }

            public void every1hr() {
                this.sendOsDetailedStats();
            }

            public void every4hr() {
                this.uploadSoftware();
            }

            public void every8hr() {
            }

            public void every24hr() {
            }

            private void sendLoadAverages() {
                try {
                    System.out.println("[SimpleGatewayMonitoring] Sending load averages back: " + this.cpuLoadAverage.getAverage1() + "," + this.cpuLoadAverage.getAverage5() + "," + this.cpuLoadAverage.getAverage15());
                    this.updateStatsLight();
                    Message m = new Message(1589727264);
                    byte[] data = new byte[]{this.cpuLoadAverage.getAverage1Byte(), this.cpuLoadAverage.getAverage5Byte(), this.cpuLoadAverage.getAverage15Byte(), this.memLoadAverage.getAverage1Byte(), this.memLoadAverage.getAverage5Byte(), this.memLoadAverage.getAverage15Byte()};
                    m.append(data);
                    SimpleGatewayMonitor.this.broadcast(m);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }

            private void sendOsBasicStats() {
                try {
                    if (CentralDebugging.SG_MONITORING_SOURCE) {
                        System.out.println("[SimpleGatewayMonitoring] Sending OS basic stats.");
                    }
                    Message m = new Message(1589727241);
                    this.updateStats();
                    GlobalEvents.get().machineStats(this.stats);
                    if (Testing.amTesting()) {
                        System.out.println("[Monitoring] Sending info from stats " + this.stats.hashCode() + ", cpu=" + this.stats.getCpuUsagePercent());
                    }
                    m.append(this.stats.getCpuUsagePercent());
                    double mem = 100.0 / (this.stats.getMemoryUsed() + this.stats.getMemoryFree()) * this.stats.getMemoryUsed();
                    m.append(mem);
                    m.append(this.stats.getWifiMbitRate());
                    m.append(this.stats.getWifiSignalPercent());
                    byte[] data = new byte[]{this.cpuLoadAverage.getAverage1Byte(), this.cpuLoadAverage.getAverage5Byte(), this.cpuLoadAverage.getAverage15Byte(), this.memLoadAverage.getAverage1Byte(), this.memLoadAverage.getAverage5Byte(), this.memLoadAverage.getAverage15Byte()};
                    m.append(data);
                    if (CentralDebugging.SG_MONITORING_SOURCE) {
                        System.out.println("[SimpleGatewayMonitoring]\t CPU=" + this.stats.getCpuUsagePercent() + " MEM=" + mem + " WIFI=" + this.stats.getWifiMbitRate() + " WIFISIG=" + this.stats.getWifiSignalPercent());
                    }
                    SimpleGatewayMonitor.this.broadcast(m);
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }

            private void sendOsDetailedStats() {
                try {
                    if (CentralDebugging.SG_MONITORING_SOURCE) {
                        System.out.println("[SimpleGatewayMonitoring] Sending OS detailed stats.");
                    }
                    Message m = new Message(1589727248);
                    this.updateStats();
                    GlobalEvents.get().machineStats(this.stats);
                    Message disks = new Message();
                    Stats.DiskSpaceStatistic[] dstats = this.stats.getDiskSpaceStatistic();
                    Arrays.sort(dstats, new DiskSpaceComparator());
                    for (Stats.DiskSpaceStatistic dstat : dstats) {
                        double percentage = dstat.getDiskUsagePercent();
                        if (Double.isInfinite(percentage) || Double.isNaN(percentage) || percentage < 0.0 || percentage > 100.0) continue;
                        disks.append(dstat.name);
                        disks.append(percentage);
                        if (!CentralDebugging.SG_MONITORING_SOURCE) continue;
                        System.out.println("[SimpleGatewayMonitoring]\t Disk " + dstat.name + " - " + percentage + " %");
                    }
                    m.append(disks);
                    Message procs = new Message();
                    Stats.ProcessStatistic[] pstats = this.stats.getProcessStatistics();
                    Arrays.sort(pstats, new ProcessStatComparator());
                    for (Stats.ProcessStatistic pstat : pstats) {
                        if (pstat.cpuPercentage < 10) continue;
                        procs.append(pstat.name);
                        procs.append((double)pstat.cpuPercentage);
                        if (!CentralDebugging.SG_MONITORING_SOURCE) continue;
                        System.out.println("[SimpleGatewayMonitoring]\t Process " + pstat.name + " - " + (double)pstat.cpuPercentage + " %");
                    }
                    m.append(procs);
                    SimpleGatewayMonitor.this.broadcast(m);
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }

            private void sendBatchedInfrequent() {
                Message m;
                Message all = new Message(1589727254);
                try {
                    m = new Message(1589727250);
                    MonitoringMessages.appendHostname(m);
                    all.append(m);
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
                try {
                    m = new Message(1589727255);
                    m.append(this.stats.getUptimeMs());
                    all.append(m);
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
                try {
                    SimpleGatewayMonitor.this.broadcast(all);
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }

            private void sendOsInfo() {
                try {
                    Message m = new Message(1589727236);
                    MonitoringMessages.appendOSInfo(m);
                    SimpleGatewayMonitor.this.broadcast(m);
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }

            private void sendHostname() {
                try {
                    Message m = new Message(1589727250);
                    MonitoringMessages.appendHostname(m);
                    SimpleGatewayMonitor.this.broadcast(m);
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }

            private void sendScreenshot(int screenNumber, boolean thumb) {
                try {
                    Message m;
                    if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                        if (thumb) {
                            DDLog.log(SimpleGatewayMonitor.this.ipc, "Sending thumbnail screenshot");
                            if (this.testing_cachedThumb != null) {
                                SimpleGatewayMonitor.this.broadcast(this.testing_cachedThumb);
                                return;
                            }
                        } else {
                            DDLog.log(SimpleGatewayMonitor.this.ipc, "Sending BIG screenshot");
                            if (this.testing_cachedBigShot != null) {
                                SimpleGatewayMonitor.this.broadcast(this.testing_cachedBigShot);
                                return;
                            }
                        }
                    }
                    if (SimpleGatewayMonitor.this.robot == null) {
                        return;
                    }
                    System.out.println("[Monitoring] Sending Screenshot (" + thumb + ")");
                    ScreenDimension[] screens = ScreenDimension.detectScreenDimensions(true);
                    if (screens == null) {
                        return;
                    }
                    if (screens.length <= screenNumber) {
                        screenNumber = 0;
                    }
                    Rectangle screenBounds = screens[screenNumber].getOriginalPhysicalBounds();
                    if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                        DDLog.log(SimpleGatewayMonitor.this.ipc, "Capturing screen");
                    }
                    BufferedImage bimg = SimpleGatewayMonitor.this.robot.createScreenCapture(screenBounds);
                    if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                        DDLog.log(SimpleGatewayMonitor.this.ipc, "Scaling image");
                    }
                    if (thumb) {
                        bimg = ImageHelper.scaleDownToFitInside((BufferedImage)bimg, (int)300, (int)200, (boolean)true);
                    } else if (Switches.SH_noBigScreenshotDownscaling) {
                        if (bimg.getWidth() >= 3840) {
                            bimg = ImageHelper.scaleDownToFitInside((BufferedImage)bimg, (int)(bimg.getWidth() / 2), (int)(bimg.getHeight() / 2), (boolean)true);
                        }
                    } else {
                        bimg = ImageHelper.scaleDownToFitInside((BufferedImage)bimg, (int)1200, (int)1200, (boolean)true);
                    }
                    if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                        DDLog.log(SimpleGatewayMonitor.this.ipc, "Filtering image");
                    }
                    ImageHelper.applyRGBFilter((BufferedImage)bimg, (Rectangle)new Rectangle(0, 0, bimg.getWidth(), bimg.getHeight()), (RGBImageFilter)new ColorSnapFilter(16));
                    if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                        DDLog.log(SimpleGatewayMonitor.this.ipc, "Converting colour model");
                    }
                    bimg = ImageHelper.toBufferedImageType((Image)bimg, (int)4);
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                        DDLog.log(SimpleGatewayMonitor.this.ipc, "Saving as JPEG");
                    }
                    ImageIO.write((RenderedImage)bimg, "JPEG", bout);
                    if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                        DDLog.log(SimpleGatewayMonitor.this.ipc, "Sending " + bout.size() + " bytes of screenshot");
                    }
                    if (thumb) {
                        m = new Message(1589727239);
                        if (Testing.amTesting()) {
                            this.testing_cachedThumb = m;
                        }
                    } else {
                        m = new Message(1589727240);
                        if (Testing.amTesting()) {
                            this.testing_cachedBigShot = m;
                        }
                    }
                    m.append(bout.toByteArray());
                    if (thumb) {
                        m.append((byte)ScreenDimension.detectScreenDimensions().length);
                    }
                    bout = null;
                    System.out.println("[Monitoring] Sending screenshot message (" + thumb + ") " + m);
                    SimpleGatewayMonitor.this.broadcast(m);
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
        }

        class DataCollectionCheck
        extends Thread {
            DataCollectionCheck() {
            }

            @Override
            public void run() {
            }
        }

        class AlertReporter
        implements AlertInput {
            AlertReporter() {
            }

            @Override
            public void timePassed() {
            }

            @Override
            public void machineStats(Stats stats) {
            }

            @Override
            public void securityStats(ArrayList<SecurityProduct> list) {
            }

            @Override
            public void alertTriggered(Alert alert) {
                if (!(alert instanceof TrackedAlert)) {
                    if (CentralDebugging.SG_ALERTS) {
                        System.out.println("[Alerts] Ignoring trigger from " + alert.getClass());
                    }
                    return;
                }
                System.out.println("[Alerts] " + alert.getName() + " triggered:\n" + alert.getReason());
                Message m = new Message(1589731350);
                m.append(alert.getID());
                m.append(alert.getContext().toCompressedMessage());
                SimpleGatewayMonitor.this.broadcast(m);
            }

            @Override
            public void alertReset(Alert alert) {
                if (!(alert instanceof TrackedAlert)) {
                    if (CentralDebugging.SG_ALERTS) {
                        System.out.println("[Alerts] Ignoring reset from " + alert.getClass());
                    }
                    return;
                }
                System.out.println("[Alerts] " + alert.getName() + " reset:\n" + alert.getReason());
                Message m = new Message(1589731351);
                m.append(alert.getID());
                m.append(alert.getContext().toCompressedMessage());
                SimpleGatewayMonitor.this.broadcast(m);
            }
        }

        class PopupTracker
        implements ActionListener {
            boolean closed = false;
            StandaloneNotification note;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public PopupTracker() {
                Object object = SimpleGatewayMonitor.this.popups_LOCK;
                synchronized (object) {
                    SimpleGatewayMonitor.this.popups.add(this);
                    System.out.println("[Monitoring] Showing " + SimpleGatewayMonitor.this.popups.size() + " popups");
                }
            }

            public void setStandaloneNotification(StandaloneNotification note) {
                this.note = note;
                if (this.closed) {
                    note.setVisible(false);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void actionPerformed(ActionEvent e) {
                this.closed = true;
                if (this.note != null) {
                    this.note.setVisible(false);
                }
                Object object = SimpleGatewayMonitor.this.popups_LOCK;
                synchronized (object) {
                    SimpleGatewayMonitor.this.popups.remove(this);
                    System.out.println("[Monitoring] Showing " + SimpleGatewayMonitor.this.popups.size() + " popups");
                    if (SimpleGatewayMonitor.this.popups.size() == 0) {
                        System.out.println("[Monitoring] Notifying RA service of popup count");
                        Message m = new Message(1589727268);
                        SimpleGatewayMonitor.this.broadcast(m);
                    }
                }
            }
        }

        class RunRespond
        implements Runnable,
        ToolBoxRunner.ToolBoxStatusListener {
            Message toProcess;
            long responseID;
            long techID;
            String messengerID;
            String serverAddress;

            public RunRespond(Message toProcess, long responseID, long techID, String messengerID, String serverAddress) {
                this.toProcess = toProcess;
                this.responseID = responseID;
                this.techID = techID;
                this.messengerID = messengerID;
                this.serverAddress = serverAddress;
            }

            @Override
            public void run() {
                Message resp = SimpleGatewayMonitor.this.processRequest(this.toProcess, this.serverAddress, true, this.responseID, this);
                if (resp != null) {
                    Message send = new Message(1589706781);
                    send.append(resp);
                    send.append(this.responseID);
                    send.append(this.techID);
                    send.append(this.messengerID);
                    SimpleGatewayMonitor.this.broadcast(send);
                } else {
                    System.out.println("[Run Response] Processing of " + this.toProcess + " had no response");
                }
            }

            @Override
            public void setStatus(ToolBoxStatus status) {
                System.out.println("[ToolBox / RunRespond] Status is " + status);
                Message statusMessage = status.toMessage();
                Message send = new Message(1589706781);
                send.append(statusMessage);
                send.append(this.responseID);
                send.append(this.techID);
                send.append(this.messengerID);
                SimpleGatewayMonitor.this.broadcast(send);
            }
        }

        class RequestReader
        extends Thread {
            RequestReader() {
            }

            @Override
            public void run() {
                InputStream in = SimpleGatewayMonitor.this.ipc.getInChannel((short)2);
                System.out.println("[Monitoring] Reading requests now...");
                try {
                    while (true) {
                        Message request = MessageUtils.readMessage((InputStream)in);
                        SimpleGatewayMonitor.this.processRequest(request, null, false, 0L, null);
                    }
                }
                catch (Exception x) {
                    x.printStackTrace();
                    SimpleGatewayMonitor.this.die("Exception in RequestReader");
                    return;
                }
            }
        }
    }

    class BroadcastReader
    extends Thread {
        BroadcastReader() {
        }

        @Override
        public void run() {
            InputStream in = SimpleGatewayMonitoring.this.ipc.getInChannel((short)1);
            try {
                while (SimpleGatewayMonitoring.this.monitoringOn) {
                    Message m = MessageUtils.readMessage((InputStream)in);
                    if (!SimpleGatewayMonitoring.this.monitoringOn) continue;
                    SimpleGatewayMonitoring.this.broadcast.broadcast(m);
                }
            }
            catch (IOException x) {
                x.printStackTrace();
            }
        }
    }

    class ClockSend
    extends Thread {
        String server;
        long clock;

        public ClockSend(String server, long clock) {
            this.server = server;
            this.clock = clock;
        }

        @Override
        public void run() {
            try {
                SimpleGatewayMonitoring.this.sendClock(this.server, this.clock);
            }
            finally {
                SimpleGatewayMonitoring.this.curClockSend = null;
            }
        }
    }
}

