/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sgateway.config;

import com.aem.VersionUtil;
import com.aem.sgateway.config.Server;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import utils.message.Message;
import utils.message.MessageUtils;
import utils.progtools.AutoFetchURL;
import utils.progtools.StackTracer;
import utils.stream.StreamUtils;
import utils.udp.bidirectional.UDPClient;
import utils.udp.bidirectional.UDPListener;
import utils.udp.bidirectional.UDPResponder;

public class URLTester
extends Thread {
    private Server server;
    private int totalTesters = 0;
    private URLTesterStatusListener listener;

    public URLTester(Server server, URLTesterStatusListener listener) {
        this.server = server;
        this.listener = listener;
    }

    public static void main(String[] args) throws Exception {
        System.out.println("Enter the server URL to test:");
        final Server server = new Server();
        server.setURL(StreamUtils.readLineAsStringUTF8((InputStream)System.in), null);
        new URLTester(server, new URLTesterStatusListener(){

            @Override
            public void notifyCheckingServer(Server server2) {
                System.out.println("Checking...");
            }

            @Override
            public void notifyServerSettingsUpdated(Server server2) {
            }

            @Override
            public void notifyTestingFinished(boolean allTestersFinished) {
                System.out.println("Server is accessible: " + server.isAccessible());
            }
        }).run();
        System.exit(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ++this.totalTesters;
        Server server = this.server;
        synchronized (server) {
            this.server.setIsBeingChecked(true);
        }
        this.listener.notifyCheckingServer(this.server);
        try {
            boolean isHttp;
            boolean bl = isHttp = this.server.getFullURL().startsWith("http://") || this.server.getFullURL().startsWith("https://");
            if (!isHttp && (this.server.isInitialAttempt() || this.server.isUDP())) {
                int i;
                UDPTestWait tester = new UDPTestWait(this.server.getHostname(), this.server.getPort());
                for (i = 0; i < 10; ++i) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (tester.finished) break;
                }
                if (!tester.finished) {
                    for (i = 0; i < 16; ++i) {
                        try {
                            Thread.sleep(250L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (tester.finished) break;
                    }
                }
                this.server.setCanConnect(tester.workedOK);
                this.server.setCanConnectUDP(tester.workedOK);
                this.server.setTestedUDP(true);
                System.out.println("[Http Test] Can Connect via UDP is " + this.server.canConnectUDP());
                if (this.server.canConnect() && this.server.isInitialAttempt()) {
                    this.server.setIsInitialAttempt(false);
                    this.server.setURL(URLTester.ensureProtocol(this.server.getFullURL(), new String[]{"udp"}, "udp"), this.server.getRecoveryKey());
                    this.listener.notifyServerSettingsUpdated(this.server);
                }
            }
            if (this.server.isInitialAttempt() || !this.server.isUDP()) {
                System.out.println("[URLTest] URL: " + this.server.getFullURL());
                System.out.println("[URLTest] Proxy Host: " + System.getProperty("http.proxyHost"));
                System.out.println("[URLTest] Proxy Port: " + System.getProperty("http.proxyPort"));
                System.out.println("[URLTest] Non Proxy Hosts: " + System.getProperty("http.nonProxyHosts"));
                URL httpURLObject = this.server.getHttpURLObject("/version");
                AutoFetchURL.URLConnectionHandler handler = new AutoFetchURL.URLConnectionHandler(){

                    public boolean initialiseURLConnection(URLConnection urlConnection) {
                        super.initialiseURLConnection(urlConnection);
                        urlConnection.setUseCaches(false);
                        urlConnection.setReadTimeout(5000);
                        urlConnection.setConnectTimeout(5000);
                        return true;
                    }
                };
                InputStream in = AutoFetchURL.getInputStreamAndHandleTLSDowngrade((URL)httpURLObject, (AutoFetchURL.URLConnectionInitialiser)handler);
                String version = StreamUtils.readAllAsStringUTF8((InputStream)in);
                HttpURLConnection hc = (HttpURLConnection)handler.connection;
                String error = hc.getErrorStream() != null ? StreamUtils.readAllAsStringUTF8((InputStream)hc.getErrorStream()) : "";
                version = version.trim();
                this.server.setCanConnect(VersionUtil.isVersionValid(version));
                this.server.setCanConnectHTTP(this.server.canConnect());
                this.server.setTestedHTTP(true);
                System.out.println("[Http Test] Can Connect via HTTP is " + this.server.canConnectHTTP());
                if (this.server.canConnect() && this.server.isInitialAttempt()) {
                    this.server.setIsInitialAttempt(false);
                    this.server.setURL(URLTester.ensureProtocol(this.server.getFullURL(), new String[]{"http", "https"}, "http"), this.server.getRecoveryKey());
                    this.listener.notifyServerSettingsUpdated(this.server);
                }
                if (!this.server.canConnect()) {
                    System.out.println("[URLTest] Response Code: " + hc.getResponseCode());
                    System.out.println("[URLTest] Response Message: " + hc.getResponseMessage());
                    if (error != null && error.length() > 0) {
                        System.out.println("[URLTest] [Error Page Start]");
                        System.out.println(error);
                        System.out.println("[URLTest] [Error Page End]");
                    }
                }
            }
        }
        catch (Throwable t) {
            System.out.println("[URLTest] Error Message: " + t.getMessage());
            System.out.println("[URLTest] Full Error: " + StackTracer.getStacktrace((Throwable)t));
            t.printStackTrace();
            this.server.setCanConnect(false);
        }
        finally {
            boolean isFinalTester = false;
            --this.totalTesters;
            if (this.totalTesters == 0) {
                isFinalTester = true;
            }
            Server server2 = this.server;
            synchronized (server2) {
                this.server.setIsBeingChecked(false);
            }
            this.listener.notifyTestingFinished(isFinalTester);
        }
    }

    private static String ensureProtocol(String fullURL, String[] allowedProtocols, String defaultProtocol) {
        for (String protocol : allowedProtocols) {
            if (!fullURL.startsWith(protocol + "://")) continue;
            return fullURL;
        }
        if (!fullURL.contains("://")) {
            return defaultProtocol + "://" + fullURL;
        }
        int colon = fullURL.indexOf(58);
        return defaultProtocol + fullURL.substring(colon);
    }

    class UDPTestWait
    implements UDPListener {
        UDPClient client;
        boolean finished = false;
        boolean workedOK = false;

        public UDPTestWait(String host, int port) {
            try {
                this.client = new UDPClient(host, port, this);
                Message m = new Message(55430003);
                this.client.send(MessageUtils.messageToBytes((Message)m));
            }
            catch (Exception x) {
                this.workedOK = false;
                this.finished = true;
            }
        }

        @Override
        public void handleMessage(byte[] dat, Object uid, UDPResponder respond, String remoteSocketIPAddress) {
            Message m = MessageUtils.bytesToMessage((byte[])dat);
            if (m.getType() == 55430003) {
                this.workedOK = true;
                this.finished = true;
            }
        }

        public void die() {
            this.client.die();
        }
    }

    public static interface URLTesterStatusListener {
        public void notifyCheckingServer(Server var1);

        public void notifyServerSettingsUpdated(Server var1);

        public void notifyTestingFinished(boolean var1);
    }
}

