/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sgateway.config;

import com.aem.shelp.common.Language;
import java.net.MalformedURLException;
import java.net.URL;

public class Server
implements Comparable {
    private boolean isInitialAttempt = false;
    private boolean launchPropertyURL = false;
    private boolean canConnect = false;
    private String fullURL;
    private String rec;
    private boolean isBeingChecked = false;
    private boolean canConnectHTTP = false;
    private boolean canConnectUDP = false;
    private boolean testedHTTP = false;
    private boolean testedUDP = false;
    private String protocol;
    private String hostname;
    private int port;

    public String getRecoveryKey() {
        return this.rec;
    }

    public String getHostname() {
        return this.hostname;
    }

    public int getPort() {
        return this.port;
    }

    public void setURL(String url, String rec) {
        int colon;
        int nextSlash;
        if (url != null) {
            url = url.trim();
        }
        this.setFullURL(url);
        this.rec = rec;
        int doubleSlash = url.indexOf("://");
        if (doubleSlash == -1) {
            this.protocol = "http";
            this.setIsInitialAttempt(true);
        } else {
            this.protocol = url.substring(0, doubleSlash);
            url = url.substring(doubleSlash + 3);
        }
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        if ((nextSlash = url.indexOf(47)) != -1) {
            url = url.substring(0, nextSlash);
        }
        if ((colon = url.indexOf(58)) == -1) {
            this.port = this.protocol != null && this.protocol.equalsIgnoreCase("https") ? 443 : 80;
            this.hostname = url;
        } else {
            this.hostname = url.substring(0, colon);
            try {
                this.port = Integer.parseInt(url.substring(colon + 1));
            }
            catch (Throwable t) {
                this.port = 80;
            }
        }
        this.protocol = this.protocol.toLowerCase();
    }

    public int compareTo(Object o) {
        Server s = (Server)o;
        return this.getFullURL().compareTo(s.getFullURL());
    }

    public boolean isUDP() {
        return this.protocol.equals("udp");
    }

    public String toString() {
        return this.getFullURL();
    }

    public URL getHttpURLObject(String file) throws MalformedURLException {
        if (this.isUDP()) {
            return new URL("http", this.hostname, this.port, file);
        }
        return new URL(this.protocol, this.hostname, this.port, file);
    }

    public String getToolTipText() {
        if (this.isBeingChecked()) {
            return this.getFullURL();
        }
        if (!this.canConnect()) {
            return Language.get("UNABLE_TO_CONNECT") + ": " + this.getFullURL();
        }
        String udp = this.canConnectUDP() ? Language.get("SUCCESSFULLY_CONNECTED") : Language.get("CONNECTION_FAILED");
        String http = this.canConnectHTTP() ? Language.get("SUCCESSFULLY_CONNECTED") : Language.get("CONNECTION_FAILED");
        StringBuffer buffer = new StringBuffer();
        buffer.append("<html>");
        buffer.append(this.getFullURL()).append("<BR><BR>");
        if (this.testedUDP()) {
            buffer.append("UDP: " + udp + "<BR>");
        }
        if (this.testedHTTP()) {
            buffer.append("HTTP: " + http + "<BR>");
        }
        buffer.append("</html>");
        return buffer.toString();
    }

    public boolean isAccessible() {
        return this.canConnect();
    }

    public String getFullURL() {
        return this.fullURL;
    }

    public void setFullURL(String fullURL) {
        this.fullURL = fullURL;
    }

    public boolean isInitialAttempt() {
        return this.isInitialAttempt;
    }

    public void setIsInitialAttempt(boolean isInitialAttempt) {
        this.isInitialAttempt = isInitialAttempt;
    }

    public boolean isBeingChecked() {
        return this.isBeingChecked;
    }

    public void setIsBeingChecked(boolean isBeingChecked) {
        this.isBeingChecked = isBeingChecked;
    }

    public boolean canConnect() {
        return this.canConnect;
    }

    public void setCanConnect(boolean canConnect) {
        this.canConnect = canConnect;
    }

    public boolean canConnectUDP() {
        return this.canConnectUDP;
    }

    public void setCanConnectUDP(boolean canConnectUDP) {
        this.canConnectUDP = canConnectUDP;
    }

    public boolean testedUDP() {
        return this.testedUDP;
    }

    public void setTestedUDP(boolean testedUDP) {
        this.testedUDP = testedUDP;
    }

    public boolean canConnectHTTP() {
        return this.canConnectHTTP;
    }

    public void setCanConnectHTTP(boolean canConnectHTTP) {
        this.canConnectHTTP = canConnectHTTP;
    }

    public boolean testedHTTP() {
        return this.testedHTTP;
    }

    public void setTestedHTTP(boolean testedHTTP) {
        this.testedHTTP = testedHTTP;
    }
}

