/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sgateway;

import aurelienribon.slidinglayout.DoTransition;
import aurelienribon.slidinglayout.SLAnimator;
import aurelienribon.slidinglayout.SLConfig;
import aurelienribon.slidinglayout.SLKeyframe;
import aurelienribon.slidinglayout.SLPanel;
import aurelienribon.slidinglayout.SLSide;
import aurelienribon.slidinglayout.SLTransition;
import com.aem.CdbgLauncher;
import com.aem.ClientManagement;
import com.aem.sdesktop.util.MainWindow;
import com.aem.sgateway.SGServiceInstallationManager;
import com.aem.sgateway.ServiceConfigureListener;
import com.aem.sgateway.SimpleGatewayConfig;
import com.aem.sgateway.SimpleGatewayService;
import com.aem.sgateway.common.SGPortUtil;
import com.aem.sgateway.config.Server;
import com.aem.sgateway.config.panels.SGChangeListener;
import com.aem.sgateway.config.panels.SGProxyPanel;
import com.aem.sgateway.config.panels.SGSecurityPanel;
import com.aem.sgateway.config.panels.SGServersPanel;
import com.aem.sgateway.ui.GroupSelectionPanel;
import com.aem.shelp.common.Language;
import com.aem.shelp.common.SGParameters;
import com.aem.shelp.licence.OemBranding;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.util.OneClock;
import com.aem.utils.NativeLibraryLoader;
import com.aem.utils.NativeScreenUtil;
import com.aem.utils.NativeUtils;
import com.jw.AuxConfig;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import jwrapper.jwutils.JWGenericOS;
import jwrapper.jwutils.JWSystem;
import jwrapper.updater.JWLaunchProperties;
import utils.ostools.osx.OSXAdapter;
import utils.progtools.net.URLParser;
import utils.swing.HeadlessUtil;
import utils.swing.SwingUtil;
import utils.swing.components.SimpleTabbedPanel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;
import utils.swing.layout.GbPanelWrapper;
import utils.switches.Switches;

public class SimpleGatewayServiceConfigure
extends JPanel
implements ActionListener,
ItemListener {
    private static final String SG_NOT_FORK_MORE = "SimpleGatewayServiceConfigure_not_fork_more";
    private final JPanel configPanel;
    private final SGProxyPanel proxyTab;
    private final SGSecurityPanel securityTab;
    private final SGServersPanel serverTab;
    private final GroupSelectionPanel groupListPanel;
    private final File configFile;
    private JButton quit;
    private JButton save;
    private JButton cancel;
    private JButton done;
    private final SimpleTabbedPanel tabs = new SimpleTabbedPanel();
    private final JPanel main;
    private final GbPanel buttonsPanel;
    private final ServiceConfigureListener listener;
    private boolean fileAccess = true;
    private static boolean dirty = false;
    private final DirtyListener dirtyListener = new DirtyListener();
    private final SLPanel containerSliding = new SLPanel();
    private SLConfig mainConfig;
    private SLConfig groupsConfig;
    private final int mode_CONFIG = 0;
    private final int mode_GROUPS = 1;
    float modeTime = 0.5f;
    private int modeCurrent = 0;
    private static JFrame frame;
    private static SimpleGatewayServiceConfigure configure;

    public static void stripSilentAndHeadlessInstallProperties(Properties lprops) {
        lprops.setProperty("show_no_ui", "false");
        SGParameters.stripSGConfigLaunchProperties(lprops);
    }

    private void setDirty(boolean dirty) {
        boolean canSave = this.proxyTab.canSave() && this.securityTab.canSave() && this.serverTab.canSave();
        SimpleGatewayServiceConfigure.dirty = dirty;
        if (canSave) {
            this.save.setEnabled(dirty);
        } else {
            this.save.setEnabled(false);
        }
    }

    private void toggleService() {
        if (SGServiceInstallationManager.isServiceRunning()) {
            this.serverTab.setSwitchButtonEnabled(false);
            this.removeServiceThread();
        } else {
            if (this.save.isEnabled()) {
                int option = JOptionPane.showConfirmDialog(frame, Language.get("SAVE_ANY_CHANGES"), Language.get("SAVE_CHANGES"), 2, -1, ImageLoader.getImageIcon((String)"images/svg/dialogs/warning.svg,48"));
                if (option == 0) {
                    this.save();
                    this.setDirty(false);
                } else {
                    return;
                }
            }
            this.serverTab.setSwitchButtonEnabled(false);
            this.installServiceThread();
        }
    }

    private static JFrame getFrameFrom(Component c) {
        if (c == null) {
            return null;
        }
        if (c instanceof JFrame) {
            return (JFrame)c;
        }
        return SimpleGatewayServiceConfigure.getFrameFrom(c.getParent());
    }

    @Override
    public Dimension getPreferredSize() {
        return this.main.getPreferredSize();
    }

    public SimpleGatewayServiceConfigure(RootPaneContainer rpc, SimpleGatewayConfig config, ServiceConfigureListener listener, boolean supportsUDP) {
        this(rpc, new File("."), config, listener, supportsUDP, true);
    }

    private SimpleGatewayServiceConfigure(RootPaneContainer rpc, File configFile) {
        this(rpc, configFile, null, null, true, true);
    }

    public SimpleGatewayServiceConfigure(RootPaneContainer rpc, File configFile, SimpleGatewayConfig config, ServiceConfigureListener listener, boolean supportsUDP, boolean useTabs) {
        this.configFile = configFile;
        this.listener = listener;
        if (rpc != null) {
            frame = SimpleGatewayServiceConfigure.getFrameFrom(rpc.getRootPane());
        }
        boolean generatedConfiguration = false;
        if (config != null) {
            this.fileAccess = false;
        } else if (!configFile.exists()) {
            SimpleGatewayConfig newConfig = SimpleGatewayServiceConfigure.generateConfig(configFile);
            boolean bl = generatedConfiguration = newConfig != null;
            if (generatedConfiguration) {
                config = newConfig;
            }
        }
        this.buttonsPanel = new GbPanel(new ScaledInsets(5, 0, 5, 6));
        this.initButtonsPanel();
        this.main = new JPanel();
        this.configPanel = new JPanel();
        this.groupListPanel = new GroupSelectionPanel(this);
        JScrollPane pane = new JScrollPane(this.main);
        pane.setBorder(SHBorderFactory.createMatteBorder((int)0, (int)0, (int)1, (int)0, (Color)SHStyle.TEXT_FIELD_BORDER));
        this.configPanel.setLayout(new BorderLayout());
        this.configPanel.add((Component)pane, "Center");
        this.configPanel.add((Component)this.buttonsPanel, "South");
        this.serverTab = new SGServersPanel(this.dirtyListener, useTabs, this.fileAccess, supportsUDP, false);
        this.proxyTab = new SGProxyPanel(this.dirtyListener, useTabs);
        this.securityTab = new SGSecurityPanel(this.dirtyListener, useTabs);
        if (useTabs) {
            this.main.setLayout(new BorderLayout());
            this.main.add("Center", this.tabs.getRootComponent());
            this.tabs.addTab(Language.get("PREFERENCES"), ImageLoader.getImageIcon((String)"images/svg/computing/sliders.svg,16"), this.serverTab.getRootComponent());
            this.tabs.addTab(Language.get("SECURITY"), ImageLoader.getImageIcon((String)"images/svg/general/lock.svg,16"), this.securityTab.getRootComponent());
            this.tabs.addTab(Language.get("PROXY"), ImageLoader.getImageIcon((String)"images/svg/computing/network.svg,16"), this.proxyTab.getRootComponent());
        } else {
            int Y = 0;
            GbPanelWrapper wrapper = new GbPanelWrapper((Container)this.main);
            wrapper.add((Component)this.serverTab.getRootComponent(), 0, Y++, 1, 1, 1, 0, 10, 1);
            wrapper.add((Component)this.securityTab.getRootComponent(), 0, Y++, 1, 1, 1, 0, 10, 1);
            wrapper.add((Component)this.proxyTab.getRootComponent(), 0, Y++, 1, 1, 1, 1, 10, 1);
        }
        if (this.fileAccess) {
            this.load();
        } else {
            this.load(config);
        }
        SGServiceInstallationManager.setServiceRunning(this.isSGServiceRunning());
        this.updateStateLabel();
        this.setDirty(false);
        this.updateEnabled();
        this.save.addActionListener(this);
        this.done.addActionListener(this);
        this.cancel.addActionListener(this);
        this.quit.addActionListener(this);
        if (this.fileAccess) {
            if (generatedConfiguration) {
                this.serverTab.getFirstServerInList().setIsInitialAttempt(true);
            }
            this.serverTab.testURLs();
        }
        this.setLayout(new GridLayout());
        this.add(this.containerSliding);
        this.initSlidingConfigs();
        this.machineListChanged();
        this.done.requestFocusInWindow();
    }

    private void initButtonsPanel() {
        this.save = new JButton(Language.get("SAVE"));
        this.done = new JButton(Language.get("SAVE_CONFIGURATION"));
        this.cancel = new JButton(Language.get("CANCEL"));
        this.quit = new JButton(Language.get("CLOSE"));
        this.save.setHorizontalAlignment(0);
        this.done.setHorizontalAlignment(0);
        this.cancel.setHorizontalAlignment(0);
        this.quit.setHorizontalAlignment(0);
        if (!this.fileAccess) {
            this.buttonsPanel.add((Component)this.cancel, 0, 0, 1, 1, 1, 1, 13, 0);
            this.buttonsPanel.add((Component)this.done, 1, 0, 1, 1, 0, 1, 17, 0);
            SHButtonUI.makeButtonBlue((JButton)this.done);
        } else {
            this.buttonsPanel.add((Component)this.save, 0, 0, 1, 1, 1, 1, 13, 0);
            this.buttonsPanel.add((Component)this.quit, 1, 0, 1, 1, 1, 1, 17, 0);
            SHButtonUI.makeButtonBlue((JButton)this.save);
        }
        SwingUtil.setSizesToWidest((JComponent)this.save, (JComponent)this.quit);
    }

    private static SimpleGatewayConfig generateConfig(File configFile) {
        try {
            System.out.println("[SimpleGatewayServiceConfigure] No existing SG configuration file, will create one");
            SimpleGatewayConfig defaultConfig = new SimpleGatewayConfig();
            SimpleGatewayServiceConfigure.setDefaultHostname(defaultConfig);
            SGParameters.updateSGConfigWithLaunchProperties(defaultConfig);
            defaultConfig.save(configFile, true);
            JWGenericOS.setReadableForAllUsers((File)configFile, (boolean)false);
            return defaultConfig;
        }
        catch (Throwable x) {
            x.printStackTrace();
            return null;
        }
    }

    private void initSlidingConfigs() {
        this.mainConfig = new SLConfig(this.containerSliding).gap(0, 0).col(1.0f).row(1.0f).place(0, 0, this.configPanel);
        this.groupsConfig = new SLConfig(this.containerSliding).gap(0, 0).col(1.0f).row(1.0f).place(0, 0, this.groupListPanel.getRootComponent());
        this.containerSliding.setTweenManager(SLAnimator.createTweenManager());
        this.containerSliding.initialize(this.mainConfig);
    }

    private void switchToNewView(SLConfig myConfig, int myMode, Component myComponent) {
        if (this.modeCurrent != myMode) {
            SLSide mySide = myMode > this.modeCurrent ? SLSide.RIGHT : SLSide.LEFT;
            SLTransition trans = this.containerSliding.createTransition().push(new SLKeyframe(myConfig, 0.5f).setStartSide(mySide, myComponent));
            new DoTransition(trans).start();
            this.modeCurrent = myMode;
        }
    }

    private void switchToGroupView() {
        this.switchToNewView(this.groupsConfig, 1, this.groupListPanel.getRootComponent());
    }

    public void switchToConfigView() {
        this.switchToNewView(this.mainConfig, 0, this.configPanel);
    }

    private static String getServerPingAddressFromUpdateURL() {
        String updateURL = JWSystem.getUpdateURL();
        if (updateURL == null || updateURL.length() == 0) {
            return updateURL;
        }
        URLParser urlParser = new URLParser(updateURL);
        return urlParser.toURL(true, true, false, false);
    }

    private static String getCodebaseFromUpdateURL() {
        int nextSlash;
        String updateURL = JWSystem.getUpdateURL();
        if (updateURL == null || updateURL.length() == 0) {
            return updateURL;
        }
        if (updateURL.endsWith("/")) {
            updateURL = updateURL.substring(0, updateURL.length() - 1);
        }
        if ((nextSlash = updateURL.lastIndexOf(47)) != -1) {
            updateURL = updateURL.substring(0, nextSlash);
        }
        return updateURL;
    }

    private void updateStateLabel() {
        if (SGServiceInstallationManager.isServiceRunning()) {
            this.serverTab.setStatusRunning();
        } else {
            this.serverTab.setStatusNotRunning();
        }
    }

    public SimpleGatewayConfig createConfigFromSettings() {
        SimpleGatewayConfig config = new SimpleGatewayConfig();
        this.serverTab.saveTo(config);
        this.proxyTab.saveTo(config);
        this.securityTab.saveTo(config);
        return config;
    }

    private void save() {
        SimpleGatewayConfig config = this.createConfigFromSettings();
        if (config != null) {
            try {
                SGServiceInstallationManager.saveConfig(config, this.configFile, SwingUtil.getRootPaneContainer((Component)frame));
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, Language.get("CONFIG_ERROR_PERMISSIONS"), Language.get("CONFIG_SAVE_ERROR"), 0);
            }
        }
    }

    private void load() {
        try {
            SimpleGatewayConfig config = new SimpleGatewayConfig(this.configFile);
            this.load(config);
        }
        catch (Throwable t) {
            this.machineListChanged();
        }
    }

    private void load(SimpleGatewayConfig config) {
        try {
            System.out.println("[SimpleGatewayServiceConfigure] Loading SimpleGateway Config");
            this.serverTab.loadFrom(config, false, true);
            this.proxyTab.loadFrom(config);
            this.securityTab.loadFrom(config);
        }
        catch (Throwable t) {
            t.printStackTrace();
            JOptionPane.showMessageDialog(this, Language.get("CONFIG_ERROR_READ_FILE"), Language.get("CONFIG_FILE_ERROR"), 0);
        }
        this.machineListChanged();
        System.out.println("[SimpleGatewayServiceConfigure] Final: " + this.serverTab.getFirstServerInList());
    }

    private void machineListChanged() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                int serverCount = SimpleGatewayServiceConfigure.this.serverTab.getServerCount();
                SimpleGatewayServiceConfigure.this.done.setEnabled(serverCount != 0);
                SimpleGatewayServiceConfigure.this.done.repaint();
                SimpleGatewayServiceConfigure.this.serverTab.updateEnabled();
            }
        });
    }

    private void updateEnabled() {
        this.securityTab.updateEnabled();
        this.proxyTab.updateEnabled();
        this.serverTab.updateEnabled();
    }

    public static void main(String[] args) {
        if (Switches.SH_1559_centralClock) {
            OneClock.startClockThread();
        }
        try {
            block31: {
                try {
                    AuxConfig.initAuxDownload();
                    AuxConfig.blockUntilAuxDownloaded();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                SGServiceInstallationManager.handleSilentUninstall(args);
                SGServiceInstallationManager.handleSilentInstall(args);
                System.setProperty("http.agent", "Mozilla/5.0 (Windows; U; Windows NT 5.1; en-GB; rv:1.8.1.16) Gecko/20080702 Firefox/2.0.0.16");
                try {
                    NativeLibraryLoader.loadLibrary(JWSystem.getAppFolder());
                }
                catch (Throwable t) {
                    // empty catch block
                }
                try {
                    NativeUtils.getInstance();
                }
                catch (Throwable t) {
                    // empty catch block
                }
                try {
                    NativeScreenUtil.getInstance();
                }
                catch (Throwable t) {
                    // empty catch block
                }
                try {
                    Language.loadTranslations();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                try {
                    SimpleGatewayServiceConfigure.loadAlternativeTranslationsThreaded();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                ClientManagement.SIMPLEGATEWAY = true;
                ClientManagement.SIMPLEHELP = false;
                boolean isHeadless = HeadlessUtil.isReallyHeadless();
                if (isHeadless) {
                    System.out.println("[SimpleGatewayServiceConfigure] This is a headless machine (no connection to the X server found)");
                    File configFile = SimpleGatewayConfig.getConfigLocation().getAbsoluteFile();
                    if (!configFile.exists()) {
                        SimpleGatewayServiceConfigure.generateConfig(configFile);
                    }
                    return;
                }
                try {
                    NativeScreenUtil.showMacOSXDockApplication();
                    OSXAdapter.requestForeground((boolean)true);
                    Image image = ImageLoader.getAsImageOriginal((String)"images/svg/logos/simplehelp-green.svg,256");
                    OSXAdapter.setDockIcon((Image)image);
                }
                catch (Throwable image) {
                    // empty catch block
                }
                if (Switches.SH_1569_sgConfigureUpdateUrlFromServiceLauncher) {
                    String prop = JWLaunchProperties.getProperty((String)SG_NOT_FORK_MORE);
                    if (!prop.equalsIgnoreCase("true")) {
                        Properties props = SimpleGatewayService.sessionGetAccessServiceLaunchPropsOrNull(false);
                        if (props != null) {
                            String myUpdateURL = JWLaunchProperties.normaliseUpdateURL((String)JWSystem.getUpdateURL());
                            String sgUpdateURL = JWLaunchProperties.normaliseUpdateURL((String)props.getProperty("update_url"));
                            if (sgUpdateURL != null) {
                                if (sgUpdateURL.trim().length() > 0) {
                                    try {
                                        URL validURL = new URL(sgUpdateURL);
                                        System.out.println("[SimpleGatewayServiceConfigure] Normalised SG service shortcut URL is valid: " + validURL);
                                        if (!sgUpdateURL.trim().equals(myUpdateURL.trim())) {
                                            System.out.println("[SimpleGatewayServiceConfigure] SG update URL (" + validURL + ") has been updated and does not match ours (" + myUpdateURL + "), will update own and fork");
                                            System.out.println("[SimpleGatewayServiceConfigure] Overriding own update URL in props");
                                            JWLaunchProperties.overrideDynamicProperty((String)"update_url", (String)sgUpdateURL);
                                            System.out.println("[SimpleGatewayServiceConfigure] Overriding own update URL in launcher");
                                            JWSystem.overrideSourceLauncherUpdateURL((URL)validURL);
                                            System.out.println("[SimpleGatewayServiceConfigure] Forking");
                                            JWLaunchProperties.overrideDynamicProperty((String)SG_NOT_FORK_MORE, (String)"true");
                                            JWSystem.forkVirtualApp((String)JWSystem.getMyAppName(), null, null, (boolean)false, (boolean)true);
                                            System.out.println("[SimpleGatewayServiceConfigure] Forked replacement with correct server update URL, EXITING in 7s...");
                                            Thread.sleep(500L);
                                            System.exit(0);
                                            break block31;
                                        }
                                        System.out.println("[SimpleGatewayServiceConfigure] SG service shortcut URL matches ours OK, no need to update");
                                    }
                                    catch (Exception x) {
                                        System.out.println("[SimpleGatewayServiceConfigure] SG update URL " + sgUpdateURL + " is not valid");
                                    }
                                } else {
                                    System.out.println("[SimpleGatewayServiceConfigure] SG update URL is empty");
                                }
                            } else {
                                System.out.println("[SimpleGatewayServiceConfigure] SG update URL is null");
                            }
                        } else {
                            System.out.println("[SimpleGatewayServiceConfigure] SG service launcher does not exist yet");
                        }
                    } else {
                        System.out.println("[SimpleGatewayServiceConfigure] Will not check SG update URL and fork again (have preventative dynprop)");
                    }
                }
            }
            JWLaunchProperties.deleteProperty((String)SG_NOT_FORK_MORE);
            CdbgLauncher.loadListener();
            frame = new SimpleHelpFrame(OemBranding.OEM_REMOTE_ACCESS_SERVICE_NAME + " v" + 5 + "." + 1);
            MainWindow.setImageListUsingReflection(frame);
            configure = new SimpleGatewayServiceConfigure(frame, SimpleGatewayConfig.getConfigLocation().getAbsoluteFile());
            frame.getContentPane().add(configure);
            frame.pack();
            Dimension minSize = SimpleGatewayServiceConfigure.configure.configPanel.getPreferredSize();
            int minHeight = minSize.height + SimpleHelpFrame.EMPTY_WINDOW_DECORATIONS_HEIGHT + 10;
            frame.setBounds(10, 10, Math.max(frame.getWidth() + 30, SimpleHelpLookAndFeel.scale((int)500)), Math.max(minHeight, SimpleHelpLookAndFeel.scale((int)500)));
            frame.setLocationRelativeTo(null);
            frame.addWindowListener(new ExitListener());
            frame.setVisible(true);
            frame.requestFocusInWindow();
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(1);
        }
    }

    private static void loadAlternativeTranslationsThreaded() {
        try {
            System.out.println("[SimpleGatewayServiceConfigure] Loading existing translations");
            Language.justLoadSecondaryTranslations();
            System.out.println("[SimpleGatewayServiceConfigure] About to call downloadSecondaryTranslations");
            new Thread("SecondaryTranslationsFetcher"){

                @Override
                public void run() {
                    try {
                        Language.downloadSecondaryTranslations(SimpleGatewayServiceConfigure.getCodebaseFromUpdateURL());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }.start();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static void setDefaultHostname(SimpleGatewayConfig siConfig) {
        String hostnameToPing = SimpleGatewayServiceConfigure.getServerPingAddressFromUpdateURL();
        if (hostnameToPing != null && hostnameToPing.length() > 0) {
            String pkhash = JWLaunchProperties.getProperty((String)"shpkhash");
            if (pkhash != null && (pkhash = pkhash.trim()).length() == 0) {
                pkhash = null;
            }
            siConfig.setURLs(new String[]{hostnameToPing});
            if (pkhash != null) {
                // empty if block
            }
        }
    }

    private String sanitise(String url) {
        char[] cs = url.toCharArray();
        for (int i = 0; i < cs.length; ++i) {
            if (Character.isLetterOrDigit(cs[i]) || cs[i] == '-') continue;
            cs[i] = 95;
        }
        return new String(cs);
    }

    private String dumpError(String urlstr, String error_info, String error_content) {
        FileOutputStream fout;
        String path;
        String info = "(no further information)";
        try {
            if (error_info != null) {
                info = path = new File("TEST_ERROR_INFO_" + this.sanitise(urlstr) + ".txt").getCanonicalPath();
                fout = new FileOutputStream(path);
                fout.write(error_info.getBytes(StandardCharsets.UTF_8));
                fout.close();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        try {
            if (error_content != null) {
                path = new File("TEST_ERROR_PAGE_" + this.sanitise(urlstr) + ".html").getCanonicalPath();
                fout = new FileOutputStream(path);
                fout.write(error_content.getBytes(StandardCharsets.UTF_8));
                fout.close();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return info;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.action(e.getSource());
    }

    private void action(Object o) {
        if (o == this.save) {
            this.save();
            this.setDirty(false);
        } else if (o == this.done) {
            this.listener.done();
        } else if (o == this.cancel) {
            this.listener.cancelled();
        } else if (o == this.quit) {
            WindowListener[] listeners = frame.getWindowListeners();
            WindowEvent e = new WindowEvent(frame, 201);
            for (WindowListener listener1 : listeners) {
                listener1.windowClosing(e);
            }
        }
    }

    private void saveThread() {
        new Thread("SaveConfigThread"){

            @Override
            public void run() {
                SimpleGatewayServiceConfigure.this.save.setEnabled(false);
                try {
                    SimpleGatewayServiceConfigure.this.save();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                SimpleGatewayServiceConfigure.this.save.setEnabled(true);
            }
        }.start();
    }

    private void installServiceThread() {
        new Thread("InstallServiceThread"){

            @Override
            public void run() {
                if (JWSystem.getUpdateURL().length() <= 1) {
                    Server s = SimpleGatewayServiceConfigure.this.serverTab.getFirstServerInList();
                    String url = s.getFullURL();
                    System.out.println("[SimpleGatewayServiceConfigure] Overriding bundle update URL with " + url);
                    try {
                        JWSystem.overrideSourceLauncherUpdateURL((URL)SGServiceInstallationManager.getUpdateUrlFromShUrl(url));
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                }
                try {
                    SGServiceInstallationManager.installService(frame);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                SimpleGatewayServiceConfigure.this.updateStateLabel();
            }
        }.start();
    }

    private void removeServiceThread() {
        new Thread("RemoveServiceThread"){

            @Override
            public void run() {
                boolean worked = false;
                try {
                    try {
                        worked = SGServiceInstallationManager.removeService(frame);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (worked) {
                        try {
                            SGServiceInstallationManager.stopRunningSGService();
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                    }
                }
                finally {
                    SimpleGatewayServiceConfigure.this.serverTab.setSwitchButtonEnabled(true);
                }
                SimpleGatewayServiceConfigure.this.updateStateLabel();
            }
        }.start();
    }

    private void restartServiceThread() {
        new Thread("RestartServiceThread"){

            @Override
            public void run() {
                boolean worked = false;
                try {
                    SGServiceInstallationManager.restartService(frame);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }.start();
    }

    private boolean isSGServiceRunning() {
        File sgPortFile = SGPortUtil.getSGPortFile(true);
        System.out.println("[RunningCheck] " + sgPortFile);
        if (!sgPortFile.exists()) {
            return false;
        }
        System.out.println("[RunningCheck] File exists...");
        return SGPortUtil.isSGPortFileLocked(sgPortFile);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.action(e.getSource());
    }

    public boolean installShortcuts() {
        return this.serverTab.canInstallShortcuts();
    }

    private void pickGroup() {
        this.groupListPanel.pickGroup();
        this.switchToGroupView();
    }

    public void setSelectedGroup(String[] selectedGroup) {
        this.serverTab.setSelectedGroup(selectedGroup);
    }

    public Server getSelectedServerOrFirstOption() {
        return this.serverTab.getSelectedServerOrFirstOption();
    }

    public RootPaneContainer getFrame() {
        return frame;
    }

    public void setTechClient(TechClient techClient) {
        this.groupListPanel.setTechClient(techClient);
    }

    public void initSLLayout() {
        this.containerSliding.initialize(this.mainConfig);
    }

    public static SimpleGatewayServiceConfigure createForShftp(RootPaneContainer rpc) {
        return new SimpleGatewayServiceConfigure(rpc, SimpleGatewayConfig.getConfigLocation().getAbsoluteFile());
    }

    public boolean shftp_isServiceRunning() {
        return this.isSGServiceRunning();
    }

    public void shftp_restartService() {
        this.restartServiceThread();
    }

    public void shftp_setService(boolean on) {
        if (!(SGServiceInstallationManager.isServiceRunning() && on || !SGServiceInstallationManager.isServiceRunning() && !on)) {
            this.toggleService();
        }
    }

    public void shftp_saveConfig(SimpleGatewayConfig config) {
        if (config != null) {
            try {
                SGServiceInstallationManager.saveConfig(config, this.configFile, SwingUtil.getRootPaneContainer((Component)frame));
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, Language.get("CONFIG_ERROR_PERMISSIONS"), Language.get("CONFIG_SAVE_ERROR"), 0);
            }
        }
    }

    public SimpleGatewayConfig shftp_loadConfig() {
        try {
            SimpleGatewayConfig config = new SimpleGatewayConfig(this.configFile);
            return config;
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static class ExitListener
    extends WindowAdapter {
        private ExitListener() {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            if (dirty) {
                int option = JOptionPane.showConfirmDialog(frame, Language.get("SAVE_ANY_CHANGES"), Language.get("SAVE_CHANGES"), 1, -1, ImageLoader.getImageIcon((String)"images/svg/dialogs/warning.svg,48"));
                if (option == 0) {
                    configure.save();
                }
                if (option != 2) {
                    System.exit(0);
                }
            } else {
                System.exit(0);
            }
        }
    }

    public class DirtyListener
    extends KeyAdapter
    implements SGChangeListener {
        boolean ignoreEvents = false;

        @Override
        public void keyReleased(KeyEvent e) {
            if (!this.ignoreEvents) {
                this.setDirty(true);
            }
        }

        @Override
        public void setDirty(boolean dirty) {
            if (!this.ignoreEvents) {
                SimpleGatewayServiceConfigure.this.setDirty(dirty);
            }
        }

        @Override
        public void machineListChanged() {
            if (!this.ignoreEvents) {
                SimpleGatewayServiceConfigure.this.machineListChanged();
            }
        }

        @Override
        public void switchServiceState() {
            if (!this.ignoreEvents) {
                SimpleGatewayServiceConfigure.this.toggleService();
            }
        }

        @Override
        public void setProxySettings() {
            if (!this.ignoreEvents) {
                SimpleGatewayConfig.setJavaUrlProxyFromConfig(SimpleGatewayServiceConfigure.this.createConfigFromSettings());
            }
        }

        @Override
        public void pickGroup() {
            if (!this.ignoreEvents) {
                SimpleGatewayServiceConfigure.this.pickGroup();
            }
        }

        @Override
        public void setIgnoreEvents(boolean b) {
            this.ignoreEvents = b;
        }
    }
}

