/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sgateway;

import bcutil.BCUtil;
import bcutil.BCUtilInputStream;
import bcutil.BCUtilOutputStream;
import build.BuildConstants;
import com.aem.CentralDebugging;
import com.aem.TestResourceBundle;
import com.aem.VersionUtil;
import com.aem.gstore.DataBlock;
import com.aem.gstore.GenStore;
import com.aem.gstore.StorePacket;
import com.aem.nodelink.Node;
import com.aem.nodelink.NodeLink;
import com.aem.nodelink.NodeLinkStatusListener;
import com.aem.nodelink.utils.DataUtils;
import com.aem.nodelink.utils.SafeClock;
import com.aem.nodelink.utils.ThreadPool;
import com.aem.sdesktop.util.Version;
import com.aem.sgateway.AutomaticCustomer;
import com.aem.sgateway.BigProgressInterface;
import com.aem.sgateway.ManageRemoteAccessService;
import com.aem.sgateway.PKHashRepository;
import com.aem.sgateway.SGExtensionAPI;
import com.aem.sgateway.SGExtensionUtil;
import com.aem.sgateway.SGHttpsUtil;
import com.aem.sgateway.SGServiceInstallationManager;
import com.aem.sgateway.ServerClaim;
import com.aem.sgateway.SimpleGatewayConfig;
import com.aem.sgateway.SimpleGatewayID;
import com.aem.sgateway.common.SGPortUtil;
import com.aem.sgateway.genstore.GenStoreProvider;
import com.aem.sgateway.genstore.ServiceGenStore;
import com.aem.sgateway.mdupload.MonitoringBroadcastListener;
import com.aem.sgateway.mdupload.MonitoringMessages;
import com.aem.sgateway.mdupload.SimpleGatewayMonitoring;
import com.aem.shelp.common.PC;
import com.aem.shelp.common.login.TechCredentials;
import com.aem.shelp.common.toolbox.ToolResourceLocator;
import com.aem.shelp.mdupload.LossyClient;
import com.aem.shelp.mdupload.LossyMessageHandler;
import com.aem.shelp.mdupload.LossyTestThread;
import com.aem.shelp.mdupload.LossyTransport;
import com.aem.shelp.mdupload.LossyUtils;
import com.aem.shelp.mdupload.SecMsgDecryptionError;
import com.aem.shelp.mdupload.SecureMessenger;
import com.aem.shelp.mdupload.SecureMessengerDB;
import com.aem.shelp.mdupload.SecureMessengerListener;
import com.aem.shelp.mdupload.ServerNotRespondingException;
import com.aem.shelp.mdupload.fs.AbstractTechFS;
import com.aem.shelp.mdupload.fs.FSConstants;
import com.aem.shelp.mdupload.fs.FSProgress;
import com.aem.shelp.mdupload.fs.GFile;
import com.aem.shelp.mdupload.fs.LocalFS;
import com.aem.shelp.mdupload.fs.RemoteFSHandler;
import com.aem.shelp.mdupload.fs.TechClientFS;
import com.aem.shelp.mdupload.transports.HttpClientLossyTransport;
import com.aem.shelp.mdupload.transports.SwitchableLossyTransport;
import com.aem.shelp.mdupload.transports.UdpClientLossyTransport;
import com.aem.shelp.proxy.alerts.AlertRegistry;
import com.aem.shelp.proxy.techclient.RAClient;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.proxy.techclient.TechClientAdapter;
import com.aem.shelp.proxy.types.Alert;
import com.aem.shelp.proxy.types.LocatedAlert;
import com.aem.shelp.proxy.types.MachineInfo;
import com.aem.shelp.proxy.types.MachineName;
import com.aem.shelp.proxy.types.ResourceContainer;
import com.aem.shelp.proxy.types.alertlocs.AllMachinesAloc;
import com.aem.shelp.proxy.types.alerts.ResourceSerialiser;
import com.aem.shelp.util.BandwidthReporting;
import com.aem.shelp.util.CadPolicyAllower;
import com.aem.shelp.util.FixedByteBuffer;
import com.aem.shelp.util.GenericSync;
import com.aem.shelp.util.HttpClientSocketTracker;
import com.aem.shelp.util.MachineInUseMonitor;
import com.aem.shelp.util.MachineStream;
import com.aem.shelp.util.OneClock;
import com.aem.shelp.util.P2PSock;
import com.aem.shelp.util.ResourceContainerComparator;
import com.aem.shelp.util.SHMemoryPolicy;
import com.aem.shelp.util.SHelpNodelinkPatcher;
import com.aem.shelp.util.SimpleServiceUtil;
import com.aem.tests.TestUtils;
import com.aem.tests.Testing;
import com.aem.utils.ChModUtil;
import com.aem.utils.NativeEventUtil;
import com.aem.utils.NativeLibraryLoader;
import com.aem.utils.StreamUtils;
import com.jw.AuxConfig;
import java.awt.Image;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.BindException;
import java.net.ConnectException;
import java.net.DatagramSocket;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.security.Security;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.Random;
import java.util.ResourceBundle;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import jwrapper.JWParameteriser;
import jwrapper.hidden.JWNativeAPI;
import jwrapper.jwutils.JWGenericOS;
import jwrapper.jwutils.JWLogging;
import jwrapper.jwutils.JWMacOS;
import jwrapper.jwutils.JWService;
import jwrapper.jwutils.JWSockIPC;
import jwrapper.jwutils.JWSystem;
import jwrapper.jwutils.JWWindowsOS;
import jwrapper.jwutils.JWWindowsRegistry;
import jwrapper.jwutils.test.JWTestControl;
import jwrapper.jwutils.test.JWTestable;
import jwrapper.jwutils.test.JWTesting;
import jwrapper.logging.StdLogging;
import jwrapper.updater.GenericUpdater;
import jwrapper.updater.JWLaunchProperties;
import jwrapper.updater.LogFolderCleaner;
import utils.ddebug.DDLog;
import utils.files.FileLockUtil;
import utils.files.FileUtil;
import utils.files.PermissionsUtil;
import utils.message.BasicMTTransactionServer;
import utils.message.Message;
import utils.message.MessageUtils;
import utils.message.SinglesListener;
import utils.message.TransactionListener;
import utils.multiplex.FastMxInputStream;
import utils.multiplex.FastMxOutputStream;
import utils.osstats.types.BasicInfo;
import utils.ostools.OS;
import utils.ostools.RunCommandGetOutput;
import utils.ostools.osx.OSXAdapter;
import utils.ostools.win32.FWFilter;
import utils.ostools.win32.FirewallAdder;
import utils.progtools.AutoFetchURL;
import utils.progtools.BatchingTimedThread;
import utils.progtools.BatchingTimedThreadLock;
import utils.progtools.BestCaseCompressor;
import utils.progtools.Cache;
import utils.progtools.ConstantGc;
import utils.progtools.HiccupThread;
import utils.progtools.Lock;
import utils.progtools.Stopwatch;
import utils.progtools.arrays.ArrayUtils;
import utils.progtools.net.URLParser;
import utils.progtools.time.Times;
import utils.stream.SSLHelper;
import utils.stream.StreamPiper;
import utils.stream.URLConnectionUtil;
import utils.string.HexData;
import utils.string.Normaliser;
import utils.swing.images.ImageLoader;
import utils.switches.LocalSwitches;
import utils.switches.Switches;
import utils.udp.Acculog;
import utils.udp.WakeOnLan;
import utils.udp.bidirectional.UDPClient;
import utils.udp.bidirectional.UDPListener;
import utils.udp.bidirectional.UDPResponder;

public class SimpleGatewayService {
    private static final int MAX_HTTP_RETURNED_DATA_SIZE = Math.max(5000000, FSConstants.FILE_DOWNLOAD_CHUNK * 2);
    private static PKHashRepository hashRepository;
    private static final Object config_LOCK;
    private static SimpleGatewayConfig config;
    private static final boolean DEBUG_NO_CHMOD = false;
    private static final boolean DEBUG_TEST_HTTP_1_0 = false;
    private static final RemoteFSHandler remoteFSMessageHandler;
    static BigProgressInterface TEST_UI;
    public static int TRACK_MULTI_UI;
    public static final int TRACK_SERVICES = 0;
    public static final int TRACK_SECMSG = 1;
    public static boolean SIMULATE_MULTIPLE_MACHINES;
    public static BigProgressInterface multi_ui;
    public static int multi_count;
    public static long multi_wait;
    public static long multi_wait_each;
    private static String multi_name_override;
    private static String[] multi_countries;
    private static final Object SERVICE_SLEEP_LOCK;
    private static boolean perUserServiceIsAsleep;
    private static boolean sleepStatusChanged;
    private static final SGEventListener nativeEventListener;
    private static URL currentLatestServerURL;
    private static ArrayList<PollThread> pollThreads;
    private static LossyClient lossyclient;
    private static SimpleGatewayID masteridStatic;
    private static long sgTransientId;
    private static final SimpleGatewayMonitoring monitoring;
    private static final MonitoringBroadcast broadcast;
    private static FileLockUtil.LockResult currentServiceLock;
    private static final int[] HTTP_RESPONSE_CODES_NOT_SH;
    private static File genstoreDir;
    private static File alertsDir;
    private static final Object alertRegs_LOCK;
    private static final HashMap<String, AlertRegistry> alertRegs;
    private static File secmsgDB;
    private static long nextCheckDue;
    private static final long ONE_HOUR = 3600000L;
    private static final long UPDATE_OVER = 172800000L;
    private static PrintStream REAL_STDOUT;
    private static boolean TRACK_SESSIONS_AND_EXIT_ON_ZERO;
    private static long TRACK_SESSIONS_AND_EXIT_MIN_ZERO_TIME;
    private static FileLockUtil.LockResult lockForSGPort;
    private static LivenessUpdater livenessUpdater;
    private static boolean test_POLLING;
    private static boolean test_POLLING_CYCLE;
    private static final Object test_BEGIN;
    private static final Object sessionTracking_LOCK;
    private static SessionsTracker sessionsTracker;
    private static int tracking_secMsgSetups;
    private static final Object tracking_LOCK;
    private static final int monitoringStateVER = 1;
    private static boolean isMonitoring;
    private static long forceSubProcessUntil;
    private static boolean amShowingPopups;
    private static long nextMonitoringLaunchAllowed;
    static final ServerClaim serverClaim;
    private static final Object problem_LOCK;
    private static BatchingTimedThreadLock glolock;
    private static int lastGloSize;
    private static final Object monitoringSwitch_LOCK;
    private static boolean renegotiation_running;
    private static final Object renegotiate_LOCK;
    private static long nextIncomingFailReneg;
    private static final Lock patchLOCK;
    private static final Cache<Integer, PatchSync> patchCache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getNameFromConfigWithLock() {
        Object object = config_LOCK;
        synchronized (object) {
            if (config == null) {
                return null;
            }
            return config.getName();
        }
    }

    private static GenStore getGenStore(String server) {
        if (genstoreDir == null) {
            genstoreDir = new File(JWSystem.getAllAppVersionsSharedFolder(), "genstore");
            genstoreDir.mkdirs();
        }
        File genstoreFile = new File(genstoreDir, Normaliser.safeWithoutNormalising((String)server));
        return new GenStore(Switches.SH_raGenStoreLimitBytes, Switches.SH_raGenStoreBytesPerBlock, genstoreFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static AlertRegistry getAlertRegistry(String server) {
        Object object = alertRegs_LOCK;
        synchronized (object) {
            AlertRegistry reg = alertRegs.get(server);
            if (reg == null) {
                File alertDB;
                reg = new AlertRegistry();
                if (alertsDir == null) {
                    alertsDir = new File(JWSystem.getAllAppVersionsSharedFolder(), "alerts");
                    alertsDir.mkdirs();
                }
                if ((alertDB = new File(alertsDir, Normaliser.safeWithoutNormalising((String)server))).exists() && alertDB.isFile()) {
                    alertDB.delete();
                }
                boolean createdNewRegistry = false;
                if (!alertDB.exists()) {
                    createdNewRegistry = true;
                    alertDB.mkdirs();
                }
                System.out.println("[Alerts] Alerts for " + server + " stored in " + alertDB.getAbsolutePath());
                reg.setAlertDbDir(alertDB);
                if (OS.isMacOS() && createdNewRegistry) {
                    System.out.println("[SimpleGatewayService] Setting permissions for alerts registry");
                    try {
                        JWGenericOS.setWritableForAllUsers((File)alertDB, (boolean)true);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
                System.out.println("[Alerts] Loading alerts for " + server);
                reg.loadAllFromDisk();
                alertRegs.put(server, reg);
            }
            return reg;
        }
    }

    private static HashMap<String, String> getOwnedAlertsForRegistry(ArrayList<ResourceContainer> all) {
        if (CentralDebugging.SG_ALERTS) {
            System.out.println("[Alerts] " + all.size() + " total alerts");
        }
        HashMap<String, String> mine = new HashMap<String, String>();
        for (ResourceContainer rc : all) {
            if (!(rc instanceof LocatedAlert)) continue;
            LocatedAlert la = (LocatedAlert)rc;
            String ID = la.getAlert().getID();
            mine.put(ID, ID);
        }
        return mine;
    }

    private static File getLivenessFileLocation() {
        File parent = JWSystem.getAllAppVersionsSharedFolder();
        if (parent == null) {
            return new File("sgalive");
        }
        return new File(parent, "sgalive");
    }

    private static void updateLivenessFile() {
        if (Testing.amTesting()) {
            return;
        }
        File liveness = SimpleGatewayService.getLivenessFileLocation().getAbsoluteFile();
        if (!liveness.setLastModified(System.currentTimeMillis())) {
            System.out.println("[SimpleGatewayService] Unable to update liveness file " + liveness + "!");
        }
    }

    private static File getServiceLockFile() {
        return SimpleGatewayID.getLockFileLocation();
    }

    private static boolean haveUniquenessLock() {
        return currentServiceLock != null;
    }

    private static boolean tryGrabUniquenessLock() {
        if (currentServiceLock != null) {
            return true;
        }
        File file = SimpleGatewayService.getServiceLockFile();
        if (!file.exists()) {
            try {
                file.createNewFile();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            PermissionsUtil.setRecursiveFullPermissions((String)file.getAbsolutePath());
        }
        return (currentServiceLock = FileLockUtil.tryLockFile((File)file)) != null;
    }

    private static void releaseUniquenessLock() {
        if (currentServiceLock == null) {
            System.out.println("WARNING: Told to release uniqueness lock but the lock is null?");
            return;
        }
        FileLockUtil.releaseLock((FileLockUtil.LockResult)currentServiceLock);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void sleepService() {
        Object object = SERVICE_SLEEP_LOCK;
        synchronized (object) {
            if (!perUserServiceIsAsleep) {
                System.out.println("[SimpleGatewayService] Sleeping service...");
                perUserServiceIsAsleep = true;
                sleepStatusChanged = true;
                SimpleGatewayService.releaseUniquenessLock();
                SERVICE_SLEEP_LOCK.notify();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void awakeService() {
        Object object = SERVICE_SLEEP_LOCK;
        synchronized (object) {
            if (perUserServiceIsAsleep) {
                System.out.println("[SimpleGatewayService] Awaking service...");
                perUserServiceIsAsleep = false;
                sleepStatusChanged = true;
                SERVICE_SLEEP_LOCK.notify();
            }
        }
    }

    private static void setLatestServerURL(URL url) throws IOException {
        if (SIMULATE_MULTIPLE_MACHINES) {
            return;
        }
        if (Switches.SHFTP_doNotOverrideSgUpdateUrl) {
            return;
        }
        if (!url.equals(currentLatestServerURL)) {
            System.out.println("[SimpleGatewayService] Overriding source launcher update URL with " + url);
            currentLatestServerURL = url;
            JWSystem.overrideSourceLauncherUpdateURL((URL)url);
        }
    }

    private static PollThread poll(String addr, SimpleGatewayID masterID) {
        PollThread pt = new PollThread(addr, masterID);
        pt.start();
        return pt;
    }

    private static void runRunnableAndWaitFor(Runnable r, int maxWaitTime) {
        Thread t = new Thread(r);
        t.start();
        try {
            t.join(maxWaitTime);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private static void recalculateNextCheckDue() {
        nextCheckDue = System.currentTimeMillis() + 3600000L + (long)new Random(System.currentTimeMillis()).nextInt(172800000);
    }

    private static int modCurrentDirToValue5000() {
        String path = new File(".").getAbsolutePath();
        return Math.abs(path.hashCode()) % 5000;
    }

    private static void configureWindowsSpecificEnvironment(final boolean addToWindowsFirewall, final boolean addSafeModeRebootKey) {
        if (Testing.amTesting()) {
            return;
        }
        new Thread(){

            @Override
            public void run() {
                if (addToWindowsFirewall) {
                    System.out.println("[SimpleGatewayService] Configuring firewall");
                    try {
                        if (OS.isWindows()) {
                            File jre = new File(JWSystem.getMyJreHome(), "bin");
                            FirewallAdder.addExe(new File(jre, "Remote Access.exe"), "SH Remote Access Service", "Inbound rule for the Remote Access Service to facilitate access sessions");
                            FirewallAdder.addExe(new File(jre, "Remote AccessECompatibility.exe"), "SH Remote Access Service Updater", "Inbound rule for the Remote Access Service updater");
                            FirewallAdder.addExe(new File(jre, "Remote AccessLauncher.exe"), "SH Remote Access Service Launcher", "Inbound rule for the launcher that can spawn the Remote Access Service");
                        }
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    try {
                        FirewallAdder.removeRulesStartingWith("SHRemote");
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    try {
                        SimpleServiceUtil util = new SimpleServiceUtil(new File("."));
                        util.terminateShTemporaryServices();
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
                if (addSafeModeRebootKey) {
                    System.out.println("[SimpleGatewayService] Configuring safe mode reboot");
                    boolean create = JWWindowsRegistry.regCreateKey((String)"HKLM", (String)"SYSTEM\\CurrentControlSet\\Control\\SafeBoot\\Network\\Remote Access Service");
                    boolean set = JWWindowsRegistry.regSet((String)"HKLM", (String)"SYSTEM\\CurrentControlSet\\Control\\SafeBoot\\Network\\Remote Access Service", (String)"", (String)"Service", (String)"REG_SZ");
                    System.out.println("[SimpleGatewayService] Safe set to " + create + "," + set);
                }
            }
        }.start();
    }

    private static int getMinuteOfHour() {
        long minOfHour = System.currentTimeMillis() / 60000L;
        return (int)(minOfHour %= 60L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void checkTestPollWait() {
        if (!Testing.amTesting()) {
            return;
        }
        if (test_POLLING_CYCLE) {
            if (SimpleGatewayService.getMinuteOfHour() % 10 > 3) {
                System.out.println("[RA Testing] Going to sleep until for remainder of 10 minutes (polling cycling on/off)");
            }
            while (SimpleGatewayService.getMinuteOfHour() % 10 > 3 && test_POLLING_CYCLE) {
                try {
                    Thread.sleep(30000L);
                    System.out.println("[RA Testing] Going to sleep until for remainder of 10 minutes (polling cycling on/off)");
                }
                catch (Exception exception) {}
            }
        }
        while (!test_POLLING) {
            System.out.println("[RA Testing] Waiting for COM_RA_START command");
            Object object = test_BEGIN;
            synchronized (object) {
                try {
                    if (!test_POLLING) {
                        test_BEGIN.wait();
                    }
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        try {
            Acculog.setJVM("RAService");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (args.length > 0 && args[0].equals("-exitOnZeroSessions")) {
            TRACK_SESSIONS_AND_EXIT_ON_ZERO = true;
            try {
                TRACK_SESSIONS_AND_EXIT_MIN_ZERO_TIME = Long.parseLong(args[1]) * 1000L;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            sessionsTracker = new SessionsTracker();
            sessionsTracker.start();
        }
        hashRepository = new PKHashRepository();
        Alert.setReadOnlyAlerts(true);
        AuxConfig.initAuxDownload();
        if (Testing.amTesting()) {
            ConstantGc.begin();
        }
        if (Testing.amTesting()) {
            JWTesting.createFakeAllAppVersionsSharedFolder((String)JWLaunchProperties.getProperty((String)"INFO_SG_NAME"));
            System.out.println("[RA Testing] using fake config folder " + JWSystem.getAllAppVersionsSharedFolder());
            System.out.println("[RA Testing] setting up IPC");
            JWSockIPC ipc = JWSockIPC.connectChild();
            ipc.setupMultipleChannels();
            System.out.println("[RA Testing] IPC ok starting command handler");
            new TestCommandThread(ipc).start();
        }
        if (Testing.amTesting()) {
            if (JWLaunchProperties.getPropertyPossiblyNull((String)"INFO_SG_POLLING_CYCLE") != null) {
                System.out.println("[RA Testing] Will cycle polling on and off");
                test_POLLING_CYCLE = true;
            }
            if (JWLaunchProperties.getPropertyPossiblyNull((String)"INFO_SG_DEFER") != null) {
                System.out.println("[RA Testing] Control deferred, will poll automatically");
                test_POLLING = true;
            } else if (JWLaunchProperties.getPropertyPossiblyNull((String)"INFO_SG_BEGIN_POLLING") != null) {
                System.out.println("[RA Testing] Polling automatically");
                test_POLLING = true;
            } else {
                System.out.println("[RA Testing] Will wait until asked to poll");
                SimpleGatewayService.checkTestPollWait();
            }
        }
        System.setProperty("apple.awt.UIElement", "true");
        REAL_STDOUT = System.out;
        SimpleGatewayService.recalculateNextCheckDue();
        boolean SHOW_NO_UI = JWLaunchProperties.getProperty((String)"show_no_ui").equals("true");
        if (!SHOW_NO_UI) {
            try {
                Image image = ImageLoader.getAsImageOriginal((String)"images/svg/logos/simplehelp-green.svg,256");
                OSXAdapter.setDockIcon((Image)image);
            }
            catch (Throwable image) {
                // empty catch block
            }
            try {
                JWMacOS.setMyOSXAppName((String)(BuildConstants.BUNDLE_SG_SERVICE + " Service"));
            }
            catch (Throwable image) {
                // empty catch block
            }
        }
        try {
            LogFolderCleaner.cleanLogFilesLargerThan((File)JWSystem.getMyLogFile().getParentFile(), (long)(1024000L * (2L * (StdLogging.DEF_INITIAL_MB + StdLogging.DEF_CIRCULAR_MB))));
        }
        catch (Throwable image) {
            // empty catch block
        }
        try {
            FixedByteBuffer.injectIntoStdout();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        try {
            CentralDebugging.loadDebugSettings("SimpleGatewayService", false);
        }
        catch (Throwable t) {
            // empty catch block
        }
        HiccupThread.startup();
        try {
            System.out.println("[SimpleGatewayService] TTL = " + Security.getProperty("networkaddress.cache.ttl"));
            System.out.println("[SimpleGatewayService] Negative TTL = " + Security.getProperty("networkaddress.cache.negative.ttl"));
        }
        catch (Throwable t) {
            // empty catch block
        }
        try {
            System.out.println("[SimpleGatewayService] SH Version: " + Version.getExtended() + " (" + Version.getSsuiteFullBuildVersion() + ")");
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (CentralDebugging.SG_ACCEPT_ALL_CERTS) {
            try {
                System.out.println("[RA Testing] Accepting all SSL certs (test file specified)");
                SSLContext ssc = SSLContext.getInstance("SSL");
                ssc.init(null, SSLHelper.getTrustAllCertsTrustManagerArray(), new SecureRandom());
                HttpsURLConnection.setDefaultHostnameVerifier(SSLHelper.getTrustAllHostnameVerifier());
                HttpsURLConnection.setDefaultSSLSocketFactory(ssc.getSocketFactory());
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        try {
            System.out.println("Trying to enable service recovery (on windows only)");
            JWService.setServiceRestartOnFailure((String)JWService.getDefaultServiceName(), (boolean)true, (boolean)false);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        Security.setProperty("networkaddress.cache.ttl", "30");
        Security.setProperty("networkaddress.cache.negative.ttl", "10");
        System.setProperty("sun.net.client.defaultConnectTimeout", "35000");
        System.setProperty("sun.net.client.defaultReadTimeout", "35000");
        System.setProperty("http.agent", "Mozilla/5.0 (Windows; U; Windows NT 5.1; en-GB; rv:1.8.1.16) Gecko/20080702 Firefox/2.0.0.16");
        System.setProperty("http.keepAlive", "true");
        System.setProperty("http.maxConnections", "2");
        SimpleGatewayService.loadNativeLibraries();
        SimpleGatewayService.registerNativeEventListener();
        SimpleGatewayService.writeVersionTxtFile();
        SecureMessenger.compressAllSends(true);
        sgTransientId = BCUtil.getSecureRandom().nextLong();
        String SGPORT = "Not set";
        try {
            Object mygroup;
            SimpleGatewayID masterid;
            if (!JWTesting.amTesting() && !SIMULATE_MULTIPLE_MACHINES) {
                File sgportFile = SGPortUtil.getSGPortFile(true);
                System.out.println("[SimpleGatewayService] Got port file " + sgportFile + " (exists=" + sgportFile.exists() + ")");
                lockForSGPort = SGPortUtil.getLockForSGPortOrTimeout(sgportFile, 60000L);
                if (lockForSGPort == null) {
                    System.out.println("************************************************************************************");
                    System.out.println("* [Error] The service was unable to lock the lock file. After trying for 60 seconds it is giving up.");
                    System.out.println("************************************************************************************");
                    throw new IOException("Service was unable to lock lock file for " + sgportFile.getAbsolutePath());
                }
                System.out.println("[SimpleGatewayService] Got lock file " + SimpleGatewayService.lockForSGPort.lockFile.getAbsolutePath() + " (exists=" + SimpleGatewayService.lockForSGPort.lockFile.exists() + ")");
                ServerSocket ssock = null;
                try {
                    ssock = new ServerSocket(5653 + SimpleGatewayService.modCurrentDirToValue5000(), 0, InetAddress.getByName("localhost"));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    if (ssock == null) {
                        ssock = new ServerSocket(56563 + SimpleGatewayService.modCurrentDirToValue5000(), 0, InetAddress.getByName("localhost"));
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (ssock == null) {
                    ssock = new ServerSocket(0, 0, InetAddress.getByName("localhost"));
                }
                int port = ssock.getLocalPort();
                System.out.println("[SimpleGatewayService] SG Port file writing  (file access). Bound to port " + port);
                FileOutputStream fout = new FileOutputStream(sgportFile);
                fout.write(("" + port).getBytes(StandardCharsets.UTF_8));
                fout.flush();
                fout.close();
                ChModUtil.chmodReadForAllMacOnly(new File("."));
                new ExitThread(ssock).start();
            }
            lossyclient = new LossyClient();
            lossyclient.init(new LossyClientSgListener(), BCUtil.getSecureRandom());
            masteridStatic = masterid = SimpleGatewayID.loadOrCreate(SIMULATE_MULTIPLE_MACHINES);
            if (OS.isWindows()) {
                livenessUpdater = new LivenessUpdater();
            }
            File configFile = SimpleGatewayConfig.getConfigLocation();
            System.out.println("[SimpleGatewayService] Loading config from " + configFile);
            try {
                SimpleGatewayService.reloadConfig();
            }
            catch (Exception x) {
                System.out.println("[SimpleGatewayService] No config file found (serviceconfig.xml), creating empty config");
                config = new SimpleGatewayConfig();
                config.subsituteMacros();
                SimpleGatewayService.config.allowMonitoring = true;
                SimpleGatewayService.config.allowRecovery = true;
                SimpleGatewayService.config.allowScripting = true;
                SimpleGatewayService.resaveConfig();
            }
            String deferTestControlHost = null;
            if (Testing.amTesting()) {
                System.out.println("[RA Testing] Creating fake config");
                String serverURL = JWLaunchProperties.getProperty((String)"INFO_SG_URL");
                String myname = JWLaunchProperties.getProperty((String)"INFO_SG_NAME");
                mygroup = JWLaunchProperties.getProperty((String)"INFO_SG_GROUP");
                deferTestControlHost = JWLaunchProperties.getPropertyPossiblyNull((String)"INFO_SG_DEFER");
                System.out.println("[RA Testing] Will run against " + serverURL);
                System.out.println("[RA Testing] Will be named " + myname + " inside " + (String)mygroup);
                config.setURLs(new String[]{serverURL});
                config.setName((String)mygroup + myname);
                System.out.println("[RA Testing] using fake config folder " + JWSystem.getAllAppVersionsSharedFolder());
                SimpleGatewayService.resaveConfig();
                String acceptAllSSL = JWLaunchProperties.getProperty((String)"INFO_SG_ACCEPT_ALL_SSL");
                if (acceptAllSSL.equals("true")) {
                    try {
                        System.out.println("[RA Testing] Accepting all SSL certs");
                        SSLContext ssc = SSLContext.getInstance("SSL");
                        ssc.init(null, SSLHelper.getTrustAllCertsTrustManagerArray(), new SecureRandom());
                        HttpsURLConnection.setDefaultHostnameVerifier(SSLHelper.getTrustAllHostnameVerifier());
                        HttpsURLConnection.setDefaultSSLSocketFactory(ssc.getSocketFactory());
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                } else {
                    System.out.println("[RA Testing] SSL connections will go through normal verification");
                }
            }
            System.out.println("[SimpleGatewayService] Setting proxy from config file");
            SimpleGatewayConfig.setJavaUrlProxyFromConfig(config);
            ChModUtil.chmodReadForAllMacOnly(new File("."));
            ChModUtil.chmodFreeForAllMacOnly(configFile);
            if (CentralDebugging.DDEBUG_ON) {
                DDLog.setProcess("Remote Access Service");
            }
            if (CentralDebugging.DDEBUG_ON) {
                DDLog.aliasMaster(config.getName(), masterid.getID());
            }
            if (CentralDebugging.DDEBUG_ON) {
                DDLog.alias(config.getName(), masterid.id + "");
            }
            if (CentralDebugging.DDEBUG_ON) {
                DDLog.alias(config.getName(), config);
            }
            if (CentralDebugging.DDEBUG_ON) {
                DDLog.log(config, "Loading all Secure Messengers");
            }
            System.out.println("[SimpleGatewayService] Picking up Secure Messengers DB");
            secmsgDB = new File(JWSystem.getAllAppVersionsSharedFolder(), "secmsg");
            if (!secmsgDB.exists()) {
                secmsgDB.mkdirs();
                if (OS.isMacOS()) {
                    System.out.println("[SimpleGatewayService] Setting permissions for secmsg repository");
                    try {
                        JWGenericOS.setWritableForAllUsers((File)secmsgDB, (boolean)true);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
            SecureMessengerDB.setDatabaseFolder(secmsgDB, null, 1000);
            if (masterid.isNew()) {
                System.out.println("[SimpleGatewayService] New ID, removing all SecMsgs");
                if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                    DDLog.log(config, "Master ID is new, removing all Secure Messengers");
                }
                SecureMessengerDB.clearAllSecureMessengers();
            }
            if (TRACK_SESSIONS_AND_EXIT_ON_ZERO) {
                System.out.println("[SimpleGatewayService] Will exit on zero sessions (after " + TRACK_SESSIONS_AND_EXIT_MIN_ZERO_TIME + "ms)");
            }
            System.out.println("[SimpleGatewayService] Writing success");
            if (!SIMULATE_MULTIPLE_MACHINES) {
                try {
                    JWLogging.writeProcessResult((int)1);
                }
                catch (Throwable e) {
                    // empty catch block
                }
            }
            if (OS.isWindows()) {
                SimpleGatewayService.configureWindowsSpecificEnvironment(CentralDebugging.SG_ADD_FIREWALL_RULES, CentralDebugging.SG_ADD_SAFE_MODE_REBOOT_KEY);
            }
            if (deferTestControlHost != null) {
                JWTestControl.shareJWT((JWTestable)new SGTestInstance(), (String)deferTestControlHost, (int)TestUtils.TESTCONTROL_PORT);
                JWTesting.reportSuccess((String)"Remote Access Service Launch");
            }
            boolean checkPolling = true;
            ServiceGenStore.setup(new PollThreadsGenStoreProvider());
            SGExtensionUtil.load();
            try {
                if (SGExtensionUtil.get() != null) {
                    SGExtensionUtil.get().setAPI(new ExtensionAPI());
                }
            }
            catch (Exception x) {
                x.printStackTrace();
            }
            while (true) {
                checkPolling = SimpleGatewayService.reloadConfigIfRequired(configFile) || checkPolling;
                Object x = config_LOCK;
                synchronized (x) {
                    if (!perUserServiceIsAsleep && !SimpleGatewayService.tryGrabUniquenessLock()) {
                        mygroup = SERVICE_SLEEP_LOCK;
                        synchronized (mygroup) {
                            SERVICE_SLEEP_LOCK.wait(5000L);
                        }
                    }
                    if (checkPolling || sleepStatusChanged) {
                        System.out.println("[SimpleGatewayService] Checking polling status");
                        sleepStatusChanged = false;
                        HashMap<String, String> requiredURLsMap = new HashMap<String, String>();
                        String[] urls = perUserServiceIsAsleep ? new String[]{} : config.getSafeURLs();
                        for (String url : urls) {
                            requiredURLsMap.put(url, url);
                            System.out.println("[SimpleGatewayService] Required URL: " + url);
                        }
                        ArrayList<PollThread> newthreads = new ArrayList<PollThread>();
                        for (PollThread pt : pollThreads) {
                            if (!requiredURLsMap.containsKey(pt.udpOrHttpServerURL)) {
                                System.out.println("[SimpleGatewayService] Thread for URL " + pt.udpOrHttpServerURL + " no longer required");
                                pt.iAmObsolete = true;
                                continue;
                            }
                            System.out.println("[SimpleGatewayService] Thread for URL " + pt.udpOrHttpServerURL + " still required");
                            requiredURLsMap.remove(pt.udpOrHttpServerURL);
                            newthreads.add(pt);
                        }
                        for (String uncateredForURL : requiredURLsMap.keySet()) {
                            System.out.println("[SimpleGatewayService] Thread for URL " + uncateredForURL + " now required");
                            newthreads.add(SimpleGatewayService.poll(uncateredForURL, masterid));
                        }
                        pollThreads = newthreads;
                        SimpleGatewayService.recheckAllPollThreadServerVersions();
                        System.out.println("[SimpleGatewayService] Loading monitoring state");
                        SimpleGatewayService.loadMonitoringState();
                        checkPolling = false;
                    }
                    long stuckMins = 7L;
                    long stuckPoller = System.currentTimeMillis() - stuckMins * 60000L;
                    for (PollThread pt : pollThreads) {
                        if (pt.lastExecutedPoll >= stuckPoller) continue;
                        System.out.println("[SimpleGatewayService] Poll thread for " + pt.serverAddress + " appears to be stuck (done nothing for " + stuckMins + " mins), will try to wake up");
                        pt.lastExecutedPoll = System.currentTimeMillis();
                        if (Testing.amTesting()) continue;
                        pt.interrupt();
                    }
                }
                x = SERVICE_SLEEP_LOCK;
                synchronized (x) {
                    SERVICE_SLEEP_LOCK.wait(5000L);
                }
                if (!CentralDebugging.PX_GENSTORE_TESTAPI) continue;
                Message m = new Message();
                m.append(new Date() + " Hello from the RA service process!");
                ServiceGenStore.INSTANCE.sendBulkData(m);
            }
        }
        catch (BindException t) {
            JWLogging.appendProcessTrace((Throwable)t);
            JWLogging.writeProcessResult((int)2);
            System.out.println("An instance of the SimpleGateway Service is already running (" + SGPORT + ")");
            System.out.println("Exit in 5 seconds...");
            Thread.sleep(5000L);
            System.exit(1);
        }
        catch (Throwable t) {
            JWLogging.appendProcessTrace((Throwable)t);
            JWLogging.writeProcessResult((int)2);
            t.printStackTrace();
            Thread.sleep(5000L);
            System.exit(1);
        }
    }

    private static boolean reloadConfigIfRequired(File configFile) {
        if (configFile.lastModified() != config.getLastModified()) {
            try {
                System.out.println("[SimpleGatewayService] Re-reading config file");
                SimpleGatewayService.reloadConfig();
                if (CentralDebugging.DDEBUG_ON) {
                    DDLog.alias(config.getName(), config);
                }
                if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                    DDLog.log(config, "Config reloaded");
                }
                SimpleGatewayConfig.setJavaUrlProxyFromConfig(config);
                return true;
            }
            catch (Exception e) {
                e.printStackTrace();
                try {
                    Thread.sleep(15000L);
                }
                catch (InterruptedException e1) {
                    e1.printStackTrace();
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void resaveConfig() throws Exception {
        Object object = config_LOCK;
        synchronized (object) {
            System.out.println("[SimpleGatewayService] Saving config.");
            File configFile = SimpleGatewayConfig.getConfigLocation();
            config.save(configFile, true);
        }
    }

    private static void resendBasicInfo() {
        try {
            String configName = SimpleGatewayService.getNameFromConfigWithLock();
            for (PollThread pt : pollThreads) {
                try {
                    pt.sendMonitoringSettingsOnNextValidate();
                    pt.sendBasicInfoOnNextValidate(false, configName);
                    pt.wakeUpAndPingNow();
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void promptConfigReload() {
        Object object = SERVICE_SLEEP_LOCK;
        synchronized (object) {
            SERVICE_SLEEP_LOCK.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void reloadConfig() throws Exception {
        Object object = config_LOCK;
        synchronized (object) {
            System.out.println("[SimpleGatewayService] Reloading config.");
            File configFile = SimpleGatewayConfig.getConfigLocation();
            config = new SimpleGatewayConfig(configFile);
            try {
                ArrayList<String> hashes = config.getAllPubkeyHashes();
                for (String hash : hashes) {
                    hashRepository.addHash(hash, "import from serviceconfig.xml");
                }
            }
            catch (Exception x) {
                x.printStackTrace();
            }
            try {
                ArrayList<String> servers = config.getAllUrlsWithHashes();
                for (String server : servers) {
                    hashRepository.addURL(server, "import from serviceconfig.xml");
                }
            }
            catch (Exception x) {
                x.printStackTrace();
            }
            hashRepository.trimURLsNotIncludedIn(config.getSafeURLs());
            if (config.subsituteMacros()) {
                System.out.println("[SimpleGatewayService] Macros resolved. Resaving.");
                SimpleGatewayService.resaveConfig();
            }
        }
        SimpleGatewayService.updateMonitoringAppStatus();
        SimpleGatewayService.resendBasicInfo();
    }

    private static void loadNativeLibraries() {
        try {
            AuxConfig.blockUntilAuxDownloaded();
            NativeLibraryLoader.loadLibrary(JWSystem.getAppFolder());
        }
        catch (Throwable t) {
            System.out.println("[SimpleGatewayService] Unable to load native libraries.");
            t.printStackTrace();
        }
    }

    private static void recheckAllPollThreadServerVersions() {
        String max = null;
        String address = null;
        for (PollThread thread : pollThreads) {
            if (thread == null || thread.serverVersion == null || max != null && !VersionUtil.isLaterThan(max, thread.serverVersion)) continue;
            max = thread.serverVersion;
            address = thread.getServerURL();
        }
        if (max == null || address == null) {
            return;
        }
        try {
            SimpleGatewayService.setLatestServerURL(SGServiceInstallationManager.getUpdateUrlFromShUrl(address));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static void writeVersionTxtFile() {
        try {
            System.out.println("[SimpleGatewayService] Version file saving (file access)");
            FileUtil.writeFile((File)new File("version.txt"), (byte[])VersionUtil.getVersion().getBytes());
            System.out.println("[SimpleGatewayService] SimpleGateway Service v" + VersionUtil.getVersion());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private static void registerNativeEventListener() {
        try {
            if (OS.isMacOS() || OS.isWindows()) {
                NativeEventUtil.getInstance().addEventListener(nativeEventListener);
            }
        }
        catch (Throwable t) {
            System.out.println("[SimpleGatewayService] Unable to register native listener.");
            t.printStackTrace();
        }
    }

    public static Properties sessionGetAccessServiceLaunchPropsOrNull(boolean useInheritedSourceLauncher) {
        try {
            File starter;
            File parentDirectory = JWSystem.getAllAppVersionsSharedFolder();
            File targetDirectory = new File(parentDirectory, "SimpleGatewayService");
            if (!targetDirectory.exists()) {
                System.out.println("[SimpleGatewayService] SimpleGatewayService shortcut folder does not exist yet");
                return null;
            }
            File target = starter = JWSystem.getLauncherLocationForVirtualApp((File)targetDirectory, (String)"SimpleGatewayService");
            System.out.println("[SimpleGatewayService] Identifying RA start launcher as " + target);
            if (!starter.exists()) {
                System.out.println("[SimpleGatewayService] SG shortcut does not exist yet");
                return null;
            }
            if (OS.isMacOS()) {
                if (!(target = JWMacOS.getParameterisationFile((File)target)).exists()) {
                    System.out.println("[SimpleGatewayService] SG shortcut does not exist yet");
                    return null;
                }
                System.out.println("[SimpleGatewayService] MacOS, so getting dynprops file as " + target);
            }
            JWParameteriser jwp = new JWParameteriser();
            Properties props = jwp.getParameters(target);
            System.out.println("[SimpleGatewayService] Loaded clean RA launch props as: ");
            for (Object key : props.keySet()) {
                String value = String.valueOf(props.get(key));
                if (value != null && value.length() > 300) {
                    value = value.substring(0, 300) + "...";
                }
                System.out.println("[SimpleGatewayService] " + key + "=" + value);
            }
            if (useInheritedSourceLauncher) {
                props.setProperty("launched_from_dynprops", JWLaunchProperties.getProperty((String)"launched_from_dynprops"));
            } else {
                props.setProperty("launched_from_dynprops", starter.getCanonicalPath());
            }
            System.out.println("[SimpleGatewayService] Set launched from dynprop as " + props.getProperty("launched_from_dynprops"));
            return props;
        }
        catch (IOException x) {
            x.printStackTrace();
            return null;
        }
        catch (Exception x) {
            x.printStackTrace();
            return null;
        }
    }

    public static Message testing_createMessage(int type, SimpleGatewayID masterid) {
        return SimpleGatewayService.createMessage(type, masterid);
    }

    private static Message createMessage(int type, SimpleGatewayID masterid) {
        Message m = new Message(type);
        m.append(masterid.id);
        m.append(masterid.auth1);
        m.append(masterid.auth2);
        return m;
    }

    private static void forceMonitoringOnForRun() {
        SimpleGatewayService.forceMonitoringOnFor(5);
    }

    private static void forceMonitoringOnFor(int minutes) {
        forceSubProcessUntil = SafeClock.currentTimeMillis() + (long)(minutes * 60000);
    }

    private static void setShowingPopupsFlag() {
        amShowingPopups = true;
    }

    private static void clearShowingPopupsFlag() {
        amShowingPopups = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean amMonitoringOrAlerting() {
        boolean anyAlerts = false;
        Object object = alertRegs_LOCK;
        synchronized (object) {
            String[] keys;
            for (String key : keys = alertRegs.keySet().toArray(new String[0])) {
                AlertRegistry reg = alertRegs.get(key);
                if (reg.size() <= 0) continue;
                anyAlerts = true;
            }
        }
        return amShowingPopups || isMonitoring || anyAlerts || SafeClock.currentTimeMillis() < forceSubProcessUntil;
    }

    private static void updateMonitoringAppStatus() {
        if (SGExtensionUtil.loaded() && !SGExtensionUtil.get().supportsMonitoring()) {
            return;
        }
        if (SimpleGatewayService.amMonitoringOrAlerting()) {
            if (!monitoring.isOn()) {
                System.out.println("[Monitoring] Launching monitoring app");
                if (System.currentTimeMillis() < nextMonitoringLaunchAllowed) {
                    System.out.println("[Monitoring] ***WARNING Monitoring app failed to launch too recently, must wait");
                } else {
                    try {
                        monitoring.setOn(config.getName(), true, broadcast);
                        System.out.println("[Monitoring] Monitoring app launched OK");
                    }
                    catch (Exception x) {
                        System.out.println("[Monitoring] Unable to launch monitoring app, will not re-attempt for 60s");
                        x.printStackTrace();
                        nextMonitoringLaunchAllowed = System.currentTimeMillis() + 60000L;
                    }
                }
            }
        } else if (monitoring.isOn()) {
            System.out.println("[Monitoring] Closing monitoring app (not required)");
            try {
                monitoring.setOn(config.getName(), false, broadcast);
                System.out.println("[Monitoring] Monitoring app closed OK");
            }
            catch (Exception x) {
                System.out.println("[Monitoring] Unable to launch monitoring app");
                x.printStackTrace();
            }
        }
    }

    private static File getMonitoringStateFile() {
        File parent = JWSystem.getAllAppVersionsSharedFolder();
        if (parent == null) {
            return new File("monitoring.settings");
        }
        return new File(parent, "monitoring.settings");
    }

    private static void saveMonitoringState() {
        Message msg = new Message();
        msg.append(1);
        msg.append(isMonitoring);
        System.out.println("[SimpleGatewayService] Saving monitoring state  (file access)");
        try {
            FileOutputStream out = new FileOutputStream(SimpleGatewayService.getMonitoringStateFile());
            MessageUtils.writeMessage((OutputStream)out, (Message)msg);
            ((OutputStream)out).close();
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void loadMonitoringState() {
        boolean savedMonitoring = false;
        try {
            System.out.println("[SimpleGatewayService] Loading monitoring state (file access)");
            FileInputStream in = new FileInputStream(SimpleGatewayService.getMonitoringStateFile());
            Message msg = MessageUtils.readMessage((InputStream)in);
            ((InputStream)in).close();
            int MVER = msg.getNextInt();
            savedMonitoring = msg.getNextBoolean();
        }
        catch (FileNotFoundException in) {
        }
        catch (Exception x) {
            x.printStackTrace();
        }
        System.out.println("[SimpleGatewayService] Monitoring state is " + (savedMonitoring ? "On" : "Off"));
        Object object = monitoringSwitch_LOCK;
        synchronized (object) {
            if (savedMonitoring != isMonitoring) {
                isMonitoring = savedMonitoring;
            }
            try {
                SimpleGatewayService.updateMonitoringAppStatus();
                SimpleGatewayService.updateGlobalEvents();
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void logProblem(String s) {
        Object object = problem_LOCK;
        synchronized (object) {
            try {
                System.out.println("[SimpleGatewayService] ***WARNING Logging problem (file access)");
                File parent = JWSystem.getAllAppLoggingFolder();
                File logFile = new File(parent, "problems.txt");
                PrintStream pout = new PrintStream(new FileOutputStream(logFile, true));
                pout.println(new Date() + ": " + s);
                pout.flush();
                pout.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static void updateGlobalEvents() {
        if (Testing.amTesting()) {
            new BatchingTimedThread(glolock){

                @Override
                public void runNow() {
                    SimpleGatewayService.doUpdateGlobalEvents();
                }
            }.startIfNecessary();
        } else {
            SimpleGatewayService.doUpdateGlobalEvents();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doUpdateGlobalEvents() {
        ToolResourceLocator locator;
        ArrayList<Alert> glo;
        boolean pauseAndRepeat;
        do {
            pauseAndRepeat = false;
            glo = new ArrayList<Alert>();
            ArrayList<LocatedAlert> all = new ArrayList<LocatedAlert>();
            locator = new ToolResourceLocator();
            Iterator iterator = alertRegs_LOCK;
            synchronized (iterator) {
                String[] servers;
                if (CentralDebugging.SG_ALERTS) {
                    System.out.println("[Alerts] Updating GlobalEvents");
                }
                for (String server : servers = alertRegs.keySet().toArray(new String[0])) {
                    AlertRegistry serverReg = alertRegs.get(server);
                    if (Switches.SH_2210_waitForResetBeforeUpdatingMonitoring && serverReg.getClock().wasResetRecently()) {
                        System.out.println("[Alerts] Alert registry for server " + server + " was reset recently so we need to pause and update when it is recreated");
                        pauseAndRepeat = true;
                        break;
                    }
                    ArrayList<ResourceContainer> areg = serverReg.getAll();
                    if (CentralDebugging.SG_ALERTS) {
                        System.out.println("[Alerts] Server " + server + " has " + areg.size() + " alerts");
                    }
                    for (ResourceContainer rc : areg) {
                        if (!(rc instanceof LocatedAlert)) continue;
                        all.add((LocatedAlert)rc);
                        Alert main = ((LocatedAlert)rc).getAlert();
                        try {
                            locator.addMapping(main, server);
                            ArrayList<Alert> subs = main.getAllSubAlerts();
                            for (Alert sub : subs) {
                                locator.addMapping(sub, server);
                            }
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                    }
                }
            }
            if (pauseAndRepeat) {
                try {
                    Thread.sleep(2000L);
                }
                catch (Exception exception) {}
                continue;
            }
            for (LocatedAlert la : all) {
                if (CentralDebugging.SG_ALERTS) {
                    System.out.println("[Alerts] -- " + la.getName() + " (" + la.getID() + ") clock=" + la.getAlert().getModifiedClock());
                }
                glo.add(la.getAlert());
            }
        } while (pauseAndRepeat);
        if (CentralDebugging.SG_ALERTS || CentralDebugging.SG_ALERTS_SGM_PROPAGATION) {
            System.out.println("[Alerts] " + glo.size() + " total alerts");
        }
        SimpleGatewayService.updateMonitoringAppStatus();
        ToolResourceLocator.setSingleton(locator);
        if (glo.size() > 0 || glo.size() != lastGloSize) {
            if (monitoring.isOn()) {
                if (!SimpleGatewayService.config.allowScripting) {
                    if (CentralDebugging.SG_ALERTS || CentralDebugging.SG_ALERTS_SGM_PROPAGATION) {
                        System.out.println("[Alerts] Refusing to send alerts to monitoring app (permission denied)");
                    }
                } else {
                    if (CentralDebugging.SG_ALERTS || CentralDebugging.SG_ALERTS_SGM_PROPAGATION) {
                        System.out.println("[Alerts] Sending alerts and resource locator to monitoring app");
                    }
                    monitoring.sendAlerts(glo, locator);
                }
            } else if (CentralDebugging.SG_ALERTS || CentralDebugging.SG_ALERTS_SGM_PROPAGATION) {
                System.out.println("[Alerts] Monitoring app is not up, alerts will not be passed on");
            }
        }
        lastGloSize = glo.size();
    }

    private static long buildAlertsHash(ArrayList<ResourceContainer> all) {
        long hash = 0L;
        Collections.sort(all, new ResourceContainerComparator());
        for (ResourceContainer rc : all) {
            long cur;
            if (!(rc instanceof LocatedAlert)) continue;
            LocatedAlert la = (LocatedAlert)rc;
            if (CentralDebugging.SG_ALERTS_HASHES) {
                System.out.println("[AlertsHash] Hashing: id=" + la.getAlert().getID() + " clock=" + la.getAlert().getModifiedClock());
            }
            if (Switches.SH_alertHashUsesAllData) {
                Message hashy = new Message();
                la.getAlert().toMessage(hashy);
                if (CentralDebugging.SG_ALERTS_HASHES) {
                    System.out.println("[AlertsHash] Hash message: " + hashy);
                }
                cur = BCUtil.getPartialSha256of((byte[])MessageUtils.messageToBytes((Message)hashy));
            } else {
                cur = BCUtil.getPartialSha256of((byte[])la.getAlert().getID().getBytes(StandardCharsets.US_ASCII));
            }
            if (CentralDebugging.SG_ALERTS_HASHES) {
                System.out.println("[AlertsHash] " + la + " hash (+ID:" + la.getAlert().getID() + ") is " + cur);
            }
            hash += cur;
            if (!CentralDebugging.SG_ALERTS_HASHES) continue;
            System.out.println("[AlertsHash] Registry hash is now " + hash);
        }
        if (CentralDebugging.SG_ALERTS_SIMULATE_REG_ERROR) {
            return hash + 1L;
        }
        return hash;
    }

    private static void disallowRenegotiationsDueToIncomingMessagFail() {
        nextIncomingFailReneg = System.currentTimeMillis() + 600000L;
    }

    private static void renegotiateSecurityFromIncomingMessageFail(LossyTransport problemSource) {
        long T = System.currentTimeMillis();
        if (T > nextIncomingFailReneg) {
            nextIncomingFailReneg = T + 600000L;
            if (CentralDebugging.RENEGOTIATION_TRACING) {
                new Exception("Renegotiate Security (incoming message fail)").printStackTrace();
            }
            new SecurityRenegotiationThread(problemSource).start();
        }
    }

    private static void renegotiateSecurity(LossyTransport problemSource) {
        if (CentralDebugging.RENEGOTIATION_TRACING) {
            new Exception("Renegotiate Security").printStackTrace();
        }
        new SecurityRenegotiationThread(problemSource).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testStartPolling() {
        test_POLLING = true;
        Object object = test_BEGIN;
        synchronized (object) {
            test_BEGIN.notifyAll();
        }
    }

    private static void testStopPolling() {
        test_POLLING = false;
    }

    private static void testRenegotiate() {
        SecureMessengerDB.clearAllSecureMessengers();
    }

    private static void testKillHttpSocket() {
        for (PollThread pt : pollThreads) {
            pt.testKillHttpSocket();
        }
    }

    private static void handleMachineStream(NodeLink nl, MachineStream ms, PollThread pt) {
        StreamTransactionListener stl = new StreamTransactionListener(ms, pt);
        final BasicMTTransactionServer mts = new BasicMTTransactionServer(ms.in.getInputStream((short)7770, "MachineStream"), ms.out.getOutputStream((short)7770), stl, 5, 10, true);
        mts.setSingleMessageListener(stl);
        if (nl != null) {
            nl.addLinkStatusListener(new NodeLinkStatusListener(){

                @Override
                public void linkDown(NodeLink link, Throwable reason) {
                }

                @Override
                public void linkOK(NodeLink link) {
                }

                @Override
                public void linkDead(NodeLink link, String reason) {
                    mts.shutdown();
                }
            });
        }
    }

    static /* synthetic */ String[] access$5802(String[] x0) {
        multi_countries = x0;
        return x0;
    }

    static {
        config_LOCK = new Object();
        remoteFSMessageHandler = new RemoteFSHandler(new LocalFS());
        TEST_UI = null;
        TRACK_MULTI_UI = 0;
        SIMULATE_MULTIPLE_MACHINES = false;
        multi_count = 1000;
        multi_wait = 10000L;
        multi_wait_each = 1L;
        multi_name_override = "multi";
        SERVICE_SLEEP_LOCK = new Object();
        perUserServiceIsAsleep = false;
        sleepStatusChanged = false;
        nativeEventListener = new SGEventListener();
        pollThreads = new ArrayList();
        monitoring = new SimpleGatewayMonitoring();
        broadcast = new MonitoringBroadcast();
        currentServiceLock = null;
        HTTP_RESPONSE_CODES_NOT_SH = new int[]{400, 401, 402, 403, 405, 406, 407, 409, 502, 504};
        alertRegs_LOCK = new Object();
        alertRegs = new HashMap();
        nextCheckDue = 0L;
        REAL_STDOUT = null;
        TRACK_SESSIONS_AND_EXIT_ON_ZERO = false;
        TRACK_SESSIONS_AND_EXIT_MIN_ZERO_TIME = 120000L;
        test_POLLING = false;
        test_POLLING_CYCLE = false;
        test_BEGIN = new Object();
        sessionTracking_LOCK = new Object();
        tracking_secMsgSetups = 0;
        tracking_LOCK = new Object();
        isMonitoring = false;
        forceSubProcessUntil = 0L;
        amShowingPopups = false;
        nextMonitoringLaunchAllowed = 0L;
        serverClaim = new ServerClaim();
        problem_LOCK = new Object();
        glolock = new BatchingTimedThreadLock(5000L);
        if (Testing.amTesting()) {
            glolock = new BatchingTimedThreadLock(300000L);
        }
        lastGloSize = -1;
        monitoringSwitch_LOCK = new Object();
        renegotiation_running = false;
        renegotiate_LOCK = new Object();
        nextIncomingFailReneg = 0L;
        patchLOCK = new Lock();
        patchCache = new Cache("MachineStreamPatch", 50);
    }

    static class PollThreadsGenStoreProvider
    implements GenStoreProvider {
        PollThreadsGenStoreProvider() {
        }

        @Override
        public void sendBulkData(Message message) {
            for (PollThread pt : pollThreads) {
                pt.genStore.addPacket(new StorePacket(message));
            }
        }
    }

    static class PatchSync
    implements GenericSync {
        boolean synced = false;
        final Object notifier = new Object();
        final int patchID;

        PatchSync(int patchID) {
            this.patchID = patchID;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void syncWithRemoteNow() {
            if (!this.synced) {
                Object object = this.notifier;
                synchronized (object) {
                    try {
                        this.notifier.wait(5000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void doSyncNow() {
            this.synced = true;
            Object object = this.notifier;
            synchronized (object) {
                this.notifier.notifyAll();
            }
        }
    }

    static class StreamTransactionListener
    implements TransactionListener,
    SinglesListener {
        final MachineStream ms;
        final PollThread pt;

        StreamTransactionListener(MachineStream ms, PollThread pt) {
            this.ms = ms;
            this.pt = pt;
        }

        @Override
        public Message doTransaction(Message msg) {
            int type = msg.getType();
            if (type > 1589723136 && type < 1589727231) {
                Message response;
                if (Switches.SH_allowLossyTransportSwitchingInRa && (type == 1589723157 || type == 1589723158) && SwitchableLossyTransport.trySwitchAlt(this.pt.serverLossyTransport, 60000L)) {
                    System.out.println("[SimpleGatewayService] Temporarily switched to alternate transport for file operations");
                }
                if ((response = remoteFSMessageHandler.handle(msg, this.ms)) == null) {
                    return new Message(-286392320);
                }
                return response;
            }
            return new Message(-404291584);
        }

        @Override
        public void doMessage(Message msg) {
            int type = msg.getType();
            if (type > 1589723136 && type < 1589727231) {
                remoteFSMessageHandler.handle(msg, this.ms);
            }
        }
    }

    private static class SGTestInstance
    implements JWTestable {
        private SGTestInstance() {
        }

        public String getTestableAppName() {
            return TestUtils.APP_RA_SERVICE;
        }

        public void call(String str, Message m) {
            if (str.equals(TestUtils.RA_CMD_startPolling)) {
                SimpleGatewayService.testStartPolling();
            } else if (str.equals(TestUtils.RA_CMD_stopPolling)) {
                SimpleGatewayService.testStopPolling();
            } else if (str.equals(TestUtils.RA_CMD_renegotiate)) {
                SimpleGatewayService.testRenegotiate();
            } else if (str.equals(TestUtils.RA_CMD_killHttpSocket)) {
                SimpleGatewayService.testKillHttpSocket();
            }
        }

        public void testControlConnectionFailed() {
            System.out.println("[Testing] JWTestControl connection failed, exiting");
            try {
                JWTesting.reportFail((String)"JWTestControl connection failed to SimpleGatewayService", (String)"");
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            System.exit(1);
        }
    }

    private static class LossyClientSgListener
    implements LossyMessageHandler {
        private LossyClientSgListener() {
        }

        @Override
        public void handleAsyncMessage(byte[] data, LossyTransport respond, Long respondConversation, Object source) {
            Message m = MessageUtils.bytesToMessage((byte[])data);
            if (m == null) {
                System.out.println("Dropped invalid message from " + respond.getUnderlyingProtocolDescription() + "/" + respondConversation);
                return;
            }
            int type = m.getType();
            if (!LossyUtils.isCurrentProtocol(type)) {
                return;
            }
            if (type == 274596355) {
                if (CentralDebugging.RA_SHOW_READABLE_MESSAGES) {
                    System.out.println("[Incoming Message] Lossy Renegotiation Message X");
                }
            } else if (type == 274596444 || type == 274596432) {
                try {
                    SecureMessenger.handleIncomingSecureMessage(data, respond, respondConversation, false, source);
                }
                catch (SecMsgDecryptionError x) {
                    System.out.println("[SecMsg] Unable to process incoming message - " + x.getMessage());
                    SimpleGatewayService.renegotiateSecurityFromIncomingMessageFail(respond);
                }
                catch (IOException x) {
                    x.printStackTrace();
                }
            } else if (type == 274596505) {
                if (CentralDebugging.RA_SHOW_READABLE_MESSAGES) {
                    System.out.println("[Incoming Message] Lossy Renegotiation Required X (we are being asked to renegotiate security)");
                }
                SimpleGatewayService.renegotiateSecurity(respond);
            } else if (type == 3003000) {
                if (CentralDebugging.RA_SHOW_READABLE_MESSAGES) {
                    System.out.println("[Incoming Message] UDP lossy echo request (lossy messaging subsystem test)");
                }
                System.out.println("[LossyMessageTest] Message " + m + ", appending and echoing");
                m.setType(m.getType() + 1);
                m.append("(machine response)");
                lossyclient.sendLossy(respond, MessageUtils.messageToBytes((Message)m), respondConversation);
            } else if (type == 3006000) {
                if (CentralDebugging.RA_SHOW_READABLE_MESSAGES) {
                    System.out.println("[Incoming Message] UDP guaranteed echo request (lossy messaging subsystem test)");
                }
                if (Math.random() < 0.5) {
                    System.out.println("[LossyMessageTest] G-Message " + m + ", dropping");
                } else {
                    System.out.println("[LossyMessageTest] G-Message " + m + ", appending and echoing");
                }
                m.setType(m.getType() + 1);
                m.append("(machine response)");
                lossyclient.sendGuaranteed(respond, MessageUtils.messageToBytes((Message)m), respondConversation);
            }
        }
    }

    static class SecurityRenegotiationThread
    extends Thread {
        final LossyTransport problemSource;

        SecurityRenegotiationThread(LossyTransport problemSource) {
            this.problemSource = problemSource;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Object object = renegotiate_LOCK;
            synchronized (object) {
                if (renegotiation_running) {
                    return;
                }
                renegotiation_running = true;
            }
            for (int i = 0; i < 10; ++i) {
                try {
                    for (PollThread pt : pollThreads) {
                        pt.transportRequiresSecurityRenegotiation(this.problemSource);
                    }
                    break;
                }
                catch (Exception x) {
                    x.printStackTrace();
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    continue;
                }
            }
            Object object2 = renegotiate_LOCK;
            synchronized (object2) {
                renegotiation_running = false;
            }
        }
    }

    static class SecureMessengerHandler
    implements SecureMessengerListener {
        final SimpleGatewayID masterid;

        SecureMessengerHandler(SimpleGatewayID masterid) {
            this.masterid = masterid;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void incomingSecureMessage(SecureMessenger incomingSecmsg, String messengerID, Message message, Long respondConv, Object source) {
            int type;
            PollThread pt = (PollThread)source;
            SecureMessenger secresp = SecureMessengerDB.fetchSecureMessenger(messengerID);
            if (secresp != incomingSecmsg) {
                System.out.println("***WARNING responding secmsg is not same as incoming for " + messengerID);
            }
            if (CentralDebugging.SG_ALL_INCOMING_MESSAGES || CentralDebugging.RA_SHOW_READABLE_MESSAGES) {
                System.out.println("[Incoming Message] Incoming secmsg " + message.toPretty(PC.REFS));
            }
            if ((type = message.getType()) == 1589706756) {
                if (CentralDebugging.RA_SHOW_READABLE_MESSAGES) {
                    System.out.println("[Incoming Message] Request for basic info upload (we will upload basic info now)");
                }
                System.out.println("[Metadata Upload] Basic info requested from " + messengerID);
                if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                    DDLog.log(messengerID, "Basic info requested from " + messengerID + ", sending now");
                }
                Message m = SimpleGatewayService.createMessage(1589706757, this.masterid);
                m.append(config.getName());
                m.append(Version.getSsuiteFullBuildVersion());
                m.append(JWSystem.getAppBundleVersion());
                secresp.secureSendNoBlock(m);
                return;
            }
            if (message.getType() == 1589706807) {
                System.out.println("[SimpleGatewayService] Asked to perform a cross machine file transfer");
                TechClient techClient = null;
                try {
                    RAClient rafs;
                    final long transferID = message.getNextLong();
                    String string = message.getNextString();
                    String targetSgID = message.getNextString();
                    String shHost = message.getNextString();
                    int shPort = message.getNextInt();
                    String techUsername = message.getNextString();
                    byte[] techSessionToken = message.getNextByteArray();
                    Message paths = message.getNextMessage();
                    String folderPath = message.getNextString();
                    GFile folder = new GFile(folderPath, new File(folderPath).getName(), 0L, 0L, true, false);
                    System.out.println("[CrossCopy] Our SGID: " + string);
                    System.out.println("[CrossCopy] Target SGID: " + targetSgID);
                    System.out.println("[CrossCopy] SH Host: " + shHost);
                    System.out.println("[CrossCopy] SH Port: " + shPort);
                    System.out.println("[CrossCopy] Tech Username: " + techUsername);
                    System.out.println("[CrossCopy] Tech Token: " + techSessionToken);
                    System.out.println("[CrossCopy] Paths: " + paths.length());
                    System.out.println("[CrossCopy] Folder Path: " + folderPath);
                    System.out.println("[CrossCopy] Folder: " + folder);
                    TechCredentials creds = new TechCredentials(techUsername, null, techSessionToken);
                    System.out.println("[CrossCopy] Opening TC...");
                    techClient = new TechClient("en", (ResourceBundle)new TestResourceBundle(), shHost, shPort, creds, false, new TechClientAdapter());
                    System.out.println("[CrossCopy] TechClient ready, opening TC FS...");
                    AbstractTechFS fs = null;
                    try {
                        System.out.println("[CrossCopy] Trying to upgrade FS to to direct... (timeout: " + Switches.SH_maxTimeoutToGetDirectRAClientFS + ")");
                        rafs = techClient.getDirectRAClient(targetSgID, Switches.SH_maxTimeoutToGetDirectRAClientFS);
                        System.out.println("[FSPane] Upgraded FS to direct OK");
                        fs = rafs;
                    }
                    catch (Exception x) {
                        x.printStackTrace();
                    }
                    if (fs == null) {
                        try {
                            System.out.println("[FSPane] Trying to upgrade FS to to patched...");
                            rafs = techClient.getRAClient(targetSgID);
                            System.out.println("[FSPane] Upgraded FS to patched OK");
                            fs = rafs;
                        }
                        catch (Exception x) {
                            x.printStackTrace();
                        }
                    }
                    if (fs == null) {
                        System.out.println("[FSPane] Falling back to TC FS");
                        fs = new TechClientFS(techClient, targetSgID);
                    }
                    System.out.println("[CrossCopy] Remote FS ready, transferring...");
                    final TechClient progressTC = techClient;
                    try {
                        while (paths.hasNext()) {
                            String localPath = paths.getNextString();
                            System.out.println("[CrossCopy] Uploading " + localPath);
                            fs.uploadIntoDir(new File(localPath), folder, new FSProgress(){
                                long lastSend = 0L;
                                long totalTransferred = 0L;

                                @Override
                                public void transferredBytes(long bytes) throws IOException {
                                    this.totalTransferred += bytes;
                                    if (SafeClock.currentTimeMillis() - this.lastSend > 150L) {
                                        this.lastSend = SafeClock.currentTimeMillis();
                                        try {
                                            progressTC.sendCrossTransferProgress(transferID, this.totalTransferred);
                                            this.totalTransferred = 0L;
                                        }
                                        catch (Exception exception) {
                                            // empty catch block
                                        }
                                    }
                                }
                            });
                        }
                    }
                    finally {
                        System.out.println("[CrossCopy] Finished");
                        try {
                            progressTC.sendCrossTransferProgress(transferID, -1L);
                        }
                        catch (Exception localPath) {}
                    }
                    System.out.println("[CrossCopy] Cross machine transfer completed successfully");
                    return;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    return;
                }
                finally {
                    try {
                        techClient.disconnect("Cross machine file transfer finished");
                    }
                    catch (Exception transferID) {}
                }
            }
            if (type == 1589706789) {
                LossyTransport transport;
                boolean worked;
                if (CentralDebugging.RA_SHOW_READABLE_MESSAGES) {
                    System.out.println("[Incoming Message] Request to use fast transport (we will attempt to use HTTP(S) for 60s to facilitate a quicker download/upload)");
                }
                if (!(worked = SwitchableLossyTransport.trySwitchAlt(transport = pt.serverLossyTransport, 60000L))) return;
                System.out.println("[SimpleGatewayService] Using alternative transport (HTTP/HTTPS) for 60000ms to " + pt.udpOrHttpServerURL);
                return;
            }
            if (type == 1589706801) {
                if (CentralDebugging.RA_SHOW_READABLE_MESSAGES) {
                    System.out.println("[Incoming Message] A message destined for the SGExtension " + message);
                }
                System.out.println("[SimpleGatewayService] Received SGExtension message " + message);
                if (!SGExtensionUtil.loaded()) return;
                SGExtensionUtil.get().serviceIncomingMessage(message);
                return;
            }
            if (type == 1589706804) {
                if (CentralDebugging.RA_SHOW_READABLE_MESSAGES) {
                    System.out.println("[Incoming Message] Request to reboot the computer (we will now reboot)");
                }
                if (OS.isWindows()) {
                    RunCommandGetOutput.runCommand((String[])new String[]{"shutdown.exe", "/r", "/f", "/t", "0"});
                    return;
                } else if (OS.isMacOS()) {
                    RunCommandGetOutput.runCommand((String[])new String[]{"shutdown", "-r", "0"});
                    return;
                } else {
                    RunCommandGetOutput.runCommand((String[])new String[]{"shutdown", "-r", "0"});
                }
                return;
            }
            if (type == 1589706803) {
                if (CentralDebugging.RA_SHOW_READABLE_MESSAGES) {
                    System.out.println("[Incoming Message] Request to restart the RA service (we will now restart)");
                }
                try {
                    System.out.println("[SimpleGatewayService] ***** SERVICE RESTART REQUESTED (MU) *****");
                    JWSystem.forkVirtualApp((String)"Remote Access Restart");
                    return;
                }
                catch (Exception x) {
                    System.out.println("[SimpleGatewayService] Service restart FAILED: " + x);
                    x.printStackTrace();
                }
                return;
            }
            if (type == 1589706772) {
                Message response;
                if (CentralDebugging.RA_SHOW_READABLE_MESSAGES) {
                    System.out.println("[Incoming Message] Request to get logs (we will now respond with our logs)");
                }
                String password = message.getNextString();
                boolean passwordRequired = false;
                if (password == null && config.getPassword() != null) {
                    passwordRequired = true;
                }
                if (password != null && config.getPassword() != null && !password.equals(config.getPassword())) {
                    passwordRequired = true;
                }
                if (passwordRequired) {
                    response = new Message(1589706772);
                    response.append(true);
                } else {
                    File file = JWSystem.getAllAppLoggingFolder();
                    try {
                        ByteArrayOutputStream bout = new ByteArrayOutputStream();
                        ZipOutputStream out = new ZipOutputStream(bout);
                        File[] files = file.listFiles();
                        System.out.println("[GetLogs] Logs folder has " + (files != null ? Integer.valueOf(files.length) : "0") + " files");
                        if (files != null) {
                            for (File file2 : files) {
                                System.out.println("[GetLogs] Processing " + file2.getName());
                                if (!file2.getName().endsWith(".log") && !file2.getName().endsWith(".txt")) continue;
                                long length = file2.length();
                                long skipBytes = 0L;
                                if (length > 200000L) {
                                    skipBytes = length - 200000L;
                                }
                                System.out.println("[SimpleGatewayService] Request to fetch logs (file access)");
                                BufferedInputStream in = new BufferedInputStream(new FileInputStream(file2));
                                try {
                                    in.skip(skipBytes);
                                    out.putNextEntry(new ZipEntry(file2.getName()));
                                    StreamPiper.pipe((InputStream)in, (OutputStream)out, (boolean)false, (boolean)false, (boolean)false);
                                    out.closeEntry();
                                }
                                finally {
                                    FileUtil.robustClose((InputStream)in);
                                }
                            }
                        }
                        out.close();
                        System.out.println("[GetLogs] Returning " + bout.size() + " bytes of data");
                        response = new Message(1589706772);
                        response.append(false);
                        response.append(bout.toByteArray());
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        response = new Message(-286392320);
                    }
                }
                System.out.println("[GetLogs] Responding with logs message " + response);
                secresp.secureSendNoBlock(response, respondConv);
                return;
            }
            if (type == 1589706802) {
                if (CentralDebugging.RA_SHOW_READABLE_MESSAGES) {
                    System.out.println("[Incoming Message] Request to retry a refused update (we will now clear the refused updates folder)");
                }
                Message response = new Message(1589706802);
                try {
                    System.out.println("[SimpleGatewayService] Technician has asked us to clear the refused updates folder");
                    File appFolder = JWSystem.getAppFolder();
                    File refusedUpdatesFolder = new File(appFolder.getParentFile(), GenericUpdater.getRefusedUpdatesFolderName());
                    if (!refusedUpdatesFolder.exists()) return;
                    FileUtil.deleteDir((File)refusedUpdatesFolder);
                    return;
                }
                finally {
                    secresp.secureSendNoBlock(response, respondConv);
                }
            }
            if (type == 1589706761) {
                if (CentralDebugging.RA_SHOW_READABLE_MESSAGES) {
                    System.out.println("[Incoming Message] Request to set out config (we will now overwrite and reload our config)");
                }
                Message response = new Message(1589706761);
                String password = message.getNextString();
                boolean passwordRequired = false;
                if (password == null && config.getPassword() != null) {
                    passwordRequired = true;
                }
                if (password != null && config.getPassword() != null && !password.equals(config.getPassword())) {
                    passwordRequired = true;
                }
                byte[] byArray = message.getNextByteArray();
                if (passwordRequired) {
                    response.append(true);
                } else {
                    response.append(false);
                    System.out.println("[SimpleGatewayService] Request from server to store config (file access)");
                    File configFile = SimpleGatewayConfig.getConfigLocation();
                    Object out = config_LOCK;
                    synchronized (out) {
                        try {
                            FileOutputStream fout = new FileOutputStream(configFile);
                            try {
                                fout.write(byArray);
                                fout.flush();
                            }
                            finally {
                                try {
                                    fout.close();
                                }
                                catch (Exception techUsername) {}
                            }
                        }
                        catch (Throwable t) {
                            response = new Message(-286392320);
                            response.append(t.getMessage());
                            t.printStackTrace();
                        }
                        SimpleGatewayService.promptConfigReload();
                    }
                }
                secresp.secureSendNoBlock(response, respondConv);
                return;
            }
            if (type == 1589706791) {
                if (CentralDebugging.RA_SHOW_READABLE_MESSAGES) {
                    System.out.println("[Incoming Message] Genstore ticket (we have been awarded an upload ticket) [PX_GENSTORE_UPLOAD to see more]");
                }
                long sendDataFrom = message.getNextLong();
                if (CentralDebugging.PX_GENSTORE_UPLOAD) {
                    System.out.println("[GenStore] We have been awarded an upload ticket (from " + sendDataFrom + ")");
                }
                pt.processGenStoreTicket(sendDataFrom);
                return;
            }
            if (type == 1589706770) {
                if (CentralDebugging.RA_SHOW_READABLE_MESSAGES) {
                    System.out.println("[Incoming Message] Request to set our machine name (we will now modify our config)");
                }
                MachineName name = MachineName.fromMessage(message);
                System.out.println("[SimpleGatewayService] The server has notified us of a name change: " + name);
                config.setName(name.toString());
                File configFile = SimpleGatewayConfig.getConfigLocation();
                try {
                    config.save(configFile, true);
                    return;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return;
            }
            if (type == 1589706776) {
                String string;
                if (CentralDebugging.RA_SHOW_READABLE_MESSAGES) {
                    System.out.println("[Incoming Message] Request to migrate (we will now adjust our config)");
                }
                System.out.println("[SimpleGatewayService] Asked to migrate");
                Message madd = message.getNextMessage();
                Message mremove = message.getNextMessage();
                Message response = new Message(1589706776);
                secresp.secureSendNoBlock(response, respondConv);
                String string2 = "";
                String addURL = "";
                String publicKeyHashIGNORED = null;
                if (madd.length() > 0 && (addURL = madd.getNextString()).length() > 0) {
                    publicKeyHashIGNORED = madd.getNextString();
                    System.out.println("[SimpleGatewayService] Migrating to URL [" + addURL + "]");
                }
                if (mremove.length() > 0 && (string = mremove.getNextString()).length() > 0) {
                    System.out.println("[SimpleGatewayService] Migrating from URL [" + string + "]");
                }
                String[] rawURLs = config.getRawURLs();
                ArrayList<String> newURLs = new ArrayList<String>();
                boolean removed = false;
                boolean added = false;
                boolean existsAlready = false;
                for (String url : rawURLs) {
                    void var12_66;
                    if (url == null) continue;
                    if (!url.equals(var12_66)) {
                        System.out.println("[SimpleGatewayService] Keeping existing URL " + url);
                        newURLs.add(url);
                        if (!url.equals(addURL)) continue;
                        existsAlready = true;
                        continue;
                    }
                    System.out.println("[SimpleGatewayService] Removing existing URL " + url);
                    SecureMessengerDB.clearSecureMessenger(url, "cleared any secmsg for newly added URL");
                    hashRepository.removeURL(url);
                    removed = true;
                    config.removeUrlHashes(url);
                }
                if (!existsAlready && addURL.length() > 0) {
                    System.out.println("[SimpleGatewayService] Adding new URL " + addURL);
                    SecureMessengerDB.clearSecureMessenger(addURL, "cleared any secmsg for newly added URL");
                    newURLs.add(addURL);
                } else {
                    System.out.println("[SimpleGatewayService] No need to add new URL " + addURL + " since it is already in the list");
                }
                String[] tmp = newURLs.toArray(new String[0]);
                config.setURLs(tmp);
                System.out.println("[SimpleGatewayService] Saving migrated config");
                File configFile = SimpleGatewayConfig.getConfigLocation();
                try {
                    config.save(configFile, true);
                    return;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return;
            }
            if (type == 1589706760) {
                if (CentralDebugging.RA_SHOW_READABLE_MESSAGES) {
                    System.out.println("[Incoming Message] Request to get our config (we will now ");
                }
                Message response = new Message(1589706760);
                String password = message.getNextString();
                boolean passwordRequired = false;
                if (password == null && config.getPassword() != null) {
                    passwordRequired = true;
                }
                if (password != null && config.getPassword() != null && !password.equals(config.getPassword())) {
                    passwordRequired = true;
                }
                if (passwordRequired) {
                    response.append(true);
                } else {
                    response.append(false);
                    try {
                        response.append(config.save(false));
                    }
                    catch (Throwable throwable) {
                        throwable.printStackTrace();
                    }
                }
                secresp.secureSendNoBlock(response, respondConv);
                return;
            }
            if (type == 1589706758) {
                if (CentralDebugging.RA_SHOW_READABLE_MESSAGES) {
                    System.out.println("[Incoming Message] Request to set monitoring explicitly on/off (note alerts or other mechanisms may have already enabled it)");
                }
                boolean on = message.getNextBoolean();
                if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                    if (on) {
                        DDLog.log(messengerID, "Monitoring requested to be turned ON");
                    } else {
                        DDLog.log(messengerID, "Monitoring requested to be turned OFF");
                    }
                }
                try {
                    Object password = monitoringSwitch_LOCK;
                    synchronized (password) {
                        System.out.println("[Monitoring] Monitoring requested to be switched " + (on ? "On" : "Off"));
                        isMonitoring = on;
                        SimpleGatewayService.updateMonitoringAppStatus();
                        System.out.println("[Monitoring] Monitoring state switched " + (isMonitoring ? "On" : "Off"));
                        System.out.println("[Monitoring] Monitoring allowed? " + config.allowMonitoring);
                        SimpleGatewayService.saveMonitoringState();
                    }
                    SimpleGatewayService.updateGlobalEvents();
                    return;
                }
                catch (Exception x) {
                    System.out.println("[Metadata Upload] Failed to set monitoring to " + on);
                    x.printStackTrace();
                }
                return;
            }
            if (type == 1589706788) {
                if (CentralDebugging.RA_SHOW_READABLE_MESSAGES) {
                    System.out.println("[Incoming Message] Request to show a notification popup to the user");
                }
                String title = message.getNextString();
                String content = message.getNextString();
                System.out.println("[PopupNotify] Notification requested by server " + messengerID + ":\n    " + title + "\n    " + content);
                SimpleGatewayService.setShowingPopupsFlag();
                System.out.println("[PopupNotify] Starting monitoring process if necessary");
                Object passwordRequired = monitoringSwitch_LOCK;
                synchronized (passwordRequired) {
                    SimpleGatewayService.updateMonitoringAppStatus();
                }
                System.out.println("[PopupNotify] Requesting popup");
                monitoring.requestPopup(title, content);
                return;
            }
            if (type == 1589706785) {
                Object url;
                if (CentralDebugging.RA_SHOW_READABLE_MESSAGES) {
                    System.out.println("[Incoming Message] Request to dump state (done before fetching logs)");
                }
                System.out.println("[StateDump] State dump requested by server " + messengerID + ", will dump then propagate to monitoring");
                try {
                    Iterator<String> title = hashRepository.iterator();
                    while (title.hasNext()) {
                        String hash = title.next();
                        System.out.println("[StateDump] Trusted pkhash: " + hash);
                    }
                    Iterator<String> urls = hashRepository.urlKeyIterator();
                    while (urls.hasNext()) {
                        url = urls.next();
                        System.out.println("[StateDump] Pinned URL: " + (String)url);
                    }
                    System.out.println("[StateDump] Recovery allowed: " + config.getAllowRecovery());
                    System.out.println("[StateDump]");
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                AlertRegistry alertRegistry = SimpleGatewayService.getAlertRegistry(messengerID);
                url = alertRegistry.getMapLOCK();
                synchronized (url) {
                    ArrayList<ResourceContainer> all = alertRegistry.getAll();
                    for (ResourceContainer res : all) {
                        if (res instanceof LocatedAlert) {
                            Alert alert = ((LocatedAlert)res).getAlert();
                            System.out.println("[StateDump] " + alert);
                            continue;
                        }
                        System.out.println("[StateDump] " + res);
                    }
                }
                url = alertRegs_LOCK;
                synchronized (url) {
                    String[] keys;
                    for (String key : keys = alertRegs.keySet().toArray(new String[0])) {
                        alertRegistry = (AlertRegistry)alertRegs.get(key);
                        if (key.equals(messengerID)) continue;
                        System.out.println("[StateDump] Listing alerts from server " + key + ":");
                        Object newURLs = alertRegistry.getMapLOCK();
                        synchronized (newURLs) {
                            ArrayList<ResourceContainer> all = alertRegistry.getAll();
                            for (ResourceContainer res : all) {
                                if (res instanceof LocatedAlert) {
                                    Alert alert = ((LocatedAlert)res).getAlert();
                                    System.out.println("[StateDump] " + alert);
                                    continue;
                                }
                                System.out.println("[StateDump] " + res);
                            }
                        }
                    }
                }
                if (monitoring.isOn()) {
                    System.out.println("[StateDump] Requesting state dump from monitoring process");
                    monitoring.requestStateDump();
                } else {
                    System.out.println("[StateDump] Unable to request state dump from monitoring process, monitoring is not currently on");
                }
                Message response = new Message(1589706785);
                response.append(true);
                secresp.secureSendNoBlock(response, respondConv);
                return;
            }
            if (type == 1589706784) {
                if (CentralDebugging.RA_SHOW_READABLE_MESSAGES) {
                    System.out.println("[Incoming Message] Request to see if the windows console session has changed");
                }
                if (OS.isWindows7OrAbove()) {
                    int sessionID = message.getNextInt();
                    System.out.println("[RaConsoleCheck] Asked to check console vs " + sessionID);
                    Message response = new Message(1589706784);
                    boolean responseSent = false;
                    try {
                        void var12_71;
                        boolean bl = false;
                        while (var12_71 < 30 && !responseSent) {
                            if (sessionID != JWNativeAPI.getInstance().getTsConsoleSessionId()) {
                                response.append(true);
                                responseSent = true;
                                secresp.secureSendNoBlock(response, respondConv);
                            }
                            Thread.sleep(1000L);
                            ++var12_71;
                        }
                    }
                    catch (Throwable throwable) {
                        System.out.println("[RaConsoleCheck] Error occurred checking for console ID change: " + throwable);
                        throwable.printStackTrace();
                    }
                    if (responseSent) return;
                    response.append(false);
                    secresp.secureSendNoBlock(response, respondConv);
                    return;
                }
                System.out.println("[RaConsoleCheck] Asked to check console but we are not on Win7 or later");
                return;
            }
            if (type == 1589706769) {
                if (CentralDebugging.RA_SHOW_READABLE_MESSAGES) {
                    System.out.println("[Incoming Message] Request to issue a Wake On LAN request to another computer");
                }
                DatagramSocket ds = null;
                try {
                    ds = new DatagramSocket();
                    for (int i = 0; i < message.length(); i += 2) {
                        byte[] ip = message.getNextByteArray();
                        byte[] byArray = message.getNextByteArray();
                        try {
                            WakeOnLan.doWOL(ds, ip, byArray);
                            continue;
                        }
                        catch (Throwable x) {
                            x.printStackTrace();
                        }
                    }
                    return;
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    return;
                }
                finally {
                    try {
                        if (ds != null) {
                            ds.close();
                        }
                    }
                    catch (Exception i) {}
                }
            }
            if (type == 1589706786) {
                void var12_76;
                if (CentralDebugging.RA_SHOW_READABLE_MESSAGES) {
                    System.out.println("[Incoming Message] Issued our proper alert structure by the server (we will modify ours to match)");
                }
                if (SGExtensionUtil.loaded() && !SGExtensionUtil.get().supportsMonitoring()) {
                    return;
                }
                HashMap<String, String> idsmap = new HashMap<String, String>();
                ArrayList<String> ids = new ArrayList<String>();
                while (message.hasNext()) {
                    String alertID = Alert.longToAlertID(message.getNextLong());
                    ids.add(alertID);
                    idsmap.put(alertID, alertID);
                }
                if (CentralDebugging.SG_ALERTS) {
                    System.out.println("[Alerts] Alert structure sent by " + messengerID + ", " + ids.size() + " alerts in total");
                }
                boolean modified = false;
                ArrayList arrayList = new ArrayList();
                AlertRegistry alertRegistry = SimpleGatewayService.getAlertRegistry(messengerID);
                Object alert = alertRegistry.getMapLOCK();
                synchronized (alert) {
                    ArrayList<ResourceContainer> list = alertRegistry.getAll();
                    for (ResourceContainer res : list) {
                        String haveID = res.getID();
                        if (idsmap.containsKey(haveID)) continue;
                        System.out.println("[Alerts] We have alert " + haveID + " (" + res.getName() + ") but shouldn't, deleting");
                        alertRegistry.remove(res);
                        if (alertRegistry.size() == 0) {
                            alertRegistry.getClock().setGlobalClock(AlertRegistry.CLOCK_EMPTY);
                        }
                        modified = true;
                    }
                    for (String id : ids) {
                        if (alertRegistry.get(id) != null) continue;
                        System.out.println("[Alerts] We are missing alert " + id + ", need to reset entire registry and fetch");
                        alertRegistry.getClock().setGlobalClock(AlertRegistry.CLOCK_RESET);
                        modified = true;
                        break;
                    }
                    if (modified) {
                        ArrayList<ResourceContainer> arrayList2 = alertRegistry.getAll();
                    }
                }
                if (!modified) return;
                long clock = alertRegistry.getClock().getCurrentClock();
                long hash = SimpleGatewayService.buildAlertsHash((ArrayList)var12_76);
                System.out.println("[Alerts] Modified by alert structure update, sending clock update, clock=" + clock + ", hash=" + hash);
                Message msg = SimpleGatewayService.createMessage(1589706778, this.masterid);
                msg.append(clock);
                msg.append(hash);
                secresp.secureSendNoBlock(msg, respondConv);
                alertRegistry.scheduleSaveInTenSeconds();
                SimpleGatewayService.updateGlobalEvents();
                return;
            }
            if (type == 1589706787) {
                if (CentralDebugging.RA_SHOW_READABLE_MESSAGES) {
                    System.out.println("[Incoming Message] Request to reset our entire alert registry");
                }
                if (CentralDebugging.SG_ALERTS) {
                    System.out.println("[Alerts] Asked to reset entire alert registry by " + messengerID);
                }
                AlertRegistry alertRegistry = SimpleGatewayService.getAlertRegistry(messengerID);
                Object ids = alertRegistry.getMapLOCK();
                synchronized (ids) {
                    alertRegistry.getClock().setGlobalClock(AlertRegistry.CLOCK_RESET);
                    return;
                }
            }
            if (type == 1589706777) {
                ArrayList<ResourceContainer> all;
                if (CentralDebugging.RA_SHOW_READABLE_MESSAGES) {
                    System.out.println("[Incoming Message] Request to update our alert config (data has changed within our alerts)");
                }
                if (SGExtensionUtil.loaded() && !SGExtensionUtil.get().supportsMonitoring()) {
                    return;
                }
                boolean fullList = message.getNextBoolean();
                long alertsModClock = message.getNextLong();
                long l = message.getNextLong();
                Message reserved = message.getNextMessage();
                if (CentralDebugging.SG_ALERTS) {
                    System.out.println("[Alerts] Received update from " + messengerID + ": fullList=" + fullList + ", serverAlertModClock=" + alertsModClock + ", fullHash=" + l + " msgLen=" + message.length());
                }
                AlertRegistry alertRegistry = SimpleGatewayService.getAlertRegistry(messengerID);
                Object id = alertRegistry.getMapLOCK();
                synchronized (id) {
                    if (fullList) {
                        alertRegistry.clearAll();
                    }
                    while (message.hasNext()) {
                        try {
                            Alert alert = ResourceSerialiser.alertFromMessage(message.getNextMessage());
                            if (CentralDebugging.SG_ALERTS) {
                                System.out.println("[Alerts] Updating alert " + alert.getName() + " (" + alert.getID() + ") to " + alert.getModifiedClock());
                                System.out.println("[Alerts] " + alert);
                            }
                            alertRegistry.add(new LocatedAlert(alert, new AllMachinesAloc()));
                        }
                        catch (Exception x) {
                            x.printStackTrace();
                        }
                    }
                    alertRegistry.getClock().setGlobalClock(alertsModClock);
                    all = alertRegistry.getAll();
                    if (CentralDebugging.SG_ALERTS) {
                        System.out.println("[Alerts] " + all.size() + " total alerts");
                    }
                    pt.alertsMap = SimpleGatewayService.getOwnedAlertsForRegistry(all);
                }
                if (CentralDebugging.SG_ALERTS) {
                    System.out.println("[Alerts] AlertRegistry clock is " + alertRegistry.getClock().getCurrentClock());
                }
                long hash = SimpleGatewayService.buildAlertsHash(all);
                if (CentralDebugging.SG_ALERTS) {
                    System.out.println("[Alerts] Our full alert registry hash is " + hash + ", server registry hash is " + l);
                }
                if (hash != l) {
                    if (fullList) {
                        System.out.println("[Alerts] ***Warning: received full alert list but hash did not match");
                    }
                    if (CentralDebugging.SG_ALERTS) {
                        System.out.println("[Alerts] List doesn't match up with server, will request full list and set AlertRegistry global clock to zero");
                    }
                    alertRegistry.getClock().setGlobalClock(AlertRegistry.CLOCK_RESET);
                } else if (CentralDebugging.SG_ALERTS) {
                    System.out.println("[Alerts] Alert list verified OK");
                }
                if (CentralDebugging.SG_ALERTS) {
                    System.out.println("[Alerts] Marking AlertRegistry for saving, sending mod clock to server, alerts to monitoring");
                }
                alertRegistry.scheduleSaveInTenSeconds();
                Message clock = SimpleGatewayService.createMessage(1589706778, this.masterid);
                clock.append(alertRegistry.getClock().getCurrentClock());
                clock.append(hash);
                secresp.secureSendNoBlock(clock, respondConv);
                SimpleGatewayService.updateGlobalEvents();
                return;
            }
            if (type > 1589723136 && type < 1589727231) {
                Message response;
                if (CentralDebugging.RA_SHOW_READABLE_MESSAGES) {
                    System.out.println("[Incoming Message] MUpload file transfer message");
                }
                if (Switches.SH_allowLossyTransportSwitchingInRa && (type == 1589723157 || type == 1589723158) && SwitchableLossyTransport.trySwitchAlt(pt.serverLossyTransport, 60000L)) {
                    System.out.println("[SimpleGatewayService] Temporarily switched to alternate transport for file operations");
                }
                if ((response = remoteFSMessageHandler.handle(message, null)) == null) return;
                secresp.secureSendNoBlock(response, respondConv);
                return;
            }
            if (type == 1589727270) {
                if (CentralDebugging.RA_SHOW_READABLE_MESSAGES) {
                    System.out.println("[Incoming Message] Request for a ProxyServer patched MachineStream (remote side wishes to connect to perform high speed interactions)");
                }
                try {
                    int patchID = message.getNextInt();
                    String salt = message.getNextString();
                    String secret = message.getNextString();
                    URLParser uRLParser = new URLParser(pt.udpOrHttpServerURL);
                    String host = uRLParser.getHostname();
                    int port = uRLParser.getPort(true);
                    System.out.println("[MachineStream] Getting connection");
                    SHelpNodelinkPatcher patcher = SHelpNodelinkPatcher.establishConnection(host, port);
                    PatchSync psync = new PatchSync(patchID);
                    Lock hash = patchLOCK;
                    synchronized (hash) {
                        patchCache.addToCache((Object)patchID, (Object)psync);
                    }
                    System.out.println("[MachineStream] Patching " + patchID);
                    NodeLink direct = patcher.finishPatch(false, patchID, null, psync, new Node(), true);
                    direct.setFriendlyName("PatchedMachineStream");
                    System.out.println("[MachineStream] Got patched connection, creating MachineStream");
                    BCUtil bcu = new BCUtil();
                    bcu.initFromSecret(salt, secret, 1);
                    BCUtilOutputStream bcout = new BCUtilOutputStream(direct.getOutputStream(), bcu);
                    BCUtilInputStream bcin = new BCUtilInputStream(direct.getInputStream(), bcu);
                    FastMxInputStream xin = new FastMxInputStream((InputStream)bcin, "TechClientMachineStream");
                    FastMxOutputStream xout = new FastMxOutputStream((OutputStream)bcout);
                    MachineStream ms = new MachineStream(direct, xin, xout);
                    SimpleGatewayService.handleMachineStream(direct, ms, pt);
                    return;
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
                return;
            }
            if (type == 1589727272) {
                if (CentralDebugging.RA_SHOW_READABLE_MESSAGES) {
                    System.out.println("[Incoming Message] MachineStream synchronisation notification (two sides will be patched now)");
                }
                int patchID = message.getNextInt();
                Lock salt = patchLOCK;
                synchronized (salt) {
                    System.out.println("[MachineStream] Signalling sync for " + patchID);
                    PatchSync psync = (PatchSync)patchCache.getFromCache((Object)patchID);
                    psync.doSyncNow();
                }
                Message resp = new Message(1589727272);
                secresp.secureSendNoBlock(resp, respondConv);
                return;
            }
            if (type == 1589727271) {
                if (CentralDebugging.RA_SHOW_READABLE_MESSAGES) {
                    System.out.println("[Incoming Message] Request for a Direct (not ProxyServer patched) MachineStream (remote side wishes to connect to perform high speed interactions)");
                }
                Message hosts = message.getNextMessage();
                int port = message.getNextInt();
                String salt = message.getNextString();
                String string = message.getNextString();
                try {
                    P2PSock p2p = new P2PSock();
                    int PORT = P2PSock.PORT_RA_P2P;
                    try {
                        PORT = p2p.listenOn(PORT, PORT + P2PSock.SCAN_LIMIT);
                    }
                    catch (Exception patcher) {
                        // empty catch block
                    }
                    Message resp = new Message(1589727271);
                    resp.append(P2PSock.getMyHostsList());
                    resp.append(PORT);
                    secresp.secureSendNoBlock(resp, respondConv);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (Exception psync) {
                        // empty catch block
                    }
                    p2p.connect(hosts, port, 30000L);
                    BCUtil bcu = new BCUtil();
                    bcu.initFromSecret(salt, string, 1);
                    if (Switches.SHFTP_noEncryptionOnLocalTransfers) {
                        System.out.println("[P2PSock] Switching to parallel encrypted NL for direct MachineStream");
                        boolean local = p2p.isLocal();
                        System.out.println("[P2PSock] Local: " + local);
                        InputStream in = p2p.getRawSocket().getInputStream();
                        local = StreamUtils.readBoolean(in);
                        if (local) {
                            System.out.println("[P2PSock] Type: Multiplexed Socket");
                            p2p.multiplexSock();
                            MachineStream ms = new MachineStream(p2p.getRawSocket(), p2p.getSecureXin(), p2p.getSecureXout());
                            SimpleGatewayService.handleMachineStream(p2p.getRawNL(), ms, pt);
                            return;
                        } else {
                            System.out.println("[P2PSock] Type: Parallel Secure NL");
                            BCUtil.removeCpuBounding();
                            p2p.switchToSecureParallelNL(bcu);
                            MachineStream ms = new MachineStream(p2p.getRawNL(), p2p.getSecureXin(), p2p.getSecureXout());
                            SimpleGatewayService.handleMachineStream(p2p.getRawNL(), ms, pt);
                        }
                        return;
                    }
                    p2p.switchToSecureNL(bcu);
                    MachineStream ms = new MachineStream(p2p.getRawNL(), p2p.getSecureXin(), p2p.getSecureXout());
                    SimpleGatewayService.handleMachineStream(p2p.getRawNL(), ms, pt);
                    return;
                }
                catch (Exception x) {
                    System.out.println("[SimpleGatewayService] P2PSock tech connection failed");
                }
                return;
            }
            if (type == 1589727273) {
                if (CentralDebugging.RA_SHOW_READABLE_MESSAGES) {
                    System.out.println("[Incoming Message] Request to cancel a Tool run");
                }
                monitoring.forwardRequest(message);
                return;
            }
            if (type == 1589727253) {
                if (CentralDebugging.RA_SHOW_READABLE_MESSAGES) {
                    System.out.println("[Incoming Message] Request to run a Tool");
                }
                message.append(pt.serverAddress);
                System.out.println("[SimpleGatewayService] Received run tool proxy message. Starting up handler if required.");
                SimpleGatewayService.forceMonitoringOnForRun();
                SimpleGatewayService.updateMonitoringAppStatus();
                if (CentralDebugging.MONAPI_SHOW_FORWARDING) {
                    System.out.println("[Metadata Upload] Forwarding run-tool " + message.toPretty(PC.REFS));
                }
                System.out.println("[SimpleGatewayService] Forwarding to handler");
                monitoring.forwardRequest(message);
                return;
            }
            if (type == 1589706780) {
                if (CentralDebugging.RA_SHOW_READABLE_MESSAGES) {
                    System.out.println("[Incoming Message] Run respond");
                }
                message.append(messengerID);
                message.append(pt.serverAddress);
                SimpleGatewayService.forceMonitoringOnForRun();
                SimpleGatewayService.updateMonitoringAppStatus();
                if (CentralDebugging.MONAPI_SHOW_FORWARDING) {
                    System.out.println("[Metadata Upload] Forwarding run-respond " + message.toPretty(PC.REFS));
                }
                monitoring.forwardRequest(message);
                return;
            }
            if (type <= 1589727232 || type >= 1589735424) return;
            if (CentralDebugging.RA_SHOW_READABLE_MESSAGES) {
                System.out.println("[Incoming Message] Monitoring message (will be forwarded to the monitoring process)");
            }
            if (isMonitoring) {
                if (!monitoring.isOn()) {
                    Object object = monitoringSwitch_LOCK;
                    synchronized (object) {
                        SimpleGatewayService.updateMonitoringAppStatus();
                    }
                    SimpleGatewayService.updateGlobalEvents();
                }
                if (!monitoring.isOn()) return;
                if (CentralDebugging.MONAPI_SHOW_FORWARDING) {
                    System.out.println("[Metadata Upload] Forwarding " + message.toPretty(PC.REFS));
                }
                monitoring.forwardRequest(message);
                return;
            }
            System.out.println("[Metadata Upload] Discarding request to forward monitoring message");
        }
    }

    private static class MonitoringBroadcast
    implements MonitoringBroadcastListener {
        private MonitoringBroadcast() {
        }

        @Override
        public void broadcast(Message msg) {
            try {
                if (msg.getType() == 1589727269) {
                    System.out.println("[Monitoring] Monitoring process requested a restart");
                    monitoring.setOn(config, false, broadcast);
                    SimpleGatewayService.updateMonitoringAppStatus();
                } else if (msg.getType() == 1589706800) {
                    Message gsmessage = msg.getNextMessage();
                    ServiceGenStore.INSTANCE.sendBulkData(gsmessage);
                } else if (msg.getType() == 1589727268) {
                    System.out.println("[Monitoring] All popups have been dismissed, resetting popup count in RA service");
                    amShowingPopups = false;
                    SimpleGatewayService.updateMonitoringAppStatus();
                } else if (msg.getType() == 1589706781) {
                    String messengerID = (String)msg.pop();
                    Message authed = SimpleGatewayService.createMessage(msg.getType(), masteridStatic);
                    authed.append(msg);
                    System.out.println("[Monitoring] Broadcasting run response to " + messengerID + ", " + msg.toPretty(PC.REFS));
                    SecureMessengerDB.fetchSecureMessenger(messengerID).secureSend(authed);
                } else {
                    Message authed = SimpleGatewayService.createMessage(msg.getType(), masteridStatic);
                    authed.appendAll(msg);
                    if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                        DDLog.log(config, "Broadcasting monitored info " + msg);
                    }
                    System.out.println("[Monitoring] Broadcasting monitored info " + msg.toPretty(PC.REFS));
                    String alertID = null;
                    boolean mute = false;
                    boolean isAlertMessage = msg.getType() >= 1589731348 && msg.getType() <= 1589732608;
                    boolean sendUsingGenStore = false;
                    if (msg.getType() == 1589731350 || msg.getType() == 1589731351) {
                        alertID = msg.getAsString(0);
                        isAlertMessage = true;
                        sendUsingGenStore = true;
                    }
                    if (isAlertMessage) {
                        if (!config.allowScripting) {
                            System.out.println("[Monitoring] Muting (dropping) broadcast alert info due to scripting permissions " + msg);
                            mute = true;
                        }
                    } else if (!config.allowMonitoring) {
                        System.out.println("[Monitoring] Muting (dropping) broadcast monitoring info due to monitoring permissions " + msg);
                        mute = true;
                    }
                    if (!mute) {
                        for (PollThread pt : pollThreads) {
                            boolean alertMatched = false;
                            if (alertID == null) {
                                alertMatched = true;
                            } else if (pt.hasAlert(alertID)) {
                                alertMatched = true;
                            }
                            if (!alertMatched) continue;
                            if (sendUsingGenStore && Switches.SH_alertTriggerResetViaGenstore) {
                                StorePacket packet = new StorePacket(authed);
                                pt.genStore.addPacket(packet);
                                continue;
                            }
                            pt.broadcastPool.runAsync(new ServerBroadcast(pt, authed));
                        }
                    }
                }
            }
            catch (Exception x) {
                if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                    DDLog.log(masteridStatic, "Failed to broadcast monitored info " + x);
                }
                x.printStackTrace();
            }
        }
    }

    private static class ExtensionAPI
    implements SGExtensionAPI {
        private ExtensionAPI() {
        }

        @Override
        public void broadcast(Message msg) {
            Message authed = SimpleGatewayService.createMessage(msg.getType(), masteridStatic);
            authed.appendAll(msg);
            for (PollThread pt : pollThreads) {
                System.out.println("[SGExtensionAPI] Broadcasting authed version of " + msg + " to " + pt.udpOrHttpServerURL);
                pt.broadcastPool.runAsync(new ServerBroadcast(pt, authed));
            }
        }
    }

    static class ServerBroadcast
    implements Runnable {
        final PollThread pt;
        final Message authed;

        ServerBroadcast(PollThread pt, Message authed) {
            this.pt = pt;
            this.authed = authed;
        }

        @Override
        public void run() {
            SecureMessenger sm;
            String secmsg = this.pt.getServerSecMsgID();
            if (secmsg != null && (sm = SecureMessengerDB.fetchSecureMessenger(secmsg)) != null) {
                if (CentralDebugging.SG_TIME_BROADCASTS) {
                    long T = SafeClock.currentTimeMillis();
                    sm.secureSend(this.authed);
                    T = SafeClock.currentTimeMillis() - T;
                    System.out.println("[SG broadcast timing] " + T + "ms for " + this.authed);
                } else {
                    sm.secureSend(this.authed);
                }
            }
        }
    }

    private static class SGEventListener
    implements NativeEventUtil.NativeEventListener {
        private SGEventListener() {
        }

        @Override
        public void sessionDeactivated() {
            if (OS.isMacOS()) {
                SimpleGatewayService.sleepService();
            }
        }

        @Override
        public void sessionActivated() {
            if (OS.isMacOS()) {
                SimpleGatewayService.awakeService();
            }
        }

        @Override
        public void powerOrLogoff() {
            System.out.println("[SimpleGatewayService] Event: power or log off");
            for (PollThread pt : pollThreads) {
                pt.sendShutdownNotify();
            }
        }

        @Override
        public void willSleep() {
            System.out.println("[SimpleGatewayService] Event: sleep");
            for (PollThread pt : pollThreads) {
                pt.sendShutdownNotify();
            }
        }

        @Override
        public void didWake() {
        }
    }

    static class WaitThenPreload
    extends Thread {
        final int[] ms;
        final String vapp;
        final String staticUpdateURL;
        final Properties props;
        final String[] cmdlineArgs;
        final boolean elevate;
        final boolean checkUpdate;
        final String serverBuild;
        final String jwRaVersion;

        WaitThenPreload(int[] ms, String jwRaVersion, String serverBuild, String vapp, String staticUpdateURL, Properties props, String[] cmdlineArgs, boolean elevate, boolean checkUpdate) {
            this.ms = ms;
            this.serverBuild = serverBuild;
            this.jwRaVersion = jwRaVersion;
            this.vapp = vapp;
            this.staticUpdateURL = staticUpdateURL;
            this.props = props;
            this.cmdlineArgs = cmdlineArgs;
            this.elevate = elevate;
            this.checkUpdate = checkUpdate;
        }

        @Override
        public void run() {
            try {
                if (Switches.SH_1568_noPreloadActivityRestartSessions) {
                    System.out.println("[SGPreload] Checking app properties are for a standard remote session...");
                    String sessionID = (String)this.props.get("AutomaticCustomerID");
                    if (sessionID != null && sessionID.startsWith("ACTIVITY_")) {
                        System.out.println("[SGPreload] This is an activity session, will not preload");
                        return;
                    }
                }
                if (Switches.SH_XXXX_noPreloadRaServiceAtAll) {
                    System.out.println("[SGPreload] Will not preload, returning");
                    return;
                }
                System.out.println("[SGPreload] Will wait " + this.ms[0] + " before starting preload");
                Thread.sleep(this.ms[0]);
                this.props.setProperty("launch_expect_appname", "Remote Access Session");
                this.props.setProperty("launch_expect_appversion", this.jwRaVersion);
                JWSystem.prepareForkVirtualApp((String)"Remote Access Session", (String)"D", (Properties)this.props, (String[])new String[0], (boolean)false, (boolean)true);
                System.out.println("[SGPreload] Updated preload version is " + this.jwRaVersion);
            }
            catch (Throwable t) {
                JWSystem.clearPreparedFork();
            }
        }
    }

    static class TellServerUpdating
    extends Thread {
        final SecureMessenger secmsg;

        TellServerUpdating(SecureMessenger secmsg) {
            this.secmsg = secmsg;
        }

        @Override
        public void run() {
            if (this.secmsg != null) {
                System.out.println("[SGLaunch] Messaging server to let it know we are updating");
                try {
                    Message m = SimpleGatewayService.createMessage(1589706783, masteridStatic);
                    this.secmsg.secureSend(m);
                }
                catch (Throwable t) {
                    System.out.println("[SGLaunch] Unable to message server to let it know we are updating (" + t + ")");
                    t.printStackTrace();
                }
            } else {
                System.out.println("[SGLaunch] Unable to message server to let it know we are updating (secmsg is null)");
            }
        }
    }

    static class PollThread
    extends Thread
    implements UDPListener {
        final ThreadPool broadcastPool = new ThreadPool("PollBroadcast", 2, 3, 5);
        final GenStore genStore;
        SimpleGatewayService parent;
        final SimpleGatewayID masterid;
        boolean iAmObsolete = false;
        private MachineInUseMonitor inUseMonitor;
        private final String udpOrHttpServerURL;
        private UDPClient udpClient;
        private String udpaddr;
        private String serverAddress;
        private String hostnameOfServerAddress;
        private boolean isHTTPS = false;
        private String ipServerAddress;
        private String serverVersion = null;
        final HashMap<String, Long> timestamps = new HashMap();
        private long httpMillisSleep = 5000L;
        private boolean immediatePingNextTime = false;
        private boolean mustSendBasicInfo = false;
        private boolean mustUploadMonitoringSettings = false;
        private long lastUploadMonitoringSettings = 0L;
        private String previousUsername = null;
        private Message previousHostname = null;
        private Message previousOS = null;
        private Message previousHardware = null;
        private long nextSslVerificationAttempt = 0L;
        private String lastPkhashMatch = null;
        private String lastPkhashMatchPortion = null;
        private HashMap<String, String> alertsMap;
        final Stopwatch min15 = new Stopwatch(15.0);
        JWWindowsOS.RDPSessionInfo[] previousRDPSessions = null;
        long lastExecutedPoll;
        LossyTransport serverLossyTransport;
        SecureMessenger secmsg;
        boolean triedToLoad = false;
        final long SM_SETUP_STDWAIT = 120000L;
        final long SM_SETUP_RANDOM = 120000L;
        long nextSmSetup = 0L;
        boolean rttMeasured = false;
        long latestRTT = 500L;
        final Object secMsgSetup_LOCK = new Object();
        final Object claims_LOCK = new Object();
        final ArrayList<ClaimThread> claims = new ArrayList();
        long lastResolutionTime = 0L;
        final Object udpPing_LOCK = new Object();
        int noopCount = 0;
        long lastOp = 0L;
        final Object gsTestData_LOCK = new Object();
        int gsTestDataIndex = 0;
        long nextPacketCreate = 0L;
        boolean testKillHttpOnce = false;
        private final Object PING_SLEEP_LOCK = new Object();
        private Long serverInstance;
        long lastDNSLookup = 0L;

        public int totalAlerts() {
            return this.alertsMap.size();
        }

        boolean hasAlert(String ID) {
            return this.alertsMap.containsKey(ID);
        }

        void sendMonitoringSettingsOnNextValidate() {
            this.mustUploadMonitoringSettings = true;
        }

        boolean mayTalkToServer() {
            if (!Switches.SH_2235_pollThreadMustClaimServer) {
                return true;
            }
            if (this.serverInstance == null) {
                return true;
            }
            return serverClaim.requestAccessTo(this.udpOrHttpServerURL, this.serverInstance);
        }

        void processGenStoreTicket(long sendDataFrom) {
            if (this.mayTalkToServer()) {
                ArrayList<DataBlock> blocks = this.genStore.getBlocksFrom(sendDataFrom, Switches.SH_raGenStoreBytesPerUpload);
                if (CentralDebugging.PX_GENSTORE_UPLOAD) {
                    System.out.println("[GenStore] " + blocks.size() + " data blocks to upload from " + sendDataFrom + " (PT " + this.hashCode() + " / " + this.udpOrHttpServerURL + ")");
                }
                if (blocks.size() > 0) {
                    try {
                        if (Switches.SH_raGenStoreSendAsLargeGuaranteed) {
                            Message m = SimpleGatewayService.createMessage(1589706793, this.masterid);
                            for (DataBlock block : blocks) {
                                m.append(BestCaseCompressor.compress((byte[])block.toBytes()));
                            }
                            this.secmsg.secureSend(m);
                        } else {
                            for (DataBlock block : blocks) {
                                Message m = SimpleGatewayService.createMessage(1589706793, this.masterid);
                                m.append(BestCaseCompressor.compress((byte[])block.toBytes()));
                                this.secmsg.secureSend(m);
                            }
                        }
                    }
                    catch (IOException x) {
                        x.printStackTrace();
                    }
                }
            }
        }

        void sendBasicInfoOnNextValidate(boolean sendNowToo, String nameFromConfig) {
            this.mustSendBasicInfo = true;
            if (sendNowToo) {
                try {
                    this.sendBasicInfo(nameFromConfig);
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            }
        }

        private void sendBasicInfo(String nameFromConfig) {
            System.out.println("[SimpleGatewayService] Uploading basic info");
            Message m = SimpleGatewayService.createMessage(1589706757, this.masterid);
            if (nameFromConfig == null) {
                m.append("Unknown");
            } else {
                m.append(nameFromConfig);
            }
            m.append(Version.getSsuiteFullBuildVersion());
            m.append(JWSystem.getAppBundleVersion());
            m.append(this.getMyAlertRegistry().getClock().getCurrentClock());
            this.secmsg.secureSend(m);
            this.previousUsername = null;
            this.previousHostname = null;
            this.previousOS = null;
            this.previousHardware = null;
            this.sendHardwareDetailsIfChanged();
            this.sendUsernameIfChanged();
            this.sendNetworkIfChanged();
            this.sendRDPIfChanged();
            this.sendOSInfoIfChanged();
            this.sendAlertClock(this.getMyAlertRegistry());
        }

        private AlertRegistry getMyAlertRegistry() {
            return SimpleGatewayService.getAlertRegistry(this.udpOrHttpServerURL);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sendAlertClock(AlertRegistry areg) {
            try {
                ArrayList<ResourceContainer> all;
                if (this.secmsg == null) {
                    return;
                }
                long curClock = areg.getClock().getCurrentClock();
                Object object = areg.getMapLOCK();
                synchronized (object) {
                    all = areg.getAll();
                }
                Message m = SimpleGatewayService.createMessage(1589706778, this.masterid);
                m.append(curClock);
                m.append(SimpleGatewayService.buildAlertsHash(all));
                System.out.println("[Alerts] Sending alert clock " + curClock);
                this.secmsg.secureSend(m);
            }
            catch (Throwable t) {
                System.out.println("[SimpleGatewayService] Unable to send alert clock: " + t.getMessage() + " (" + t.getClass() + ")");
            }
        }

        private void sendHardwareDetailsIfChanged() {
            try {
                boolean send;
                if (this.secmsg == null) {
                    return;
                }
                BasicInfo basicInfo = BasicInfo.getBasicInfo();
                Message m = SimpleGatewayService.createMessage(1589727257, this.masterid);
                m.append(basicInfo.toMessage());
                boolean bl = send = !basicInfo.isBlank() && !m.equals((Object)this.previousHardware);
                if (send) {
                    if (this.previousHardware != null) {
                        System.out.println("[SimpleGatewayService] Hardware details have changed. Uploading.");
                    } else {
                        System.out.println("[SimpleGatewayService] Uploading hardware details.");
                    }
                    this.secmsg.secureSend(m);
                }
                this.previousHardware = m;
            }
            catch (Throwable t) {
                System.out.println("[SimpleGatewayService] Unable to log new OS info: " + t.getMessage() + " (" + t.getClass() + ")");
            }
        }

        private void sendOSInfoIfChanged() {
            try {
                boolean send;
                if (this.secmsg == null) {
                    return;
                }
                Message m = SimpleGatewayService.createMessage(1589727236, this.masterid);
                MonitoringMessages.appendOSInfo(m);
                boolean bl = send = !m.equals((Object)this.previousOS);
                if (send) {
                    if (this.previousOS != null) {
                        System.out.println("[SimpleGatewayService] OS has changed, uploading.");
                    } else {
                        System.out.println("[SimpleGatewayService] Uploading OS data.");
                    }
                    this.secmsg.secureSend(m);
                }
                this.previousOS = m;
            }
            catch (Throwable t) {
                System.out.println("[SimpleGatewayService] Unable to log new OS info: " + t.getMessage() + " (" + t.getClass() + ")");
            }
        }

        private void sendNetworkIfChanged() {
            try {
                boolean send;
                if (this.secmsg == null) {
                    return;
                }
                Message m = SimpleGatewayService.createMessage(1589727250, this.masterid);
                MonitoringMessages.appendHostname(m);
                boolean bl = send = !m.equals((Object)this.previousHostname);
                if (send) {
                    if (this.previousHostname != null) {
                        System.out.println("[SimpleGatewayService] Hostname has changed, uploading.");
                    } else {
                        System.out.println("[SimpleGatewayService] Uploading hostname data.");
                    }
                    this.secmsg.secureSend(m);
                }
                this.previousHostname = m;
            }
            catch (Throwable t) {
                System.out.println("[SimpleGatewayService] Unable to log new network info: " + t.getMessage() + " (" + t.getClass() + ")");
            }
        }

        private void sendRDPIfChanged() {
            if (!OS.isWindows()) {
                return;
            }
            try {
                boolean send;
                if (this.secmsg == null) {
                    return;
                }
                Object[] sessionInfo = JWWindowsOS.getWindowsInstance().getRDPSessionInfos();
                boolean bl = send = sessionInfo != null;
                if (send && this.previousRDPSessions != null && Arrays.equals(this.previousRDPSessions, sessionInfo)) {
                    send = false;
                }
                if (send) {
                    Message m = SimpleGatewayService.createMessage(1589727252, this.masterid);
                    m.append(sessionInfo.length);
                    for (Object info : sessionInfo) {
                        m.append(MachineInfo.rdpSessionInfoToMessage((JWWindowsOS.RDPSessionInfo)info));
                    }
                    if (this.previousRDPSessions != null) {
                        System.out.println("[SimpleGatewayService] RDP session information has changed, uploading.");
                    } else {
                        System.out.println("[SimpleGatewayService] Uploading RDP session information");
                    }
                    this.secmsg.secureSend(m);
                }
                this.previousRDPSessions = sessionInfo;
            }
            catch (Throwable t) {
                System.out.println("[SimpleGatewayService] Unable to send RDP information: " + t.getMessage() + " (" + t.getClass() + ")");
            }
        }

        private void sendUsernameIfChanged() {
            try {
                boolean send;
                if (this.secmsg == null) {
                    return;
                }
                String newUsername = MonitoringMessages.getUsername();
                boolean bl = send = !newUsername.equals(this.previousUsername);
                if (send) {
                    if (this.previousUsername != null) {
                        System.out.println("[SimpleGatewayService] Username has changed. Uploading.");
                    } else {
                        System.out.println("[SimpleGatewayService] Uploading username data.");
                    }
                    Message m = SimpleGatewayService.createMessage(1589727233, this.masterid);
                    MonitoringMessages.appendUsername(m);
                    this.secmsg.secureSend(m);
                    this.previousUsername = newUsername;
                }
            }
            catch (Throwable t) {
                System.out.println("[SimpleGatewayService] Unable to log new username: " + t.getMessage() + " (" + t.getClass() + ")");
            }
        }

        private void sendShutdownNotify() {
            try {
                Message m = SimpleGatewayService.createMessage(1589727251, this.masterid);
                this.secmsg.secureSend(m);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateRecoveryKey(String recKey) {
            try {
                Object object = config_LOCK;
                synchronized (object) {
                    String recoveryKey = config.getUrlRecoveryKey(this.udpOrHttpServerURL);
                    if (recoveryKey != null) {
                        if (recKey != null && recKey.equals(recoveryKey)) {
                            return;
                        }
                    } else if (recKey == null) {
                        return;
                    }
                    System.out.println("[SecMsg] Storing recovery key for " + this.udpOrHttpServerURL + " = " + recKey);
                    config.setUrlRecoveryKey(this.udpOrHttpServerURL, recKey);
                }
                SimpleGatewayService.resaveConfig();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }

        private boolean verifySecureMessengerNow(String serverID, String source) {
            boolean mustClearSecMsg;
            boolean mustCreateSecMsg;
            String clearReason;
            if (CentralDebugging.SECMSG_TRACE_VERIFY_REQUESTS) {
                new Exception("SecureMessenger verification requested").printStackTrace();
            }
            try {
                SecureMessengerDB.waitForAnyExistingSetup(serverID);
                SecureMessenger fetchedSecmsg = SecureMessengerDB.fetchSecureMessenger(serverID);
                if (fetchedSecmsg == null && !this.triedToLoad) {
                    this.triedToLoad = true;
                    System.out.println("[SimpleGatewayService] Trying to load SecMsg for " + serverID + " (" + source + ")");
                    fetchedSecmsg = SecureMessengerDB.loadSecureMessenger(serverID, lossyclient, this.serverLossyTransport, new SecureMessengerHandler(this.masterid));
                    if (fetchedSecmsg != null) {
                        System.out.println("[SimpleGatewayService] Loaded SecMsg for " + serverID + " OK");
                    } else {
                        System.out.println("[SimpleGatewayService] Unable to load SecMsg for " + serverID);
                    }
                }
                if (fetchedSecmsg == null) {
                    if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                        DDLog.log(this.udpOrHttpServerURL, "No existing Secure Messenger was found (null) for server " + serverID);
                    }
                    System.out.println("[SimpleGatewayService] Unable to claim ID " + this.masterid.id + " - no existing fully negotiated SecMsg was found for server " + serverID);
                    clearReason = "tried to send a message, no SecMsg found (but will not clear...)";
                    mustCreateSecMsg = true;
                    mustClearSecMsg = false;
                } else {
                    Message resp;
                    this.secmsg = fetchedSecmsg;
                    System.out.println("[SimpleGatewayService] Claiming ID " + this.masterid.getID() + " on " + this.udpOrHttpServerURL + " with " + this.secmsg);
                    if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                        DDLog.log(this.udpOrHttpServerURL, "Fetched Secure Messenger, will claim ID");
                    }
                    Message claim = SimpleGatewayService.createMessage(1589706771, this.masterid);
                    claim.append(sgTransientId);
                    boolean mustRefreshMonitoringSettings = false;
                    long tnow = SafeClock.currentTimeMillis();
                    if (tnow - this.lastUploadMonitoringSettings > 120000L) {
                        mustRefreshMonitoringSettings = true;
                    }
                    if (this.mustUploadMonitoringSettings || mustRefreshMonitoringSettings) {
                        if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                            DDLog.log(this.udpOrHttpServerURL, "Will upload monitoring settings along with ID claim");
                        }
                        Message msettings = new Message(1589706759);
                        msettings.append(isMonitoring);
                        msettings.append(config.allowMonitoring);
                        msettings.append(config.allowScripting);
                        claim.append(msettings);
                        this.lastUploadMonitoringSettings = SafeClock.currentTimeMillis();
                    }
                    if ((resp = this.secmsg.transactSecure(claim)) != null) {
                        int type;
                        LossyTransport transport = this.secmsg.getUnderlyingTransport();
                        if (transport instanceof UdpClientLossyTransport) {
                            ((UdpClientLossyTransport)transport).resetNonResponseCounter();
                        }
                        if ((type = resp.getType()) == 1589706755) {
                            this.mustUploadMonitoringSettings = false;
                            System.out.println("[SimpleGatewayService] Claimed our ID " + this.masterid.id + " OK");
                            clearReason = "claimed our ID ok (will not clear)";
                            mustCreateSecMsg = false;
                            mustClearSecMsg = false;
                            if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                                DDLog.log(this.udpOrHttpServerURL, "Claimed our ID OK");
                            }
                            if (resp.length() > 0) {
                                System.out.println("[SimpleGatewayService] ID claim has " + resp.length() + " additional properties");
                                for (int i = 0; i < resp.length(); ++i) {
                                    try {
                                        Message sub = resp.getAsMessage(i);
                                        System.out.println("[SimpleGatewayService] Additional Prop " + (i + 1) + "/" + resp.length() + "" + sub.getType() + " / " + Integer.toHexString(sub.getType()));
                                        if (sub.getType() == 1589706805) {
                                            System.out.println("[SimpleGatewayService] Server instance is " + this.serverInstance);
                                            this.serverInstance = sub.getNextLong();
                                            continue;
                                        }
                                        if (sub.getType() == 1589706806) {
                                            System.out.println("[SimpleGatewayService] Server instance is being CLEARED");
                                            this.serverInstance = null;
                                            continue;
                                        }
                                        if (sub.getType() == 1589706774) {
                                            String myUrlRecoveryKey = sub.getAsString(0);
                                            this.updateRecoveryKey(myUrlRecoveryKey);
                                            if (sub.length() > 1) {
                                                String pubkeyHash = sub.getAsString(1);
                                                hashRepository.addHash(pubkeyHash, "PKHash returned from secure ID claim with valid recovery key message");
                                                hashRepository.addURL(this.udpOrHttpServerURL, "PKHash returned from secure ID claim with valid recovery message");
                                                System.out.println("[SimpleGatewayService] Recovery Update " + this.udpOrHttpServerURL + " recovery " + myUrlRecoveryKey + " pkhash " + pubkeyHash);
                                                continue;
                                            }
                                            System.out.println("[SimpleGatewayService] Recovery Update " + this.udpOrHttpServerURL + " recovery " + myUrlRecoveryKey);
                                            continue;
                                        }
                                        if (sub.getType() == 1589706775) {
                                            System.out.println("[SimpleGatewayService] Recovery not allowed");
                                            this.updateRecoveryKey(null);
                                            continue;
                                        }
                                        if (sub.getType() == 1589706782) {
                                            long time = sub.getNextLong();
                                            System.out.println("[SimpleGatewayService] Server " + this.udpOrHttpServerURL + " centralised time is " + OneClock.translate(time));
                                            try {
                                                if (!monitoring.isOn()) continue;
                                                monitoring.sendClockAsync(this.udpOrHttpServerURL, time);
                                            }
                                            catch (Throwable t) {
                                                t.printStackTrace();
                                            }
                                            continue;
                                        }
                                        System.out.println("[SimpleGatewayService] Prop " + sub.getType() + " / " + Integer.toHexString(sub.getType()) + " not recognised, message too new?");
                                        continue;
                                    }
                                    catch (Exception x) {
                                        System.out.println("Unable to process additional property on ID claim: " + x);
                                    }
                                }
                            }
                            if (this.serverInstance != null) {
                                if (serverClaim.claimAccessTo(this.udpOrHttpServerURL, this.serverInstance)) {
                                    System.out.println("[ServerClaim] PollThread " + this.udpOrHttpServerURL + " claimed access to server " + this.serverInstance);
                                } else {
                                    System.out.println("[ServerClaim] PollThread " + this.udpOrHttpServerURL + " was unable to claim access to server " + this.serverInstance);
                                }
                            }
                            if (this.mustSendBasicInfo) {
                                if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                                    DDLog.log(this.udpOrHttpServerURL, "Will upload basic info ID claim");
                                }
                                this.mustSendBasicInfo = false;
                                this.sendBasicInfo(SimpleGatewayService.getNameFromConfigWithLock());
                            }
                        } else if (type == 1589706773) {
                            System.out.println("[SimpleGatewayService] Asked to split and secure a new ID " + this.masterid.id + " - this ID is apparently in use on another (duplicated) service");
                            this.masterid.resetToNewID();
                            SimpleGatewayService.disallowRenegotiationsDueToIncomingMessagFail();
                            SecureMessengerDB.clearAllSecureMessengers();
                            this.resetNextSmSetup();
                            this.mustUploadMonitoringSettings = true;
                            clearReason = "asked to split our ID";
                            mustCreateSecMsg = true;
                            mustClearSecMsg = true;
                        } else if (type == 1589706754) {
                            System.out.println("[SimpleGatewayService] Unable to claim ID " + this.masterid.id + " - is this ID in use with some other machine?");
                            if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                                DDLog.log(this.udpOrHttpServerURL, "SPOOFING - ID is in use on another machine (collision?)");
                            }
                            clearReason = "told we were spoofing, ID collision? (will not clear)";
                            mustCreateSecMsg = false;
                            mustClearSecMsg = false;
                        } else if (type == 274596505) {
                            clearReason = "server asked us to renegotiate";
                            mustCreateSecMsg = true;
                            mustClearSecMsg = true;
                        } else {
                            System.out.println("[SimpleGatewayService] Unrecognised response to ID claim " + type);
                            clearReason = "received an unrecognised response to an ID claim (" + type + ") (will not clear)";
                            mustCreateSecMsg = false;
                            mustClearSecMsg = false;
                        }
                    } else {
                        System.out.println("[SimpleGatewayService] Unable to claim ID " + this.masterid.id + " - the server did not respond?");
                        LossyTransport transport = this.secmsg.getUnderlyingTransport();
                        if (transport instanceof UdpClientLossyTransport) {
                            ((UdpClientLossyTransport)transport).incrementNonResponseCounter();
                        }
                        if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                            DDLog.log(this.udpOrHttpServerURL, "Server did not respond to my Claim ID request");
                        }
                        clearReason = "server did not respond to our ID claim (will not clear)";
                        mustCreateSecMsg = false;
                        mustClearSecMsg = false;
                        this.sendBasicInfoOnNextValidate(false, SimpleGatewayService.getNameFromConfigWithLock());
                        this.mustUploadMonitoringSettings = true;
                    }
                }
            }
            catch (SecMsgDecryptionError t) {
                System.out.println("[SimpleGatewayService] Unable to claim ID " + this.masterid.id + " - an unexpected issue occurred with secure comms (DECR), will request renegotiation");
                clearReason = "decryption error in ID claim";
                mustCreateSecMsg = true;
                mustClearSecMsg = true;
            }
            catch (NegativeArraySizeException t) {
                System.out.println("[SimpleGatewayService] Unable to claim ID " + this.masterid.id + " - an unexpected issue occurred with secure comms (NASE)");
                clearReason = "error in comms (NASE)";
                mustCreateSecMsg = false;
                mustClearSecMsg = false;
            }
            catch (OutOfMemoryError t) {
                System.out.println("[SimpleGatewayService] Unable to claim ID " + this.masterid.id + " - an unexpected issue occurred with secure comms (OOM)");
                clearReason = "error in comms (OOM)";
                mustCreateSecMsg = false;
                mustClearSecMsg = false;
            }
            catch (Throwable t) {
                System.out.println("[SimpleGatewayService] Unable to claim ID " + this.masterid.id + " - an unexpected issue occurred with secure comms " + t);
                t.printStackTrace();
                clearReason = "error in comms (" + t + ")";
                mustCreateSecMsg = false;
                mustClearSecMsg = false;
            }
            if (CentralDebugging.SG_TEST_RENEGOTIATE_SECMSG_EVERY_TIME) {
                System.out.println("***TESTING: CLEARING SECMSG TO TEST RENEGOTIATION");
                clearReason = "testing, clearing secmsg to test renegotiation";
                mustCreateSecMsg = true;
                mustClearSecMsg = true;
                this.nextSmSetup = 0L;
            }
            if (mustCreateSecMsg) {
                if (mustClearSecMsg) {
                    System.out.println("[SimpleGatewayService] SecMsg verification failed, clearing SecMsg for " + serverID);
                    SecureMessengerDB.clearSecureMessenger(serverID, clearReason);
                } else {
                    System.out.println("[SimpleGatewayService] SecMsg verification failed for " + serverID + ", must create or wait for existing secmsg setup");
                }
            }
            return !mustCreateSecMsg;
        }

        String getServerSecMsgID() {
            return this.udpOrHttpServerURL;
        }

        private void transportRequiresSecurityRenegotiation(LossyTransport transport) {
            if (transport == this.serverLossyTransport) {
                SecureMessengerDB.clearSecureMessenger(this.udpOrHttpServerURL, "transport requested security renegotiation");
                if (this.canSetupSecureMessengerNow("Server requested renegotiation")) {
                    new SecureMessengerSetup(this.masterid.getID(), this.udpOrHttpServerURL, this.serverLossyTransport, this.masterid).start();
                }
            }
        }

        private void setServerLossyTransport(LossyTransport transport) {
            this.serverLossyTransport = transport;
            this.verifyOrSetupSecureMessenger();
        }

        private void resetNextSmSetup() {
            this.nextSmSetup = 0L;
        }

        private void noSecMsgSetupFor(long t) {
            this.nextSmSetup = CentralDebugging.DDEBUG_ON || CentralDebugging.SECMSG_NO_BUSY_WAIT ? SafeClock.currentTimeMillis() + 10000L : SafeClock.currentTimeMillis() + t + (long)((int)(120000.0 * Math.random()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean canSetupSecureMessengerNow(String reason) {
            Object object = this.secMsgSetup_LOCK;
            synchronized (object) {
                long Twait = (this.nextSmSetup - SafeClock.currentTimeMillis()) / 1000L;
                if (SafeClock.currentTimeMillis() > this.nextSmSetup) {
                    this.noSecMsgSetupFor(120000L);
                    return true;
                }
                System.out.println("[SecMsg] Will not renegotiate security (" + reason + ") for " + this.udpOrHttpServerURL + " yet, too soon since last time, " + Twait + "s...");
                if (CentralDebugging.RENEGOTIATION_TRACING) {
                    new Exception("[SecMsg] Will not renegotiate security (" + reason + ") for " + this.udpOrHttpServerURL + " yet, too soon since last time, " + Twait + "s...").printStackTrace();
                }
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void verifyOrSetupSecureMessenger() {
            Object object = this.claims_LOCK;
            synchronized (object) {
                if (this.claims.size() > 10) {
                    System.out.println("[SecMsg] ***WARNING Claim threads stacking, N=" + this.claims.size() + ", will try to clear all and skip current claim");
                    for (ClaimThread ct : this.claims) {
                        try {
                            StackTraceElement[] elems = ct.getStackTrace();
                            for (int i = 0; i < Math.min(5, elems.length - 1); ++i) {
                                System.out.println("[ClaimThreadStack] " + ct.getName() + ", " + elems[i].getClassName() + "." + elems[i].getMethodName() + " (" + elems[i].getFileName() + ":" + elems[i].getLineNumber() + ")");
                            }
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        try {
                            ct.interrupt();
                        }
                        catch (Throwable throwable) {}
                    }
                    return;
                }
                ClaimThread ct = new ClaimThread();
                this.claims.add(ct);
                ct.start();
            }
        }

        PollThread(String addr, SimpleGatewayID masterid) {
            super("PollThread");
            System.out.println("[PollThread] Polling " + addr + " " + masterid);
            if (!JWTesting.amTesting()) {
                this.inUseMonitor = new MachineInUseMonitor(30000);
            }
            this.sendMonitoringSettingsOnNextValidate();
            this.sendBasicInfoOnNextValidate(false, SimpleGatewayService.getNameFromConfigWithLock());
            this.masterid = masterid;
            this.udpOrHttpServerURL = addr;
            if (addr.toLowerCase().startsWith("udp")) {
                this.udpaddr = addr;
                System.out.println("[PollThread] UDP Address: " + this.udpaddr);
                addr = SGHttpsUtil.getRequiredHttpProtocol() + addr.substring(3);
            }
            this.isHTTPS = addr.toLowerCase().startsWith("https");
            System.out.println("[PollThread] HTTP Address: " + addr);
            this.serverAddress = addr;
            this.lastExecutedPoll = System.currentTimeMillis();
            this.alertsMap = SimpleGatewayService.getOwnedAlertsForRegistry(this.getMyAlertRegistry().getAll());
            this.genStore = SimpleGatewayService.getGenStore(this.udpOrHttpServerURL);
        }

        String getServerURL() {
            return this.serverAddress;
        }

        public void handleMessage(byte[] dat) {
            this.handleMessage(dat, null, null, null);
        }

        @Override
        public void handleMessage(byte[] dat, Object uid, UDPResponder respond, String remoteSocketIPAddress) {
            Message msg;
            Message m = MessageUtils.bytesToMessage((byte[])dat);
            if (CentralDebugging.SG_ALL_INCOMING_MESSAGES) {
                System.out.println("[SG] Incoming message " + m);
            }
            if (m.getType() == 3002000) {
                Message lossy = (Message)m.pop();
                lossyclient.lossyMessageReceived(this.serverLossyTransport, lossy, this);
                return;
            }
            Object peek = m.peek();
            if (peek instanceof Message && (msg = (Message)m.pop()).getType() == 3005000) {
                for (int i = 0; i < msg.length(); ++i) {
                    Message sub = (Message)msg.get(i);
                    if (CentralDebugging.DEBUG_SECMSG_INITIAL_CHAT) {
                        System.out.println("[SecmsgInitial] Incoming message from ping-return " + sub);
                    }
                    lossyclient.lossyMessageReceived(this.serverLossyTransport, sub, this);
                }
            }
            int index = 0;
            long timestamp = m.getAsLong(index++);
            if (m.getType() == 55430001) {
                this.setServerVersion(m.getAsString(index + 1));
            } else {
                this.setServerVersion(m.getAsString(index++));
            }
            String messagingThreadKey = "" + m.getType();
            Long latestMessageReceived = this.timestamps.get(messagingThreadKey);
            if (latestMessageReceived == null) {
                latestMessageReceived = -99L;
            }
            if (timestamp <= latestMessageReceived) {
                return;
            }
            this.timestamps.put(messagingThreadKey, timestamp);
            switch (m.getType()) {
                case 55430002: {
                    this.pingUDP();
                    break;
                }
                case 55430008: {
                    if (m.length() > index) {
                        long pingTime = m.getAsLong(index);
                        long rtt = System.currentTimeMillis() - pingTime;
                        if (rtt > 0L && rtt < 10000L) {
                            if (!this.rttMeasured) {
                                this.rttMeasured = true;
                                this.latestRTT = rtt;
                            } else {
                                this.latestRTT = (long)((double)this.latestRTT * 0.6 + (double)rtt * 0.4);
                            }
                        }
                    }
                    if (m.length() <= index + 1) break;
                    String pubkeyhash = m.getAsString(index + 1);
                    this.setTrustedBasedOnPubkeyHashPortion(pubkeyhash);
                    break;
                }
                case 55430001: {
                    String MyID = (String)m.get(index++);
                    if (LocalSwitches.DEV_acculogSessionLaunch) {
                        Acculog.log("[RA Service] Received SG_CONNECT request");
                    }
                    String ServerShortVersion = "";
                    try {
                        ServerShortVersion = (String)m.get(index++);
                    }
                    catch (Exception rtt) {
                        // empty catch block
                    }
                    String ServerBuild = "";
                    try {
                        ServerBuild = (String)m.get(index++);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    String JwRaVersion = "";
                    try {
                        JwRaVersion = (String)m.get(index++);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    String primaryServer = "";
                    try {
                        primaryServer = (String)m.get(index++);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    String requiredPubkeyhashPortion = "";
                    try {
                        requiredPubkeyhashPortion = (String)m.get(index++);
                        if (requiredPubkeyhashPortion == null) {
                            requiredPubkeyhashPortion = "";
                        }
                        this.setTrustedBasedOnPubkeyHashPortion(requiredPubkeyhashPortion);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    String requestedSessionID = null;
                    if (MyID.contains(":::")) {
                        int indexOfColon = MyID.indexOf(":::");
                        if (indexOfColon != -1) {
                            requestedSessionID = MyID.substring(indexOfColon + ":::".length());
                            MyID = MyID.substring(0, indexOfColon);
                        }
                        System.out.println("[PollThread] Connection required with ID: " + MyID + " (" + requestedSessionID + ")");
                    } else {
                        System.out.println("[PollThread] Connection required with ID: " + MyID);
                    }
                    try {
                        System.out.println("[PollThread] Server version is " + ServerShortVersion + " / " + ServerBuild);
                        this.handleConnectRequest(MyID, requiredPubkeyhashPortion, requestedSessionID, ServerBuild, JwRaVersion, primaryServer, this.secmsg);
                    }
                    catch (Exception x) {
                        x.printStackTrace();
                    }
                    break;
                }
                case 55430007: {
                    this.httpMillisSleep = m.getAsLong(index++);
                    break;
                }
                case 55430006: {
                    this.httpMillisSleep = m.getAsLong(index++);
                    if (m.length() <= index) break;
                    this.setTrustedBasedOnPubkeyHashPortion(m.getAsString(index++));
                    break;
                }
                case 55430009: {
                    long ignoredHttpMillisSleep = m.getAsLong(index++);
                    if (m.length() > index) {
                        this.setTrustedBasedOnPubkeyHashPortion(m.getAsString(index++));
                    }
                    this.immediatePingNextTime = true;
                    break;
                }
                default: {
                    System.out.println("[PollThread] WARNING: Unknown message of type (" + m.getType() + ")");
                }
            }
        }

        String setTrustedBasedOnPubkeyHashPortion(String pubkeyhashPortion) {
            if (pubkeyhashPortion == null) {
                return null;
            }
            if (pubkeyhashPortion.length() == 0) {
                return null;
            }
            String hashFound = null;
            Iterator<String> iterator = hashRepository.iterator();
            while (iterator.hasNext()) {
                String hash = iterator.next();
                if (!hash.endsWith(pubkeyhashPortion)) continue;
                hashFound = hash;
            }
            if (hashFound != null) {
                this.lastPkhashMatch = hashFound;
                this.lastPkhashMatchPortion = pubkeyhashPortion;
            } else {
                this.lastPkhashMatch = "no match found";
                this.lastPkhashMatchPortion = "no match found";
            }
            return hashFound;
        }

        private void setServerVersion(String newVersion) {
            if (this.serverVersion != null && this.serverVersion.equals(newVersion)) {
                return;
            }
            this.serverVersion = newVersion;
            SimpleGatewayService.recheckAllPollThreadServerVersions();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void pingUDP() {
            if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                DDLog.log(config, "Doing UDP Ping");
            }
            Object object = this.udpPing_LOCK;
            synchronized (object) {
                try {
                    if (this.udpClient == null) {
                        URL url = new URL(this.serverAddress);
                        String host = url.getHost();
                        int port = url.getPort();
                        if (port == -1) {
                            port = 80;
                        }
                        this.udpClient = new UDPClient(host, port, this);
                        if (CentralDebugging.UDP_VERBOSE) {
                            System.out.println("[PollThread] Created UDP client to " + host + ":" + port);
                        }
                        UdpClientLossyTransport temp = new UdpClientLossyTransport(lossyclient);
                        temp.init(this.udpClient);
                        if (Switches.SH_allowLossyTransportSwitchingInRa) {
                            HttpClientLossyTransport http = new HttpClientLossyTransport(this.getServerURL(), this.masterid.getID());
                            SwitchableLossyTransport switchable = new SwitchableLossyTransport(temp, http);
                            this.setServerLossyTransport(switchable);
                        } else {
                            this.setServerLossyTransport(temp);
                        }
                        this.lastResolutionTime = System.currentTimeMillis();
                    } else if (System.currentTimeMillis() - this.lastResolutionTime > 30000L) {
                        String oldAddress = null;
                        try {
                            oldAddress = this.udpClient.getHostFor(null);
                        }
                        catch (Throwable host) {
                            // empty catch block
                        }
                        int oldPort = this.udpClient.getPortFor(null);
                        if (CentralDebugging.SG_DNS_RESOLUTION_DEBUG) {
                            System.out.println("[PollThread] [UDP] Rechecking DNS mapping. Old address is " + oldAddress + ".");
                        }
                        URL url = new URL(this.serverAddress);
                        String host = url.getHost();
                        int port = url.getPort();
                        if (port == -1) {
                            port = 80;
                        }
                        this.udpClient.setTargetAddress(host, port);
                        if (CentralDebugging.SG_DNS_RESOLUTION_DEBUG) {
                            System.out.println("[PollThread] [UDP] Rechecking DNS mapping. Updated UDPClient with " + host + ".");
                        }
                        String newAddress = null;
                        try {
                            newAddress = this.udpClient.getHostFor(null);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        int newPort = this.udpClient.getPortFor(null);
                        if (oldAddress == null || oldPort != newPort || !oldAddress.equals(newAddress)) {
                            System.out.println("[PollThread] [UDP] Client has detected a host DNS change (" + oldAddress + " -> " + newAddress + ")");
                        }
                        this.lastResolutionTime = System.currentTimeMillis();
                    }
                    byte[] dat = MessageUtils.messageToBytes((Message)this.getPingMessage(this.lastPkhashMatchPortion, false));
                    this.udpClient.send(dat);
                }
                catch (IOException x) {
                    System.out.println("[SimpleGatewayService] Unable to ping " + this.udpClient + " " + x);
                }
                catch (Exception x) {
                    System.out.println("[SimpleGatewayService] Unable to ping " + this.udpClient + " " + x);
                    x.printStackTrace();
                }
            }
        }

        private String getInUse() {
            if (SIMULATE_MULTIPLE_MACHINES) {
                return "2";
            }
            if (Testing.amTesting()) {
                return "2";
            }
            if (this.inUseMonitor.checkIfHeadless()) {
                return "3";
            }
            if (this.inUseMonitor.isAvailable()) {
                if (this.inUseMonitor.isInUse()) {
                    return "1";
                }
                return "2";
            }
            return "0";
        }

        private long trackPollWaitGetMinSleep(boolean isNoop) {
            this.noopCount = isNoop ? ++this.noopCount : 0;
            long now = SafeClock.currentTimeMillis();
            if (this.lastOp == 0L) {
                this.lastOp = now;
            } else if (now - this.lastOp > 2000L) {
                if (this.noopCount >= 4) {
                    System.out.println("[RA Polling] Enforcing minimum wait");
                    this.noopCount = 0;
                    this.lastOp = now;
                    return 2500L;
                }
                this.noopCount = 0;
                this.lastOp = now;
                return 0L;
            }
            return 0L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Message getPingMessage(String pkhashPortion, boolean http10) {
            Object m;
            if (CentralDebugging.PX_GENSTORE_TESTDATA) {
                Object object = this.gsTestData_LOCK;
                synchronized (object) {
                    if (System.currentTimeMillis() > this.nextPacketCreate) {
                        m = new Message(this.gsTestDataIndex++);
                        m.append("Wippity Woppity " + this.gsTestDataIndex + " " + new Date());
                        m.append(new byte[100000 + (int)(Math.random() * 600000.0)]);
                        this.genStore.addPacket(new StorePacket((Message)m));
                        this.nextPacketCreate = System.currentTimeMillis() + 10000L;
                    }
                }
            }
            if (CentralDebugging.PKHASH_PORTION_DEBUGGING) {
                System.out.println("[SimpleGatewayService] Pinging with pkhashPortion='" + pkhashPortion + "'");
            }
            Message message = new Message(55430000);
            if (SIMULATE_MULTIPLE_MACHINES) {
                message.append(multi_name_override);
            } else if (Switches.SH_noConfigLockInGetPollMessage) {
                message.append(this.masterid.getID());
            } else {
                m = config_LOCK;
                synchronized (m) {
                    message.append(this.masterid.getID());
                }
            }
            message.append(this.getInUse());
            message.append("5.1");
            message.append(false);
            message.append(System.currentTimeMillis());
            if (Switches.SHFTP_uploadJwConvertedSSuiteBuild) {
                message.append(Version.jwVersionToSSuiteVersion(JWSystem.getAppBundleVersion()));
            } else {
                message.append(Version.getSsuiteFullBuildVersion());
            }
            message.append(pkhashPortion);
            boolean updateRefused = this.areThereRefusedUpdates();
            byte state = 0;
            if (http10) {
                state = (byte)(state | 1);
            }
            if (updateRefused) {
                state = (byte)(state | 2);
            }
            message.append(state);
            message.append(this.genStore.getLatestDataPoint());
            message.append(this.genStore.getEarliestDataPoint());
            message.append(4);
            if (CentralDebugging.PX_GENSTORE_UPLOAD) {
                System.out.println("[GenStore] Constructing ping message " + this.genStore.getLatestDataPoint() + " to " + this.genStore.getEarliestDataPoint() + " (PT " + this.hashCode() + " / " + this.udpOrHttpServerURL + ")");
            }
            if (CentralDebugging.VERBOSE_PING_MESSAGE) {
                System.out.println("[SimpleGatewayService] Ping message: " + message);
            }
            return message;
        }

        private boolean areThereRefusedUpdates() {
            try {
                File appFolder = JWSystem.getAppFolder();
                File refusedUpdatesFolder = new File(appFolder.getParentFile(), GenericUpdater.getRefusedUpdatesFolderName());
                if (refusedUpdatesFolder.exists()) {
                    File[] children = refusedUpdatesFolder.listFiles();
                    return children != null && children.length > 0;
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            return false;
        }

        private String ripOutHostname(String address) {
            int colon;
            int nextSlash;
            int doubleSlash = address.indexOf("://");
            if (doubleSlash != -1) {
                address = address.substring(doubleSlash + 3);
            }
            if (address.endsWith("/")) {
                address = address.substring(0, address.length() - 1);
            }
            if ((nextSlash = address.indexOf(47)) != -1) {
                address = address.substring(0, nextSlash);
            }
            if ((colon = address.indexOf(58)) == -1) {
                return address;
            }
            return address.substring(0, colon);
        }

        private void lossyTest() {
            if (LossyTestThread.DEBUG) {
                new LossyTestThread(lossyclient, this.serverLossyTransport, this.masterid.getID());
            }
        }

        void testKillHttpSocket() {
            this.testKillHttpOnce = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!this.serverAddress.endsWith("/")) {
                this.serverAddress = this.serverAddress + "/";
            }
            try {
                URL testURL = new URL(this.serverAddress);
                this.hostnameOfServerAddress = testURL.getHost();
            }
            catch (Throwable t) {
                this.hostnameOfServerAddress = this.ripOutHostname(this.serverAddress);
            }
            if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                DDLog.log(config, "Server address is " + this.serverAddress + ", server hostname is " + this.hostnameOfServerAddress);
            }
            System.out.println("[PollThread] From " + this.serverAddress + " we got a hostname of " + this.hostnameOfServerAddress);
            if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                DDLog.log(config, "Updating DNS lookup");
            }
            this.updateDNSLookup();
            int major_failures = 0;
            HttpClientSocketTracker sockTracker = new HttpClientSocketTracker("Poll");
            int newSockets = 0;
            long newSocketsTime = System.currentTimeMillis();
            boolean firstUdpPing = true;
            boolean sslFailing = false;
            if (SIMULATE_MULTIPLE_MACHINES) {
                multi_ui.waitForGo();
            }
            while (!this.iAmObsolete) {
                if (Testing.amTesting()) {
                    SimpleGatewayService.checkTestPollWait();
                }
                this.lastExecutedPoll = System.currentTimeMillis();
                if (this.mayTalkToServer()) {
                    if (this.serverInstance != null) {
                        System.out.println("[ServerClaim] PollThread " + this.udpOrHttpServerURL + " is allowed to poll server " + this.serverInstance);
                    } else {
                        System.out.println("[ServerClaim] PollThread " + this.udpOrHttpServerURL + " is allowed to poll as there is no server instance ID yet");
                    }
                    if (this.min15.resetIfMaxed() && Switches.SH_alertAndBasicInfoSentEvery15min) {
                        try {
                            this.sendBasicInfoOnNextValidate(false, null);
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                        }
                    }
                    if (this.udpaddr != null && !SwitchableLossyTransport.isUsingAlt(this.serverLossyTransport)) {
                        if (SIMULATE_MULTIPLE_MACHINES) {
                            this.simulateMachines();
                            continue;
                        }
                        if (firstUdpPing) {
                            this.pingUDP();
                            firstUdpPing = false;
                            try {
                                Thread.sleep(900 + (int)(200.0 * Math.random()));
                            }
                            catch (Exception t) {
                                // empty catch block
                            }
                        }
                        this.pingUDP();
                        this.lossyTest();
                        this.sendUsernameIfChanged();
                        this.sendNetworkIfChanged();
                        this.sendRDPIfChanged();
                        try {
                            this.lastExecutedPoll = System.currentTimeMillis();
                            this.verifyOrSetupSecureMessenger();
                            Object t = this.PING_SLEEP_LOCK;
                            synchronized (t) {
                                this.PING_SLEEP_LOCK.wait(17500 + (int)(3000.0 * Math.random()));
                                continue;
                            }
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                            continue;
                        }
                    }
                    this.updateDNSLookup();
                    String httpAddress = this.ipServerAddress == null ? this.serverAddress + "machine-" + System.currentTimeMillis() : this.ipServerAddress + "machine-" + System.currentTimeMillis();
                    if (CentralDebugging.SG_DNS_RESOLUTION_DEBUG) {
                        if (this.ipServerAddress == null) {
                            System.out.println("[PollThread] [HTTP] ipServerAddress is null. Using hostname to form address " + httpAddress);
                        } else {
                            System.out.println("[PollThread] [HTTP] ipServerAddress is " + this.ipServerAddress + ". Using it to form address " + httpAddress);
                        }
                    }
                    boolean isProbablyHTTP10 = major_failures > 0 || newSockets >= 6;
                    Message pingMessage = this.getPingMessage(this.lastPkhashMatchPortion, isProbablyHTTP10);
                    String hexPingMessage = HexData.byteArrayToHexString((byte[])MessageUtils.messageToBytes((Message)pingMessage));
                    httpAddress = httpAddress + "?ping=" + hexPingMessage;
                    this.httpMillisSleep = 5000L;
                    long T_httpQuery = 0L;
                    AutoFetchURL.URLConnectionHandler handler = null;
                    URLConnection urlConnection = null;
                    InputStream in = null;
                    try {
                        InputStream urlInputStream;
                        if (newSockets >= 7) {
                            long diff = System.currentTimeMillis() - newSocketsTime;
                            if (diff <= 900000L) {
                                this.reportFailure(++major_failures, sslFailing);
                            } else {
                                major_failures = 0;
                            }
                            newSockets = 0;
                            newSocketsTime = System.currentTimeMillis();
                        }
                        if (this.serverLossyTransport == null) {
                            this.setServerLossyTransport(new HttpClientLossyTransport(httpAddress, this.masterid.getID()));
                        }
                        URL url = new URL(httpAddress);
                        if (CentralDebugging.SG_BANDWIDTH_REPORTING) {
                            BandwidthReporting.sentHttp("RA Ping " + url.getHost(), httpAddress.length());
                        }
                        handler = new AutoFetchURL.URLConnectionHandler(){

                            public boolean initialiseURLConnection(URLConnection urlConnection) {
                                super.initialiseURLConnection(urlConnection);
                                if (PollThread.this.ipServerAddress != null) {
                                    if (CentralDebugging.SG_DNS_RESOLUTION_DEBUG) {
                                        System.out.println("[PollThread] [HTTP] Overwriting Host header request property with " + PollThread.this.hostnameOfServerAddress);
                                    }
                                    try {
                                        this.connection.setRequestProperty("Host", PollThread.this.hostnameOfServerAddress);
                                    }
                                    catch (Throwable t) {
                                        t.printStackTrace();
                                    }
                                }
                                this.connection.setConnectTimeout(35000);
                                this.connection.setReadTimeout(35000);
                                this.connection.setUseCaches(false);
                                return true;
                            }
                        };
                        long T_tmp = System.currentTimeMillis();
                        if (CentralDebugging.SG_VERBOSE_HTTP_READ) {
                            System.out.println("[SG][HTTP] Connecting HTTP");
                        }
                        try {
                            urlInputStream = AutoFetchURL.getInputStreamAndHandleTLSDowngrade((URL)url, (AutoFetchURL.URLConnectionInitialiser)handler);
                        }
                        catch (SocketTimeoutException x) {
                            if (Switches.SH_retryOnceOnRaReadTimeout && x.getMessage().toLowerCase().contains("read")) {
                                System.out.println("[SG][HTTP]Server didn't respond, will drain and try again once...");
                                URLConnectionUtil.drainErrorStreamToMaintain(x, handler.connection);
                                urlInputStream = AutoFetchURL.getInputStreamAndHandleTLSDowngrade((URL)url, (AutoFetchURL.URLConnectionInitialiser)handler);
                            }
                            throw x;
                        }
                        if (CentralDebugging.SG_VERBOSE_HTTP_READ) {
                            System.out.println("[SG][HTTP] Connected HTTP");
                        }
                        urlConnection = handler.connection;
                        int responseCode = 200;
                        if (urlConnection instanceof HttpURLConnection) {
                            responseCode = ((HttpURLConnection)urlConnection).getResponseCode();
                        }
                        if (ArrayUtils.contains((int[])HTTP_RESPONSE_CODES_NOT_SH, (int)responseCode)) {
                            System.out.println("[PollThread] HTTP request for " + url + " has a response code of " + responseCode + ". This is not a SimpleHelp server. Not checking for new socket.");
                        } else {
                            try {
                                if (sockTracker.checkForNewSocket(urlConnection)) {
                                    System.out.println("[PollThread] New HTTP client (ns=" + ++newSockets + ") (mf=" + major_failures + ") for " + url);
                                } else {
                                    major_failures = 0;
                                    newSockets = 0;
                                    newSocketsTime = System.currentTimeMillis();
                                }
                            }
                            catch (Throwable t) {
                                t.printStackTrace();
                            }
                        }
                        in = new BufferedInputStream(urlInputStream);
                        ByteArrayOutputStream bout = new ByteArrayOutputStream();
                        int count = 0;
                        if (CentralDebugging.SG_VERBOSE_HTTP_READ) {
                            System.out.println("[SG][HTTP] Reading HTTP...");
                        }
                        int n = in.read();
                        while (n != -1) {
                            bout.write(n);
                            if (++count > MAX_HTTP_RETURNED_DATA_SIZE) {
                                throw new Exception("Data returned exceeded maximum length limit (" + MAX_HTTP_RETURNED_DATA_SIZE + ")");
                            }
                            n = in.read();
                        }
                        if (CentralDebugging.SG_VERBOSE_HTTP_READ) {
                            System.out.println("[SG][HTTP] Read all HTTP " + bout.size());
                        }
                        T_httpQuery = System.currentTimeMillis() - T_tmp;
                        if (CentralDebugging.SG_BANDWIDTH_REPORTING) {
                            BandwidthReporting.receivedHttp("RA Ping " + url.getHost(), bout.size());
                        }
                        this.handleMessage(bout.toByteArray(), null, null, null);
                        if (this.testKillHttpOnce) {
                            this.testKillHttpOnce = false;
                            ((HttpURLConnection)urlConnection).disconnect();
                        }
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        if (t instanceof SSLException) {
                            sslFailing = true;
                            ++newSockets;
                        } else {
                            sslFailing = false;
                        }
                        URLConnection failedUrlConnection = null;
                        if (urlConnection != null) {
                            failedUrlConnection = urlConnection;
                        } else if (handler != null) {
                            failedUrlConnection = handler.connection;
                        }
                        URLConnectionUtil.drainErrorStreamToMaintain(t, failedUrlConnection);
                        if (t instanceof ConnectException) {
                            newSockets = 0;
                            newSocketsTime = System.currentTimeMillis();
                        }
                        System.out.println("[PollThread] " + t + " (URL=" + httpAddress + ")");
                    }
                    try {
                        in.close();
                    }
                    catch (Throwable t) {
                        // empty catch block
                    }
                    this.lossyTest();
                    try {
                        if (this.httpMillisSleep < 2500L) {
                            this.httpMillisSleep = Switches.SH_raServiceZeroSleepUnlessConsecutiveNoop ? this.trackPollWaitGetMinSleep(!this.immediatePingNextTime) : 2500L;
                        }
                        this.lastExecutedPoll = System.currentTimeMillis();
                        if (this.immediatePingNextTime) {
                            this.immediatePingNextTime = false;
                        } else {
                            this.sendUsernameIfChanged();
                            this.sendNetworkIfChanged();
                            this.sendRDPIfChanged();
                            if (T_httpQuery <= 6000L) {
                                Object object;
                                if (this.httpMillisSleep > 5000L) {
                                    long actualSleep = this.httpMillisSleep - 2500L + (long)((int)(3000.0 * Math.random()));
                                    object = this.PING_SLEEP_LOCK;
                                    synchronized (object) {
                                        this.PING_SLEEP_LOCK.wait(actualSleep);
                                    }
                                }
                                if (this.httpMillisSleep >= 2500L) {
                                    long actualSleep = this.httpMillisSleep - 1000L + (long)((int)(1500.0 * Math.random()));
                                    object = this.PING_SLEEP_LOCK;
                                    synchronized (object) {
                                        this.PING_SLEEP_LOCK.wait(actualSleep);
                                    }
                                }
                                if (this.httpMillisSleep > 0L) {
                                    Object actualSleep = this.PING_SLEEP_LOCK;
                                    synchronized (actualSleep) {
                                        this.PING_SLEEP_LOCK.wait(this.httpMillisSleep);
                                    }
                                }
                            }
                            this.verifyOrSetupSecureMessenger();
                        }
                        if (!CentralDebugging.SG_SERVICE_SIMULATE_STUCK) continue;
                        System.out.println("Simulating stuck service (will sleep until woken)");
                        try {
                            Thread.sleep(999999999L);
                        }
                        catch (Exception x) {
                            System.out.println("Somebody woke me! " + x);
                            CentralDebugging.SG_SERVICE_SIMULATE_STUCK = false;
                        }
                    }
                    catch (Throwable throwable) {}
                    continue;
                }
                System.out.println("[ServerClaim] PollThread " + this.udpOrHttpServerURL + " is not allowed to talk to server " + this.serverInstance);
                try {
                    Thread.sleep(12000 + BCUtil.getSecureRandom().nextInt(6000));
                }
                catch (Exception exception) {}
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void wakeUpAndPingNow() {
            Object object = this.PING_SLEEP_LOCK;
            synchronized (object) {
                this.PING_SLEEP_LOCK.notify();
            }
        }

        private void updateDNSLookup() {
            if (System.currentTimeMillis() - this.lastDNSLookup < 30000L) {
                return;
            }
            if (this.isHTTPS) {
                return;
            }
            if (CentralDebugging.SG_DNS_RESOLUTION_DEBUG) {
                System.out.println("[PollThread] [HTTP] Updating DNS mapping...");
            }
            String previousIPAddress = this.ipServerAddress;
            try {
                String ipOfServerAddress = InetAddress.getByName(this.hostnameOfServerAddress).getHostAddress();
                if (CentralDebugging.SG_DNS_RESOLUTION_DEBUG) {
                    System.out.println("[PollThread] [HTTP] Resolved " + this.hostnameOfServerAddress + " -> " + ipOfServerAddress);
                }
                this.ipServerAddress = this.serverAddress.replace(this.hostnameOfServerAddress, ipOfServerAddress);
                if (CentralDebugging.SG_DNS_RESOLUTION_DEBUG) {
                    System.out.println("[PollThread] [HTTP] Created new IP address: " + this.ipServerAddress);
                }
            }
            catch (Throwable t) {
                this.ipServerAddress = null;
                t.printStackTrace();
            }
            if (previousIPAddress != null && this.ipServerAddress != null && !previousIPAddress.equals(this.ipServerAddress)) {
                System.out.println("[PollThread] HTTP client has detected a host IP change (" + previousIPAddress + " -> " + this.ipServerAddress + ")");
            }
            this.lastDNSLookup = System.currentTimeMillis();
        }

        private void reportFailure(int major_failures, boolean sslFailing) throws InterruptedException {
            Date date = new Date();
            if (major_failures < 4) {
                int ONE_HOUR = 3600000;
                int sleepTime = major_failures * ONE_HOUR;
                if (sslFailing) {
                    SimpleGatewayService.logProblem("[" + date + "] SSL connections are failing to connect, possibly because your server does not have a valid certificate, temporarily shutting down to avoid harming server...");
                    System.out.println("**************************************************************");
                    System.out.println("**************************************************************");
                    System.out.println("[" + date + "] WARNING! SSL connections are failing to connect, possibly because your server does not have a valid certificate, temporarily shutting down to avoid harming server...");
                    System.out.println("**************************************************************");
                    System.out.println("**************************************************************");
                } else {
                    SimpleGatewayService.logProblem("[" + date + "] Consistently failing to maintain TCP connections for HTTP 1.1 queries, temporarily shutting down to avoid harming server...");
                    System.out.println("**************************************************************");
                    System.out.println("**************************************************************");
                    System.out.println("[" + date + "] WARNING! Consistently failing to maintain TCP connections for HTTP 1.1 queries, sleeping for " + major_failures + " hours and retrying...");
                    System.out.println("**************************************************************");
                    System.out.println("**************************************************************");
                }
                Thread.sleep(sleepTime);
            } else {
                long retryOnceHours = 12L;
                if (sslFailing) {
                    SimpleGatewayService.logProblem("[" + date + "] SSL connections are failing to connect, possibly because your server does not have a valid certificate.  Further connection attempts would be detrimental to the server, stalling for " + retryOnceHours + " hours...");
                    System.out.println("[" + date + "] WARNING! SSL connections are failing to connect, possibly because your server does not have a valid certificate.  Further connection attempts would be detrimental to the server, stalling for " + retryOnceHours + " hours...");
                } else {
                    SimpleGatewayService.logProblem("[" + date + "] HTTP 1.1 (TCP) sockets are not being maintained through to the server, possibly a proxy or network device is forcing the use of HTTP 1.0 which is not efficient enough to run SimpleGateway, stalling for " + retryOnceHours + " hours...");
                    System.out.println("[" + date + "] WARNING! Sockets are not being maintained through to the server, possibly a proxy or network device is forcing the use of HTTP 1.0 which is not efficient enough to run SimpleGateway, stalling for " + retryOnceHours + " hours...");
                }
                long retryOnce = System.currentTimeMillis() + 3600000L * retryOnceHours;
                while (true) {
                    if (System.currentTimeMillis() > retryOnce) {
                        SimpleGatewayService.logProblem("[" + date + "] Will retry again now and fail fast if issues are detected");
                        System.out.println("[" + date + "] Will retry again now and fail fast if issues are detected");
                        break;
                    }
                    Thread.sleep(600000L);
                    System.out.println("WARNING! Sockets are not being maintained to the server, possibly a proxy or network device is forcing the use of HTTP 1.0 which is not efficient enough to run SimpleGateway, exiting...");
                }
            }
        }

        private void simulateMachines() {
            long T = System.currentTimeMillis();
            if (multi_countries == null) {
                SimpleGatewayService.access$5802(Locale.getISOCountries());
                for (int i = 0; i < multi_countries.length; ++i) {
                    multi_countries[i] = new Locale("en", multi_countries[i]).getDisplayCountry();
                }
                System.out.println("[PollThread] Simulating machines from " + multi_countries.length + " countries");
            }
            int COMP = 0;
            block5: while (COMP < multi_count) {
                for (String multi_country : multi_countries) {
                    multi_name_override = multi_country + "/Region " + (1 + COMP % 100) + "/Computer " + (1 + COMP);
                    this.pingUDP();
                    ++COMP;
                    try {
                        if (multi_wait_each == 0L) {
                            if (COMP % 2 == 0) {
                                Thread.sleep(1L);
                            }
                        } else {
                            Thread.sleep(multi_wait_each);
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (COMP >= multi_count) continue block5;
                    if (TRACK_MULTI_UI != 0) continue;
                    if (multi_ui != null) {
                        multi_ui.setProgress(COMP, multi_count);
                    }
                    if (COMP % 10000 != 0) continue;
                    System.out.println("Simulated " + COMP + " of " + multi_count + " machines...");
                }
            }
            if (TRACK_MULTI_UI == 0 && multi_ui != null) {
                multi_ui.setProgress(multi_count, multi_count);
            }
            T = System.currentTimeMillis() - T;
            System.out.println("[PollThread] Simulated " + multi_count + " machines in " + T / 1000L + " seconds");
            this.verifyOrSetupSecureMessenger();
            try {
                Thread.sleep(multi_wait);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void handleConnectRequest(String MyID, String pkhashPortionHint, String requestedSessionID, String serverBuild, String JwRaVersion, String primaryServerURL, SecureMessenger secmsg) throws Exception {
            boolean updateRequired;
            boolean launchInSession;
            String targetServerAddress = this.serverAddress;
            if (primaryServerURL.length() > 0) {
                targetServerAddress = primaryServerURL;
            }
            URL url = new URL(targetServerAddress);
            String host = url.getHost();
            int port = url.getPort();
            if (port == -1) {
                port = targetServerAddress.toLowerCase().startsWith("https") ? 443 : 80;
            }
            Properties props = new Properties();
            if (Switches.SHFTP_doNotOverrideSgUpdateUrl) {
                props.setProperty("update_url", JWLaunchProperties.getProperty((String)"update_url"));
            } else {
                props.setProperty("update_url", targetServerAddress);
                if (targetServerAddress.toLowerCase().startsWith("https")) {
                    props.setProperty("update_url", "https://" + host + ":" + port + "/access");
                } else {
                    props.setProperty("update_url", "http://" + host + ":" + port + "/access");
                }
            }
            props.setProperty("match_versions", "true");
            boolean isAutoRestart = "ACTIVITY_RESTART_SERVICE".equals(MyID);
            props.setProperty("launch_in_session", "false");
            props.setProperty("launch_in_specific_session", "false");
            try {
                BasicInfo basicInfo = BasicInfo.getBasicInfo();
                if (basicInfo.memoryTotalBytes >= 0x40000000L) {
                    props.setProperty("xmx_override", "512");
                }
            }
            catch (Throwable t) {
                System.out.println("[SimpleGatewayService] Unable to adjust Xmx.");
                t.printStackTrace();
            }
            boolean bl = launchInSession = OS.isWindowsVistaOrAbove() && !isAutoRestart;
            if (Switches.SH_1509_XP_RDP_SUPPORT) {
                boolean bl2 = launchInSession = OS.isWindows() && !isAutoRestart;
            }
            if (launchInSession) {
                if (requestedSessionID != null) {
                    props.setProperty("launch_in_specific_session", requestedSessionID);
                } else {
                    props.setProperty("launch_in_session", "true");
                }
            }
            props.setProperty("AutomaticCustomerHost", host);
            props.setProperty("AutomaticCustomerPort", Integer.toString(port));
            props.setProperty("AutomaticCustomerID", MyID);
            if (config.sessionsRequirePermission) {
                props.setProperty("AutomaticCustomerRequest", Boolean.toString(true));
                long timeout = config.getRequirePermissionTimeoutMS();
                if (timeout > 0L) {
                    props.setProperty("AutomaticCustomerRequestTimeout", Long.toString(timeout));
                }
            }
            if (pkhashPortionHint.length() == 0) {
                System.out.println("[SGLaunch] No pubkey hash hint specified, fetching required key from the server direct");
                URL hashUrl = targetServerAddress.toLowerCase().startsWith("https") ? new URL("https://" + host + ":" + port + "/pubkeyhash") : new URL("http://" + host + ":" + port + "/pubkeyhash");
                try (InputStream in = hashUrl.openStream();){
                    pkhashPortionHint = StreamUtils.readAllAsStringUTF8(in);
                    System.out.println("[SGLaunch] Got pkhash hint from server direct");
                }
            }
            if (hashRepository.getNumberOfHashes() == 0) {
                props.setProperty("shpkhash", "");
            } else {
                String fullHash = this.setTrustedBasedOnPubkeyHashPortion(pkhashPortionHint);
                if (fullHash == null) {
                    throw new Exception("Unable to verify authenticity of server to start a connection (not found: ..." + pkhashPortionHint + ")");
                }
                props.setProperty("shpkhash", fullHash);
            }
            props.setProperty("force_spawn", "true");
            if (serverBuild == null) {
                serverBuild = "";
            }
            String prelaunchedVersion = "";
            try {
                Properties preps = JWSystem.getPreparedForkProperties();
                if (preps != null) {
                    prelaunchedVersion = preps.getProperty("launch_expect_appversion");
                }
            }
            catch (Exception x) {
                x.printStackTrace();
            }
            System.out.println("[SGPreload] Recent preload verison is [" + prelaunchedVersion + "] vs required [" + JwRaVersion + "]");
            if (prelaunchedVersion.equals("") || !prelaunchedVersion.equals(JwRaVersion)) {
                System.out.println("[SGPreload] Unable to use preload (version " + prelaunchedVersion + " != required " + JwRaVersion + "), must start from new");
                if (LocalSwitches.DEV_acculogSessionLaunch) {
                    Acculog.log("[RA Service] Unable to use preloaded process, clearing it now");
                }
                JWSystem.clearPreparedFork();
            }
            if (JWSystem.getSpecificVersionAppFolder((String)JwRaVersion) == null) {
                System.out.println("[SGLaunch] Specified version " + JwRaVersion + " does not exist, will need to update");
                updateRequired = true;
            } else {
                System.out.println("[SGLaunch] Specified version " + JwRaVersion + " Exists, no need to update");
                updateRequired = false;
            }
            SHMemoryPolicy.applyCustomerSessionPolicy(props);
            if (LocalSwitches.DEV_acculogSessionLaunch) {
                Acculog.log("[RA Service] Forking session process now");
            }
            JWSystem.forkVirtualApp((String)"Remote Access Session", (String)"D", (Properties)props, (String[])new String[0], (boolean)false, (boolean)true);
            if (Switches.SH_XXXX_tellServerIfUpdateOnSgSession && updateRequired) {
                new TellServerUpdating(secmsg).start();
            }
            try {
                Thread.sleep(2000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!updateRequired || !Switches.SH_XXXX_noPreloadIfUpdateOnSgSession) {
                System.out.println("[SGPreload] No update required, will launch preloaded copy shortly");
                new WaitThenPreload(new int[]{4000}, JwRaVersion, serverBuild, "Remote Access Session", "D", props, new String[0], false, true).start();
            } else {
                System.out.println("[SGPreload] Update required, will not launch preloaded copy");
            }
        }

        class ClaimThread
        extends Thread {
            ClaimThread() {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                        DDLog.log(PollThread.this.udpOrHttpServerURL, "Verifying Secure Messaging is set up");
                    }
                    if (!PollThread.this.verifySecureMessengerNow(PollThread.this.udpOrHttpServerURL, "claim thread") && PollThread.this.canSetupSecureMessengerNow("SecMsg verification failed")) {
                        if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                            DDLog.log(PollThread.this.udpOrHttpServerURL, "Secure Messaging is NOT set up, will set up now");
                        }
                        System.out.println("[SimpleGatewayService] Renegotiating security for " + PollThread.this.udpOrHttpServerURL);
                        new SecureMessengerSetup(PollThread.this.masterid.getID(), PollThread.this.udpOrHttpServerURL, PollThread.this.serverLossyTransport, PollThread.this.masterid).start();
                    }
                }
                finally {
                    Object object = PollThread.this.claims_LOCK;
                    synchronized (object) {
                        PollThread.this.claims.remove(this);
                    }
                }
            }
        }

        class SecureMessengerSetup
        extends Thread {
            final String mySgMachineID;
            String serverID;
            final LossyTransport server;
            final SimpleGatewayID masterid;

            SecureMessengerSetup(String mySgMachineID, String serverID, LossyTransport server, SimpleGatewayID masterid) {
                this.mySgMachineID = mySgMachineID;
                this.serverID = serverID;
                this.server = server;
                this.masterid = masterid;
                if (SIMULATE_MULTIPLE_MACHINES) {
                    this.serverID = serverID + "_" + (int)(Math.random() * 1000000.0);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                block33: {
                    PollThread.this.secmsg = SecureMessengerDB.loadSecureMessenger(this.serverID, lossyclient, this.server, new SecureMessengerHandler(this.masterid));
                    if (PollThread.this.secmsg == null) {
                        String recKey;
                        System.out.println("[SecMsg] Creating new SecMsg for " + this.serverID + " since none found");
                        if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                            DDLog.log(PollThread.this.udpOrHttpServerURL, "Creating a new Secure Messenger");
                        }
                        Object object = config_LOCK;
                        synchronized (object) {
                            recKey = config.getUrlRecoveryKey(PollThread.this.udpOrHttpServerURL);
                            System.out.println("[SecMsg] Reckey (" + PollThread.this.udpOrHttpServerURL + ") " + recKey);
                        }
                        BCUtil bcu = new BCUtil();
                        if (hashRepository != null) {
                            bcu.setValidHashRequired(hashRepository.containsURL(PollThread.this.udpOrHttpServerURL));
                        }
                        if (recKey != null) {
                            System.out.println("[SecMsg] Recovery allowed");
                            bcu.setClientRsaKeyPairHash((BCUtil.PublicKeyHashProvider)hashRepository, this.masterid.getID(), recKey);
                        } else {
                            System.out.println("[SecMsg] Recovery not allowed");
                            bcu.setClientRsaKeyPairHashNoRecovery((BCUtil.PublicKeyHashProvider)hashRepository);
                        }
                        try {
                            PollThread.this.secmsg = SecureMessenger.createSecureMessengerAsClient(bcu, lossyclient, this.server, this.serverID, new SecureMessengerHandler(this.masterid), this.mySgMachineID);
                            if (OS.isMacOS()) {
                                System.out.println("[SimpleGatewayService] Setting permissions for new secmsg files");
                                try {
                                    JWGenericOS.setWritableForAllUsers((File)secmsgDB, (boolean)true);
                                }
                                catch (IOException e) {
                                    e.printStackTrace();
                                }
                            }
                            if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                                DDLog.log(PollThread.this.udpOrHttpServerURL, "Created Secure Messenger OK");
                            }
                            boolean savePkhash = false;
                            String conditions = "required";
                            if (!bcu.wasValidHashRequired()) {
                                conditions = "not required";
                            }
                            if (bcu.wasRecoveryRequired()) {
                                conditions = conditions + ", recovered";
                            }
                            hashRepository.addURL(PollThread.this.udpOrHttpServerURL, "Successful BCU handshake (" + conditions + ")");
                            hashRepository.addHash(bcu.getSavedPublicKeyAuthHash(), "Successful BCU handshake (" + conditions + ")");
                            System.out.println("[SecMsg] SecMsg successfully negotiated for " + this.serverID + ", will claim or verify ID on this server (" + PollThread.this.secmsg + ")");
                            Object object2 = tracking_LOCK;
                            synchronized (object2) {
                                tracking_secMsgSetups++;
                            }
                            if (TRACK_MULTI_UI == 1 && multi_ui != null) {
                                multi_ui.setProgress(tracking_secMsgSetups, multi_count);
                                System.out.println("Simulated " + tracking_secMsgSetups + " SecMsg setups...");
                            }
                        }
                        catch (BCUtil.ServerAuthenticityException x) {
                            System.out.println("[SecMsg] Unable to negotiate new SecMsg with server " + this.serverID + " - " + (Object)((Object)x));
                            if (Switches.SH_1751_verifyServerAuthenticityUsingSslAlso && System.currentTimeMillis() > PollThread.this.nextSslVerificationAttempt) {
                                System.out.println("Attempting to verify over HTTPS now");
                                PollThread.this.nextSslVerificationAttempt = 8L * Times.ONE_HOUR + (long)(Math.random() * (double)(8L * Times.ONE_HOUR));
                                try {
                                    URLParser parser = new URLParser(PollThread.this.udpOrHttpServerURL);
                                    if (parser.getHostname() == null) {
                                        System.out.println("Unable to verify over HTTPS, server URL does not seem valid? " + PollThread.this.udpOrHttpServerURL);
                                        break block33;
                                    }
                                    String serverURL = "https://" + parser.getHostname() + ":" + parser.getPort(true);
                                    serverURL = serverURL + "/pubkeyhash";
                                    System.out.println("Will query " + serverURL);
                                    URL url = new URL(serverURL);
                                    String serverhost = url.getHost();
                                    try (InputStream in = url.openStream();){
                                        String pubkeyhash = StreamUtils.readAllAsStringUTF8(in);
                                        System.out.println("Verified server, got hash of " + pubkeyhash);
                                        hashRepository.addHash(pubkeyhash, "Validated via SSL");
                                        break block33;
                                    }
                                }
                                catch (Exception xx) {
                                    xx.printStackTrace();
                                }
                                break block33;
                            }
                            System.out.println("[SecMsg] Waiting until " + new Date(PollThread.this.nextSslVerificationAttempt) + " before attempting SSL verificiation");
                        }
                        catch (ServerNotRespondingException x) {
                            System.out.println("[SecMsg] Unable to negotiate new SecMsg with server " + this.serverID + " - server would not respond, may be too old");
                        }
                        catch (Exception x) {
                            System.out.println("[SecMsg] Unable to negotiate new SecMsg with server " + this.serverID + " - " + x);
                            x.printStackTrace();
                        }
                    } else {
                        System.out.println("[SecMsg] Existing SecMsg found for " + this.serverID);
                        if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                            DDLog.log(PollThread.this.udpOrHttpServerURL, "Existing Secure Messenger found, will verify");
                        }
                    }
                }
                System.out.println("[SimpleGatewayService] Trying to claim ID " + this.masterid.id + " on " + this.serverID + "...");
                PollThread.this.verifySecureMessengerNow(this.serverID, "post sm-setup");
                if (PollThread.this.secmsg != null) {
                    if (CentralDebugging.DDEBUG_PROXYSERVER_MONITORING) {
                        DDLog.log(PollThread.this.udpOrHttpServerURL, "Sending Basic Info now immediately after new successful Secure Messenger setup");
                    }
                    PollThread.this.sendBasicInfo(SimpleGatewayService.getNameFromConfigWithLock());
                    PollThread.this.sendHardwareDetailsIfChanged();
                    PollThread.this.sendNetworkIfChanged();
                    PollThread.this.sendOSInfoIfChanged();
                    PollThread.this.sendAlertClock(PollThread.this.getMyAlertRegistry());
                }
            }
        }
    }

    static class SessionsTracker
    extends Thread {
        long exitAt = System.currentTimeMillis() + SimpleGatewayService.access$2300();

        SessionsTracker() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    Thread.sleep(10000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Object object = sessionTracking_LOCK;
                synchronized (object) {
                    if (FileLockUtil.isFileCurrentlyLocked((File)AutomaticCustomer.getSessionTrackerLockFile())) {
                        this.exitAt = System.currentTimeMillis() + TRACK_SESSIONS_AND_EXIT_MIN_ZERO_TIME;
                    } else if (System.currentTimeMillis() > this.exitAt) {
                        System.out.println("[SessionsTracker] Zero sessions for minimum wait period, stopping service and exiting...");
                        this.removeOSService();
                        try {
                            Thread.sleep(3000L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        System.exit(0);
                    }
                }
            }
        }

        private void removeOSService() {
            try {
                File parentDirectory = JWSystem.getAllAppVersionsSharedFolder();
                File targetDirectory = new File(parentDirectory, "SimpleGatewayService");
                File starter = JWSystem.getLauncherLocationForVirtualApp((File)targetDirectory, (String)"SimpleGatewayService");
                File stopper = JWSystem.getLauncherLocationForVirtualApp((File)targetDirectory, (String)"StopSimpleGatewayService");
                Properties lprops = new Properties();
                if (OS.isWindows()) {
                    lprops.setProperty(ManageRemoteAccessService.PROPERTY_START_LAUNCHER_PATH, "\"" + starter.getCanonicalPath() + "\"");
                    lprops.setProperty(ManageRemoteAccessService.PROPERTY_STOP_LAUNCHER_PATH, "\"" + stopper.getCanonicalPath() + "\"");
                } else {
                    lprops.setProperty(ManageRemoteAccessService.PROPERTY_START_LAUNCHER_PATH, starter.getCanonicalPath());
                    lprops.setProperty(ManageRemoteAccessService.PROPERTY_STOP_LAUNCHER_PATH, stopper.getCanonicalPath());
                }
                SGServiceInstallationManager.initManageServiceVirtualApp(lprops, ManageRemoteAccessService.VALUE_ACTION_REMOVE, null);
            }
            catch (Throwable t) {
                System.out.println("[SessionsTracker] Unable to stop service (" + t + ")");
                t.printStackTrace();
            }
        }
    }

    static class TestCommandThread
    extends Thread {
        final JWSockIPC ipc;

        TestCommandThread(JWSockIPC ipc) {
            this.ipc = ipc;
        }

        @Override
        public void run() {
            InputStream in = this.ipc.getInChannel((short)0);
            OutputStream out = this.ipc.getOutChannel((short)0);
            while (true) {
                try {
                    while (true) {
                        String command = DataUtils.readNStringUTF8(in, 10000);
                        System.out.println("[RA Testing] Incoming command " + command);
                        if (command.equals("COM_RA_START")) {
                            SimpleGatewayService.testStartPolling();
                        } else if (command.equals("COM_RA_STOP")) {
                            SimpleGatewayService.testStopPolling();
                        } else if (command.equals("COM_RA_CYCLE")) {
                            test_POLLING_CYCLE = true;
                        } else if (command.equals("COM_RA_NOCYCLE")) {
                            test_POLLING_CYCLE = false;
                        } else if (command.equals("COM_RA_RENEGOTIATE")) {
                            SimpleGatewayService.testRenegotiate();
                        } else if (command.equals("COM_RA_KILL_HTTP")) {
                            SimpleGatewayService.testKillHttpSocket();
                        } else if (command.equals("COM_RA_NOOP")) {
                            // empty if block
                        }
                        DataUtils.writeStringUTF8(out, "COM_OK");
                        out.flush();
                    }
                }
                catch (Exception x) {
                    x.printStackTrace();
                    System.out.println("[RA Testing] Test command finished, EXITING NOW");
                    System.exit(0);
                    continue;
                }
                break;
            }
        }
    }

    private static class WinFwFilter
    implements FWFilter {
        private WinFwFilter() {
        }

        @Override
        public boolean allow(File f) {
            String name = f.getName().toLowerCase();
            if (name.contains("pack200")) {
                return false;
            }
            if (name.equals("simpleservice.exe")) {
                return false;
            }
            return !name.equals("ssvagent.exe");
        }
    }

    static class LivenessUpdater
    extends Thread {
        LivenessUpdater() {
            this.start();
        }

        @Override
        public void run() {
            while (true) {
                try {
                    SimpleGatewayService.updateLivenessFile();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (Exception exception) {
                }
            }
        }
    }

    static class ExitThread
    extends Thread {
        final ServerSocket ssock;

        ExitThread(ServerSocket ssock) {
            super("ExitThread");
            this.ssock = ssock;
        }

        @Override
        public void run() {
            try {
                while (true) {
                    Socket sock = this.ssock.accept();
                    new ExitRequestThread(sock).start();
                }
            }
            catch (OutOfMemoryError x) {
                try {
                    Thread.sleep(3000L);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                System.exit(0);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static class MonitoringKiller
    implements Runnable {
        private MonitoringKiller() {
        }

        @Override
        public void run() {
            try {
                System.out.println("[Shutdown] Shutting down monitoring...");
                monitoring.setOn(config, false, broadcast);
            }
            catch (Exception x) {
                x.printStackTrace();
            }
        }
    }

    private static class PollThreadKiller
    implements Runnable {
        private PollThreadKiller() {
        }

        @Override
        public void run() {
            System.out.println("[Shutdown] Shutting down pollthreads...");
            for (PollThread pt : pollThreads) {
                pt.sendShutdownNotify();
            }
        }
    }

    static class ExitRequestThread
    extends Thread {
        final Socket ssock;

        ExitRequestThread(Socket ssock) {
            super("ExitRequestThread");
            this.ssock = ssock;
        }

        @Override
        public void run() {
            block15: {
                try {
                    if (this.ssock.getInetAddress().isAnyLocalAddress() || this.ssock.getInetAddress().isSiteLocalAddress() || this.ssock.getInetAddress().isLinkLocalAddress() || this.ssock.getInetAddress().isLoopbackAddress()) {
                        InputStream in = this.ssock.getInputStream();
                        String s = StreamUtils.readNStringISO88591(in, 10000);
                        OutputStream out = this.ssock.getOutputStream();
                        if (s.equalsIgnoreCase("SimpleGatewayService:Shutdown")) {
                            System.out.println("[SimpleGatewayService] Shutdown request received.");
                            StreamUtils.writeStringISO88591(out, "SimpleGatewayService:OK");
                            out.flush();
                            try {
                                SimpleGatewayService.runRunnableAndWaitFor(new MonitoringKiller(), 5000);
                            }
                            catch (Throwable t) {
                                t.printStackTrace();
                            }
                            try {
                                SimpleGatewayService.runRunnableAndWaitFor(new PollThreadKiller(), 2000);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            try {
                                System.out.println("[Shutdown] Finished.");
                                Thread.sleep(3000L);
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            System.exit(0);
                        } else if (s.equalsIgnoreCase("SimpleGatewayService:CAD")) {
                            CadPolicyAllower.tryForceAllowSAS();
                            REAL_STDOUT.println("\nSG_SERVICE_DO_CAD_NOW");
                            REAL_STDOUT.flush();
                            StreamUtils.writeStringISO88591(out, "SimpleGatewayService:OK");
                            out.flush();
                            Thread.sleep(3000L);
                        }
                        this.ssock.close();
                        break block15;
                    }
                    System.out.println("Connection from a non-local socket (" + this.ssock.getInetAddress() + ") - closing");
                    this.ssock.close();
                }
                catch (OutOfMemoryError x) {
                    try {
                        Thread.sleep(3000L);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    System.exit(0);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

