/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sgateway;

import bcutil.BCUtil;
import com.aem.nodelink.utils.DataUtils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import jwrapper.jwutils.JWGenericOS;
import jwrapper.jwutils.JWSystem;
import utils.encryption.aes.RijndaelDecryptionStream;
import utils.encryption.aes.RijndaelEncryptionStream;
import utils.files.AtomicFileOutputStream;
import utils.ostools.OS;

public class SimpleGatewayID {
    private static int VER = 0;
    Long id;
    Long auth1;
    Long auth2;
    boolean isNew;
    String stringID;

    public String getID() {
        if (this.stringID == null) {
            this.stringID = "SG_" + this.id;
        }
        return this.stringID;
    }

    public static String getID(long machineID) {
        return "SG_" + machineID;
    }

    public static long getLong(String id) {
        return Long.parseLong(id.substring(3));
    }

    public boolean isNew() {
        return this.isNew;
    }

    public static final File getFileLocation() {
        System.out.println("[SimpleGatewayID] Retrieving ID file location");
        File parent = JWSystem.getAllAppVersionsSharedFolder();
        if (parent == null) {
            return new File("serviceid.dat");
        }
        return new File(parent, "serviceid.dat");
    }

    public static final File getLockFileLocation() {
        System.out.println("[SimpleGatewayID] Retrieving ID lock file location");
        File parent = JWSystem.getAllAppVersionsSharedFolder();
        if (parent == null) {
            return new File("serviceid.lock");
        }
        return new File(parent, "serviceid.lock");
    }

    public void resetToFakeID() {
        this.id = new Long(BCUtil.getSecureRandom().nextLong());
        this.auth1 = new Long(BCUtil.getSecureRandom().nextLong());
        this.auth2 = new Long(BCUtil.getSecureRandom().nextLong());
        this.stringID = null;
    }

    public void resetToNewID() throws IOException {
        this.id = new Long(BCUtil.getSecureRandom().nextLong());
        this.auth1 = new Long(BCUtil.getSecureRandom().nextLong());
        this.auth2 = new Long(BCUtil.getSecureRandom().nextLong());
        this.stringID = null;
        File f = SimpleGatewayID.getFileLocation();
        String KEY = "&*&^%DS*gdyuasgeyu1g3iuy12gi7bG*&^%&^%00129djdbavs,msg3u14yy9783ndocmla..lrh2u3rhhhhh";
        AtomicFileOutputStream fout = new AtomicFileOutputStream(f);
        RijndaelEncryptionStream bfout = new RijndaelEncryptionStream((OutputStream)new BufferedOutputStream((OutputStream)fout), KEY);
        DataUtils.writeInt((OutputStream)bfout, VER);
        DataUtils.writeLong((OutputStream)bfout, this.id);
        DataUtils.writeLong((OutputStream)bfout, this.auth1);
        DataUtils.writeLong((OutputStream)bfout, this.auth2);
        bfout.flush();
        bfout.close();
        System.out.println("[SimpleGatewayID] Newly RESET ID is " + this.getID());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long loadOnlyID(File sgid) throws IOException {
        String KEY = "&*&^%DS*gdyuasgeyu1g3iuy12gi7bG*&^%&^%00129djdbavs,msg3u14yy9783ndocmla..lrh2u3rhhhhh";
        if (sgid.exists()) {
            FileInputStream fin = null;
            AtomicFileOutputStream.prepareForReading((File)sgid);
            try {
                long id;
                fin = new FileInputStream(sgid);
                RijndaelDecryptionStream bfin = new RijndaelDecryptionStream((InputStream)new BufferedInputStream(fin), KEY);
                DataUtils.readInt((InputStream)bfin);
                long l = id = DataUtils.readLong((InputStream)bfin);
                return l;
            }
            finally {
                try {
                    fin.close();
                }
                catch (Exception exception) {}
            }
        }
        throw new IOException("Unable to load SGID from " + sgid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SimpleGatewayID loadOrCreate(boolean forceNew) throws IOException {
        File f = SimpleGatewayID.getFileLocation();
        String KEY = "&*&^%DS*gdyuasgeyu1g3iuy12gi7bG*&^%&^%00129djdbavs,msg3u14yy9783ndocmla..lrh2u3rhhhhh";
        SimpleGatewayID id = new SimpleGatewayID();
        if (f.exists() && !forceNew) {
            System.out.println("[SimpleGatewayID] Loading ID");
            id.isNew = false;
            FileInputStream fin = null;
            try {
                AtomicFileOutputStream.prepareForReading((File)f);
                fin = new FileInputStream(f);
                RijndaelDecryptionStream bfin = new RijndaelDecryptionStream((InputStream)new BufferedInputStream(fin), KEY);
                DataUtils.readInt((InputStream)bfin);
                id.id = DataUtils.readLong((InputStream)bfin);
                id.auth1 = DataUtils.readLong((InputStream)bfin);
                id.auth2 = DataUtils.readLong((InputStream)bfin);
                fin.close();
            }
            catch (Throwable x) {
                try {
                    fin.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                System.out.println("[SimpleGatewayID] Unexpected problem reading ID, will create new: " + x);
                x.printStackTrace();
                return SimpleGatewayID.loadOrCreate(true);
            }
        }
        System.out.println("[SimpleGatewayID] Creating new ID (" + forceNew + ")");
        id.isNew = true;
        id.id = new Long(BCUtil.getSecureRandom().nextLong());
        id.auth1 = new Long(BCUtil.getSecureRandom().nextLong());
        id.auth2 = new Long(BCUtil.getSecureRandom().nextLong());
        AtomicFileOutputStream fout = new AtomicFileOutputStream(f);
        RijndaelEncryptionStream bfout = new RijndaelEncryptionStream((OutputStream)new BufferedOutputStream((OutputStream)fout), KEY);
        try {
            DataUtils.writeInt((OutputStream)bfout, VER);
            DataUtils.writeLong((OutputStream)bfout, id.id);
            DataUtils.writeLong((OutputStream)bfout, id.auth1);
            DataUtils.writeLong((OutputStream)bfout, id.auth2);
        }
        finally {
            bfout.flush();
            bfout.close();
        }
        if (OS.isMacOS()) {
            System.out.println("[SimpleGatewayService] Setting permissions for service id");
            try {
                JWGenericOS.setWritableForAllUsers((File)f, (boolean)true);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        System.out.println("[SimpleGatewayID] ID is " + id.getID());
        return id;
    }
}

