/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sgateway;

import com.aem.sgateway.ManageRemoteAccessService;
import com.aem.sgateway.SGHttpsUtil;
import com.aem.sgateway.SimpleGatewayConfig;
import com.aem.sgateway.SimpleGatewayServiceConfigure;
import com.aem.sgateway.UninstallRemoteAccessService;
import com.aem.shelp.common.Language;
import com.aem.shelp.common.SGParameters;
import com.aem.shelp.util.ErrorDialogs;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Properties;
import javax.swing.RootPaneContainer;
import jwrapper.JWParameteriser;
import jwrapper.jwutils.JWGenericOS;
import jwrapper.jwutils.JWInstallApp;
import jwrapper.jwutils.JWSystem;
import jwrapper.jwutils.JWUninstallApp;
import jwrapper.logging.ProcessResult;
import jwrapper.updater.JWLaunchProperties;
import utils.files.PermissionsUtil;
import utils.message.Message;
import utils.message.mappedfile.MFMessageHandler;
import utils.message.mappedfile.MessageHandler;
import utils.ostools.OS;
import utils.stream.MappedChannel;
import utils.string.HexData;
import utils.string.StringUtil;

public class SGServiceInstallationManager {
    private static final Object INSTALL_REMOVE_LOCK = new Object();
    private static boolean serviceInstallUninstallResult;
    private static boolean serviceRunning;

    public static boolean isServiceRunning() {
        return serviceRunning;
    }

    public static void setServiceRunning(boolean running) {
        serviceRunning = running;
    }

    private static boolean isSilentInstall(String[] args) {
        if (SGServiceInstallationManager.isSilentUninstall(args)) {
            return false;
        }
        for (String arg : args) {
            if (!arg.equalsIgnoreCase("silent") && !arg.equalsIgnoreCase("/S")) continue;
            return true;
        }
        return false;
    }

    private static boolean isSilentUninstall(String[] args) {
        if (JWSystem.getAppLaunchProperty((String)"sg_silent_uninstall").equalsIgnoreCase("true")) {
            System.out.println("[SimpleGatewayServiceConfigure] Silent uninstall (launch properties)");
            return true;
        }
        for (String arg : args) {
            if (!arg.equalsIgnoreCase("uninstall")) continue;
            return true;
        }
        return false;
    }

    private static boolean getBooleanValue(String val) {
        return val.equalsIgnoreCase("yes") || val.equalsIgnoreCase("on") || Boolean.parseBoolean(val);
    }

    public static void main(String[] args) {
        SGServiceInstallationManager.getSilentInstallConfig(new String[]{"/S", "/NAME=AUTODETECT", "/CONFIRM_TIMEOUT=1000"});
    }

    private static SilentInstallConfig getSilentInstallConfig(String[] args) {
        if (SGServiceInstallationManager.isSilentInstall(args)) {
            System.out.println("[SimpleGatewayServiceConfigure] Silent install (command line args)");
            SilentInstallConfig result = new SilentInstallConfig();
            result.silentInstallConfig = new SimpleGatewayConfig();
            String siName = null;
            String siHost = null;
            String siPassword = null;
            String siProxyHost = null;
            String siProxyPort = null;
            String siProxyUsername = null;
            String siProxyPassword = null;
            String siMonitor = null;
            String siScript = null;
            String siConfirm = null;
            long siConfirmTimeout = 0L;
            String siShortcuts = null;
            for (int i = 1; i < args.length; ++i) {
                String key;
                System.out.println("[SimpleGatewayServiceConfigure] ARG " + i + " [" + args[i] + "]");
                int eq = args[i].indexOf(61);
                if (eq != -1) {
                    key = args[i].substring(0, eq);
                    String value = args[i].substring(eq + 1);
                    if (key.startsWith("/")) {
                        key = key.substring(1);
                    }
                    if (key.equalsIgnoreCase("NAME")) {
                        siName = value;
                        continue;
                    }
                    if (key.equalsIgnoreCase("HOST")) {
                        siHost = value;
                        continue;
                    }
                    if (key.equalsIgnoreCase("PASSWORD")) {
                        siPassword = value;
                        continue;
                    }
                    if (key.equalsIgnoreCase("PROXYPORT")) {
                        siProxyPort = value;
                        continue;
                    }
                    if (key.equalsIgnoreCase("PROXYHOST")) {
                        siProxyHost = value;
                        continue;
                    }
                    if (key.equalsIgnoreCase("PROXYUSERNAME")) {
                        siProxyUsername = value;
                        continue;
                    }
                    if (key.equalsIgnoreCase("PROXYPASSWORD")) {
                        siProxyPassword = value;
                        continue;
                    }
                    if (key.equalsIgnoreCase("MONITOR")) {
                        siMonitor = value;
                        continue;
                    }
                    if (key.equalsIgnoreCase("SCRIPT")) {
                        siScript = value;
                        continue;
                    }
                    if (key.equalsIgnoreCase("CONFIRM")) {
                        siConfirm = value;
                        continue;
                    }
                    if (key.equalsIgnoreCase("SHORTCUTS")) {
                        siShortcuts = value;
                        continue;
                    }
                    if (!key.equalsIgnoreCase("CONFIRM_TIMEOUT")) continue;
                    try {
                        siConfirmTimeout = Long.parseLong(value);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        siConfirmTimeout = 0L;
                    }
                    continue;
                }
                key = args[i];
                if (key.startsWith("/")) {
                    key = key.substring(1);
                }
                if (!key.equalsIgnoreCase("NOSHORTCUTS")) continue;
                result.installShortcuts = false;
            }
            if (siName != null) {
                result.silentInstallConfig.setName(siName);
            }
            if (siHost != null) {
                if (siHost.indexOf(44) == -1) {
                    result.silentInstallConfig.setURLs(new String[]{siHost});
                } else {
                    result.silentInstallConfig.setURLs(siHost.split("\\,"));
                }
            } else {
                SimpleGatewayServiceConfigure.setDefaultHostname(result.silentInstallConfig);
            }
            if (siPassword != null) {
                result.silentInstallConfig.setPassword(siPassword);
            }
            if (siProxyHost != null) {
                result.silentInstallConfig.setProxyHost(siProxyHost);
                result.silentInstallConfig.setProxyPort(Integer.parseInt(siProxyPort));
            }
            if (siProxyUsername != null) {
                result.silentInstallConfig.setProxyUser(siProxyUsername);
            }
            if (siProxyPassword != null) {
                result.silentInstallConfig.setProxyPass(siProxyPassword);
            }
            if (siMonitor != null) {
                result.silentInstallConfig.setAllowMonitoring(SGServiceInstallationManager.getBooleanValue(siMonitor));
            }
            if (siScript != null) {
                result.silentInstallConfig.setAllowScripting(SGServiceInstallationManager.getBooleanValue(siScript));
            }
            if (siConfirm != null) {
                result.silentInstallConfig.setRequireSessionConfirmation(SGServiceInstallationManager.getBooleanValue(siConfirm), siConfirmTimeout);
            }
            if (siShortcuts != null) {
                result.installShortcuts = SGServiceInstallationManager.getBooleanValue(siShortcuts);
            }
            return result;
        }
        if (StringUtil.stringIsTrue((String)JWSystem.getAppLaunchProperty((String)"sg_silent_install"))) {
            String entireConfigXML = JWSystem.getAppLaunchProperty((String)"sg_silent_install_config_xml");
            if (entireConfigXML != null && entireConfigXML.length() > 0) {
                System.out.println("[SimpleGatewayServiceConfigure] Silent install (launch properties)");
                byte[] xml = HexData.hexStringToByteArray((String)JWSystem.getAppLaunchProperty((String)"sg_silent_install_config_xml"));
                try {
                    SilentInstallConfig result = new SilentInstallConfig();
                    result.silentInstallConfig = new SimpleGatewayConfig(xml);
                    result.installShortcuts = SGParameters.writeShortcuts();
                    return result;
                }
                catch (Exception x) {
                    x.printStackTrace();
                    return null;
                }
            }
            System.out.println("[SimpleGatewayServiceConfigure] Silent install (individual launch properties)");
            SilentInstallConfig result = new SilentInstallConfig();
            result.silentInstallConfig = new SimpleGatewayConfig();
            result.installShortcuts = SGParameters.writeShortcuts();
            SGParameters.updateSGConfigWithLaunchProperties(result.silentInstallConfig);
            return result;
        }
        return null;
    }

    public static void handleSilentInstall(String[] args) {
        SilentInstallConfig silentInstallConfig = SGServiceInstallationManager.getSilentInstallConfig(args);
        if (silentInstallConfig != null) {
            try {
                System.out.println("[SimpleGatewayServiceConfigure] Performing silent service install");
                System.out.println("[SimpleGatewayServiceConfigure] Using config " + new String(silentInstallConfig.silentInstallConfig.save(true), StandardCharsets.UTF_8));
                SGServiceInstallationManager.silentlyInstallService(silentInstallConfig.silentInstallConfig);
                System.out.println("[SimpleGatewayServiceConfigure] Silent service install finished");
                if (silentInstallConfig.installShortcuts) {
                    System.out.println("[SimpleGatewayServiceConfigure] Setting up install shortcuts");
                    SGServiceInstallationManager.silentlySetupShortcuts();
                } else {
                    System.out.println("[SimpleGatewayServiceConfigure] NOT setting up install shortcuts");
                    JWInstallApp.removeAllStandardShortcuts();
                    SGServiceInstallationManager.silentlySetupShortcuts(JWSystem.getAllAppVersionsSharedFolder());
                }
                System.out.println("[SimpleGatewayServiceConfigure] Silent install and config adjustments complete");
                System.exit(0);
            }
            catch (Exception x) {
                x.printStackTrace();
                System.exit(1);
            }
        }
    }

    public static void handleSilentUninstall(String[] args) {
        if (SGServiceInstallationManager.isSilentUninstall(args)) {
            try {
                ProcessResult processResult = UninstallRemoteAccessService.elevateProcessToRequestUninstall(null);
                System.out.println(processResult);
                System.out.println("[SimpleGatewayServiceConfigure] Silent uninstall complete");
                System.exit(0);
            }
            catch (Exception x) {
                x.printStackTrace();
                System.exit(1);
            }
        }
    }

    private static void silentlySetupShortcuts(File targetFolder) throws IOException {
        Properties lprops = JWLaunchProperties.getAsProperties();
        lprops.setProperty("show_no_ui", "false");
        SimpleGatewayServiceConfigure.stripSilentAndHeadlessInstallProperties(lprops);
        JWInstallApp.setupAllStandardShortcutsInFolder((boolean)true, (File)targetFolder);
        if (OS.isMacOS()) {
            System.out.println("[SimpleGatewayServiceConfigure] Setting up config launcher in /Applications");
            if (targetFolder == null) {
                JWSystem.saveLauncherShortcutForVirtualApp((File)new File("/Applications"), (String)"Remote Access Configure", (String)JWSystem.getMyAppName(), (Properties)lprops, (boolean)false);
            } else {
                JWSystem.saveLauncherShortcutForVirtualApp((File)targetFolder, (String)"Remote Access Configure", (String)JWSystem.getMyAppName(), (Properties)lprops, (boolean)false);
            }
        } else {
            System.out.println("[SimpleGatewayServiceConfigure] Overwriting default shortcut launcher with config launcher (vs silent install) launch properties");
            File deflauncher = JWInstallApp.getWindowsOrLinuxShortcutLauncherFile();
            JWParameteriser jwp = new JWParameteriser();
            jwp.setParameters(lprops, deflauncher, true);
        }
    }

    private static void silentlySetupShortcuts() throws IOException {
        SGServiceInstallationManager.silentlySetupShortcuts(null);
    }

    private static void silentlyInstallService(SimpleGatewayConfig config) throws Exception {
        String stopPath;
        String startPath;
        System.out.println("[SimpleGatewayServiceConfigure] Install service requested");
        File configFile = SimpleGatewayConfig.getConfigLocation().getAbsoluteFile();
        config.save(configFile, true);
        System.out.println("[SimpleGatewayServiceConfigure] Config saved");
        if (OS.isMacOS()) {
            System.out.println("[SimpleGatewayServiceConfigure] macOS - making config writable");
            JWGenericOS.setWritableForAllUsers((File)configFile, (boolean)true);
        }
        System.out.println("[SimpleGatewayServiceConfigure] Creating launcher");
        File targetDirectory = SGServiceInstallationManager.getServiceLauncherShortcutDirectory();
        File starter = SGServiceInstallationManager.getOrCreateSgServiceStartLauncher();
        File stopper = SGServiceInstallationManager.getOrCreateSgServiceStopLauncher();
        if (JWSystem.getUpdateURL().length() <= 1) {
            String url = config.getRawURLs()[0];
            System.out.println("[SimpleGatewayServiceConfigure] Overriding bundle update URL with " + url);
            JWSystem.overrideSourceLauncherUpdateURL((URL)SGServiceInstallationManager.getUpdateUrlFromShUrl(url));
        }
        System.out.println("[SimpleGatewayServiceConfigure] Installing SG service");
        if (OS.isWindows()) {
            startPath = "\"" + starter.getCanonicalPath() + "\"";
            stopPath = "\"" + stopper.getCanonicalPath() + "\"";
        } else {
            startPath = starter.getCanonicalPath();
            stopPath = stopper.getCanonicalPath();
        }
        ManageRemoteAccessService.installSgService(startPath, stopPath, targetDirectory.getCanonicalPath(), ManageRemoteAccessService.getLivenessFile());
        System.out.println("[SimpleGatewayServiceConfigure] Done installing SG service");
    }

    public static void stopRunningSGService() throws Exception {
        System.out.println("[SimpleGatewayServiceConfigure] Stopping running service now");
        Properties properties = new Properties();
        properties.setProperty("show_no_ui", "true");
        JWSystem.forkVirtualApp((String)"Stop Remote Access Service", (Properties)properties, null, (boolean)false, (boolean)false);
    }

    private static File getServiceLauncherShortcutDirectory() {
        File parentDirectory = JWSystem.getAllAppVersionsSharedFolder();
        File targetDirectory = new File(parentDirectory, "SimpleGatewayService");
        return targetDirectory;
    }

    private static File getOrCreateSgServiceStartLauncher() throws IOException {
        return SGServiceInstallationManager.getOrCreateSgServiceLauncher("SimpleGatewayService", "Remote Access Service");
    }

    private static File getOrCreateSgServiceStopLauncher() throws IOException {
        return SGServiceInstallationManager.getOrCreateSgServiceLauncher("StopSimpleGatewayService", "Stop Remote Access Service");
    }

    private static File getOrCreateSgServiceLauncher(String shortcutName, String vapp) throws IOException {
        File targetDirectory = SGServiceInstallationManager.getServiceLauncherShortcutDirectory();
        if (!targetDirectory.exists()) {
            targetDirectory.mkdirs();
            JWGenericOS.setWritableForAllUsers((File)targetDirectory, (boolean)true);
        }
        Properties serviceProperties = new Properties();
        serviceProperties.setProperty("show_no_ui", "true");
        if (OS.isWindows()) {
            serviceProperties.setProperty("force_spawn", "true");
        }
        System.out.println("[SimpleGatewayServiceConfigure] Creating " + shortcutName + " launcher shortcut for Remote Access Service virtual app (" + vapp + ")");
        File launcher = JWSystem.saveLauncherShortcutForVirtualApp((File)targetDirectory, (String)shortcutName, (String)vapp, (Properties)serviceProperties, (boolean)false);
        JWGenericOS.setReadableForAllUsers((File)launcher, (boolean)true);
        return launcher;
    }

    public static void silentlyUninstallService() throws Exception {
        System.out.println("[SimpleGatewayServiceConfigure] Uninstall service requested");
        File targetDirectory = SGServiceInstallationManager.getServiceLauncherShortcutDirectory();
        ManageRemoteAccessService.uninstallSgService(targetDirectory.getCanonicalPath());
    }

    public static void silentlyDeleteShortcuts() throws IOException {
        JWUninstallApp.removeAllStandardShortcuts((boolean)true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean installService(RootPaneContainer rpc) throws Exception {
        System.out.println("[SimpleGatewayServiceConfigure] Install service requested");
        File starter = SGServiceInstallationManager.getOrCreateSgServiceStartLauncher();
        File stopper = SGServiceInstallationManager.getOrCreateSgServiceStopLauncher();
        serviceInstallUninstallResult = false;
        Object object = INSTALL_REMOVE_LOCK;
        synchronized (object) {
            System.out.println("[SimpleGatewayServiceConfigure] Initialising manage service virtual app");
            Properties lprops = new Properties();
            if (OS.isWindows()) {
                lprops.setProperty(ManageRemoteAccessService.PROPERTY_START_LAUNCHER_PATH, "\"" + starter.getCanonicalPath() + "\"");
                lprops.setProperty(ManageRemoteAccessService.PROPERTY_STOP_LAUNCHER_PATH, "\"" + stopper.getCanonicalPath() + "\"");
            } else {
                lprops.setProperty(ManageRemoteAccessService.PROPERTY_START_LAUNCHER_PATH, starter.getCanonicalPath());
                lprops.setProperty(ManageRemoteAccessService.PROPERTY_STOP_LAUNCHER_PATH, stopper.getCanonicalPath());
            }
            SGServiceInstallationManager.initManageServiceVirtualApp(lprops, ManageRemoteAccessService.VALUE_ACTION_INSTALL, new ServiceMessageHandler(rpc));
            INSTALL_REMOVE_LOCK.wait(30000L);
        }
        if (serviceInstallUninstallResult) {
            serviceRunning = !serviceRunning;
        }
        return serviceInstallUninstallResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean removeService(RootPaneContainer rpc) throws Exception {
        serviceInstallUninstallResult = false;
        File targetDirectory = SGServiceInstallationManager.getServiceLauncherShortcutDirectory();
        File starter = JWSystem.getLauncherLocationForVirtualApp((File)targetDirectory, (String)"SimpleGatewayService");
        File stopper = JWSystem.getLauncherLocationForVirtualApp((File)targetDirectory, (String)"StopSimpleGatewayService");
        Object object = INSTALL_REMOVE_LOCK;
        synchronized (object) {
            Properties lprops = new Properties();
            if (OS.isWindows()) {
                lprops.setProperty(ManageRemoteAccessService.PROPERTY_START_LAUNCHER_PATH, "\"" + starter.getCanonicalPath() + "\"");
                lprops.setProperty(ManageRemoteAccessService.PROPERTY_STOP_LAUNCHER_PATH, "\"" + stopper.getCanonicalPath() + "\"");
            } else {
                lprops.setProperty(ManageRemoteAccessService.PROPERTY_START_LAUNCHER_PATH, starter.getCanonicalPath());
                lprops.setProperty(ManageRemoteAccessService.PROPERTY_STOP_LAUNCHER_PATH, stopper.getCanonicalPath());
            }
            SGServiceInstallationManager.initManageServiceVirtualApp(lprops, ManageRemoteAccessService.VALUE_ACTION_REMOVE, new ServiceMessageHandler(rpc));
            INSTALL_REMOVE_LOCK.wait(30000L);
        }
        if (serviceInstallUninstallResult) {
            serviceRunning = !serviceRunning;
        }
        return serviceInstallUninstallResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void restartService(RootPaneContainer rpc) throws Exception {
        File targetDirectory = SGServiceInstallationManager.getServiceLauncherShortcutDirectory();
        File starter = SGServiceInstallationManager.getOrCreateSgServiceStartLauncher();
        File stopper = SGServiceInstallationManager.getOrCreateSgServiceStopLauncher();
        Object object = INSTALL_REMOVE_LOCK;
        synchronized (object) {
            Properties lprops = new Properties();
            if (OS.isWindows()) {
                lprops.setProperty(ManageRemoteAccessService.PROPERTY_START_LAUNCHER_PATH, "\"" + starter.getCanonicalPath() + "\"");
                lprops.setProperty(ManageRemoteAccessService.PROPERTY_STOP_LAUNCHER_PATH, "\"" + stopper.getCanonicalPath() + "\"");
            } else {
                lprops.setProperty(ManageRemoteAccessService.PROPERTY_START_LAUNCHER_PATH, starter.getCanonicalPath());
                lprops.setProperty(ManageRemoteAccessService.PROPERTY_STOP_LAUNCHER_PATH, stopper.getCanonicalPath());
            }
            SGServiceInstallationManager.initManageServiceVirtualApp(lprops, ManageRemoteAccessService.VALUE_ACTION_REINSTALL_FORCED, new ServiceMessageHandler(rpc));
            INSTALL_REMOVE_LOCK.wait(60000L);
        }
    }

    public static void initManageServiceVirtualApp(Properties properties, String action, MessageHandler handler) throws Exception {
        File targetDirectory = SGServiceInstallationManager.getServiceLauncherShortcutDirectory();
        properties.setProperty(ManageRemoteAccessService.PROPERTY_ACTION, action);
        properties.setProperty(ManageRemoteAccessService.PROPERTY_SERVICE_DIR, targetDirectory.getCanonicalPath());
        properties.setProperty("show_no_ui", "true");
        File serverFile = File.createTempFile("managera", "server");
        serverFile.deleteOnExit();
        PermissionsUtil.setRecursiveFullPermissions((String)serverFile.getAbsolutePath());
        File clientFile = File.createTempFile("managera", "client");
        clientFile.deleteOnExit();
        PermissionsUtil.setRecursiveFullPermissions((String)clientFile.getAbsolutePath());
        properties.setProperty(ManageRemoteAccessService.PROPERTY_CHANNEL_SERVER, serverFile.getAbsolutePath());
        properties.setProperty(ManageRemoteAccessService.PROPERTY_CHANNEL_CLIENT, clientFile.getAbsolutePath());
        System.out.println("[SimpleGatewayServiceConfigure] Forking manage remote access service virtual app");
        JWSystem.forkVirtualApp((String)"Manage Remote Access Service", (Properties)properties, null, (boolean)true, (boolean)false);
        System.out.println("[SimpleGatewayServiceConfigure] Opening communication channel as server");
        MappedChannel openAsServer = MappedChannel.openAsServer((File)serverFile, (File)clientFile, (long)30000L);
        System.out.println("[SimpleGatewayServiceConfigure] Initialising message handler");
        new MFMessageHandler(openAsServer, handler);
    }

    public static URL getUpdateUrlFromShUrl(String shurl) throws MalformedURLException {
        if (shurl.startsWith("udp:")) {
            shurl = SGHttpsUtil.getRequiredHttpProtocol() + ":" + shurl.substring(4);
        }
        if (!shurl.endsWith("/")) {
            shurl = shurl + "/";
        }
        shurl = shurl + "access";
        return new URL(shurl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveConfig(SimpleGatewayConfig config, File configFile, RootPaneContainer rpc) throws Exception {
        serviceInstallUninstallResult = false;
        Object object = INSTALL_REMOVE_LOCK;
        synchronized (object) {
            Properties lprops = new Properties();
            lprops.setProperty(ManageRemoteAccessService.PROPERTY_CONFIG_FILE, configFile.getCanonicalPath());
            String hexData = HexData.byteArrayToHexString((byte[])config.save(true));
            lprops.setProperty(ManageRemoteAccessService.PROPERTY_CONFIG_FILE_XML, hexData);
            System.out.println("[SimpleGatewayServiceConfigure] Set config to: " + hexData);
            System.out.println("[SimpleGatewayServiceConfigure] Initialising manage service virtual app");
            SGServiceInstallationManager.initManageServiceVirtualApp(lprops, ManageRemoteAccessService.VALUE_ACTION_SAVECONFIG, new ServiceMessageHandler(rpc));
            INSTALL_REMOVE_LOCK.wait(30000L);
        }
    }

    static {
        serviceRunning = false;
    }

    static class ServiceMessageHandler
    implements MessageHandler {
        private RootPaneContainer rpc;

        public ServiceMessageHandler(RootPaneContainer rpc) {
            this.rpc = rpc;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message m) {
            switch (m.getType()) {
                case 655361: {
                    Object object = INSTALL_REMOVE_LOCK;
                    synchronized (object) {
                        serviceInstallUninstallResult = true;
                        INSTALL_REMOVE_LOCK.notify();
                        break;
                    }
                }
                case 655362: {
                    ErrorDialogs.ErrorGlassDialog egd;
                    boolean amInstalling;
                    String message = m.getAsString(0);
                    String details = m.getAsString(1);
                    boolean bl = amInstalling = !serviceRunning;
                    if (amInstalling) {
                        egd = new ErrorDialogs.ErrorGlassDialog(this.rpc, Language.get("SERVICE_INSTALL_TITLE"));
                        egd.setText(Language.get("ERROR_INSTALLING_SERVICE_HEADER"), message, details);
                    } else {
                        egd = new ErrorDialogs.ErrorGlassDialog(this.rpc, Language.get("SERVICE_INSTALL_TITLE"));
                        egd.setText(Language.get("ERROR_REMOVING_SERVICE_HEADER"), message, details);
                    }
                    egd.showDialog();
                    Object object = INSTALL_REMOVE_LOCK;
                    synchronized (object) {
                        serviceInstallUninstallResult = false;
                        INSTALL_REMOVE_LOCK.notify();
                        break;
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void closed() {
            Object object = INSTALL_REMOVE_LOCK;
            synchronized (object) {
                System.out.println("[ServiceMessageHandler] Closing channel");
                serviceInstallUninstallResult = false;
                INSTALL_REMOVE_LOCK.notify();
            }
        }
    }

    private static class SilentInstallConfig {
        boolean installShortcuts = true;
        SimpleGatewayConfig silentInstallConfig;

        private SilentInstallConfig() {
        }
    }
}

