/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.util.ui;

import java.awt.image.BufferedImage;
import java.util.HashMap;
import javax.swing.ImageIcon;
import utils.ostools.OS;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.images.ImageHelper;

public class AvatarMap {
    private static final HashMap<String, BufferedImage> usernameToImageMap = new HashMap();
    public static final int AVATAR_WIDTH = SimpleHelpLookAndFeel.scale((int)48);
    public static final int AVATAR_HEIGHT = SimpleHelpLookAndFeel.scale((int)48);
    public static final int AVATAR_BORDER_WIDTH = 1;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage getAvatarFor(String username) {
        System.out.println("[AvatarMap] Retrieving avatar for " + username);
        HashMap<String, BufferedImage> hashMap = usernameToImageMap;
        synchronized (hashMap) {
            return usernameToImageMap.get(username);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage setAvatar(String username, BufferedImage avatar) {
        System.out.println("[AvatarMap] Registering " + username + " avatar:" + (avatar != null));
        HashMap<String, BufferedImage> hashMap = usernameToImageMap;
        synchronized (hashMap) {
            return usernameToImageMap.put(username, avatar);
        }
    }

    public static ImageIcon getAvatarIconFor(String techUsername) {
        BufferedImage image = AvatarMap.getAvatarFor(techUsername);
        if (image != null) {
            return new ImageIcon(image);
        }
        return null;
    }

    public static BufferedImage getScaledAvatar(BufferedImage image) {
        int factor = 1;
        if (OS.isOSXRetina()) {
            factor = 2;
        }
        int iw = image.getWidth(null);
        int ih = image.getHeight(null);
        int widthBound = factor * (AVATAR_WIDTH - 2);
        int heightBound = factor * (AVATAR_HEIGHT - 2);
        widthBound = Math.max(0, widthBound);
        heightBound = Math.max(0, heightBound);
        if (widthBound == 0 || heightBound == 0) {
            return image;
        }
        if (widthBound < iw || heightBound < ih) {
            return ImageHelper.scaleDownToFitInside((BufferedImage)image, (int)widthBound, (int)heightBound, (boolean)false);
        }
        return image;
    }
}

