/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.util;

import com.aem.utils.multiplex.MultiplexerByteInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;

public class DualPrinter {
    private final ArrayList<PrintStream> targetStreams = new ArrayList();
    private final ArrayList<PrintStream> targetTimeStampedStreams = new ArrayList();
    private SimpleDateFormat sdf = new SimpleDateFormat("dd/MM HH:mm:ss.SSS: ");
    private final Object LOCK = new Object();
    private final Object NEW_DATA_LOCK = new Object();
    private final ArrayList<RePrinter> threads = new ArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTargetStream(PrintStream targetStream, boolean timestamp) {
        Object object = this.LOCK;
        synchronized (object) {
            if (timestamp) {
                this.targetTimeStampedStreams.add(targetStream);
            } else {
                this.targetStreams.add(targetStream);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeTargetStream(PrintStream targetStream) {
        Object object = this.LOCK;
        synchronized (object) {
            this.targetTimeStampedStreams.remove(targetStream);
            this.targetStreams.remove(targetStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputStream createNewOutputStream() {
        MultiplexerByteInputStream bin = new MultiplexerByteInputStream();
        ByteArrayInPrinter printer = new ByteArrayInPrinter(bin);
        RePrinter reprinter = new RePrinter(new BufferedReader(new InputStreamReader(bin)));
        reprinter.start();
        ArrayList<RePrinter> arrayList = this.threads;
        synchronized (arrayList) {
            this.threads.add(reprinter);
        }
        return printer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void die() {
        ArrayList<RePrinter> arrayList = this.threads;
        synchronized (arrayList) {
            for (RePrinter printer : this.threads) {
                printer.die();
            }
            this.threads.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushAll() {
        Object object = this.NEW_DATA_LOCK;
        synchronized (object) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    class ByteArrayInPrinter
    extends OutputStream {
        MultiplexerByteInputStream bin;

        public ByteArrayInPrinter(MultiplexerByteInputStream bin) {
            this.bin = bin;
        }

        @Override
        public void write(byte[] b) {
            this.bin.addData(b);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void write(byte[] b, int off, int len) {
            byte[] dat = new byte[len];
            System.arraycopy(b, off, dat, 0, len);
            Object object = DualPrinter.this.NEW_DATA_LOCK;
            synchronized (object) {
                this.bin.addData(dat);
            }
        }

        @Override
        public void write(int b) {
            this.bin.addData(new byte[]{(byte)b});
        }
    }

    public class RePrinter
    extends Thread {
        private BufferedReader bread;
        private boolean die;

        public RePrinter(BufferedReader bread) {
            super("RePrinter");
            this.die = false;
            this.bread = bread;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (!this.die) {
                    String s = this.bread.readLine();
                    Date date = new Date(System.currentTimeMillis());
                    if (s == null) {
                        return;
                    }
                    Object object = DualPrinter.this.LOCK;
                    synchronized (object) {
                        for (PrintStream printStream : DualPrinter.this.targetStreams) {
                            printStream.println(s);
                            printStream.flush();
                        }
                        for (PrintStream printStream : DualPrinter.this.targetTimeStampedStreams) {
                            printStream.print(DualPrinter.this.sdf.format(date) + s + "\r\n");
                            printStream.flush();
                        }
                    }
                }
                return;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }

        public void die() {
            this.die = true;
        }
    }
}

