/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.text.View;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.layout.GbPanel;
import utils.swing.utils.shadowlabel.ShadowLabelUI;

public class BlankDisplayBMPGenerator {
    public static void generateBitmapImage(File targetFile, String title, String message, ImageIcon image, Color background) throws IOException {
        System.out.println("[BlankDisplayBMPGenerator] Creating BMP...");
        GbPanel panel = new GbPanel();
        panel.setBackground(background);
        JLabel imageLabel = image != null ? new JLabel(image) : new JLabel();
        JLabel titleLabel = new JLabel(title);
        titleLabel.setUI(ShadowLabelUI.upShadowUI);
        titleLabel.setForeground(new Color(254, 254, 254));
        titleLabel.setFont(titleLabel.getFont().deriveFont(1, SimpleHelpLookAndFeel.scale((float)20.0f)));
        titleLabel.setHorizontalAlignment(0);
        JLabel messageLabel = new JLabel("<html><center>" + message + "</center></html>");
        messageLabel.setForeground(new Color(224, 224, 224));
        messageLabel.setFont(SHStyle.mediumFont);
        messageLabel.setHorizontalAlignment(0);
        panel.add((Component)imageLabel, 0, 0, 1, 1, 0, 0, 10, 2, (Insets)new ScaledInsets(0, 0, 20, 0));
        panel.add((Component)titleLabel, 0, 1, 1, 1, 1, 0, 10, 2, (Insets)new ScaledInsets(0, 0, 20, 0));
        panel.add((Component)messageLabel, 0, 2, 1, 1, 1, 1, 11, 1);
        View view = (View)messageLabel.getClientProperty("html");
        view.setSize(400.0f, 0.0f);
        float w = view.getPreferredSpan(0);
        float h = view.getPreferredSpan(1);
        messageLabel.setSize((int)w, (int)h);
        JFrame dummyFrame = new JFrame();
        dummyFrame.getContentPane().add((Component)panel);
        dummyFrame.pack();
        Dimension dim = panel.getPreferredSize();
        BufferedImage bufferedImage = new BufferedImage(dim.width, dim.height, 1);
        Graphics2D createGraphics = bufferedImage.createGraphics();
        panel.paint((Graphics)createGraphics);
        createGraphics.dispose();
        dummyFrame.dispose();
        ImageIO.write((RenderedImage)bufferedImage, "bmp", targetFile);
        System.out.println("[BlankDisplayBMPGenerator] Wrote display image file: " + targetFile.getAbsolutePath());
    }
}

