/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.server.controller;

import com.aem.CentralDebugging;
import com.aem.nodelink.tcp.Base64;
import com.aem.nodelink.utils.BandwidthBuckets;
import com.aem.nodelink.utils.RTTBuckets;
import com.aem.nodelink.utils.SafeClock;
import com.aem.sdesktop.interfaces.GC;
import com.aem.sdesktop.interfaces.MSG;
import com.aem.sdesktop.interfaces.ServerPart;
import com.aem.sdesktop.server.controller.EmptyChunkProcessor;
import com.aem.sdesktop.server.controller.GrabSpec;
import com.aem.sdesktop.server.controller.SDesktopServerController;
import com.aem.sdesktop.server.controller.SDesktopServerInstance;
import com.aem.sdesktop.server.controller.ScreenChunkGrabber;
import com.aem.sdesktop.server.controller.ScreenChunkProcessor;
import com.aem.sdesktop.util.FTPUtil;
import com.aem.sdesktop.util.HumanInputTracker;
import com.aem.sdesktop.util.ScreenDataBatch;
import com.aem.shelp.tech.admin.subsections.simulation.SimulationStep;
import com.aem.shelp.tech.admin.subsections.simulation.steps.SessionsStep;
import com.aem.shelp.util.FnvHash2D;
import com.aem.shelp.util.ProcessCache;
import com.aem.shelp.util.ScreenDataDump;
import com.aem.shelp.util.ScreenDimension;
import com.aem.thp.LevelGzipOutputStream;
import com.aem.utils.Debugger;
import com.aem.utils.LogicalArray;
import com.aem.utils.LogicalArrayUtil;
import com.aem.utils.NonNativeLogicalArray;
import com.aem.utils.ScreenUtil;
import java.awt.AWTException;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Random;
import javax.imageio.ImageIO;
import utils.message.Message;
import utils.message.MessageReader;
import utils.message.MessageWriter;
import utils.ostools.OS;
import utils.progtools.LimitedErrorHandler;
import utils.progtools.MemoryCache;
import utils.progtools.Ticker;
import utils.stream.OpenByteArrayOutputStream;
import utils.string.StringToAscii;
import utils.swing.customlaf.ScalingUtil;
import utils.swing.images.ImageHelper;
import utils.swing.png.PngEncoder;
import utils.switches.LocalSwitches;
import utils.switches.Switches;
import utils.udp.Acculog;
import utils.vnc.VNC;

public class ScreenServer
extends Thread
implements MSG,
GC,
ServerPart,
ScreenChunkProcessor,
HumanInputTracker {
    private static final boolean AIM_66_PERCENT_CPU = true;
    private static final boolean SLEEP_AFTER_GRAB = true;
    private static boolean FORCE_MIN_SLEEP_AFTER_GRAB = true;
    private static boolean BATCH_UP_SCREEN_DATAS = true;
    private final FnvHash2D myfnv = new FnvHash2D();
    private final Object grab_LOCK = new Object();
    private Message grab_override = null;
    private boolean sendAsPngs = false;
    private boolean pngFormatBase64 = false;
    private boolean screenAsRGBBytes = false;
    private MessageReader min;
    private MessageWriter mout;
    private SDesktopServerController controller;
    private SDesktopServerInstance instance;
    private ScreenChunkGrabber grabber;
    public final RTTBuckets processingTimeBuckets = new RTTBuckets();
    public final BandwidthBuckets screenSizeBuckets = new BandwidthBuckets();
    private final LimitedErrorHandler limitedErrorHandler = new LimitedErrorHandler(5000L, LimitedErrorHandler.STDOUT_HANDLER);
    private byte[] chunkrgbs = new byte[0];
    private int chunkN = 0;
    private int[] color = new int[128];
    private HashMap<Integer, Integer> colorMap = new HashMap(128, 1.0f);
    private int[] tempChunk = new int[65536];
    private int tempChunkCount = 0;
    private int colorsFound = 0;
    private boolean continuousSend = false;
    private boolean die = false;
    private Point last_pos;
    private boolean useHardwareAcceleratedScreenGrabs = true;
    private boolean clearScreenRequested = false;
    private boolean clearCacheRequested = false;
    private boolean mouseDragging = false;
    boolean amSimulating = false;
    SessionsStep simulationSessions;
    int simulateScreenChangePerSecond = 0;
    Random simulateRandom = new Random(0L);
    NonNativeLogicalArray simulatedScreenData;
    Ticker simulationTicker;
    private static final Integer[] STATIC_INTS = new Integer[128];
    private final int requestedScreen = 0;
    long ignoreRttsUntil = 0L;
    Message rttEchoCommand;
    private VNC vncConnection;
    private int coresAvailable = 0;
    private boolean initedSoRun = false;
    private HumanInputTracker inputTracker;
    private long lastScreenSizeSent = 0L;
    private int lastScreenSizeW = 0;
    private int lastScreenSizeH = 0;
    private int lastScreenCount = 1;
    private int lastRequestedScreen = 0;
    private Rectangle lastRequestedArea;
    private boolean sentWarning = false;
    private long poorSince = 0L;
    private ContinuousScreenSend continuous_screen_send;
    private Message last_grab_message;
    long LAST_GRAB = 0L;
    private long SUGGESTED_DELAY = 40L;
    private long ADAPTIVE_DELAY = 40L;
    private static final Object SCREEN_GRAB_STATIC_LOCK;
    private boolean haveIssuedTranslate = false;
    private boolean wasDraggingOnLastGrab = false;
    private Point mouseCursorPreviousLocation;
    private Point mouseCursorLocation;
    private long screenGrabDebugID;
    private int screenDumpN;
    private final ArrayList<int[]> translateScanlines = new ArrayList();
    private int maxTranslateDelta = 0;
    private MemoryCache chunkCache;
    private final Object uniqueID_LOCK = new Object();
    private long uniqueID = 1000L;
    boolean firstScreenStart = true;
    boolean firstScreenEnd = true;
    private PngEncoder pngenc;
    private Rectangle requestedArea = null;
    private final OpenByteArrayOutputStream compdat = new OpenByteArrayOutputStream();
    private final ScreenDataBatch batch = new ScreenDataBatch();
    private SDesktopServerController.PreSessionLoaderThread delayedInitialisationThread;

    @Override
    public void die() {
        this.die = true;
        if (this.grabber != null) {
            this.grabber.die = true;
        }
    }

    public void setRttCommand(Message command) {
        if (SafeClock.currentTimeMillis() < this.ignoreRttsUntil) {
            return;
        }
        this.ignoreRttsUntil = SafeClock.currentTimeMillis() + 1000L;
        this.rttEchoCommand = command;
    }

    public boolean amSimulating() {
        return this.amSimulating;
    }

    public void setSimulation(SimulationStep step) {
        System.out.println("[ScreenServer] Requested to run simulation " + step.getSummary());
        try {
            if (step instanceof SessionsStep) {
                this.simulationSessions = (SessionsStep)step;
                this.simulateScreenChangePerSecond = this.simulationSessions.getPercentScreenChangePerSecond();
                byte[] imageData = this.simulationSessions.getImageData();
                BufferedImage image = ImageIO.read(new ByteArrayInputStream(imageData));
                BufferedImage bimg = ImageHelper.toBufferedImageARGB((Image)image);
                image = null;
                int[] screenData = bimg.getRGB(0, 0, bimg.getWidth(), bimg.getHeight(), null, 0, bimg.getWidth());
                this.simulatedScreenData = new NonNativeLogicalArray(bimg.getWidth(), bimg.getHeight(), screenData, bimg.getWidth(), 0, 0);
                int referenceScreenPixels = 2073600;
                int maxPixels = 2 * referenceScreenPixels;
                int pixelsPerSecond = (int)((double)referenceScreenPixels * ((double)this.simulationSessions.getPercentScreenChangePerSecond() / 100.0));
                System.out.println("[ScreenServer] Activity rate is " + pixelsPerSecond + " pixels per second (based on a consistent reference 1920x1080 screen size), with a max of " + maxPixels + " pixels marked for sending");
                this.simulationTicker = new Ticker(referenceScreenPixels);
                this.simulationTicker.startCounting(pixelsPerSecond);
                this.grabber.setSimulationTicker(this.simulationTicker);
                this.amSimulating = true;
            }
        }
        catch (Exception x) {
            System.out.println("[ScreenServer] Failed to load simulation: " + x);
            x.printStackTrace();
        }
    }

    public NonNativeLogicalArray getSimulatedScreenData(int width, int height) {
        int wscope = this.simulatedScreenData.getWidth() - width;
        int hscope = this.simulatedScreenData.getHeight() - height;
        int x = this.simulateRandom.nextInt(wscope);
        int y = this.simulateRandom.nextInt(hscope);
        return this.simulatedScreenData.getSubArray(x, y, width, height);
    }

    public void setUseHardwareAcceleratedScreenGrab(boolean b) {
        if (b) {
            System.out.println("[ScreenServer] Asked to use hardware acceleration for screen updates where possible");
        } else {
            System.out.println("[ScreenServer] Asked to NOT use hardware acceleration for screen updates where possible");
        }
        if (this.useHardwareAcceleratedScreenGrabs != b) {
            this.useHardwareAcceleratedScreenGrabs = b;
        }
    }

    public void initCaptureViaVNC(VNC vncConnection) {
        this.vncConnection = vncConnection;
    }

    public void loginCaptureViaVNC(String[] credentials) throws Exception {
        this.vncConnection.login(credentials);
        this.lastScreenSizeSent = 0L;
        this.grabber.enableCaptureViaVNC(this.vncConnection);
    }

    public void disableCaptureViaVNC() {
        this.vncConnection = null;
        this.lastScreenSizeSent = 0L;
        if (this.grabber != null) {
            this.grabber.disableCaptureViaVNC();
        } else {
            this.delayedInitialisationThread.start();
        }
    }

    public void setLastMousePosition(Point p) {
        this.last_pos = p;
    }

    public void setMouseDragging(boolean b) {
        this.mouseDragging = b;
    }

    private void log(String s) {
        System.out.println(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOverridingGrabMessage(Message m) {
        Object object = this.grab_LOCK;
        synchronized (object) {
            this.grab_override = m;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setScreenSendAsRGBBytes() {
        Object object = this.grab_LOCK;
        synchronized (object) {
            this.screenAsRGBBytes = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setSendScreenAsPngs(boolean sendBase64Encoded) {
        Object object = this.grab_LOCK;
        synchronized (object) {
            this.sendAsPngs = true;
            this.pngFormatBase64 = sendBase64Encoded;
        }
    }

    public ScreenServer() {
        super("ScreenServerThread");
        try {
            this.coresAvailable = Runtime.getRuntime().availableProcessors();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void initMK1_ScreenGrabber() {
        System.out.println("[ScreenServer] InitMK1 ScreenGrabber");
        this.start();
    }

    public void initMK2_SendScreens(SDesktopServerInstance instance, SDesktopServerController controller, InputStream input, OutputStream output) {
        System.out.println("[ScreenServer] InitMK2 ScreenGrabber");
        this.controller = controller;
        this.instance = instance;
        this.min = new MessageReader(input);
        this.mout = new MessageWriter(output);
        this.continuous_screen_send = new ContinuousScreenSend();
        this.continuous_screen_send.start();
        this.initedSoRun = true;
    }

    public void setHumanInputTracker(HumanInputTracker info) {
        this.inputTracker = info;
    }

    @Override
    public long mostRecentAffectiveInput() {
        if (this.inputTracker != null) {
            return this.inputTracker.mostRecentAffectiveInput();
        }
        return 0L;
    }

    public void cleanUp(boolean lastConnectionAlive) {
        try {
            this.grabber.cleanUpForShutdown();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.grabber = null;
        this.colorMap = null;
        this.color = null;
        this.tempChunk = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Message m = null;
        try {
            try {
                ScreenChunkGrabber tmp = new ScreenChunkGrabber(this);
                Object object = SCREEN_GRAB_STATIC_LOCK;
                synchronized (object) {
                    System.out.println("[ScreenServer] Spinning up grabber now");
                    this.spinUp(tmp);
                    System.out.println("[ScreenServer] Spun up");
                    this.grabber = tmp;
                }
            }
            catch (AWTException e) {
                e.printStackTrace();
            }
            long tInited = System.currentTimeMillis();
            while (!this.initedSoRun) {
                try {
                    Thread.sleep(20L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (System.currentTimeMillis() - tInited <= 600000L) continue;
                System.out.println("[ScreenServer] not spun up after 10 minutes, exiting...");
                return;
            }
            this.sendScreenSize();
            while (!this.die) {
                m = this.min.read();
                this.handleMessage(m);
            }
        }
        catch (IOException e) {
            if (CentralDebugging.PRINT_STACK_ON_CONNECTION_FAIL) {
                System.out.println("(Screen Server) LAST MESSAGE:" + m);
                e.printStackTrace();
            } else {
                System.out.println("[ScreenServer] " + e);
            }
            this.log("[ScreenServer] Connection terminated");
        }
        catch (Throwable e) {
            this.log("An unclassified error occurred in ScreenServer: " + Debugger.getStackTrace(e));
            System.out.println("(Screen Server) LAST MESSAGE:" + m);
            e.printStackTrace();
        }
        this.instance.died();
    }

    public int[] getValidCoord() {
        if (this.grabber == null) {
            return new int[]{0, 0};
        }
        return this.grabber.getValidCoord();
    }

    public boolean isCoordValid(int x, int y) {
        if (this.grabber == null) {
            return true;
        }
        return this.grabber.isCoordValid(x, y);
    }

    public int translateX(int x) {
        if (this.grabber == null) {
            return x;
        }
        return this.grabber.translateX(x);
    }

    public int translateY(int y) {
        if (this.grabber == null) {
            return y;
        }
        return this.grabber.translateY(y);
    }

    public int translateReverseX(int x) {
        if (this.grabber == null) {
            return x;
        }
        return this.grabber.translateReverseX(x);
    }

    public int translateReverseY(int y) {
        if (this.grabber == null) {
            return y;
        }
        return this.grabber.translateReverseY(y);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void spinUp(ScreenChunkGrabber grabber) {
        try {
            Object object = SCREEN_GRAB_STATIC_LOCK;
            synchronized (object) {
                Dimension size = grabber.getPhysicalScreenSize();
                GrabSpec spec = new GrabSpec(0, 0, size.width, size.height, 3, 51, 101, 256, 0L, this.last_pos, this.useHardwareAcceleratedScreenGrabs, false);
                grabber.processChanges(spec, new EmptyChunkProcessor());
                grabber.clearScreen();
            }
        }
        catch (Throwable tt) {
            tt.printStackTrace();
        }
    }

    public int getLastScreenWidth() {
        return this.lastScreenSizeW;
    }

    public int getLastScreenHeight() {
        return this.lastScreenSizeH;
    }

    private void sendScreenSize() throws IOException {
        if (System.currentTimeMillis() - this.lastScreenSizeSent > 1000L) {
            Dimension screen_size;
            this.lastScreenSizeSent = System.currentTimeMillis();
            int screenCount = 1;
            ScreenDimension[] dimensions = null;
            if (this.vncConnection != null) {
                screen_size = new Dimension(this.vncConnection.getCurrentPixelFormat().getScreenWidth(), this.vncConnection.getCurrentPixelFormat().getScreenHeight());
            } else {
                screen_size = ScreenDimension.getPhysicalScreenSize();
                if (this.grabber != null) {
                    dimensions = ScreenDimension.detectScreenDimensions();
                    screenCount = dimensions.length;
                }
                if (screenCount < 1) {
                    screenCount = 1;
                    dimensions = new ScreenDimension[]{new ScreenDimension(0, 0, screen_size.width, screen_size.height, 0, "")};
                }
            }
            if (screen_size.width != this.lastScreenSizeW || screen_size.height != this.lastScreenSizeH || screenCount != this.lastScreenCount || 0 != this.lastRequestedScreen || this.requestedArea != this.lastRequestedArea) {
                if (screen_size.width == -1 || screen_size.height == -1) {
                    System.out.println("[ScreenServer] Error: Screen size detected as " + screen_size.width + "," + screen_size.height);
                }
                Message m = new Message(196613);
                if (this.requestedArea == null) {
                    m.append(0);
                    m.append(0);
                    m.append(screen_size.width);
                    m.append(screen_size.height);
                    System.out.println("[ScreenServer] No requested area: 0 0 " + screen_size.width + " " + screen_size.height + " " + screenCount);
                } else {
                    m.append(this.requestedArea.x);
                    m.append(this.requestedArea.y);
                    m.append(this.requestedArea.width);
                    m.append(this.requestedArea.height);
                    System.out.println("[ScreenServer] Requested area: " + this.requestedArea.x + " " + this.requestedArea.y + " " + this.requestedArea.width + " " + this.requestedArea.height + " " + screenCount);
                }
                m.append(ScalingUtil.detectScalingPercetange());
                m.append(screenCount);
                if (dimensions != null) {
                    for (int i = 0; i < screenCount; ++i) {
                        System.out.println("[ScreenServer] Screen " + i + ": " + dimensions[i]);
                        m.append(dimensions[i].getPhysicalBounds().x);
                        m.append(dimensions[i].getPhysicalBounds().y);
                        m.append(dimensions[i].getPhysicalBounds().width);
                        m.append(dimensions[i].getPhysicalBounds().height);
                    }
                } else {
                    System.out.println("[ScreenServer] No per-screen dimensions. Returning 0 0 " + screen_size.width + " " + screen_size.height);
                    m.append(0);
                    m.append(0);
                    m.append(screen_size.width);
                    m.append(screen_size.height);
                }
                this.mout.write(m);
                this.lastScreenSizeW = screen_size.width;
                this.lastScreenSizeH = screen_size.height;
                this.lastScreenCount = screenCount;
                this.lastRequestedScreen = 0;
                this.lastRequestedArea = this.requestedArea;
                System.out.println("[ScreenServer] Sending screen " + this.lastScreenSizeW + "x" + this.lastScreenSizeH + " " + this.lastScreenCount);
            }
        }
    }

    public boolean isInitialised() {
        return this.grabber != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleMessage(Message m) throws IOException {
        int type = m.getType();
        if (type == 196624) {
            this.continuousSend = (Boolean)m.get(0);
            if (this.continuousSend) {
                FTPUtil.SLOW_DOWN_FOREVER();
                this.instance.setLowLatencyRequired(true);
            } else {
                FTPUtil.SPEED_UP_FOREVER();
                this.instance.setLowLatencyRequired(false);
            }
        } else if (type == 196627) {
            this.clearScreenRequested = true;
        } else if (type == 196614) {
            this.grabber.clearScreen();
            this.grab_override = null;
            this.mout.write(m);
        } else if (type == 196615) {
            this.mout.write(m);
        } else if (type != 196632) {
            if (type == 196630 || type == 196647) {
                if (m.length() > 0) {
                    int x2 = m.getAsInt(0);
                    int y = m.getAsInt(1);
                    int width = m.getAsInt(2);
                    int height = m.getAsInt(3);
                    this.requestedArea = new Rectangle(x2, y, width, height);
                } else {
                    this.requestedArea = null;
                }
                this.sendScreenSize();
                this.setSendScreenAsPngs(type == 196630);
                this.clearScreenRequested = true;
            } else if (type == 196609) {
                this.last_grab_message = m;
                if (this.clearScreenRequested) {
                    this.clearScreenRequested = false;
                    this.grabber.clearScreen();
                    this.clearCacheRequested = true;
                }
            } else if (type == 196625) {
                if (!this.amSimulating() && (this.sendAsPngs || this.screenAsRGBBytes) && this.clearScreenRequested) {
                    this.clearScreenRequested = false;
                    this.grabber.clearScreen();
                }
                if (CentralDebugging.MSG_VERBOSE) {
                    System.out.println("SCREEN_GRAB " + m);
                }
                try {
                    int coldepth;
                    int comp;
                    int fil;
                    int enc;
                    int h;
                    int w;
                    int y;
                    int x;
                    if (this.grab_override != null) {
                        Object x2 = this.grab_LOCK;
                        synchronized (x2) {
                            m = this.grab_override;
                        }
                    }
                    if (CentralDebugging.SCR_USE_MINIMAL_ENCODING) {
                        int tmp = (Integer)m.get(0);
                        x = 0xFFFF & tmp >>> 16;
                        y = 0xFFFF & tmp;
                        tmp = (Integer)m.get(1);
                        w = 0xFFFF & tmp >>> 16;
                        h = 0xFFFF & tmp;
                        tmp = (Integer)m.get(2);
                        enc = tmp >>> 29;
                        fil = ((tmp & 0x1FFFFFFF) >>> 27) + 50;
                        comp = ((tmp & 0x7FFFFFF) >>> 24) + 100;
                        int scal = ((tmp & 0xFFFFFF) >>> 22) + 150;
                        coldepth = (tmp & 0x3FFFFF) >>> 14;
                        this.SUGGESTED_DELAY = tmp & 0x3FFF;
                    } else {
                        x = (Integer)m.get(0);
                        y = (Integer)m.get(1);
                        w = (Integer)m.get(2);
                        h = (Integer)m.get(3);
                        enc = (Integer)m.get(4);
                        fil = (Integer)m.get(5);
                        comp = (Integer)m.get(6);
                        int scal = (Integer)m.get(7);
                        coldepth = 256;
                        if (m.length() > 8) {
                            coldepth = (Integer)m.get(8);
                        }
                        if (m.length() > 9) {
                            this.SUGGESTED_DELAY = ((Number)m.get(9)).intValue();
                        }
                    }
                    FORCE_MIN_SLEEP_AFTER_GRAB = true;
                    if (CentralDebugging.SCR_ADAPTIVE_DELAY) {
                        this.SUGGESTED_DELAY = this.ADAPTIVE_DELAY;
                    } else {
                        this.ADAPTIVE_DELAY = 40L;
                    }
                    boolean lowQuality = false;
                    if (CentralDebugging.LOW_COLDEPTH_ON_DRAG && this.mouseDragging) {
                        lowQuality = true;
                    }
                    GrabSpec spec = new GrabSpec(x, y, w, h, enc, fil, comp, coldepth, this.SUGGESTED_DELAY, this.last_pos, this.useHardwareAcceleratedScreenGrabs, lowQuality);
                    if (CentralDebugging.SCR_DUMP_GRAB_SPEC) {
                        System.out.println("[ScreenServer] Grab spec: " + spec);
                    }
                    Object object = SCREEN_GRAB_STATIC_LOCK;
                    synchronized (object) {
                        this.grabber.processChanges(spec, this);
                    }
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    e.printStackTrace();
                }
                catch (ClassCastException e) {
                    this.log("bad screen grab message " + m);
                }
            } else {
                this.log("unrecognised screen server message " + m);
            }
        }
    }

    @Override
    public void beginProcessingPixels(GrabSpec spec) throws IOException {
        if (Switches.SH_rttsWaitForScreenUpdate && this.rttEchoCommand != null) {
            try {
                this.instance.asyncserver.handleRttEchoMessage(this.rttEchoCommand);
            }
            catch (Exception x) {
                x.printStackTrace();
            }
            this.rttEchoCommand = null;
        }
        this.sendScreenSize();
        if (!BATCH_UP_SCREEN_DATAS) {
            Message msg_packets_start = new Message(196610);
            this.mout.write(msg_packets_start);
        }
        BATCH_UP_SCREEN_DATAS = !CentralDebugging.SCR_NO_BATCH_SCREEN_PACKETS;
    }

    @Override
    public void immediatelyBeforeGrab() {
        if (CentralDebugging.CACHE_ALL_CHUNKS && this.chunkCache != null && this.clearCacheRequested) {
            try {
                this.mout.write(new Message(196642));
                this.chunkCache.clear();
            }
            catch (Exception x) {
                x.printStackTrace();
            }
            this.clearCacheRequested = false;
        }
        this.screenGrabDebugID = System.currentTimeMillis();
        this.screenDumpN = 0;
        this.mouseCursorLocation = this.grabber != null ? this.grabber.getPointer() : null;
    }

    @Override
    public boolean processEntireScreen(NonNativeLogicalArray filter, ScreenUtil screen, Rectangle valid, Dimension ssize) throws IOException {
        if (CentralDebugging.STORE_SCREEN_DEBUG_DUMPS) {
            ScreenDataDump.dumpToPng("screen_debug_" + this.screenGrabDebugID + "_" + this.screenDumpN + "-beforeprocessing.png", filter, 0, 0, filter.getWidth(), filter.getHeight());
        }
        this.haveIssuedTranslate = false;
        if (this.mouseCursorLocation == null) {
            return false;
        }
        if (this.mouseCursorPreviousLocation == null) {
            this.mouseCursorPreviousLocation = this.mouseCursorLocation;
            return false;
        }
        Point mouseWas = new Point(this.mouseCursorPreviousLocation);
        Point mouseNow = new Point(this.mouseCursorLocation);
        this.mouseCursorPreviousLocation = this.mouseCursorLocation;
        if (mouseWas.x == mouseNow.x && mouseWas.y == mouseNow.y) {
            return false;
        }
        if (this.mouseDragging) {
            this.wasDraggingOnLastGrab = true;
        }
        if (this.mouseDragging || this.wasDraggingOnLastGrab || CentralDebugging.DETECT_DRAGS_ALWAYS) {
            if (this.wasDraggingOnLastGrab) {
                this.wasDraggingOnLastGrab = false;
            }
            if (CentralDebugging.DEBUG_DRAG_TRANSLATIONS_VERBOSE) {
                System.out.println("[ScreenServer] translation check " + mouseWas + " -> " + mouseNow);
            }
            if (mouseWas.x < 0 || mouseWas.y < 0 || mouseWas.x > ssize.width || mouseWas.y > ssize.height) {
                if (CentralDebugging.DEBUG_DRAG_TRANSLATIONS_VERBOSE) {
                    System.out.println("[ScreenServer] old mouse coords are invalid");
                }
                return false;
            }
            if (mouseNow.x < 0 || mouseNow.y < 0 || mouseNow.x > ssize.width || mouseNow.y > ssize.height) {
                if (CentralDebugging.DEBUG_DRAG_TRANSLATIONS_VERBOSE) {
                    System.out.println("[ScreenServer] new mouse coords are invalid");
                }
                return false;
            }
            int deltaX = 999999;
            int deltaY = 999999;
            int scan_height = 50;
            int scan_gran = 5;
            int[] vals = new int[scan_height / scan_gran];
            try {
                int n = 0;
                for (int y = mouseWas.y; y < mouseWas.y + scan_height; y += scan_gran) {
                    vals[n++] = filter.getXY(mouseWas.x, y);
                }
                block5: for (int x = mouseWas.x; x >= 0; --x) {
                    n = 0;
                    for (int y = mouseWas.y; y < mouseWas.y + scan_height; y += scan_gran) {
                        if (vals[n++] == filter.getXY(x, y)) continue;
                        deltaX = x - mouseWas.x;
                        deltaY = y - mouseWas.y;
                        x = -1;
                        continue block5;
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException x) {
                return false;
            }
            if (CentralDebugging.DEBUG_DRAG_TRANSLATIONS_VERBOSE) {
                System.out.println("[ScreenServer] translation check starting at " + deltaX + "," + deltaY);
            }
            if (deltaX == 999999 || deltaY == 999999) {
                return false;
            }
            int hashW = 32;
            int hashH = 64;
            int spaceW = 24;
            int spaceH = 24;
            int spaceW2 = spaceW / 2;
            int spaceH2 = spaceH / 2;
            int[] deltaXs = new int[]{deltaX - 3, deltaX - hashW + 3};
            int[] deltaYs = new int[]{deltaY - 3, deltaY - 3};
            for (int S = 0; S < deltaXs.length; ++S) {
                int toY;
                int toX;
                long srcHash;
                deltaX = deltaXs[S];
                deltaY = deltaYs[S];
                int fromX = mouseWas.x + deltaX;
                int fromY = mouseWas.y + deltaY;
                if (fromX < 0) {
                    deltaX -= fromX;
                    fromX -= fromX;
                }
                if (fromY < 0) {
                    deltaY -= fromY;
                    fromY -= fromY;
                }
                if (fromX > ssize.width) {
                    deltaX -= fromX - ssize.width;
                    fromX -= fromX - ssize.width;
                }
                if (fromY > ssize.height) {
                    deltaY -= fromY - ssize.height;
                    fromY -= fromY - ssize.height;
                }
                try {
                    srcHash = this.myfnv.hashCached(filter, fromX, fromY, hashW, hashH);
                }
                catch (ArrayIndexOutOfBoundsException x) {
                    return false;
                }
                if (CentralDebugging.STORE_SCREEN_DEBUG_DUMPS) {
                    ScreenDataDump.dumpToPng("screen_debug_" + this.screenGrabDebugID + "_" + this.screenDumpN + "-translatematch.png", filter, mouseWas.x + deltaX, mouseWas.y + deltaY, hashW, hashH);
                }
                if (!valid.contains((toX = mouseNow.x + deltaX) - spaceW2, (toY = mouseNow.y + deltaY) - spaceH2) || !valid.contains(toX + spaceW2 + hashW, toY + spaceH2 + hashH)) {
                    if (CentralDebugging.DEBUG_DRAG_TRANSLATIONS_VERBOSE) {
                        System.out.println("[ScreenServer] translation check start point is out of grab rectangle");
                    }
                    return false;
                }
                if (CentralDebugging.DEBUG_DRAG_TRANSLATIONS_VERBOSE) {
                    System.out.println("[ScreenServer] searching for translation at " + toX + "," + toY);
                }
                boolean found = false;
                NonNativeLogicalArray search = screen.fetchArray(toX - spaceW2 - valid.x, toY - spaceH2 - valid.y, hashW + spaceW, hashH + spaceH);
                for (int yoff = 0; yoff < spaceH; ++yoff) {
                    for (int xoff = 0; xoff < spaceW; ++xoff) {
                        long searchHash = this.myfnv.hashCached(search, xoff, yoff, hashW, hashH);
                        if (srcHash == searchHash) {
                            toX += (xoff -= spaceW2);
                            toY += (yoff -= spaceH2);
                            if (CentralDebugging.DEBUG_DRAG_TRANSLATIONS_VERBOSE) {
                                System.out.println("[ScreenServer] translation match found at relative pointer offset " + xoff + "," + yoff);
                            }
                            if (CentralDebugging.DEBUG_DRAG_TRANSLATIONS_VERBOSE) {
                                System.out.println("[ScreenServer] +++++TRANSLATING+++++ " + fromX + "," + fromY + " -> " + toX + "," + toY + " (==" + (toX - fromX) + "," + (toY - fromY) + ")");
                            }
                            found = true;
                            if (this.mouseDragging || this.wasDraggingOnLastGrab) {
                                if (Math.abs(xoff) > this.maxTranslateDelta) {
                                    this.maxTranslateDelta = Math.abs(xoff);
                                    System.out.println("[ScreenServer] Max T Delta: " + this.maxTranslateDelta);
                                }
                                if (Math.abs(yoff) > this.maxTranslateDelta) {
                                    this.maxTranslateDelta = Math.abs(yoff);
                                    System.out.println("[ScreenServer] Max T Delta: " + this.maxTranslateDelta);
                                }
                            }
                            if (toX == fromX && toY == fromY) {
                                return false;
                            }
                            int xDelta = toX - fromX;
                            int yDelta = toY - fromY;
                            int gtop = Math.max(Math.max(0, valid.y), valid.y - yDelta);
                            int gbottom = Math.min(Math.min(ssize.height, valid.y + valid.height), valid.y + valid.height - yDelta);
                            int gleft = Math.max(Math.max(0, valid.x), valid.x - xDelta);
                            int gright = Math.min(Math.min(ssize.width, valid.x + valid.width), valid.x + valid.width - xDelta);
                            this.translateScanlines.clear();
                            if (CentralDebugging.DEBUG_DRAG_TRANSLATIONS_VERBOSE) {
                                System.out.println("[ScreenServer] ----- Starting translations search ----- ");
                            }
                            if (CentralDebugging.DEBUG_DRAG_TRANSLATIONS_VERBOSE) {
                                System.out.println("[ScreenServer] Valid grab area is " + valid);
                            }
                            if (CentralDebugging.DEBUG_DRAG_TRANSLATIONS_VERBOSE) {
                                System.out.println("[ScreenServer] Filter bound top=" + gtop + " bottom=" + gbottom + " left=" + gleft + " right=" + gright);
                            }
                            for (int grabAreaY = gtop; grabAreaY < gbottom; ++grabAreaY) {
                                int width;
                                int cy = grabAreaY + yDelta;
                                if (CentralDebugging.DEBUG_DRAG_TRANSLATIONS_VERBOSE) {
                                    System.out.println("[ScreenServer] checking translation scanline y=" + grabAreaY);
                                }
                                NonNativeLogicalArray screenLa = screen.fetchArray(0, cy - valid.y, valid.width, 1);
                                boolean keep = false;
                                boolean finished = false;
                                int start = -1;
                                int end = -1;
                                boolean translationResultsInChange = false;
                                for (int grabAreaX = gleft; grabAreaX < gright; ++grabAreaX) {
                                    int cx = grabAreaX + xDelta;
                                    if (screenLa.getXY(cx - valid.x, 0) == filter.getXY(grabAreaX, grabAreaY)) {
                                        if (filter.getXY(grabAreaX, grabAreaY) != filter.getXY(grabAreaX + xDelta, grabAreaY + yDelta)) {
                                            translationResultsInChange = true;
                                            if (start == -1) {
                                                start = grabAreaX;
                                            }
                                            if (CentralDebugging.DEBUG_TRANSLATIONS_CROP_RIGHT) {
                                                end = grabAreaX;
                                            }
                                        }
                                        if (!CentralDebugging.DEBUG_TRANSLATIONS_CROP_RIGHT) {
                                            end = grabAreaX + 1;
                                        }
                                        if (start == -1 || end == -1 || grabAreaX != fromX) continue;
                                        keep = true;
                                        continue;
                                    }
                                    if (keep) break;
                                    if (grabAreaX == fromX) {
                                        if (grabAreaY < fromY) {
                                            if (this.translateScanlines.size() <= 0) break;
                                            if (CentralDebugging.DEBUG_DRAG_TRANSLATIONS_VERBOSE) {
                                                System.out.println("[ScreenServer] line at y=" + grabAreaY + " (vs " + fromX + "," + fromY + ") did not match at " + grabAreaX + " so discarding entire list");
                                            }
                                            this.translateScanlines.clear();
                                            break;
                                        }
                                        if (CentralDebugging.DEBUG_DRAG_TRANSLATIONS_VERBOSE) {
                                            System.out.println("[ScreenServer] line at y=" + grabAreaY + " (vs " + fromX + "," + fromY + ") did not match at " + grabAreaX + " so finishing with list of size " + this.translateScanlines.size());
                                        }
                                        finished = true;
                                        break;
                                    }
                                    start = -1;
                                }
                                if (keep && translationResultsInChange && (width = end - start + 1) > 0) {
                                    if (CentralDebugging.DEBUG_DRAG_TRANSLATIONS_VERBOSE) {
                                        System.out.println("[ScreenServer] line at y=" + grabAreaY + ":" + start + "->" + end + " was valid (vs " + fromX + "," + fromY + ")... so storing in list (" + this.translateScanlines.size() + ")");
                                    }
                                    this.translateScanlines.add(new int[]{start, grabAreaY, width});
                                }
                                if (finished) break;
                            }
                            if (yDelta > 0) {
                                Collections.reverse(this.translateScanlines);
                            }
                            if (CentralDebugging.STORE_SCREEN_DEBUG_DUMPS) {
                                ScreenDataDump.dumpToPng("screen_debug_" + this.screenGrabDebugID + "_" + this.screenDumpN + "-beforetranslate.png", filter, 0, 0, filter.getWidth(), filter.getHeight());
                            }
                            Message m = new Message(196641);
                            m.append(xDelta);
                            m.append(yDelta);
                            for (int[] translateScanline : this.translateScanlines) {
                                if (!BATCH_UP_SCREEN_DATAS) {
                                    m.append(translateScanline[0]);
                                    m.append(translateScanline[1]);
                                    m.append(translateScanline[2]);
                                }
                                LogicalArrayUtil.translate(filter, translateScanline[0], translateScanline[1], translateScanline[2], 1, translateScanline[0] + xDelta, translateScanline[1] + yDelta);
                            }
                            if (BATCH_UP_SCREEN_DATAS) {
                                this.batch.addTranslatedBlock(m, this.translateScanlines);
                            } else {
                                this.mout.write(m);
                            }
                            if (CentralDebugging.STORE_SCREEN_DEBUG_DUMPS) {
                                ScreenDataDump.dumpToPng("screen_debug_" + this.screenGrabDebugID + "_" + this.screenDumpN + "-aftertranslate.png", filter, 0, 0, filter.getWidth(), filter.getHeight());
                            }
                            this.haveIssuedTranslate = true;
                        }
                        if (found) break;
                    }
                    if (found) break;
                }
                if (CentralDebugging.DEBUG_DRAG_TRANSLATIONS_VERBOSE && !found) {
                    System.out.println("[ScreenServer] translation not found for mouse move " + (mouseNow.x - mouseWas.x) + "," + (mouseNow.y - mouseWas.y));
                }
                if (CentralDebugging.STORE_SCREEN_DEBUG_DUMPS) {
                    if (found) {
                        ScreenDataDump.dumpToPng("screen_debug_" + this.screenGrabDebugID + "_" + this.screenDumpN + "-translatesuccessmatch.png", screen.fetchArray(toX, toY, hashW, hashH), 0, 0, hashW, hashH);
                    } else {
                        ScreenDataDump.dumpToPng("screen_debug_" + this.screenGrabDebugID + "_" + this.screenDumpN + "-translatefailure.png", search, 0, 0, search.getWidth(), search.getHeight());
                    }
                }
                if (!found) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processPixels(GrabSpec spec, NonNativeLogicalArray deviceChunkArray, LogicalArray screenChunkArray, int abs_x, int abs_y, boolean immediateSend, boolean sendFromScratch) throws IOException {
        if (this.amSimulating()) {
            deviceChunkArray = this.getSimulatedScreenData(deviceChunkArray.getWidth(), deviceChunkArray.getHeight());
        }
        Long chunkUid = null;
        CentralDebugging.timerStart("Cumulative Cache Checking");
        if (!this.sendAsPngs && !this.screenAsRGBBytes && CentralDebugging.CACHE_ALL_CHUNKS) {
            Long UID;
            int cw = deviceChunkArray.getWidth();
            int ch = deviceChunkArray.getHeight();
            long FNV = 0L;
            Long OFNV = FNV += this.myfnv.hashCached(deviceChunkArray);
            if (this.chunkCache == null) {
                this.chunkCache = ProcessCache.getEquivalentCacheCustomerSide();
                System.out.println("[ScreenServer] cache size is " + this.chunkCache.maxSizeBytes() + " bytes");
            }
            if ((UID = (Long)this.chunkCache.getFromCache(OFNV)) != null) {
                Message m = new Message(196640);
                m.append(abs_x);
                m.append(abs_y);
                m.append(cw);
                m.append(ch);
                m.append(UID);
                if (BATCH_UP_SCREEN_DATAS) {
                    this.batch.addCachedBlock(m);
                } else {
                    this.mout.write(m);
                }
                if (CentralDebugging.DEBUG_SCR_CACHING_VERBOSE) {
                    System.out.println("[ScreenServer] cache hit " + UID);
                }
                return;
            }
            Object m = this.uniqueID_LOCK;
            synchronized (m) {
                UID = this.uniqueID++;
            }
            if (CentralDebugging.DEBUG_SCR_CACHING_VERBOSE) {
                System.out.println("[ScreenServer] cache miss for " + UID + " immediate=" + immediateSend + " fromscratch=" + sendFromScratch + " w=" + deviceChunkArray.getWidth() + " h=" + deviceChunkArray.getHeight());
            }
            this.chunkCache.addToCache(OFNV, UID, ProcessCache.getStoredChunkSize(deviceChunkArray));
            chunkUid = UID;
        }
        CentralDebugging.timerStop("Cumulative Cache Checking");
        CentralDebugging.timerStart("Cumulative Screen Modding and Copying");
        boolean blackIsEmpty = spec.blackIsEmpty;
        boolean colour = spec.colour;
        if (this.sendAsPngs || this.screenAsRGBBytes) {
            colour = true;
            blackIsEmpty = false;
        }
        if (sendFromScratch) {
            blackIsEmpty = false;
        }
        int reqSize = deviceChunkArray.getWidth() * deviceChunkArray.getHeight() * 3;
        if (CentralDebugging.SCR_USE_COLOUR_RLE) {
            ++reqSize;
        }
        this.chunkN = 0;
        if (this.chunkrgbs.length < reqSize) {
            this.chunkrgbs = new byte[reqSize];
        }
        byte zero = 0;
        byte[] byteModderRef = spec.byteModder.ref;
        if (CentralDebugging.SCR_USE_COLOUR_RLE && colour && !this.sendAsPngs && !this.screenAsRGBBytes) {
            CentralDebugging.timerStart("Colour RLE");
            this.colorsFound = 0;
            this.colorMap.clear();
            int start = this.chunkN;
            this.chunkrgbs[this.chunkN++] = 0;
            this.tempChunkCount = 0;
            try {
                int n;
                int i;
                int newCol;
                int d_yoffset;
                CentralDebugging.timerStart("Colour RLE PreProcessing");
                if (blackIsEmpty) {
                    for (int dy = 0; dy < deviceChunkArray.getHeight(); ++dy) {
                        d_yoffset = deviceChunkArray.getYOffset(dy);
                        for (int dx = 0; dx < deviceChunkArray.getWidth(); ++dx) {
                            Integer key;
                            Integer index;
                            int colorModded;
                            newCol = deviceChunkArray.source[d_yoffset + dx];
                            int oldCol = screenChunkArray.getXY(dx, dy);
                            screenChunkArray.getXY(dx, dy);
                            if (oldCol == newCol) {
                                this.chunkrgbs[this.chunkN++] = zero;
                                this.chunkrgbs[this.chunkN++] = zero;
                                this.chunkrgbs[this.chunkN++] = zero;
                                colorModded = 0;
                            } else {
                                byte b1 = byteModderRef[128 + (byte)(newCol >>> 16)];
                                byte b2 = byteModderRef[128 + (byte)(newCol >>> 8)];
                                byte b3 = byteModderRef[128 + (byte)newCol];
                                this.chunkrgbs[this.chunkN++] = b1;
                                this.chunkrgbs[this.chunkN++] = b2;
                                this.chunkrgbs[this.chunkN++] = b3;
                                colorModded = 0;
                                colorModded = colorModded << 8 | 0xFF & b1;
                                colorModded = colorModded << 8 | 0xFF & b2;
                                colorModded = colorModded << 8 | 0xFF & b3;
                            }
                            this.tempChunk[this.tempChunkCount++] = colorModded;
                            CentralDebugging.timerStart("Colour Counting");
                            if (this.colorsFound < 128 && (index = this.colorMap.get(key = Integer.valueOf(colorModded))) == null) {
                                this.color[this.colorsFound] = colorModded;
                                this.colorMap.put(key, STATIC_INTS[this.colorsFound++]);
                            }
                            CentralDebugging.timerStop("Colour Counting");
                        }
                    }
                } else {
                    for (int dy = 0; dy < deviceChunkArray.getHeight(); ++dy) {
                        d_yoffset = deviceChunkArray.getYOffset(dy);
                        for (int dx = 0; dx < deviceChunkArray.getWidth(); ++dx) {
                            Integer key;
                            Integer index;
                            newCol = deviceChunkArray.source[d_yoffset + dx];
                            byte b1 = byteModderRef[128 + (byte)(newCol >>> 16)];
                            byte b2 = byteModderRef[128 + (byte)(newCol >>> 8)];
                            byte b3 = byteModderRef[128 + (byte)newCol];
                            this.chunkrgbs[this.chunkN++] = b1;
                            this.chunkrgbs[this.chunkN++] = b2;
                            this.chunkrgbs[this.chunkN++] = b3;
                            int colorModded = 0;
                            colorModded = colorModded << 8 | 0xFF & b1;
                            colorModded = colorModded << 8 | 0xFF & b2;
                            colorModded = colorModded << 8 | 0xFF & b3;
                            this.tempChunk[this.tempChunkCount++] = colorModded;
                            CentralDebugging.timerStart("Colour Counting");
                            if (this.colorsFound < 128 && (index = this.colorMap.get(key = Integer.valueOf(colorModded))) == null) {
                                this.color[this.colorsFound] = colorModded;
                                this.colorMap.put(key, STATIC_INTS[this.colorsFound++]);
                            }
                            CentralDebugging.timerStop("Colour Counting");
                        }
                    }
                }
                CentralDebugging.timerStop("Colour RLE PreProcessing");
                if (this.colorsFound == 1) {
                    CentralDebugging.timerStart("Colour RLE Processing - 1 Color");
                    this.chunkN = start;
                    this.chunkrgbs[this.chunkN++] = 1;
                    this.chunkN += 3;
                    CentralDebugging.timerStop("Colour RLE Processing - 1 Color");
                } else if (this.colorsFound <= 16) {
                    int pixelsPerByte;
                    int bitsPerPixel;
                    CentralDebugging.timerStart("Colour RLE Processing - <= 16 Colours");
                    this.chunkN = start;
                    this.chunkrgbs[this.chunkN++] = (byte)this.colorsFound;
                    for (i = 0; i < this.colorsFound; ++i) {
                        n = this.color[i];
                        this.chunkrgbs[this.chunkN++] = (byte)(n >>> 16);
                        this.chunkrgbs[this.chunkN++] = (byte)(n >>> 8);
                        this.chunkrgbs[this.chunkN++] = (byte)n;
                    }
                    switch (this.colorsFound) {
                        case 2: {
                            bitsPerPixel = 1;
                            pixelsPerByte = 8;
                            break;
                        }
                        case 3: 
                        case 4: {
                            bitsPerPixel = 2;
                            pixelsPerByte = 4;
                            break;
                        }
                        default: {
                            bitsPerPixel = 4;
                            pixelsPerByte = 2;
                        }
                    }
                    int bb = 0;
                    for (int x = 0; x < this.tempChunkCount; ++x) {
                        int col = this.tempChunk[x];
                        for (int i2 = 0; i2 < this.colorsFound; ++i2) {
                            if (this.color[i2] != col) continue;
                            bb = (byte)(bb << bitsPerPixel);
                            bb = (byte)(bb | i2);
                            break;
                        }
                        if (x + 1 == this.tempChunkCount) {
                            int pixelsLeft = (pixelsPerByte - (x + 1) % pixelsPerByte) % pixelsPerByte;
                            bb = (byte)(bb << pixelsLeft * bitsPerPixel);
                            this.chunkrgbs[this.chunkN++] = bb;
                            continue;
                        }
                        if ((x + 1) % pixelsPerByte != 0) continue;
                        this.chunkrgbs[this.chunkN++] = bb;
                    }
                    CentralDebugging.timerStop("Colour RLE Processing - <= 16 Colours");
                } else if (this.colorsFound <= 127) {
                    CentralDebugging.timerStart("Colour RLE Processing - <= 127 Colours");
                    this.chunkN = start;
                    this.chunkrgbs[this.chunkN++] = (byte)this.colorsFound;
                    for (i = 0; i < this.colorsFound; ++i) {
                        n = this.color[i];
                        this.chunkrgbs[this.chunkN++] = (byte)(n >>> 16);
                        this.chunkrgbs[this.chunkN++] = (byte)(n >>> 8);
                        this.chunkrgbs[this.chunkN++] = (byte)n;
                    }
                    int rgb = this.tempChunk[0];
                    int run = 0;
                    for (int i3 = 0; i3 < this.tempChunkCount; ++i3) {
                        int nextRGB = this.tempChunk[i3];
                        if (nextRGB == rgb) {
                            ++run;
                            continue;
                        }
                        Integer idx = this.colorMap.get(rgb);
                        if (run == 1) {
                            this.chunkrgbs[this.chunkN++] = (byte)idx.intValue();
                        } else {
                            this.chunkrgbs[this.chunkN++] = (byte)(idx | 0x80);
                            int tmp = --run / 255;
                            run %= 255;
                            for (int ii = 0; ii < tmp; ++ii) {
                                this.chunkrgbs[this.chunkN++] = -1;
                            }
                            this.chunkrgbs[this.chunkN++] = (byte)run;
                        }
                        rgb = nextRGB;
                        run = 1;
                    }
                    Integer idx = this.colorMap.get(rgb);
                    if (run == 1) {
                        int n2 = idx;
                        this.chunkrgbs[this.chunkN++] = (byte)n2;
                    } else {
                        this.chunkrgbs[this.chunkN++] = (byte)(idx | 0x80);
                        int tmp = --run / 255;
                        run %= 255;
                        for (int ii = 0; ii < tmp; ++ii) {
                            this.chunkrgbs[this.chunkN++] = -1;
                        }
                        this.chunkrgbs[this.chunkN++] = (byte)run;
                    }
                    CentralDebugging.timerStop("Colour RLE Processing - <= 127 Colours");
                }
            }
            catch (ArrayIndexOutOfBoundsException x) {
                x.printStackTrace();
            }
            CentralDebugging.timerStop("Colour RLE");
        } else if (blackIsEmpty) {
            CentralDebugging.timerStart("Cumulative Black is Empty Pixel Processing");
            for (int dy = 0; dy < deviceChunkArray.getHeight(); ++dy) {
                int d_yoffset = deviceChunkArray.getYOffset(dy);
                try {
                    for (int dx = 0; dx < deviceChunkArray.getWidth(); ++dx) {
                        int newCol = deviceChunkArray.source[d_yoffset + dx];
                        int oldCol = screenChunkArray.getXY(dx, dy);
                        if (oldCol == newCol) {
                            if (colour) {
                                this.chunkrgbs[this.chunkN++] = zero;
                                this.chunkrgbs[this.chunkN++] = zero;
                                this.chunkrgbs[this.chunkN++] = zero;
                                continue;
                            }
                            this.chunkrgbs[this.chunkN++] = zero;
                            continue;
                        }
                        if (colour) {
                            this.chunkrgbs[this.chunkN++] = byteModderRef[128 + (byte)(newCol >>> 16)];
                            this.chunkrgbs[this.chunkN++] = byteModderRef[128 + (byte)(newCol >>> 8)];
                            this.chunkrgbs[this.chunkN++] = byteModderRef[128 + (byte)newCol];
                            continue;
                        }
                        int r = 0xFF & newCol >>> 16;
                        int g = 0xFF & newCol >>> 8;
                        int b = 0xFF & newCol;
                        int total = (r + g + b) / 3;
                        this.chunkrgbs[this.chunkN++] = byteModderRef[128 + (byte)(0xFF & total)];
                    }
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException x) {
                    x.printStackTrace();
                }
            }
            CentralDebugging.timerStop("Cumulative Black is Empty Pixel Processing");
        } else {
            CentralDebugging.timerStart("Cumulative Mod Only Pixel Processing");
            try {
                for (int dy = 0; dy < deviceChunkArray.getHeight(); ++dy) {
                    int d_yoffset = deviceChunkArray.getYOffset(dy);
                    for (int dx = 0; dx < deviceChunkArray.getWidth(); ++dx) {
                        int newCol = deviceChunkArray.source[d_yoffset + dx];
                        if (colour) {
                            this.chunkrgbs[this.chunkN++] = byteModderRef[128 + (byte)(newCol >>> 16)];
                            this.chunkrgbs[this.chunkN++] = byteModderRef[128 + (byte)(newCol >>> 8)];
                            this.chunkrgbs[this.chunkN++] = byteModderRef[128 + (byte)newCol];
                            continue;
                        }
                        int r = 0xFF & newCol >>> 16;
                        int g = 0xFF & newCol >>> 8;
                        int b = 0xFF & newCol;
                        int total = (r + g + b) / 3;
                        this.chunkrgbs[this.chunkN++] = byteModderRef[128 + (byte)(0xFF & total)];
                    }
                }
            }
            catch (ArrayIndexOutOfBoundsException x) {
                x.printStackTrace();
            }
            CentralDebugging.timerStop("Cumulative Mod Only Pixel Processing");
        }
        CentralDebugging.timerStop("Cumulative Screen Modding and Copying");
        if (CentralDebugging.SCR_DISABLE_IMMEDIATE_SEND_AROUND_CURSOR) {
            immediateSend = false;
        }
        if (this.haveIssuedTranslate) {
            immediateSend = false;
        }
        this.sendScreenChunk(abs_x, abs_y, deviceChunkArray.getWidth(), deviceChunkArray.getHeight(), spec.enc, spec.fil, spec.comp, spec.coldepth, this.chunkrgbs, this.chunkN, immediateSend, spec.minimiseBandwidth, blackIsEmpty, chunkUid);
    }

    @Override
    public void endProcessingPixels(GrabSpec spec) throws IOException {
        boolean isEmpty = false;
        if (this.sendAsPngs || this.screenAsRGBBytes) {
            Message m = new Message(196633);
            Point point = this.instance.getMouseLocation();
            this.translatePointerLocation(point);
            if (point != null) {
                if (this.requestedArea != null) {
                    m.append(point.x -= this.requestedArea.x);
                    m.append(point.y -= this.requestedArea.y);
                }
                m.append(point.x);
                m.append(point.y);
            }
            this.mout.write(m);
        }
        if (BATCH_UP_SCREEN_DATAS) {
            isEmpty = this.batch.isEmpty();
            if (isEmpty) {
                if (LocalSwitches.DEV_acculogPipeline) {
                    Acculog.log("[ScreenServer] Nothing to send");
                }
            } else {
                if (LocalSwitches.DEV_acculogPipeline) {
                    Acculog.log("[ScreenServer] Sending screen data");
                }
                if (LocalSwitches.DEV_acculogSessionLaunch && this.firstScreenStart) {
                    this.firstScreenStart = false;
                    Acculog.log("[Session] Started sending screen back");
                }
                Message msg_packets_start = new Message(196610);
                this.mout.write(msg_packets_start);
                CentralDebugging.timerStart("Get Batch Message");
                Message towrite = this.batch.getBatchMessage();
                long t_processingTime = System.currentTimeMillis() - spec.t_created;
                this.processingTimeBuckets.rttMeasured(t_processingTime);
                CentralDebugging.timerStop("Get Batch Message");
                CentralDebugging.timerStart("Write Batch Message");
                this.mout.write(towrite);
                CentralDebugging.timerStop("Write Batch Message");
                CentralDebugging.counterAdd("Bytes Per Chunk (Compressed)", this.batch.compressedSize());
                CentralDebugging.counterFinish("Bytes Per Chunk (Compressed)");
                CentralDebugging.counterAdd("Bytes Per Screen Transfer (Compressed)", this.batch.compressedSize());
                this.screenSizeBuckets.bytesMeasured(this.batch.compressedSize());
            }
            this.batch.reset();
        }
        CentralDebugging.counterFinish("Bytes Per Screen Transfer (Uncompressed)");
        CentralDebugging.counterFinish("Bytes Per Screen Transfer (Compressed)");
        CentralDebugging.counterFinish("PNG Bytes Per Screen Transfer");
        if (LocalSwitches.DEV_acculogSessionLaunch && this.firstScreenEnd) {
            this.firstScreenEnd = false;
            Acculog.log("[Session] Finished sending screen back");
        }
        Message msg_packets_end = new Message(196612);
        if (!(CentralDebugging.SCR_SEND_NOTHING_ON_NO_CHANGE && BATCH_UP_SCREEN_DATAS && isEmpty)) {
            CentralDebugging.timerStart("Prepare Message");
            if (BATCH_UP_SCREEN_DATAS && isEmpty) {
                msg_packets_end = new Message(196626);
            }
            Point pointerPoint = null;
            if (this.grabber != null) {
                pointerPoint = this.grabber.getPointer();
            }
            if (pointerPoint != null) {
                this.translatePointerLocation(pointerPoint);
                if (CentralDebugging.SCR_USE_MINIMAL_ENCODING) {
                    int tmp = pointerPoint.x + 1 << 16 | pointerPoint.y + 1;
                    msg_packets_end.append(tmp);
                } else {
                    msg_packets_end.append(pointerPoint.x);
                    msg_packets_end.append(pointerPoint.y);
                }
            } else if (CentralDebugging.SCR_USE_MINIMAL_ENCODING) {
                msg_packets_end.append(0);
            } else {
                msg_packets_end.append(-1);
                msg_packets_end.append(-1);
            }
            CentralDebugging.timerStop("Prepare Message");
            CentralDebugging.timerStart("Write Message");
            this.mout.write(msg_packets_end);
            CentralDebugging.timerStop("Write Message");
            if (!CentralDebugging.SCR_NO_FLUSH_ALL_BUFFERS) {
                CentralDebugging.timerStart("Flushed Message");
                try {
                    this.instance.socket.flushAllBuffers(5000);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                CentralDebugging.timerStop("Flushed Message");
            }
        }
        long suggested_delay = spec.suggested_delay;
        CentralDebugging.timerStart("Sleep");
        if (!FORCE_MIN_SLEEP_AFTER_GRAB) {
            // empty if block
        }
        try {
            CentralDebugging.counterAdd("ScreenServer Suggested Sleep", suggested_delay);
            CentralDebugging.counterFinish("ScreenServer Suggested Sleep");
            long t_workedFor = System.currentTimeMillis() - spec.t_created;
            CentralDebugging.counterAdd("ScreenServer Worked For", t_workedFor);
            CentralDebugging.counterFinish("ScreenServer Worked For");
            if (Switches.SH_simpleConsistentScreenServerSleep) {
                long actualSleep = System.currentTimeMillis();
                long intendedSleep = suggested_delay;
                if (intendedSleep < 10L) {
                    intendedSleep = 10L;
                }
                if (intendedSleep > 0L) {
                    Thread.sleep(intendedSleep);
                }
                actualSleep = System.currentTimeMillis() - actualSleep;
                if (LocalSwitches.DEV_acculogPipeline) {
                    Acculog.log("[ScreenServer] Slept for " + actualSleep + ", intended to sleep for " + intendedSleep + " (requested delay was " + suggested_delay + ")");
                }
                if (CentralDebugging.SCR_PRINT_INTENDED_VS_ACTUAL_SLEEP) {
                    System.out.println("[ScreenServerSleep] Intended - " + intendedSleep + " (" + suggested_delay + "), Actual - " + actualSleep);
                }
            } else {
                long intendedSleep;
                long actualSleep = System.currentTimeMillis();
                if (this.coresAvailable > 1 && Switches.SH_1577_noScreenServerMinSleep && suggested_delay <= 30L) {
                    if (t_workedFor < 20L) {
                        if (t_workedFor < 0L) {
                            t_workedFor = 0L;
                        }
                        intendedSleep = 20L - t_workedFor;
                        Thread.sleep(intendedSleep);
                    } else {
                        intendedSleep = -1L;
                    }
                } else if (FORCE_MIN_SLEEP_AFTER_GRAB) {
                    long minSleep = suggested_delay - t_workedFor;
                    long cpuFriendlySleep = 0L;
                    cpuFriendlySleep = t_workedFor / 2L;
                    long toSleep = Math.max(minSleep, cpuFriendlySleep);
                    toSleep = Math.max(10L, Math.min(5000L, toSleep));
                    CentralDebugging.counterAdd("ScreenServer Attempted Sleep", toSleep);
                    CentralDebugging.counterFinish("ScreenServer Attempted Sleep");
                    intendedSleep = toSleep;
                    Thread.sleep(toSleep);
                } else {
                    long tosleep = suggested_delay - t_workedFor;
                    long minsleep = t_workedFor / 4L;
                    if (minsleep > 100L) {
                        minsleep = 100L;
                    }
                    if (tosleep < minsleep) {
                        tosleep = minsleep;
                    }
                    if (tosleep < 5L) {
                        tosleep = 5L;
                    }
                    intendedSleep = tosleep;
                    Thread.sleep(tosleep);
                }
                actualSleep = System.currentTimeMillis() - actualSleep;
                if (LocalSwitches.DEV_acculogPipeline) {
                    Acculog.log("[ScreenServer] Slept for " + actualSleep + ", intended to sleep for " + intendedSleep + " (requested delay was " + suggested_delay + ")");
                }
                if (CentralDebugging.SCR_PRINT_INTENDED_VS_ACTUAL_SLEEP) {
                    System.out.println("[ScreenServerSleep] Intended - " + intendedSleep + " (" + suggested_delay + "), Actual - " + actualSleep);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        CentralDebugging.timerStop("Sleep");
    }

    @Override
    public void notifySlowCapture() {
        this.instance.notifySlowCapture();
    }

    private void sendScreenChunk(int x, int y, int w, int h, int enc, int fil, int comp, int coldepth, byte[] screenBytes, int screenBytesLen, boolean paintNow, boolean betterCompression, boolean blackIsEmpty, Long chunkUid) throws IOException {
        if (CentralDebugging.SCR_VERBOSE_CHUNK_SEND) {
            System.out.println("sending chunk " + x + " " + y + " " + w + " " + h + " " + screenBytesLen / 1024 + "k");
        }
        CentralDebugging.counterAdd("Bytes Per Chunk (Uncompressed)", screenBytesLen);
        CentralDebugging.counterFinish("Bytes Per Chunk (Uncompressed)");
        CentralDebugging.counterAdd("Bytes Per Screen Transfer (Uncompressed)", screenBytesLen);
        if (this.screenAsRGBBytes) {
            Message m = new Message(196648);
            if (this.requestedArea != null) {
                m.append(x - this.requestedArea.x);
                m.append(y - this.requestedArea.y);
            } else {
                m.append(x);
                m.append(y);
            }
            byte[] newData = new byte[w * h * 3];
            this.mout.write(m);
        }
        if (this.sendAsPngs) {
            if (this.pngenc == null) {
                this.pngenc = new PngEncoder();
            }
            CentralDebugging.timerStart("PNG encoding");
            byte[] PNG = this.pngenc.encode(w, h, screenBytes);
            CentralDebugging.timerStop("PNG encoding");
            Message m = new Message(196631);
            if (this.requestedArea != null) {
                m.append(x - this.requestedArea.x);
                m.append(y - this.requestedArea.y);
            } else {
                m.append(x);
                m.append(y);
            }
            if (this.pngFormatBase64) {
                byte[] stringToAsciiBytes = StringToAscii.stringToAsciiBytes(Base64.byteArrayToBase64SB(PNG));
                m.append(stringToAsciiBytes);
            } else {
                m.append(PNG);
            }
            CentralDebugging.counterAdd("PNG Bytes Per Screen Transfer", PNG.length);
            this.mout.write(m);
        } else {
            if (!BATCH_UP_SCREEN_DATAS || paintNow) {
                comp = 101;
                CentralDebugging.timerStart("GZIP Compression (when compressing each chunk)");
                this.compdat.reset();
                LevelGzipOutputStream gzout = new LevelGzipOutputStream((OutputStream)this.compdat, betterCompression ? 5 : 3);
                gzout.write(screenBytes, 0, screenBytesLen);
                gzout.finish();
                gzout.close();
                screenBytes = this.compdat.getByteArray();
                screenBytesLen = this.compdat.size();
                CentralDebugging.timerStop("GZIP Compression (when compressing each chunk)");
            }
            Message msg_screen_packet = paintNow ? new Message(196616) : new Message(196611);
            if (CentralDebugging.SCR_USE_MINIMAL_ENCODING) {
                int tmp = x << 16 | y;
                msg_screen_packet.append(tmp);
                tmp = w << 16 | h;
                msg_screen_packet.append(tmp);
                tmp = enc << 2 | fil - 50;
                tmp = blackIsEmpty ? tmp << 1 | 1 : tmp << 1 | 0;
                if (BATCH_UP_SCREEN_DATAS && !paintNow) {
                    tmp = tmp << 3 | 0;
                    msg_screen_packet.append(tmp);
                    msg_screen_packet.append(this.batch.getEmpty());
                } else {
                    tmp = tmp << 3 | comp - 100;
                    msg_screen_packet.append(tmp);
                    msg_screen_packet.append(screenBytes);
                    CentralDebugging.counterAdd("Bytes Per Chunk (Compressed)", screenBytesLen);
                    CentralDebugging.counterFinish("Bytes Per Chunk (Compressed)");
                    CentralDebugging.counterAdd("Bytes Per Screen Transfer (Compressed)", screenBytesLen);
                }
            } else {
                msg_screen_packet.append(x);
                msg_screen_packet.append(y);
                msg_screen_packet.append(w);
                msg_screen_packet.append(h);
                msg_screen_packet.append(enc);
                msg_screen_packet.append(fil);
                msg_screen_packet.append(blackIsEmpty);
                if (BATCH_UP_SCREEN_DATAS && !paintNow) {
                    msg_screen_packet.append(100);
                    msg_screen_packet.append(this.batch.getEmpty());
                } else {
                    msg_screen_packet.append(comp);
                    msg_screen_packet.append(screenBytes);
                    CentralDebugging.counterAdd("Bytes Per Chunk (Compressed)", screenBytesLen);
                    CentralDebugging.counterFinish("Bytes Per Chunk (Compressed)");
                    CentralDebugging.counterAdd("Bytes Per Screen Transfer (Compressed)", screenBytesLen);
                }
            }
            Point pointerPoint = null;
            if (this.grabber != null) {
                pointerPoint = this.grabber.getPointer();
            }
            if (pointerPoint != null) {
                this.translatePointerLocation(pointerPoint);
                if (CentralDebugging.SCR_USE_MINIMAL_ENCODING) {
                    int tmp = pointerPoint.x + 1 << 16 | pointerPoint.y + 1;
                    msg_screen_packet.append(tmp);
                } else {
                    msg_screen_packet.append(pointerPoint.x);
                    msg_screen_packet.append(pointerPoint.y);
                }
            } else if (CentralDebugging.SCR_USE_MINIMAL_ENCODING) {
                msg_screen_packet.append(0);
            } else {
                msg_screen_packet.append(-1);
                msg_screen_packet.append(-1);
            }
            if (CentralDebugging.CACHE_ALL_CHUNKS) {
                if (CentralDebugging.DEBUG_SCR_CACHING_VERBOSE) {
                    System.out.println("DELETEME [ScreenServer] batching up and caching " + chunkUid + " paintNow=" + paintNow);
                }
                msg_screen_packet.append(chunkUid);
            }
            if (BATCH_UP_SCREEN_DATAS && !paintNow) {
                CentralDebugging.timerStart("Cumulative Screen batching and compression");
                this.batch.addBlock(msg_screen_packet, screenBytes, 0, screenBytesLen);
                CentralDebugging.timerStop("Cumulative Screen batching and compression");
            } else {
                this.mout.write(msg_screen_packet);
            }
        }
    }

    public void translatePointerLocation(Point pointerPoint) {
        if (pointerPoint == null || this.grabber == null) {
            return;
        }
        pointerPoint.x = this.grabber.translateReverseX(pointerPoint.x);
        pointerPoint.y = this.grabber.translateReverseY(pointerPoint.y);
        if (OS.isWindowsVistaOrAbove()) {
            ScreenDimension.toPhysical(pointerPoint);
        }
    }

    public void setInitialisationThread(SDesktopServerController.PreSessionLoaderThread pt) {
        this.delayedInitialisationThread = pt;
    }

    static {
        for (int i = 0; i < STATIC_INTS.length; ++i) {
            ScreenServer.STATIC_INTS[i] = i;
        }
        SCREEN_GRAB_STATIC_LOCK = new Object();
    }

    class ContinuousScreenSend
    extends Thread {
        ContinuousScreenSend() {
        }

        @Override
        public void run() {
            while (!ScreenServer.this.die) {
                if (CentralDebugging.SCR_SEND_THREAD_VERBOSE) {
                    System.out.println("ContinuousSendThread: loop begin");
                }
                if (ScreenServer.this.continuousSend) {
                    try {
                        if (!ScreenServer.this.sentWarning) {
                            double ratekb = ((ScreenServer)ScreenServer.this).instance.directSocket.getCurrentFlowRateKB();
                            if (((ScreenServer)ScreenServer.this).instance.directSocket.isUsingFlowControl()) {
                                if (ratekb >= 11.0) {
                                    ScreenServer.this.poorSince = 0L;
                                } else {
                                    long poorElapsed;
                                    if (ScreenServer.this.poorSince == 0L) {
                                        ScreenServer.this.poorSince = SafeClock.currentTimeMillis();
                                    }
                                    if ((poorElapsed = SafeClock.currentTimeMillis() - ScreenServer.this.poorSince) > 20000L) {
                                        System.out.println("[ScreenServer] rate has been poor for more than 20 seconds now, sending a warning");
                                        ScreenServer.this.sentWarning = true;
                                        ScreenServer.this.instance.warnPoorConnection();
                                    }
                                }
                            } else {
                                ScreenServer.this.poorSince = 0L;
                            }
                        }
                    }
                    catch (Exception ratekb) {
                        // empty catch block
                    }
                    if (CentralDebugging.SCR_SEND_THREAD_VERBOSE) {
                        System.out.println("ContinuousSendThread: continuousSend is ON");
                    }
                    try {
                        Message tmp;
                        Message toUse = null;
                        if (ScreenServer.this.grab_override != null) {
                            if (CentralDebugging.SCR_SEND_THREAD_VERBOSE) {
                                System.out.println("ContinuousSendThread: sending grab message based on override");
                            }
                            toUse = ScreenServer.this.grab_override;
                        } else if (ScreenServer.this.last_grab_message != null) {
                            if (CentralDebugging.SCR_SEND_THREAD_VERBOSE) {
                                System.out.println("ContinuousSendThread: sending grab message based on last grab request");
                            }
                            toUse = ScreenServer.this.last_grab_message;
                            tmp = new Message(196625);
                            tmp.appendAll(ScreenServer.this.last_grab_message);
                            ScreenServer.this.handleMessage(tmp);
                        }
                        if (toUse != null) {
                            if (CentralDebugging.SCR_SEND_THREAD_VERBOSE) {
                                System.out.println("ContinuousSendThread: requesting full grab");
                            }
                            tmp = new Message(196625);
                            tmp.appendAll(toUse);
                            ScreenServer.this.handleMessage(tmp);
                            if (!CentralDebugging.SCR_SEND_THREAD_VERBOSE) continue;
                            System.out.println("ContinuousSendThread: completed grab message processing");
                            continue;
                        }
                        if (!CentralDebugging.SCR_SEND_THREAD_VERBOSE) continue;
                        System.out.println("ContinuousSendThread: no grab message to use");
                    }
                    catch (Throwable e) {
                        ScreenServer.this.limitedErrorHandler.handlerError("[ScreenServer] Severe error in continuous screen_internal send (width: " + ScreenServer.this.lastScreenSizeW + " height:" + ScreenServer.this.lastScreenSizeH + ")", e);
                        try {
                            Thread.sleep(40L);
                        }
                        catch (Throwable throwable) {}
                    }
                    continue;
                }
                if (CentralDebugging.SCR_SEND_THREAD_VERBOSE) {
                    System.out.println("ContinuousSendThread: continuousSend is OFF");
                }
                try {
                    Thread.sleep(250L);
                }
                catch (Exception exception) {}
            }
            System.out.println("Continuous screen send thread stopping (die set to true)");
        }
    }
}

