/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.server.controller;

import com.aem.CentralDebugging;
import com.aem.sdesktop.server.controller.NativeGrab;
import com.aem.shelp.util.ScreenDimension;
import com.aem.utils.NativeLibraryLoader;
import java.awt.Dimension;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import utils.ostools.OS;

public class MultiScreenMapper {
    private Rectangle max;
    private Rectangle[] mine;
    private GraphicsDevice[] devs;
    private Robot[] robots;
    private int xoff;
    private int yoff;
    private NativeGrab grabUtilGrab = NativeGrab.getInstance();
    private long lastRecalculated = 0L;
    int[] subcached;
    int[] cached;

    public void cleanUpForShutdown() {
        this.mine = null;
        this.devs = null;
        this.robots = null;
    }

    public static void main(String[] args) {
        NativeLibraryLoader.loadLibrary();
        MultiScreenMapper msm = new MultiScreenMapper();
        Dimension dim = msm.getScreenSize();
        System.out.println("Dimension: " + dim);
        long start = System.currentTimeMillis();
        int count = 20;
        for (int i = 0; i < count; ++i) {
            int[] rgbPixels = msm.getRGBPixels(new Rectangle(0, 0, (int)dim.getWidth(), (int)dim.getHeight()), false);
            System.out.println("Got " + rgbPixels.length + " pixels");
        }
        System.out.println((System.currentTimeMillis() - start) / 20L);
    }

    public MultiScreenMapper() {
        this.recalculateScreens();
    }

    private void recalculateScreens() {
        GraphicsDevice[] devices = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        if (this.devs == null || devices.length != this.devs.length) {
            if (CentralDebugging.SCR_GRAB_VERBOSE) {
                System.out.println("**Expensive** Graphics devices have changed, recalculating screens");
            }
            GraphicsDevice[] olddevs = this.devs;
            this.devs = devices;
            this.mine = new Rectangle[this.devs.length];
            Robot[] oldrobots = this.robots;
            this.robots = new Robot[this.devs.length];
            for (int i = 0; i < this.devs.length; ++i) {
                boolean found = false;
                if (olddevs != null) {
                    String newID = this.devs[i].getIDstring();
                    for (int k = 0; k < olddevs.length; ++k) {
                        try {
                            String oldID = olddevs[k].getIDstring();
                            if (!newID.equals(oldID)) continue;
                            this.robots[i] = oldrobots[k];
                            found = true;
                            break;
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                if (found) continue;
                try {
                    this.robots[i] = new Robot(this.devs[i]);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            this.lastRecalculated = 0L;
        }
        if (System.currentTimeMillis() - this.lastRecalculated > 5000L) {
            if (CentralDebugging.SCR_GRAB_VERBOSE) {
                System.out.println("Recalculating screen size(s)");
            }
            for (int i = 0; i < this.devs.length; ++i) {
                Rectangle bounds = ScreenDimension.getOriginalScreenBoundsFor(i);
                System.out.println("[MultiScreenMapper] Bounds for " + i + "=" + bounds);
                this.mine[i] = bounds;
                this.max = i == 0 ? bounds : this.max.union(bounds);
            }
            this.xoff = this.max.x;
            this.yoff = this.max.y;
            this.lastRecalculated = System.currentTimeMillis();
        }
    }

    public int translateX(int x) {
        this.recalculateScreens();
        return x + this.xoff;
    }

    public int translateY(int y) {
        this.recalculateScreens();
        return y + this.yoff;
    }

    public int translateReverseX(int x) {
        return x - this.xoff;
    }

    public int translateReverseY(int y) {
        return y - this.yoff;
    }

    public int[] getValidCoord() {
        if (this.mine.length > 0) {
            return new int[]{this.mine[0].x, this.mine[0].y};
        }
        return new int[]{0, 0};
    }

    public boolean isCoordValid(int x, int y) {
        if (OS.isWindowsVistaOrAbove()) {
            return true;
        }
        this.recalculateScreens();
        x = this.translateX(x);
        y = this.translateY(y);
        for (int i = 0; i < this.mine.length; ++i) {
            if (!this.mine[i].contains(x, y)) continue;
            return true;
        }
        return false;
    }

    private int[] getOpenGLPixels(int i, Rectangle grabby, int[] dest) {
        this.grabUtilGrab.scrapeScreensAsInts(dest, grabby.width, grabby.height, dest.length, i);
        return dest;
    }

    private int[] getNonNativePixels_superSlow(int i, Rectangle grabby) {
        BufferedImage screenCapture = this.robots[i].createScreenCapture(grabby);
        return ((DataBufferInt)screenCapture.getRaster().getDataBuffer()).getData();
    }

    public void temporarilyFreeMemoryAtFutureCost() {
        this.subcached = null;
        this.cached = null;
    }

    public int[] getRGBPixels(Rectangle r, boolean forceNonNative) {
        if (CentralDebugging.SCR_FORCE_NON_NATIVE_GRAB) {
            forceNonNative = true;
        }
        if (this.cached == null || this.cached.length != r.width * r.height) {
            this.cached = null;
            this.cached = new int[r.width * r.height];
            if (CentralDebugging.SCR_GRAB_VERBOSE) {
                System.out.println("**Expensive** Creating new cached int array (wrong size)");
            }
        }
        int[] data = this.cached;
        try {
            this.recalculateScreens();
            r = new Rectangle(this.translateX(r.x), this.translateY(r.y), r.width, r.height);
            for (int i = 0; i < this.mine.length; ++i) {
                if (!this.mine[i].intersects(r)) continue;
                if (CentralDebugging.SCR_GRAB_VERBOSE) {
                    System.out.println("Requested rectable " + r + " intersects with GD " + i + " rectangle " + this.mine[i]);
                }
                Rectangle grabby = this.mine[i].intersection(r);
                Rectangle altgrabby = (Rectangle)grabby.clone();
                if (CentralDebugging.SCR_GRAB_VERBOSE) {
                    System.out.println("Grabbing " + grabby + " from GD " + i + " ()");
                }
                try {
                    int[] dat;
                    block25: {
                        CentralDebugging.timerStart("Grab screen pixels");
                        if (this.subcached == null || this.subcached.length < grabby.width * grabby.height) {
                            this.subcached = null;
                            this.subcached = new int[grabby.width * grabby.height];
                        }
                        dat = null;
                        try {
                            if (!forceNonNative) {
                                if (CentralDebugging.SCR_GRAB_OPENGL_NATIVE) {
                                    if (CentralDebugging.SCR_GRAB_VERBOSE) {
                                        System.out.println("Grabbing opengl pixels (fastest)");
                                    }
                                    dat = this.getOpenGLPixels(i, grabby, this.subcached);
                                    if (CentralDebugging.SCR_GRAB_VERBOSE && dat == null) {
                                        System.out.println("OpenGL pixel grab failed (null array)");
                                    }
                                }
                            } else {
                                dat = null;
                            }
                            if (dat == null) {
                                if (CentralDebugging.SCR_GRAB_VERBOSE) {
                                    System.out.println("Grabbing non native pixels from GD (null) " + i + " (slower)");
                                }
                                this.subcached = null;
                                dat = this.getNonNativePixels_superSlow(i, grabby);
                                if (CentralDebugging.SCR_GRAB_VERBOSE) {
                                    System.out.println("Got " + dat);
                                }
                            }
                        }
                        catch (NegativeArraySizeException e) {
                            if (CentralDebugging.SCR_GRAB_VERBOSE) {
                                System.out.println("NegativeArraySizeException, rebasing X, Y");
                            }
                            altgrabby.x -= this.mine[i].x;
                            altgrabby.y -= this.mine[i].y;
                            if (dat != null) break block25;
                            if (CentralDebugging.SCR_GRAB_VERBOSE) {
                                System.out.println("Post rebase, Grabbing non native pixels from GD (exception) " + i);
                            }
                            this.subcached = null;
                            dat = this.getNonNativePixels_superSlow(i, altgrabby);
                            if (!CentralDebugging.SCR_GRAB_VERBOSE) break block25;
                            System.out.println("Post rebase, Got " + dat);
                        }
                    }
                    CentralDebugging.timerStop("Grab screen pixels");
                    CentralDebugging.timerStart("Copy screen data from grab to master array");
                    for (int yy = 0; yy < grabby.height; ++yy) {
                        int lineOffset = (grabby.y - r.y + yy) * r.width;
                        int glineOffset = yy * grabby.width;
                        int colOffset = grabby.x - r.x;
                        System.arraycopy(dat, glineOffset, data, lineOffset + colOffset, grabby.width);
                    }
                    CentralDebugging.timerStop("Copy screen data from grab to master array");
                    continue;
                }
                catch (OutOfMemoryError e) {
                    if (!CentralDebugging.SCR_GRAB_VERBOSE) continue;
                    System.out.println("**Important** Disabling robot peers (out of memory in main block of getRGBPixels)");
                    e.printStackTrace();
                    continue;
                }
                catch (Throwable e) {
                    StringBuffer sb = new StringBuffer();
                    sb.append("Error grabbing screen data (" + e + ") from display " + i + "...\n");
                    sb.append("\tRectangle requested: " + r + "\n");
                    sb.append("\tRectangle available: " + this.mine[i] + "\n");
                    sb.append("\tIntersecting rectangle requested: " + grabby + "\n");
                    sb.append("\tGraphics Device Configuration: " + this.devs[i] + "\n");
                    System.out.println(sb);
                    e.printStackTrace();
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return data;
    }

    public Dimension getScreenSize() {
        this.recalculateScreens();
        return new Dimension(this.max.width, this.max.height);
    }
}

