/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.server.controller;

import com.aem.CentralDebugging;
import com.aem.sdesktop.interfaces.GC;
import com.aem.sdesktop.interfaces.MSG;
import com.aem.sdesktop.interfaces.ServerPart;
import com.aem.sdesktop.server.controller.SDesktopServerController;
import com.aem.sdesktop.server.controller.SDesktopServerInstance;
import com.aem.sdesktop.util.ClipboardUtil;
import com.aem.utils.CompressionUtil;
import com.aem.utils.Debugger;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import utils.message.Message;
import utils.message.MessageReader;
import utils.message.MessageWriter;

public class ClipboardServer
extends Thread
implements MSG,
GC,
ServerPart {
    MessageReader min;
    MessageWriter mout;
    SDesktopServerController controller;
    SDesktopServerInstance instance;
    boolean die = false;
    String lastClipboard = "";

    @Override
    public void die() {
        this.die = true;
    }

    public void log(String s) {
        System.out.println(s);
    }

    public ClipboardServer(SDesktopServerInstance instance, SDesktopServerController controller, InputStream input, OutputStream output) {
        super("ClipboardServerThread");
        this.controller = controller;
        this.instance = instance;
        this.min = new MessageReader(input);
        this.mout = new MessageWriter(output);
    }

    @Override
    public void run() {
        Message m = null;
        try {
            while (!this.die) {
                m = this.min.read();
                this.handleMessage(m);
            }
        }
        catch (IOException e) {
            if (CentralDebugging.PRINT_STACK_ON_CONNECTION_FAIL) {
                System.out.println("(Clipboard Server) LAST MESSAGE:" + m);
                e.printStackTrace();
            } else {
                System.out.println("[ClipboardServer] " + e);
            }
            this.log("[ClipboardServer] Connection terminated");
        }
        catch (Throwable e) {
            this.log("An unclassified error occurred in ClipboardServer: " + Debugger.getStackTrace(e));
            System.out.println("(Clipboard Server) LAST MESSAGE:" + m);
            e.printStackTrace();
        }
        this.instance.died();
    }

    public void handleMessage(Message m) throws IOException {
        int type = m.getType();
        if (type == 262160) {
            if (CentralDebugging.MSG_VERBOSE) {
                System.out.println("CLIP_PUTSTRING " + m);
            }
            byte[] bytes = (byte[])m.get(0);
            String data = CompressionUtil.decompressString(bytes, "UTF-8");
            ClipboardUtil.setClipboardAsText(data);
        } else if (type == 262161) {
            if (CentralDebugging.MSG_VERBOSE) {
                System.out.println("CLIP_PUTSTRING_AND_PASTE " + m);
            }
            byte[] bytes = (byte[])m.get(0);
            String data = CompressionUtil.decompressString(bytes, "UTF-8");
            try {
                if (data != null && !data.equals(this.lastClipboard)) {
                    ClipboardUtil.setClipboardAsText(data);
                    this.lastClipboard = data;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.instance.inputserver.sendPasteKeys();
        } else if (type == 262153) {
            if (CentralDebugging.MSG_VERBOSE) {
                System.out.println("CLIP_GETSTRING " + m);
            }
            System.out.println("[ClipboardServer] Attempting to process GetString request.");
            try {
                Thread.sleep(75L);
            }
            catch (Exception bytes) {
                // empty catch block
            }
            try {
                String data = ClipboardUtil.getClipboardAsText();
                if (data != null) {
                    System.out.println("[ClipboardServer] Got " + data.length() + " data from the clipboard");
                } else {
                    System.out.println("[ClipboardServer] Got no (null) data from the clipboard");
                }
                byte[] compressedData = CompressionUtil.compressString(data, "UTF-8");
                if (compressedData != null) {
                    System.out.println("[ClipboardServer] Compressed to " + compressedData.length + " bytes");
                } else {
                    System.out.println("[ClipboardServer] Error while compressing text clipboard contents.");
                }
                m = new Message(262160);
                m.append(compressedData);
                this.mout.write(m);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (type == 262145) {
            if (CentralDebugging.MSG_VERBOSE) {
                System.out.println("CLIP_SAVE " + m);
            }
            String savepath = (String)m.get(0);
            Clipboard clipb = Toolkit.getDefaultToolkit().getSystemClipboard();
            Transferable transfer = clipb.getContents(this);
            try {
                ArrayList files = null;
                String text = null;
                try {
                    files = (ArrayList)transfer.getTransferData(DataFlavor.javaFileListFlavor);
                    text = "";
                }
                catch (Exception e) {
                    files = new ArrayList();
                    text = (String)transfer.getTransferData(DataFlavor.stringFlavor);
                }
                System.out.println("Sending clipboard packets (" + files.size() + " files)");
                m = new Message(262146);
                m.append(savepath);
                this.mout.write(m);
                for (int i = 0; i < files.size(); ++i) {
                    File file = (File)files.get(i);
                    this.sendFile(file, file);
                }
                if (text != null) {
                    m = new Message(262151);
                    m.append(text);
                    this.mout.write(m);
                }
                System.out.println("finished clipboard packets");
                m = new Message(262149);
                this.mout.write(m);
            }
            catch (Exception e) {
                System.out.println("clipboard transfer failure " + e);
                e.printStackTrace();
                m = new Message(262150);
                this.mout.write(m);
            }
        } else {
            this.log("unrecognised clipboard server message " + m);
        }
    }

    private String getRelativeName(File base, File file) throws IOException {
        if (base == file) {
            return "";
        }
        String basename = base.getName();
        String path = base.getCanonicalPath();
        String subpath = file.getCanonicalPath();
        if (!path.endsWith("/") && !path.endsWith("\\")) {
            path = path + File.separatorChar;
        }
        subpath = subpath.substring(path.length() - (basename.length() + 1));
        return subpath;
    }

    private void sendFile(File base, File file) throws IOException {
        String relname = this.getRelativeName(base, file);
        if (base == file || relname.length() == 0) {
            relname = file.getName();
        }
        System.out.println("Sending file " + base.getAbsolutePath() + " // " + relname);
        boolean dir = file.isDirectory();
        Message m = new Message(262147);
        m.append(relname);
        m.append(file.length());
        if (dir) {
            m.append("DIR");
        }
        this.mout.write(m);
        if (dir) {
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                this.sendFile(base, files[i]);
            }
        } else {
            BufferedInputStream fin = new BufferedInputStream(new FileInputStream(file));
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            byte[] buf = new byte[50000];
            int n = 0;
            while (n != -1) {
                n = ((InputStream)fin).read(buf, 0, 50000);
                if (n > 0) {
                    bout.write(buf, 0, n);
                }
                if (bout.size() <= 4096) continue;
                m = new Message(262148);
                m.append(bout.toByteArray());
                this.mout.write(m);
                bout.reset();
            }
            if (bout.size() > 0) {
                m = new Message(262148);
                m.append(bout.toByteArray());
                this.mout.write(m);
            }
            ((InputStream)fin).close();
        }
    }
}

