/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.server.controller;

import com.aem.CentralDebugging;
import com.aem.sdesktop.ArrayToMessage;
import com.aem.sdesktop.client.gui.diag.ServicesTableModel;
import com.aem.sdesktop.common.CachedSplashLoader;
import com.aem.sdesktop.common.OpusConfig;
import com.aem.sdesktop.interfaces.GC;
import com.aem.sdesktop.interfaces.MSG;
import com.aem.sdesktop.interfaces.ServerPart;
import com.aem.sdesktop.interfaces.ServerUserInterface;
import com.aem.sdesktop.server.SessionInfoUpdater;
import com.aem.sdesktop.server.controller.CursorMonitorThread;
import com.aem.sdesktop.server.controller.KeyboardMappingThread;
import com.aem.sdesktop.server.controller.LinuxKeyboardHandler;
import com.aem.sdesktop.server.controller.SDesktopServerController;
import com.aem.sdesktop.server.controller.SDesktopServerInstance;
import com.aem.sdesktop.server.controller.ScreenServer;
import com.aem.sdesktop.server.controller.SoundServer;
import com.aem.sdesktop.server.controller.settings.AeroDisabler;
import com.aem.sdesktop.server.controller.settings.ControlBlocker;
import com.aem.sdesktop.server.controller.settings.GraphicsDriverDisabler;
import com.aem.sdesktop.server.controller.settings.MonitorOffKeeper;
import com.aem.sdesktop.server.controller.settings.ScreenBlanker;
import com.aem.sdesktop.server.controller.settings.WallpaperDisabler;
import com.aem.sdesktop.server.gui.ConnectionSettings;
import com.aem.sdesktop.util.CancelledException;
import com.aem.sdesktop.util.MouseMover;
import com.aem.sdesktop.util.ui.AvatarMap;
import com.aem.sgateway.SimpleGatewayID;
import com.aem.shelp.common.toolbox.ToolBoxItem;
import com.aem.shelp.common.toolbox.ToolBoxResult;
import com.aem.shelp.common.toolbox.server.ToolBoxRunner;
import com.aem.shelp.tech.admin.subsections.simulation.Simulation;
import com.aem.shelp.tech.admin.subsections.simulation.SimulationStep;
import com.aem.shelp.util.FixedByteBuffer;
import com.aem.shelp.util.GetDoubleClickTime;
import com.aem.shelp.util.MousePositionUtil;
import com.aem.shelp.util.OneClock;
import com.aem.shelp.util.P2PSock;
import com.aem.shelp.util.PopupNotificationWindow;
import com.aem.shelp.util.RebootMain;
import com.aem.shelp.util.SHelpNodelinkConnector;
import com.aem.shelp.util.ShFork;
import com.aem.shelp.util.WEnv;
import com.aem.shelp.util.WReg;
import com.aem.shelp.util.WSessionInfo;
import com.aem.shelp.util.windows.AmIAdministrator;
import com.aem.utils.CursorInfo;
import com.aem.utils.Debugger;
import com.aem.utils.NativeEventUtil;
import com.aem.utils.NativeMacUtils;
import com.aem.utils.NativeUtils;
import com.aem.utils.ProcessResultMessage;
import com.aem.utils.keyhandling.KeyboardLayout;
import com.aem.utils.os.SystemInfo;
import java.awt.Point;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.Properties;
import javax.swing.ImageIcon;
import jwrapper.allplatformwrapper.AllPlatformWrapper;
import jwrapper.failover.FailoverListener;
import jwrapper.failover.FailoverMonitor;
import jwrapper.failover.InfiniteDelayFailoverListener;
import jwrapper.hidden.JWNativeAPI;
import jwrapper.jwutils.JWLinuxOS;
import jwrapper.jwutils.JWSystem;
import jwrapper.jwutils.JWSystemUI;
import jwrapper.jwutils.JWWindowsOS;
import jwrapper.logging.ProcessResult;
import jwrapper.proxy.JWProxyCredentials;
import jwrapper.updater.JWLaunchProperties;
import utils.message.Message;
import utils.message.MessageReader;
import utils.message.MessageUtils;
import utils.message.MessageWriter;
import utils.osstats.LoadAverageUtil;
import utils.osstats.OsStats;
import utils.osstats.Stats;
import utils.osstats.winutils.WMIRegistry;
import utils.osstats.winutils.WMIResults;
import utils.osstats.winutils.WmicUtil;
import utils.ostools.OS;
import utils.ostools.RunCommandGetOutput;
import utils.progtools.ProcessPrinter;
import utils.progtools.StackTracer;
import utils.progtools.URIUtil;
import utils.string.Base64;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.switches.LocalSwitches;
import utils.switches.Switches;
import utils.udp.Acculog;
import utils.vnc.VNC;
import utils.vnc.utils.SimpleVNCSessionSettings;

public class AsyncServer
extends Thread
implements MSG,
GC,
ServerPart {
    private final MessageReader min;
    private final MessageWriter mout;
    private final SDesktopServerInstance instance;
    private final SDesktopServerController controller;
    private final ServerUserInterface serverUI;
    private boolean die = false;
    private boolean sendingStats = false;
    private final boolean mmoveRequiredButFailed;
    private VNC currentVNCConnection = null;
    private final SessionNotificationListener sessionStateListener = new SessionNotificationListener();
    private CursorMonitorThread cmt;
    private KeyboardMappingThread kmt;
    private InfiniteDelayFailoverListener failoverListener;
    private PopupNotificationWindow.ClosablePopupNotificationWindow popupNotificationWindow;
    private MetricBroadcaster metricBroadcaster;
    String cachedName;
    private RTTThread rtts;
    private int previousX = 0;
    private int previousY = 0;

    @Override
    public void die() {
        this.die = true;
    }

    public void notifyTechnicianCustomerDisconnect() throws IOException {
        System.out.println("[AsyncServer] Sending notification to technician that session is being terminated by the customer.");
        Message m = new Message(-1061158827);
        m.append(this.controller.currentCustomer.getCustomerID());
        this.mout.write(m);
        this.mout.flush();
    }

    public ScreenServer getScreenServer() {
        return this.instance.screenserver;
    }

    public AsyncServer(SDesktopServerInstance instance, ServerUserInterface sui, SDesktopServerController controller, InputStream input, OutputStream output, boolean mmoveRequiredButFailed) {
        super("AsyncServerThread");
        this.controller = controller;
        this.instance = instance;
        this.serverUI = sui;
        this.mmoveRequiredButFailed = mmoveRequiredButFailed;
        this.min = new MessageReader(input);
        this.mout = new MessageWriter(output);
        try {
            if (!controller.currentCustomer.isDemo()) {
                this.cmt = new CursorMonitorThread(this);
                this.cmt.start();
                this.kmt = new KeyboardMappingThread(this);
                this.kmt.start();
            }
        }
        catch (Throwable t) {
            System.out.println("[AsyncServer] [ERROR] Unable to initialise CursorMonitorThread/KeyboardMappingThread");
            t.printStackTrace();
        }
        try {
            if (OS.isWindows()) {
                WmicUtil.initWindowsDirectory((String)WEnv.getEnv("windir"));
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        try {
            if (OS.isWindows7OrAbove()) {
                int consoleID;
                int mySessionID = JWNativeAPI.getInstance().getTsMySessionId();
                if (mySessionID == (consoleID = JWNativeAPI.getInstance().getTsConsoleSessionId())) {
                    Message m = new Message(196643);
                    m.append(true);
                    m.append(mySessionID);
                    m.append(consoleID);
                    this.mout.write(m);
                } else {
                    Message m = new Message(196643);
                    m.append(false);
                    m.append(mySessionID);
                    m.append(consoleID);
                    this.mout.write(m);
                }
            } else {
                Message m = new Message(196643);
                m.append(false);
                m.append(-1);
                m.append(-1);
                this.mout.write(m);
            }
        }
        catch (Throwable m) {
            // empty catch block
        }
        new SessionInfoSender();
        System.out.println("[AsyncServer] Registering event handler");
        if (NativeEventUtil.getInstance() != null) {
            try {
                NativeEventUtil.getInstance().addEventListener(this.sessionStateListener);
                System.out.println("[AsyncServer] Registered event handler");
            }
            catch (Throwable t) {
                System.out.println("[AsyncServer] [ERROR] Unable to add session state listener");
                t.printStackTrace();
            }
        }
    }

    public void notifySlowCapture() {
        try {
            Message m = new Message(196645);
            this.mout.write(m);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        Message m = null;
        System.out.println("[AsyncServer] running, disabling automatic failover");
        this.failoverListener = new InfiniteDelayFailoverListener();
        FailoverMonitor.setListener((FailoverListener)this.failoverListener);
        try {
            NativeUtils nutils = NativeUtils.getInstance();
            try {
                if (MouseMover.getStaticMouseMover() != null) {
                    System.out.println("Requesting that UAC be turned off");
                    MouseMover.getStaticMouseMover().uacOff();
                } else {
                    System.out.println("No mmove, UAC will be left on");
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            try {
                new RdpConsoleChecker().start();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            try {
                if (!this.controller.isRemoteAccessSession()) {
                    new RemoteAccessServiceChecker().start();
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            this.metricBroadcaster = new MetricBroadcaster();
            this.metricBroadcaster.start();
            if (this.mmoveRequiredButFailed) {
                Message failure = new Message(65556);
                this.mout.write(failure);
            }
            try {
                long doubleClickSpeed = GetDoubleClickTime.getDoubleClickTimeMillis();
                Message speed = new Message(65568);
                speed.append(doubleClickSpeed);
                this.mout.write(speed);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            while (!this.die) {
                m = this.min.read();
                this.handleMessage(m);
            }
        }
        catch (IOException e) {
            if (CentralDebugging.PRINT_STACK_ON_CONNECTION_FAIL) {
                System.out.println("(Async Server) LAST MESSAGE:" + m);
                e.printStackTrace();
            } else {
                System.out.println("[AsyncServer] " + e);
            }
            System.out.println("[AsyncServer] Connection terminated");
        }
        catch (Throwable e) {
            System.out.println("An unclassified error occurred in AsyncServer: " + Debugger.getStackTrace(e));
            System.out.println("(Async Server) LAST MESSAGE:" + m);
            e.printStackTrace();
        }
        this.instance.died();
    }

    public void autodetectKeyboardMapping() {
        try {
            if (OS.isMacOS()) {
                String layoutName = RunCommandGetOutput.runCommandGetOutput((String[])new String[]{"/bin/sh", "-c", "defaults read ~/Library/Preferences/com.apple.HIToolbox.plist AppleCurrentKeyboardLayoutInputSourceID"})[0];
                String keyboardLayoutID = layoutName.trim();
                String name = keyboardLayoutID.replace("com.apple.keylayout.", "");
                if (this.cachedName == null || !this.cachedName.equals(name)) {
                    this.cachedName = name;
                    System.out.println("[AsyncServer] Detected new keyboard mapping " + this.cachedName);
                    Message mapping = new Message(65571);
                    mapping.append(this.cachedName);
                    this.mout.write(mapping);
                    NativeMacUtils.getInstance().reinitMapping();
                }
            } else if (OS.isWindows()) {
                long id = JWNativeAPI.getInstance().getCurrentKeyboardLayout();
                String name = KeyboardLayout.toHexLayoutID(id);
                String desc = KeyboardLayout.getWindowsKeyboardLayoutDescription(id);
                if (this.cachedName == null || !this.cachedName.equals(name)) {
                    this.cachedName = name;
                    System.out.println("[AsyncServer] Detected new keyboard mapping " + desc + " (" + name + ")");
                    Message mapping = new Message(65571);
                    mapping.append(desc);
                    this.mout.write(mapping);
                }
            } else if (OS.isLinux()) {
                String name = LinuxKeyboardHandler.getCurrentLayoutName();
                if (this.cachedName == null || !this.cachedName.equals(name)) {
                    this.cachedName = name;
                    System.out.println("[AsyncServer] Detected new keyboard mapping " + name);
                    Message mapping = new Message(65571);
                    mapping.append(name);
                    this.mout.write(mapping);
                    if (LinuxKeyboardHandler.INSTANCE != null) {
                        LinuxKeyboardHandler.INSTANCE.reinit();
                    }
                }
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void restoreSettings(boolean lastConnectionAlive) {
        if (lastConnectionAlive) {
            System.out.println("Last connection terminating, restoring all settings");
        }
        if (lastConnectionAlive) {
            WallpaperDisabler.INSTANCE.restore();
            AeroDisabler.INSTANCE.restore();
            GraphicsDriverDisabler.INSTANCE.restore();
            try {
                System.out.println("Checking to restore UAC");
                if (MouseMover.getStaticMouseMover() != null) {
                    System.out.println("Last connection, restoring UAC");
                    MouseMover.getStaticMouseMover().uacOn();
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            WallpaperDisabler.INSTANCE.block();
            AeroDisabler.INSTANCE.block();
            GraphicsDriverDisabler.INSTANCE.block();
        }
    }

    public static void setLockDesktopOnDisconnect(boolean enabled) {
        System.out.println("[AsyncServer] Requesting lock desktop on disconnect: " + enabled);
        if (MouseMover.getPossiblyRestrictedMouseMover() != null) {
            System.out.println("[AsyncServer] Got mousemover...");
            MouseMover.getPossiblyRestrictedMouseMover().setCleanupState("lock", Boolean.toString(enabled));
            System.out.println("[AsyncServer] Completed sending request to mousemover");
        }
    }

    private void setUseHardwareAcceleratedScreenGrab(boolean useIt) {
        AsyncServer.setUseHardwareAcceleratedScreenGrab(useIt, this.instance);
    }

    public static void setUseHardwareAcceleratedScreenGrab(boolean useIt, SDesktopServerInstance instance) {
        if (useIt) {
            System.out.println("[AsyncServer] Hardware accelerated screen grabs set to ON, forcing Aero OFF");
            AeroDisabler.INSTANCE.enable();
        }
        instance.setUseHardwareAcceleratedScreenGrab(useIt);
    }

    private void handleMessage(Message m) throws IOException {
        int type = m.getType();
        if (type == 524288) {
            String conversation = (String)m.get(0);
            Message command = (Message)m.get(1);
            int ctype = command.getType();
            if (ctype == 65557 || ctype == 65558) {
                System.out.println("async command (elevation request " + ctype + ")");
            } else if (ctype == -1061158791) {
                if (LocalSwitches.DEV_acculogRttLag) {
                    Acculog.log("AsyncServer received RTT message " + command);
                }
                this.handleRttEchoAsync(command);
            } else if (ctype == -1061158781) {
                this.handleSimulation(command);
            } else {
                System.out.println("async command " + command.toString(0, false, new Class[]{MSG.class}));
            }
            if (ctype != -1061158791) {
                new CommandThread(conversation, command).start();
            }
        } else {
            System.out.println("unrecognised async server message " + m.toString(0, false, new Class[]{MSG.class}));
        }
    }

    private void handleSimulation(Message m) {
        String simulationData = m.getNextString();
        Message message = MessageUtils.bytesToMessage((byte[])Base64.base64ToByteArray((String)simulationData));
        SimulationStep step = Simulation.stepFromMessage(message);
        this.getScreenServer().setSimulation(step);
    }

    public void setCurrentCursor(CursorInfo cInfo) {
        Message m = cInfo.toMessage();
        m.setType(-1061158856);
        try {
            this.mout.write(m);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void sendCurrentCursorLocation() {
        if (!this.getScreenServer().isInitialised()) {
            return;
        }
        Point location = MousePositionUtil.get().getLocation();
        this.getScreenServer().translatePointerLocation(location);
        if (location.x != this.previousX || location.y != this.previousY && CentralDebugging.MOUSE_UPDATE_1PX_ACCURACY || Math.abs(this.previousX - location.x) > 5 || Math.abs(this.previousY - location.y) > 5) {
            this.previousX = location.x;
            this.previousY = location.y;
            Message m = new Message();
            m.setType(-1061158855);
            try {
                int tmp = location.x + 1 << 16 | location.y + 1;
                m.append(tmp);
                this.mout.write(m);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void stopTechnicianReconnects() {
        Message m = new Message(-1061158877);
        try {
            this.mout.write(m);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void respond(Message m, String conversation) {
        Message res = new Message(524289);
        res.append(conversation);
        res.append(m);
        try {
            this.mout.write(res);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleRttEchoAsync(Message command) {
        if (Switches.SH_rttsWaitForScreenUpdate) {
            if (LocalSwitches.DEV_acculogRttLag) {
                Acculog.log("AsyncServer added RTT to response queue: " + command);
            }
            this.getScreenServer().setRttCommand(command);
        } else {
            if (this.rtts == null) {
                this.rtts = new RTTThread();
                this.rtts.start();
            }
            if (LocalSwitches.DEV_acculogRttLag) {
                Acculog.log("AsyncServer added RTT to response queue: " + command);
            }
            this.rtts.incoming = command;
            Object object = this.rtts.wait;
            synchronized (object) {
                this.rtts.wait.notifyAll();
            }
        }
    }

    public void handleRttEchoMessage(Message command) {
        boolean sendBackBuckets;
        long oneclock = (Long)command.pop();
        boolean mustClear = (Boolean)command.pop();
        if (mustClear) {
            this.instance.screenserver.processingTimeBuckets.clear();
            this.instance.screenserver.screenSizeBuckets.clear();
            this.instance.directSocket.clearReadRate();
        }
        if (sendBackBuckets = ((Boolean)command.pop()).booleanValue()) {
            command.append(ArrayToMessage.toCompressed(this.instance.screenserver.processingTimeBuckets.rtts));
            command.append(ArrayToMessage.toCompressed(this.instance.screenserver.screenSizeBuckets.bytes));
        }
        if (LocalSwitches.DEV_acculogRttLag) {
            Acculog.log("AsyncServer responding to RTT message " + command);
        }
        this.respond(command, "rttecho");
        OneClock.print(oneclock);
    }

    private static void appendStackTrace(Message ret, Throwable t) {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        t.printStackTrace(new PrintStream(bout));
        ret.append(new String(bout.toByteArray()));
    }

    private String getConnectNow() {
        String[] keys;
        ConnectionSettings settings = this.controller.getPreviousConnectionSettings();
        StringBuilder connectNow = new StringBuilder("on");
        for (String key1 : keys = settings.getCustomer().getDetailsKeys()) {
            try {
                String key = key1;
                String value = settings.getCustomer().getValue(key, true);
                if (key == null || value == null) continue;
                String encodedKey = URIUtil.urlEncodeSingleURLQueryKeyValue((String)key);
                String encodedValue = URIUtil.urlEncodeSingleURLQueryKeyValue((String)value);
                connectNow.append(",").append(encodedKey).append("=").append(encodedValue);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
        try {
            if (settings.queuePassword != null && settings.queuePassword.length() > 0) {
                String password = URIUtil.urlEncodeSingleURLQueryKeyValue((String)settings.queuePassword);
                connectNow.append(",queuepassword=").append(password);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return connectNow.toString();
    }

    private void installCallingCard(String shortcutName, boolean installDesktop, boolean installMenu, boolean automaticallyLogIn) throws IOException {
        System.out.println("[AsyncServer] Installing a calling card...");
        Properties properties = new Properties();
        ConnectionSettings settings = this.controller.getPreviousConnectionSettings();
        if (settings.getCustomer().hasDetails() && automaticallyLogIn) {
            properties.setProperty("connectnow", this.getConnectNow());
        }
        File desktop = new File(System.getProperty("user.home"), "Desktop");
        if (installDesktop) {
            System.out.println("[AsyncServer] Desktop location is " + desktop.getAbsolutePath());
            if (desktop.exists()) {
                JWSystem.saveLauncherShortcutForVirtualApp((File)desktop, (String)shortcutName, (String)JWSystem.getMyAppName(), (Properties)properties, (boolean)false);
            }
        }
        if (installMenu) {
            if (OS.isWindows()) {
                JWWindowsOS win = new JWWindowsOS();
                File menu = win.getStartMenuFolder(null);
                System.out.println("[AsyncServer] Menu location is " + menu.getAbsolutePath());
                JWSystem.saveLauncherShortcutForVirtualApp((File)menu, (String)shortcutName, (String)JWSystem.getMyAppName(), (Properties)properties, (boolean)false);
            } else if (OS.isLinux()) {
                File target = JWSystem.getLauncherLocationForVirtualApp((File)desktop, (String)shortcutName);
                if (!target.exists()) {
                    File parent = new File(System.getProperty("user.home"), "." + shortcutName);
                    parent.mkdirs();
                    JWSystem.saveLauncherShortcutForVirtualApp((File)parent, (String)shortcutName, (String)JWSystem.getMyAppName(), (Properties)properties, (boolean)false);
                    target = JWSystem.getLauncherLocationForVirtualApp((File)parent, (String)shortcutName);
                }
                System.out.println("[AsyncServer] Creating menu item '" + shortcutName + "'");
                JWLinuxOS.createApplicationStartShortcut((String)shortcutName, (String)shortcutName, (String)target.getAbsolutePath(), (boolean)false, (File)JWSystemUI.getMyAppLogoFile());
            } else if (OS.isMacOS()) {
                File target = new File("/Applications");
                JWSystem.saveLauncherShortcutForVirtualApp((File)target, (String)shortcutName, (String)JWSystem.getMyAppName(), (Properties)properties, (boolean)false);
            }
        }
    }

    private void postProcessElevation() {
        try {
            if (MouseMover.getStaticMouseMover() != null) {
                MouseMover.getStaticMouseMover().uacOff();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        try {
            if (MouseMover.getStaticMouseMover() != null) {
                new RdpConsoleChecker().start();
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static ProcessResult parseErrorFromStackTrace(Throwable ex) {
        int ERROR;
        String error = ex.getMessage();
        if (error.contains("ERROR") && (ERROR = error.indexOf("ERROR") + "ERROR ".length()) != -1 && ERROR < error.length()) {
            int NEWLINE = (error = error.substring(ERROR).trim()).indexOf("\n");
            if (NEWLINE != -1) {
                error = error.substring(NEWLINE);
            }
            if (error != null) {
                error = error.trim();
            }
            if (error != null && error.equals("null")) {
                error = ex.getMessage();
            }
        }
        ProcessResult result = new ProcessResult();
        result.code = 2;
        result.logErrors.append(error);
        result.logMessages.append(ex.getMessage());
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ex.printStackTrace(new PrintStream(bout));
        result.stacktrace = new String(bout.toByteArray());
        return result;
    }

    public void warnPoorConnection() throws IOException {
        Message m = new Message(-1061158795);
        this.mout.write(m);
        this.mout.flush();
    }

    public void notifyThatUserIsTyping(String displayName) throws IOException {
        Message m = new Message(-1061158799);
        m.append(displayName);
        this.mout.write(m);
        this.mout.flush();
    }

    public long mustFailoverTo(String newURL, long maxDelay, long autoSwitchTimeMS) {
        return 600000L;
    }

    public void prepareForRelaunch(String newURL) {
    }

    private class SessionInfoSender
    extends Thread {
        public SessionInfoSender() {
            this.start();
        }

        @Override
        public void run() {
            try {
                Message m = SessionInfoUpdater.getSessionInfo().toMessage();
                m.setType(-791674879);
                AsyncServer.this.mout.write(m);
                AsyncServer.this.mout.flush();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    class SessionNotificationListener
    implements NativeEventUtil.NativeEventListener {
        SessionNotificationListener() {
        }

        @Override
        public void sessionDeactivated() {
            System.out.println("[AsyncServer] sessionDeactivated event being processed");
            Message m = new Message(-1061158829);
            m.append(((AsyncServer)AsyncServer.this).controller.currentCustomer.getCustomerID());
            this.sendMessage(m);
        }

        @Override
        public void sessionActivated() {
            System.out.println("[AsyncServer] sessionActivated event being processed");
            Message m = new Message(-1061158830);
            m.append(((AsyncServer)AsyncServer.this).controller.currentCustomer.getCustomerID());
            this.sendMessage(m);
        }

        @Override
        public void powerOrLogoff() {
            System.out.println("[AsyncServer] powerOrLogoff event being processed");
            Message m = new Message(-1061158832);
            m.append(((AsyncServer)AsyncServer.this).controller.currentCustomer.getCustomerID());
            this.sendMessage(m);
        }

        @Override
        public void willSleep() {
            System.out.println("[AsyncServer] willSleep event being processed");
            Message m = new Message(-1061158831);
            m.append(((AsyncServer)AsyncServer.this).controller.currentCustomer.getCustomerID());
            this.sendMessage(m);
        }

        @Override
        public void didWake() {
            System.out.println("[AsyncServer] didWake event being processed");
            Message m = new Message(-1061158828);
            m.append(((AsyncServer)AsyncServer.this).controller.currentCustomer.getCustomerID());
            this.sendMessage(m);
        }

        private void sendMessage(Message m) {
            try {
                AsyncServer.this.mout.write(m);
                AsyncServer.this.mout.flush();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                AsyncServer.this.instance.sendMessageToServer_Unencrypted(m, true);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    class MetricBroadcaster
    extends Thread {
        private Stats stats;
        private final Object waitLock;
        private LoadAverageUtil cpuLoadAverage;
        private LoadAverageUtil memLoadAverage;

        public MetricBroadcaster() {
            super("MetricBroadcaster");
            this.stats = null;
            this.waitLock = new Object();
            this.cpuLoadAverage = new LoadAverageUtil();
            this.memLoadAverage = new LoadAverageUtil();
        }

        public void respond(Message m, String conversation) {
            AsyncServer.this.respond(m, conversation);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void sendNow() {
            Object object = this.waitLock;
            synchronized (object) {
                this.waitLock.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                this.stats = OsStats.getOsStats();
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            boolean firstFail = true;
            try {
                while (!AsyncServer.this.die) {
                    Object object = this.waitLock;
                    synchronized (object) {
                        try {
                            this.waitLock.wait(3000L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        if (!AsyncServer.this.sendingStats) continue;
                    }
                    try {
                        if (this.stats == null) continue;
                        this.stats.update();
                        this.cpuLoadAverage.addSample(System.currentTimeMillis(), this.stats.getCpuUsagePercent());
                        this.memLoadAverage.addSample(System.currentTimeMillis(), this.stats.getMemoryUsedPercent());
                        Message m = new Message(-1061158908);
                        try {
                            m.append(OsStats.toMessage((Stats)this.stats));
                            byte[] data = new byte[]{this.cpuLoadAverage.getAverage1Byte(), this.cpuLoadAverage.getAverage5Byte(), this.cpuLoadAverage.getAverage15Byte(), this.memLoadAverage.getAverage1Byte(), this.memLoadAverage.getAverage5Byte(), this.memLoadAverage.getAverage15Byte()};
                            m.append(data);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            m = new Message(-1061158907);
                        }
                        this.respond(m, "stats");
                    }
                    catch (Throwable t) {
                        if (firstFail) {
                            t.printStackTrace();
                        }
                        firstFail = false;
                    }
                }
            }
            catch (Exception e) {
                System.out.println("Metric Broadcaster died " + e);
                e.printStackTrace();
            }
            AsyncServer.this.instance.died();
        }
    }

    class SysInfoCommand {
        final String untranslatedName;
        final String cmd;

        public SysInfoCommand(String untranslatedName, String cmd) {
            this.untranslatedName = untranslatedName;
            this.cmd = cmd;
        }
    }

    class CommandThread
    extends Thread {
        final String conversation;
        final Message command;

        public CommandThread(String conversation, Message command) {
            this.conversation = conversation;
            this.command = command;
        }

        public void respond(Message m) {
            AsyncServer.this.respond(m, this.conversation);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            int type = this.command.getType();
            if (type == -1061158893) {
                WMIResults wmiResults = WMIRegistry.getProvider().queryWMI("SELECT DisplayName, Description, PathName, Started, StartMode from Win32_Service");
                Message m = new Message(-1061158893);
                if (wmiResults.hasProperties()) {
                    Properties[] resultRows;
                    for (Properties row : resultRows = wmiResults.getProperties()) {
                        ServicesTableModel.Service s = new ServicesTableModel.Service();
                        s.name = row.getProperty("DisplayName");
                        s.started = row.getProperty("Started");
                        s.mode = row.getProperty("StartMode");
                        s.commandLine = row.getProperty("PathName");
                        s.description = row.getProperty("Description");
                        if (CentralDebugging.SERVICES_VERBOSE) {
                            System.out.println("[AsyncServer] " + s);
                        }
                        m.append(s.toMessage());
                    }
                }
                this.respond(m);
            } else if (type == -1061158797) {
                Message m = new Message(-1061158797);
                this.respond(m);
            } else if (type == -1061158796) {
                int bw_size = this.command.getNextInt();
                Message m = new Message(-1061158797);
                m.append(new byte[bw_size]);
                this.respond(m);
            } else if (type == -1061158864) {
                String title = this.command.getAsString(0);
                String message = this.command.getAsString(1);
                String techUsername = this.command.getAsString(2);
                long timeout = 0L;
                if (AsyncServer.this.popupNotificationWindow != null) {
                    AsyncServer.this.popupNotificationWindow.closeDialog();
                }
                AsyncServer.this.popupNotificationWindow = new PopupNotificationWindow.ClosablePopupNotificationWindow();
                boolean result = false;
                try {
                    ImageIcon imageIcon = null;
                    try {
                        BufferedImage icon = CachedSplashLoader.getSplashFromCache(SimpleHelpLookAndFeel.scale((int)380), SimpleHelpLookAndFeel.scale((int)96));
                        if (icon != null) {
                            imageIcon = new ImageIcon(icon);
                        }
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    result = AsyncServer.this.popupNotificationWindow.showMessage(imageIcon, AvatarMap.getAvatarIconFor(techUsername), message, timeout);
                }
                catch (PopupNotificationWindow.NotificationTimedOut notificationTimedOut) {
                    notificationTimedOut.printStackTrace();
                }
                finally {
                    AsyncServer.this.popupNotificationWindow.closeDialog();
                    AsyncServer.this.popupNotificationWindow = null;
                }
                Message m = new Message(-1061158864);
                m.append(result);
                this.respond(m);
            } else if (type == -1061158798) {
                long id = this.command.getAsLong(0);
                int thisType = this.command.getAsInt(1);
                AsyncServer.this.instance.reestablishNonUdpTransport(thisType, id);
            } else if (type == -1061158782) {
                Message hosts = this.command.getNextMessage();
                int remotePort = this.command.getNextInt();
                System.out.println("[AsyncServer] Received Direct TCP reestablish request");
                P2PSock p2p = null;
                int PORT = P2PSock.PORT_CSES_P2P;
                try {
                    p2p = new P2PSock();
                    PORT = p2p.listenOn(PORT, PORT + P2PSock.SCAN_LIMIT);
                }
                catch (IOException x) {
                    System.out.println("[AsyncServer] Unable to listen on ports " + PORT + "+");
                }
                if (p2p != null) {
                    System.out.println("[AsyncServer] Sending our P2P settings to tech");
                    Message m = new Message(-1061158782);
                    m.append(P2PSock.getMyHostsList());
                    m.append(PORT);
                    this.respond(m);
                    System.out.println("[AsyncServer] Attempting to connect");
                    AsyncServer.this.instance.reestablishDirectTcpTransport(hosts, remotePort, p2p);
                } else {
                    Message m = new Message(-1061158782);
                    this.respond(m);
                }
            } else if (type == -1061158860) {
                boolean direct = this.command.getAsBoolean(0);
                boolean allowPortScan = this.command.getAsBoolean(1);
                int maxMeasuredRate = this.command.getAsInt(2);
                AsyncServer.this.instance.reestablishUdpTransport(direct, allowPortScan, maxMeasuredRate);
                Message m = new Message(-1061158860);
                m.append(AsyncServer.this.instance.getMaxMeasuredReadRate(direct));
                this.respond(m);
            } else if (type == -1061158862) {
                CentralDebugging.launchDebuggingUI(true);
                Message m = new Message(-1061158862);
                this.respond(m);
            } else if (type == -1061158783) {
                int KBps = this.command.getNextInt();
                System.out.println("[AsyncServer] Setting bandwidth limit to " + KBps + "KB/s");
                try {
                    ((AsyncServer)AsyncServer.this).instance.directSocket.setBandwidthLimit(KBps);
                    ((AsyncServer)AsyncServer.this).instance.socket.setBandwidthLimit(KBps);
                }
                catch (Exception allowPortScan) {}
            } else if (type == -1061158792) {
                boolean fixed = this.command.getNextBoolean();
                try {
                    if (fixed) {
                        double kbps = this.command.getNextDouble();
                        System.out.println("[AsyncServer] Fixing UDP bandwidth at " + kbps + "KB/s");
                        ((AsyncServer)AsyncServer.this).instance.directSocket.setFixedBandwidth(kbps);
                    } else {
                        System.out.println("[AsyncServer] Setting flexible UDP bandwidth");
                        ((AsyncServer)AsyncServer.this).instance.directSocket.setFlexibleBandwidth();
                    }
                }
                catch (Exception x) {
                    System.out.println("[AsyncServer] ERROR setting bandwidth profile: " + x);
                    x.printStackTrace();
                }
                Message m = new Message(-1061158792);
                this.respond(m);
            } else if (type == -1061158791) {
                boolean mustClear = (Boolean)this.command.pop();
                if (mustClear) {
                    ((AsyncServer)AsyncServer.this).instance.screenserver.processingTimeBuckets.clear();
                    ((AsyncServer)AsyncServer.this).instance.screenserver.screenSizeBuckets.clear();
                    ((AsyncServer)AsyncServer.this).instance.directSocket.clearReadRate();
                }
                this.command.append(ArrayToMessage.toMessage(((AsyncServer)AsyncServer.this).instance.screenserver.processingTimeBuckets.rtts));
                this.command.append(ArrayToMessage.toMessage(((AsyncServer)AsyncServer.this).instance.screenserver.screenSizeBuckets.bytes));
                this.respond(this.command);
            } else if (type == -1061158793) {
                String url = this.command.getAsString(0);
                String custID = this.command.getAsString(1);
                System.out.println("[ASyncServer] asked to fail over to " + url);
                url = FailoverMonitor.make((String)JWSystem.getUpdateURL(), (String)url);
                System.out.println("[ASyncServer] reinterpreted URL as " + url);
                if (((AsyncServer)AsyncServer.this).controller.currentCustomer.isSH()) {
                    JWLaunchProperties.deleteProperty((String)"reuse_cust_id");
                    JWLaunchProperties.overrideDynamicProperty((String)"reuse_cust_id", (String)custID);
                    JWLaunchProperties.overrideDynamicProperty((String)"connectnow", (String)AsyncServer.this.getConnectNow());
                }
                try {
                    System.out.println("[ASyncServer] Checking failover URL for own site...");
                    FailoverMonitor.TargetURL targetURL = FailoverMonitor.checkTargetURL();
                    System.out.println("[ASyncServer] Own failover URL is " + targetURL + ", relaunching now");
                    FailoverMonitor.relaunchToFailoverURL((String)targetURL.switchTo, (FailoverListener)AsyncServer.this.failoverListener);
                }
                catch (Exception x) {
                    x.printStackTrace();
                }
            } else if (type == -791674880) {
                int requestedScreen = this.command.getAsInt(0);
                Message m = new Message(-791674880);
                System.out.println("[AsyncServer] Received request for screen " + requestedScreen);
                this.respond(m);
            } else if (type == -1061158874) {
                Message m = new Message(-1061158874);
                m.append(AsyncServer.this.instance.getSessionStats().toBytes());
                this.respond(m);
            } else if (type == 65543) {
                String cmd = this.command.getNextString();
                String workingDir = this.command.getNextString();
                boolean elevate = this.command.getNextBoolean();
                System.out.println("[AsyncServer] Got request to run command");
                Message m = new Message(65543);
                try {
                    AsyncServer.this.instance.runCommand(cmd, workingDir, elevate);
                    m.append(true);
                }
                catch (Throwable x) {
                    x.printStackTrace();
                    m.append(false);
                }
                this.respond(m);
            } else if (type == -1061158876) {
                Message m = new Message(-1061158876);
                System.out.println("[AsyncServer] Got request to issue CAD");
                try {
                    AsyncServer.this.instance.doCAD();
                    m.append(true);
                }
                catch (Throwable x) {
                    x.printStackTrace();
                    m.append(false);
                }
                this.respond(m);
            } else if (type == -1061158891) {
                Message m = new Message(-1061158891);
                System.out.println("[AsyncServer] Got request for debug info");
                try {
                    System.out.println("[AsyncServer] Appending debug info now");
                    m.append(SystemInfo.getFullInfo() + "\n" + FixedByteBuffer.INSTANCE.getContents());
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    m.append("[AsyncServer] Unable to get info: " + t);
                }
                System.out.println("[AsyncServer] Responding with debug info now");
                this.respond(m);
            } else if (type == -1061158871) {
                System.out.println("[AsyncServer] Got set avatar request");
                byte[] bytes = (byte[])this.command.get(0);
                String username = this.command.getAsString(1);
                String displayName = this.command.getAsString(2);
                AsyncServer.this.serverUI.setAvatar(bytes, username, displayName);
                Message m = new Message(-1061158871);
                this.respond(m);
            } else if (type == -1061158875) {
                Message m = new Message(-1061158875);
                boolean extended = (Boolean)this.command.get(0);
                System.out.println("Got request for connection test");
                try {
                    System.out.println("Running and appending connection test now");
                    m.append(SHelpNodelinkConnector.diagnoseConnectionIssues(extended));
                }
                catch (Throwable t) {
                    t.printStackTrace();
                    m.append("Unable to run connection test: " + t);
                }
                this.respond(m);
            } else if (type == -1061158784) {
                System.out.println("[AsyncServer] Got request to lock desktop");
                boolean state = (Boolean)this.command.get(0);
                AsyncServer.setLockDesktopOnDisconnect(state);
                this.respond(new Message(-1061158784));
                System.out.println("[AsyncServer] Processed request to lock desktop");
            } else if (type == -1061158889) {
                boolean state = (Boolean)this.command.get(0);
                WallpaperDisabler.INSTANCE.setEnabled(state);
                this.respond(new Message(-1061158889));
            } else if (type == -1061158800) {
                boolean state = this.command.getAsBoolean(0);
                MonitorOffKeeper.INSTANCE.setEnabled(state);
                this.respond(new Message(-1061158800));
            } else if (type == -1061158843) {
                boolean state = this.command.getAsBoolean(0);
                int bitrate = this.command.getAsInt(1);
                if (bitrate > 0) {
                    OpusConfig.bitRate = bitrate;
                    System.out.println("[SoundServer] Default audio encoding bitrate set to " + bitrate + " b/s");
                }
                SoundServer.INSTANCE.setCaptureAudio(state);
                this.respond(new Message(-1061158843));
            } else if (type == -1061158873) {
                boolean state = this.command.getAsBoolean(0);
                String title = this.command.getAsString(1);
                String message = this.command.getAsString(2);
                if (state) {
                    AsyncServer.this.setUseHardwareAcceleratedScreenGrab(true);
                }
                ScreenBlanker.INSTANCE.setMessage(title, message);
                ScreenBlanker.INSTANCE.setEnabled(state);
                this.respond(new Message(-1061158873));
            } else if (type == -1061158872) {
                boolean state = this.command.getAsBoolean(0);
                ControlBlocker.INSTANCE.setBlockControl(state);
                this.respond(new Message(-1061158872));
            } else if (type == -1061158888) {
                boolean state = this.command.getAsBoolean(0);
                AeroDisabler.INSTANCE.setEnabled(state);
            } else if (type == -1061158887) {
                boolean state = this.command.getAsBoolean(0);
                GraphicsDriverDisabler.INSTANCE.setEnabled(state);
            } else if (type == -1061158880) {
                boolean state = this.command.getAsBoolean(0);
                AsyncServer.this.setUseHardwareAcceleratedScreenGrab(state);
            } else if (type == -1061158861) {
                boolean high = this.command.getAsBoolean(0);
                if (high) {
                    try {
                        if (OS.isWindows()) {
                            System.out.println("[ASyncServer] Natively increasing process priority.");
                            NativeUtils.getInstance().setProcessPriorityHigh(-1);
                        }
                    }
                    catch (Throwable t) {
                        System.out.println("[ASyncServer] Unable to change process priority.");
                        t.printStackTrace();
                    }
                } else {
                    try {
                        if (OS.isWindows()) {
                            System.out.println("[ASyncServer] Natively resetting process priority.");
                            NativeUtils.getInstance().setProcessPriorityNormal(-1);
                        }
                    }
                    catch (Throwable t) {
                        System.out.println("[ASyncServer] Unable to change process priority.");
                        t.printStackTrace();
                    }
                }
            } else if (type == -1061158878) {
                Message m = new Message(-1061158878);
                OS.isWindows();
                m.append(OS.base_type);
                m.append(OS.variant);
                this.respond(m);
            } else if (type == -1061158879) {
                boolean safeMode = this.command.getNextBoolean();
                boolean force = this.command.getNextBoolean();
                if (MouseMover.getStaticMouseMover() == null && safeMode && OS.isWindowsVistaOrAbove()) {
                    Message m = new Message(-286392320);
                    this.respond(m);
                } else {
                    AsyncServer.this.restoreSettings(true);
                    AsyncServer.this.serverUI.expectTechnicianInitiatedReboot();
                    if (MouseMover.getStaticMouseMover() != null) {
                        MouseMover.getStaticMouseMover().reboot(safeMode, force);
                    } else {
                        try {
                            Process p = ShFork.forkCustomerSessionJVM(safeMode, RebootMain.class.getName(), new String[]{safeMode ? "safemode" : "normal", force ? "force" : ""});
                            new ProcessPrinter(p, (OutputStream)System.out, (OutputStream)System.out);
                        }
                        catch (Throwable x) {
                            x.printStackTrace();
                        }
                    }
                    Message m = new Message(-1061158879);
                    this.respond(m);
                }
            } else if (type == -1061158910) {
                String cmd = (String)this.command.get(0);
                System.out.println("Running " + cmd + " console command");
                String[] output = RunCommandGetOutput.runCommandGetOutput((String)cmd);
                if (output != null) {
                    System.out.println("Responding with output of " + cmd);
                    Message m = new Message(-1061158910);
                    m.append(cmd);
                    m.append(output[0]);
                    this.respond(m);
                } else {
                    Message m = new Message(-1061158909);
                    this.respond(m);
                }
            } else if (type == -1061158858) {
                System.out.println("[AsyncServer] Received VNC credentials");
                String username = this.command.getAsString(0);
                String password = this.command.getAsString(1);
                Message m = new Message(-1061158858);
                try {
                    ((AsyncServer)AsyncServer.this).instance.screenserver.loginCaptureViaVNC(new String[]{username, password});
                    System.out.println("[AsyncServer] Configuring VNC input processing");
                    if (!AsyncServer.this.currentVNCConnection.isConnectedLocally()) {
                        ((AsyncServer)AsyncServer.this).instance.inputserver.enableVNCInputForwarding(AsyncServer.this.currentVNCConnection);
                    }
                }
                catch (Exception e) {
                    if (AsyncServer.this.currentVNCConnection != null) {
                        AsyncServer.this.currentVNCConnection.disconnect();
                        AsyncServer.this.currentVNCConnection = null;
                    }
                    ((AsyncServer)AsyncServer.this).instance.screenserver.disableCaptureViaVNC();
                    ((AsyncServer)AsyncServer.this).instance.inputserver.disableVNCInputForwarding();
                    e.printStackTrace();
                    m = new Message(-286392320);
                    m.append(e.getMessage());
                }
                this.respond(m);
            } else if (type == -1061158857) {
                Message m = new Message(-1061158857);
                ((AsyncServer)AsyncServer.this).instance.screenserver.disableCaptureViaVNC();
                if (AsyncServer.this.currentVNCConnection != null) {
                    AsyncServer.this.currentVNCConnection.disconnect();
                    AsyncServer.this.currentVNCConnection = null;
                }
                this.respond(m);
            } else if (type == -1061158859) {
                Message m = new Message(-1061158859);
                boolean doIt = true;
                if (this.command.length() > 0 && !this.command.getAsBoolean(0)) {
                    doIt = false;
                }
                if (doIt) {
                    String hostname = null;
                    String port = null;
                    if (this.command.length() > 2) {
                        hostname = this.command.getAsString(1);
                        port = this.command.getAsString(2);
                    }
                    if (((AsyncServer)AsyncServer.this).instance.screenserver != null) {
                        SimpleVNCSessionSettings settings = new SimpleVNCSessionSettings(hostname, port);
                        try {
                            if (AsyncServer.this.currentVNCConnection != null) {
                                AsyncServer.this.currentVNCConnection.disconnect();
                                AsyncServer.this.currentVNCConnection = null;
                            }
                        }
                        catch (Throwable result) {
                            // empty catch block
                        }
                        try {
                            AsyncServer.this.currentVNCConnection = new VNC();
                            if (settings.getHostname().equals("localhost") || settings.getHostname().equals("127.0.0.1")) {
                                AsyncServer.this.currentVNCConnection.setConnectedLocally(true);
                                AsyncServer.this.currentVNCConnection.connect(settings, new int[]{0});
                            } else {
                                AsyncServer.this.currentVNCConnection.setConnectedLocally(false);
                                AsyncServer.this.currentVNCConnection.connect(settings);
                            }
                            int securityType = AsyncServer.this.currentVNCConnection.getChosenSecurityType();
                            ((AsyncServer)AsyncServer.this).instance.screenserver.initCaptureViaVNC(AsyncServer.this.currentVNCConnection);
                            m.append(securityType);
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            m = new Message(-286392320);
                            m.append(hostname);
                            m.append(port);
                            m.append(ex.getMessage());
                        }
                    } else {
                        m = new Message(-286392320);
                        m.append(hostname);
                        m.append(port);
                    }
                } else {
                    try {
                        if (AsyncServer.this.currentVNCConnection != null) {
                            AsyncServer.this.currentVNCConnection.disconnect();
                            AsyncServer.this.currentVNCConnection = null;
                        }
                    }
                    catch (Throwable hostname) {
                        // empty catch block
                    }
                    ((AsyncServer)AsyncServer.this).instance.screenserver.disableCaptureViaVNC();
                    ((AsyncServer)AsyncServer.this).instance.inputserver.disableVNCInputForwarding();
                    m = new Message(-1061158859);
                }
                this.respond(m);
            } else if (type == -1061158890) {
                int sessionID;
                System.out.println("Switching RDP console");
                try {
                    sessionID = JWNativeAPI.getInstance().getTsMySessionId();
                }
                catch (Throwable t) {
                    WSessionInfo info = WSessionInfo.getStaticWSessionInfo_Slow();
                    sessionID = info.getSessionID();
                }
                String cmd = "tscon " + sessionID + " /DEST:console";
                if (MouseMover.getStaticMouseMover() != null) {
                    MouseMover.getStaticMouseMover().runCommandAndIgnore(cmd, ".");
                    try {
                        Thread.sleep(1500L);
                    }
                    catch (Exception info) {
                        // empty catch block
                    }
                }
                RunCommandGetOutput.runCommandIgnoreOutput((String)cmd);
            } else if (type == -1061158894) {
                try {
                    Message ret = new Message(-1061158894);
                    if (OS.isWindows()) {
                        ret.append("win");
                    } else if (OS.isMacOS()) {
                        ret.append("mac");
                    } else if (OS.isLinux()) {
                        ret.append("lin");
                    }
                    this.respond(ret);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            } else if (type == -1061158911) {
                String[] output;
                ArrayList<SysInfoCommand> commands = new ArrayList<SysInfoCommand>();
                if (OS.isWindows()) {
                    try {
                        RunCommandGetOutput.runCommandGetOutput((String)"wmic get bios serialnumber");
                        StringBuilder sb = new StringBuilder();
                        String[] output2 = RunCommandGetOutput.runCommandGetOutput((String)"wmic csproduct get name,vendor,IdentifyingNumber");
                        if (output2 != null) {
                            sb.append(output2[0]);
                        }
                        sb.append("\n");
                        output2 = RunCommandGetOutput.runCommandGetOutput((String)"wmic bios get name,serialnumber,version");
                        if (output2 != null) {
                            sb.append(output2[0]);
                        }
                        Message mf = new Message(-1061158911);
                        mf.append("REMOTE_MACHINE");
                        mf.append("-");
                        mf.append(sb.toString());
                        this.respond(mf);
                        sb.setLength(0);
                        output = RunCommandGetOutput.runCommandGetOutput((String)"wmic diskdrive get name,size,model");
                        if (output != null) {
                            sb.append(output[0]);
                        }
                        sb.append("\n");
                        output = RunCommandGetOutput.runCommandGetOutput((String)"wmic partition get name,size,type");
                        if (output != null) {
                            sb.append(output[0]);
                        }
                        mf = new Message(-1061158911);
                        mf.append("DISK_INFO");
                        mf.append("-");
                        mf.append(sb.toString());
                        this.respond(mf);
                    }
                    catch (Exception sb) {
                        // empty catch block
                    }
                    commands.add(new SysInfoCommand("OS_VERSION", "cmd.exe /c ver"));
                    commands.add(new SysInfoCommand("OS_INFO", "cmd.exe /c systeminfo"));
                    commands.add(new SysInfoCommand("WIN_DOMAIN", "cmd.exe /c echo Computer: %COMPUTERNAME% & echo Username: %USERNAME% & echo Domain: %USERDOMAIN% & echo Logon Server: %LOGONSERVER% & echo DNS Domain: %USERDNSDOMAIN% & echo User Profile: %USERPROFILE% & echo System Root: %SYSTEMROOT%"));
                    commands.add(new SysInfoCommand("NETWORK_CONFIG", "cmd.exe /c ipconfig /all"));
                    commands.add(new SysInfoCommand("WINDOWS_SERVICES", "cmd.exe /c sc query"));
                    commands.add(new SysInfoCommand("SCHEDULED_TASKS", "cmd.exe /c schtasks"));
                    commands.add(new SysInfoCommand("DRIVER_QUERY", "cmd.exe /c driverquery"));
                    commands.add(new SysInfoCommand("NETWORK_USAGE", "netstat -a"));
                    commands.add(new SysInfoCommand("NET_SHARE", "cmd.exe /c net share"));
                    commands.add(new SysInfoCommand("NET_USE", "cmd.exe /c net use"));
                    if (Switches.v45) {
                        commands.add(new SysInfoCommand("PRINTERS", "cmd.exe /c wmic printer get caption,name,deviceid,drivername,portname"));
                        commands.add(new SysInfoCommand("PRINT_JOBS", "cmd.exe /c wmic printjob"));
                    }
                } else if (OS.isMacOS()) {
                    commands.add(new SysInfoCommand("OS_VERSION", "uname -a"));
                    commands.add(new SysInfoCommand("SYSSOFTWARE_INFO", "system_profiler SPSoftwareDataType"));
                    commands.add(new SysInfoCommand("HARDWARE_INFO", "system_profiler SPHardwareDataType"));
                    commands.add(new SysInfoCommand("NETWORK_CONFIG", "ifconfig -a"));
                    commands.add(new SysInfoCommand("MEMORY_INFO", "system_profiler SPMemoryDataType"));
                    commands.add(new SysInfoCommand("DISK_INFO", "df -h"));
                    commands.add(new SysInfoCommand("ACTIVE_USERS", "w"));
                } else if (OS.isLinux()) {
                    commands.add(new SysInfoCommand("OS_VERSION", "uname -a"));
                    commands.add(new SysInfoCommand("CPU_INFO", "cat /proc/cpuinfo"));
                    commands.add(new SysInfoCommand("NETWORK_CONFIG", "ifconfig -a"));
                    commands.add(new SysInfoCommand("MEMORY_INFO", "cat /proc/meminfo"));
                    commands.add(new SysInfoCommand("DISK_INFO", "df"));
                    commands.add(new SysInfoCommand("ACTIVE_USERS", "w"));
                    commands.add(new SysInfoCommand("SWAP_FILES", "cat /proc/swaps"));
                    commands.add(new SysInfoCommand("NETWORK_USAGE", "netstat -a"));
                }
                System.out.println("Running " + commands.size() + " system info commands");
                for (SysInfoCommand cmd : commands) {
                    System.out.println("Running " + cmd.cmd);
                    output = RunCommandGetOutput.runCommandGetOutput((String)cmd.cmd);
                    if (output == null) continue;
                    System.out.println("Responding with output of " + cmd.cmd);
                    Message m = new Message(-1061158911);
                    m.append(cmd.untranslatedName);
                    m.append(cmd.cmd);
                    m.append(output[0]);
                    this.respond(m);
                }
            } else if (type == -1061158906) {
                AsyncServer.this.sendingStats = true;
                AsyncServer.this.metricBroadcaster.sendNow();
            } else if (type == -1061158905) {
                AsyncServer.this.sendingStats = false;
            } else if (type == -1061158799) {
                AsyncServer.this.serverUI.setTechnicianIsTyping(this.command.getAsString(0));
            } else if (type == -1061158794) {
                Message m = new Message(-1061158794);
                m.append(((AsyncServer)AsyncServer.this).instance.inputserver.getServerURL());
                this.respond(m);
            } else if (type == -1061158892) {
                String pid = (String)this.command.get(0);
                System.out.println("Running wmic command " + pid);
                if (MouseMover.getStaticMouseMover() != null) {
                    MouseMover.getStaticMouseMover().wmicCommand(pid);
                } else {
                    try {
                        Process p = WmicUtil.launchWmicCommand((String)pid);
                        OutputStream pout = p.getOutputStream();
                        pout.write("yyyyyyyy\r\nyyyyyy\r\n".getBytes());
                        pout.flush();
                        p.getInputStream().close();
                        p.getErrorStream().close();
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            } else if (type == -1061158816) {
                AsyncServer.this.serverUI.alertUser();
                Message m = new Message(-1061158816);
                this.respond(m);
            } else if (type == -1061158904) {
                Message m;
                String error;
                String pid = (String)this.command.get(0);
                System.out.println("Terminating process with PID=" + pid);
                Stats stats = OsStats.getOsStats();
                if (MouseMover.getStaticMouseMover() != null) {
                    MouseMover.getStaticMouseMover().killProcess(pid);
                    error = null;
                } else {
                    error = stats.killProcess(pid);
                }
                if (error == null) {
                    m = new Message(-1061158904);
                } else {
                    m = new Message(-1061158896);
                    m.append(error);
                }
                this.respond(m);
            } else if (type == -1061158903) {
                Message m;
                Stats stats = OsStats.getOsStats();
                int errorCount = 0;
                int total = 0;
                for (int i = 0; i < this.command.length(); ++i) {
                    String error;
                    String pid = (String)this.command.get(i);
                    System.out.println("\n\nTerminating process with PID=" + pid + "\n\n");
                    if (MouseMover.getStaticMouseMover() != null) {
                        MouseMover.getStaticMouseMover().killProcess(pid);
                        error = null;
                    } else {
                        error = stats.killProcess(pid);
                    }
                    if (error != null) {
                        System.out.println("\n\n" + error + "\n\n");
                        ++errorCount;
                    }
                    ++total;
                }
                if (errorCount == 0) {
                    m = new Message(-1061158903);
                } else {
                    m = new Message(-1061158895);
                    m.append(errorCount + " / " + total);
                }
                this.respond(m);
            } else {
                if (type == 65558) {
                    Message ret;
                    Message contentMessage = (Message)this.command.get(0);
                    boolean isElevated = MouseMover.getStaticMouseMover() != null;
                    boolean skipElevation = false;
                    System.out.println("\n[AsyncServer] Elevation request (elevated=" + isElevated + ") (skip=" + skipElevation + ")");
                    if (isElevated || skipElevation) {
                        Message ret2 = new Message(65558);
                        ret2.append(contentMessage);
                        this.respond(ret2);
                        return;
                    }
                    if (this.command.length() > 1 || OS.isMacOS() || OS.isLinux()) {
                        boolean mustPrompt = true;
                        String username = null;
                        String password = null;
                        if (this.command.length() > 1) {
                            mustPrompt = (Boolean)this.command.get(1);
                            username = (String)this.command.get(2);
                            password = (String)this.command.get(3);
                        }
                        if (password != null) {
                            System.out.println("\n[AsyncServer] Elevation credentials supplied (" + (password.length() > 0) + ").");
                        } else {
                            System.out.println("\n[AsyncServer] No credentials supplied.");
                        }
                        try {
                            ProcessResult result = new ProcessResult();
                            result.code = 1;
                            try {
                                if (!mustPrompt) {
                                    MouseMover.forceNewElevatedInstanceWithCredentials(username, password);
                                } else {
                                    MouseMover.forceNewElevatedInstanceWithoutCredentials();
                                }
                            }
                            catch (CancelledException ex) {
                                ex.printStackTrace();
                                result.code = 3;
                                Message ret3 = new Message(-286392320);
                                Message errorMessage = ProcessResultMessage.toMessage(result);
                                ret3.append(errorMessage);
                                this.respond(ret3);
                                return;
                            }
                            catch (IOException ex) {
                                ex.printStackTrace();
                                if (ex instanceof MouseMover.ElevationException) {
                                    result = new ProcessResult();
                                    result.code = 2;
                                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                                    ex.printStackTrace(new PrintStream(bout));
                                    result.stacktrace = new String(bout.toByteArray());
                                } else {
                                    result = AsyncServer.parseErrorFromStackTrace(ex);
                                }
                                Message ret4 = new Message(-286392320);
                                Message errorMessage = ProcessResultMessage.toMessage(result);
                                ret4.append(errorMessage);
                                this.respond(ret4);
                                return;
                            }
                            AsyncServer.this.postProcessElevation();
                            ret = new Message(65558);
                            ret.append(contentMessage);
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                            ret = new Message(-286392320);
                            ret.append(t.getMessage());
                            ByteArrayOutputStream bout = new ByteArrayOutputStream();
                            t.printStackTrace(new PrintStream(bout));
                            ret.append(new String(bout.toByteArray()));
                        }
                    } else {
                        System.out.println("\n[AsyncServer] No elevation credentials supplied");
                        boolean isXPandAmAdmin = false;
                        if (OS.isWindows() && !OS.isWindowsVistaOrAbove() && !isElevated) {
                            isXPandAmAdmin = AmIAdministrator.amIAdministrator();
                        }
                        if (isXPandAmAdmin) {
                            try {
                                MouseMover.forceNewElevatedInstanceWithoutCredentials();
                                Message ret5 = new Message(65558);
                                ret5.append(contentMessage);
                                this.respond(ret5);
                                return;
                            }
                            catch (IOException ex) {
                                ex.printStackTrace();
                            }
                        }
                        ret = new Message(-421134336);
                        ret.append(contentMessage);
                    }
                    this.respond(ret);
                    return;
                }
                if (type == 65552) {
                    Message ret;
                    byte[] configbytes = (byte[])this.command.get(0);
                    boolean installShortcuts = this.command.getAsBoolean(1);
                    boolean isElevated = MouseMover.getStaticMouseMover() != null;
                    boolean skipElevation = false;
                    if (!isElevated && !skipElevation) {
                        ret = new Message(-421134336);
                        ret.append(this.command);
                    } else {
                        try {
                            String proxyHost = null;
                            int proxyPort = 0;
                            String proxyUser = null;
                            String proxyPass = null;
                            try {
                                Proxy jWrapperProxy = JWSystem.getJWrapperProxy();
                                if (jWrapperProxy != null) {
                                    InetSocketAddress isa = (InetSocketAddress)jWrapperProxy.address();
                                    proxyHost = isa.getAddress().getHostAddress();
                                    proxyPort = isa.getPort();
                                    JWProxyCredentials.Credentials creds = JWSystem.getJWrapperProxyCredentials();
                                    if (creds != null) {
                                        proxyUser = creds.username;
                                        proxyPass = creds.password;
                                    }
                                }
                            }
                            catch (Throwable t) {
                                t.printStackTrace();
                            }
                            ProcessResult result = MouseMover.getStaticMouseMover() != null ? MouseMover.getStaticMouseMover().installSGService(configbytes, proxyHost, proxyPort, proxyUser, proxyPass, installShortcuts) : MouseMover.installSGServiceWithoutMouseMover(configbytes, false, proxyHost, proxyPort, proxyUser, proxyPass, installShortcuts);
                            ret = new Message(65552);
                            Message message = ProcessResultMessage.toMessage(result);
                            ret.append(message);
                        }
                        catch (Throwable t) {
                            ret = new Message(-286392320);
                            ret.append(t.getMessage());
                            ret.append(StackTracer.getStacktrace((Throwable)t));
                        }
                    }
                    this.respond(ret);
                } else if (type == 65553) {
                    Message ret;
                    boolean isElevated = MouseMover.getStaticMouseMover() != null;
                    boolean skipElevation = false;
                    if (!isElevated && !skipElevation) {
                        ret = new Message(-421134336);
                        ret.append(this.command);
                    } else {
                        try {
                            ProcessResult result = MouseMover.getStaticMouseMover() != null ? MouseMover.getStaticMouseMover().uninstallSGService() : MouseMover.uninstallSGServiceWithoutMouseMover(false);
                            ret = new Message(65553);
                            Message message = ProcessResultMessage.toMessage(result);
                            ret.append(message);
                        }
                        catch (Throwable t) {
                            t.printStackTrace();
                            ret = new Message(-286392320);
                            ret.append(t.getMessage());
                            ByteArrayOutputStream bout = new ByteArrayOutputStream();
                            t.printStackTrace(new PrintStream(bout));
                            ret.append(new String(bout.toByteArray()));
                        }
                    }
                    this.respond(ret);
                } else if (type == -1061158846) {
                    String keyToCreate = this.command.getAsString(0);
                    System.out.println("[AsyncServer] Instructed to create registry key " + keyToCreate);
                    Message response = new Message(-1061158846);
                    try {
                        boolean success = WReg.createRegistryKey(keyToCreate);
                        response.append(success);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        response.append(false);
                    }
                    response.append(keyToCreate);
                    this.respond(response);
                } else if (type == -1061158847) {
                    String keyToDelete = this.command.getAsString(0);
                    System.out.println("[AsyncServer] Instructed to delete registry key " + keyToDelete);
                    Message response = new Message(-1061158847);
                    try {
                        boolean success = WReg.deleteKey(keyToDelete);
                        response.append(success);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        response.append(false);
                    }
                    response.append(keyToDelete);
                    this.respond(response);
                } else if (type == -1061158845) {
                    String key = this.command.getAsString(0);
                    String valueName = this.command.getAsString(1);
                    System.out.println("[AsyncServer] Instructed to delete value " + key + "!" + valueName);
                    Message response = new Message(-1061158845);
                    try {
                        WReg.deleteValue(key, valueName);
                        response.append(true);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        response.append(false);
                    }
                    response.append(key);
                    response.append(valueName);
                    this.respond(response);
                } else if (type == -1061158844) {
                    String key = this.command.getAsString(0);
                    String valueName = this.command.getAsString(1);
                    String valueValue = this.command.getAsString(2);
                    String valueType = this.command.getAsString(3);
                    System.out.println("[AsyncServer] Instructed to set value " + key + "!" + valueName + " to " + valueValue + "(" + valueType + ")");
                    System.out.flush();
                    Message response = new Message(-1061158844);
                    try {
                        WReg.set(key, valueName, valueValue, valueType);
                        response.append(true);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        response.append(false);
                    }
                    response.append(key);
                    response.append(valueName);
                    response.append(valueValue);
                    response.append(valueType);
                    this.respond(response);
                } else if (type == -1061158811) {
                    ToolBoxItem item = new ToolBoxItem();
                    item.fromMessage(this.command);
                    ConnectionSettings settings = AsyncServer.this.controller.getPreviousConnectionSettings();
                    ToolBoxResult result = ToolBoxRunner.runToolBoxItem(item, settings.host, settings.port, null);
                    Message response = result.toMessage();
                    response.setType(-1061158811);
                    this.respond(response);
                } else if (type == -1061158815) {
                    Message response;
                    String callingCardName = this.command.getAsString(0);
                    boolean installDesktop = this.command.getAsBoolean(1);
                    boolean installMenu = this.command.getAsBoolean(2);
                    boolean automaticallyLogin = this.command.getAsBoolean(3);
                    try {
                        if (installDesktop || installMenu) {
                            AsyncServer.this.installCallingCard(callingCardName, installDesktop, installMenu, automaticallyLogin);
                        }
                        response = new Message(-1061158815);
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                        response = new Message(-286392320);
                        response.append(t.getMessage());
                        AsyncServer.appendStackTrace(response, t);
                    }
                    this.respond(response);
                } else if (type == -1061158848) {
                    Message response;
                    String parentKeyName = this.command.getAsString(0);
                    System.out.println("[AsyncServer] Instructed to get children of " + parentKeyName);
                    try {
                        response = new Message(-1061158848);
                        String[][] children = WReg.getChildren(parentKeyName);
                        response.append(true);
                        response.append(parentKeyName);
                        String[] keys = new String[]{};
                        String[] values = new String[]{};
                        if (children == null) {
                            children = new String[][]{};
                        }
                        if (children.length > 1) {
                            keys = children[0];
                            values = children[1];
                        }
                        if (keys.length == 0 && values.length == 0) {
                            response = new Message(-1061158848);
                            response.append(false);
                            response.append(parentKeyName);
                            response.append(0);
                            response.append(0);
                        } else {
                            response.append(keys.length);
                            for (String key : keys) {
                                response.append(key);
                            }
                            response.append(values.length);
                            for (String value : values) {
                                response.append(value);
                            }
                        }
                    }
                    catch (Throwable t) {
                        response = new Message(-1061158848);
                        t.printStackTrace();
                        response.append(false);
                        response.append(parentKeyName);
                        response.append(0);
                        response.append(0);
                    }
                    this.respond(response);
                } else if (type == 65557) {
                    Message ret;
                    String username = (String)this.command.get(0);
                    String password = (String)this.command.get(1);
                    if (password != null) {
                        System.out.println("\n[AsyncServer] Elevation request with credentials (" + (password.length() > 0) + ")");
                    } else {
                        System.out.println("\n[AsyncServer] Elevation request with credentials (null)");
                    }
                    try {
                        ProcessResult result = new ProcessResult();
                        result.code = 1;
                        try {
                            if (username != null) {
                                MouseMover.forceNewElevatedInstanceWithCredentials(username, password);
                            } else {
                                MouseMover.forceNewElevatedInstanceWithoutCredentials();
                            }
                        }
                        catch (IOException ex) {
                            ex.printStackTrace();
                            result = AsyncServer.parseErrorFromStackTrace(ex);
                            Message ret6 = new Message(65557);
                            Message message = ProcessResultMessage.toMessage(result);
                            ret6.append(message);
                            this.respond(ret6);
                            return;
                        }
                        AsyncServer.this.postProcessElevation();
                        ret = new Message(65557);
                        Message message = ProcessResultMessage.toMessage(result);
                        ret.append(message);
                    }
                    catch (Throwable t) {
                        ret = new Message(-286392320);
                        ret.append(t.getMessage());
                        AsyncServer.appendStackTrace(ret, t);
                    }
                    this.respond(ret);
                }
            }
        }
    }

    class RTTThread
    extends Thread {
        final int MAX_RTT_ECHO_FREQUENCY_MS = 1000;
        Message incoming;
        final Object wait = new Object();

        public RTTThread() {
            this.setName("AppRttThread");
            this.setPriority(10);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!AsyncServer.this.die) {
                try {
                    Object object = this.wait;
                    synchronized (object) {
                        if (this.incoming == null) {
                            this.wait.wait(5000L);
                        }
                    }
                }
                catch (InterruptedException x) {
                    x.printStackTrace();
                }
                if (this.incoming == null) continue;
                AsyncServer.this.handleRttEchoMessage(this.incoming);
                this.incoming = null;
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (!Switches.SH_clearRttAfterFrequencySleep) continue;
                this.incoming = null;
            }
        }
    }

    private class RdpConsoleChecker
    extends Thread {
        private RdpConsoleChecker() {
        }

        @Override
        public void run() {
            block6: {
                try {
                    boolean isConsole;
                    if (!OS.isWindows() || OS.isWindowsPreXp()) break block6;
                    System.out.println("[RDPChecker] waiting for session info");
                    try {
                        int consoleID = JWNativeAPI.getInstance().getTsConsoleSessionId();
                        int myID = JWNativeAPI.getInstance().getTsMySessionId();
                        isConsole = consoleID == myID;
                        System.out.println("[RDPChecker] Native RDP checking worked");
                    }
                    catch (Throwable t) {
                        WSessionInfo.clearStaticWSessionInfo();
                        WSessionInfo info = WSessionInfo.getStaticWSessionInfo_Slow();
                        isConsole = info.isSessionConsole();
                    }
                    if (isConsole) {
                        System.out.println("[RDPChecker] Windows session is OK");
                    } else {
                        System.out.println("[RDPChecker] Windows session may need RDP switch");
                        Message m = new Message(196629);
                        AsyncServer.this.mout.write(m);
                    }
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    private class RemoteAccessServiceChecker
    extends Thread {
        private RemoteAccessServiceChecker() {
        }

        @Override
        public void run() {
            System.out.println("[RemoteAccessServiceChecker] Checking for existing Remote Access Service installation");
            File installationFolder = AllPlatformWrapper.getStandardMasterFolder((String)"Remote Access", (boolean)true);
            File sharedFolder = new File(installationFolder, "JWAppsSharedConfig");
            File serviceID = new File(sharedFolder, "serviceid.dat");
            while (!serviceID.exists()) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            System.out.println("[RemoteAccessServiceChecker] Service ID detected. Reading ID file.");
            long previousID = -1L;
            block9: while (true) {
                try {
                    while (true) {
                        long id;
                        if (serviceID.exists() && (id = SimpleGatewayID.loadOnlyID(serviceID)) != previousID) {
                            previousID = id;
                            System.out.println("[RemoteAccessServiceChecker] Notifying server of installed RAS ID " + id);
                            try {
                                Message m = new Message(196646);
                                m.append(id);
                                AsyncServer.this.mout.write(m);
                            }
                            catch (IOException e) {
                                e.printStackTrace();
                            }
                        }
                        try {
                            Thread.sleep(5000L);
                            continue block9;
                        }
                        catch (InterruptedException interruptedException) {
                            continue;
                        }
                        break;
                    }
                }
                catch (IOException iOException) {
                    continue;
                }
                break;
            }
        }
    }
}

