/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.client.gui.tools.api;

import com.aem.sdesktop.client.gui.tools.api.Tool;
import com.aem.sdesktop.client.gui.tools.ui.AbstractToolButton;
import com.aem.sdesktop.client.gui.tools.ui.OnOffToolButton;
import com.aem.shelp.proxy.TechGroupPermissions;
import java.util.Properties;
import javax.swing.Icon;
import javax.swing.RootPaneContainer;
import javax.swing.event.ChangeListener;
import utils.message.Message;

public abstract class AbstractOnOffTool
extends Tool {
    protected boolean currentState = this.isOnByDefault();
    protected OnOffToolButton buttonUI = null;

    public abstract boolean isOnByDefault();

    protected abstract boolean toggleOnOffTool(boolean var1);

    public AbstractOnOffTool(String title, String group, Icon icon) {
        super(title, group, null);
    }

    public boolean getCurrentState() {
        return this.currentState;
    }

    @Override
    protected RootPaneContainer getRpcForConfigurationUI() {
        return (RootPaneContainer)((Object)this.buttonUI.getRootComponent().getRootPane().getParent());
    }

    public void setButtonUIEnabled(boolean enabled) {
        if (this.buttonUI != null) {
            this.buttonUI.setEnabled(enabled);
            this.buttonUI.getRootComponent().repaint();
        }
    }

    @Override
    public boolean configure() {
        return true;
    }

    @Override
    public boolean toolActioned() {
        boolean turnOn;
        boolean bl = turnOn = !this.currentState;
        if (turnOn && !this.configure()) {
            return false;
        }
        if (!this.isSimulate()) {
            boolean didWork = this.toggleOnOffTool(turnOn);
            if (didWork) {
                this.currentState = turnOn;
            }
            return didWork;
        }
        this.currentState = turnOn;
        return true;
    }

    @Override
    public AbstractToolButton initToolButtonUI(ChangeListener listener) {
        System.out.println("[ToolsPanel] " + this.title + " initToolButtonUI called");
        this.buttonUI = new OnOffToolButton(this, listener);
        if (this.currentState) {
            this.buttonUI.setOn();
        } else {
            this.buttonUI.setOff();
        }
        return this.buttonUI;
    }

    @Override
    public void loadFrom(Properties props, boolean applySettings) {
        boolean defaultSetting = this.isOnByDefault();
        String currentSetting = props.getProperty("TOOL_" + this.getUniqueID());
        boolean setting = defaultSetting;
        if (currentSetting != null) {
            setting = currentSetting.equalsIgnoreCase("on");
        }
        if (this.buttonUI != null) {
            if (setting) {
                this.buttonUI.setOn();
            } else {
                this.buttonUI.setOff();
            }
        }
        this.currentState = setting;
        System.out.println("[AbstractOnOffTool] Loaded state for " + this.title + " [apply:" + applySettings + ", current:" + this.currentState + ", default:" + defaultSetting + "]");
        if (applySettings && this.currentState != defaultSetting) {
            this.toggleOnOffTool(this.currentState);
        }
    }

    @Override
    public void saveTo(Properties props) {
        String currentSetting = "on";
        if (!this.currentState) {
            currentSetting = "off";
        }
        props.setProperty("TOOL_" + this.getUniqueID(), currentSetting);
    }

    @Override
    public Message getDesiredStateAsMessage() {
        Message message = new Message(1);
        message.append(this.getUniqueID());
        message.append(this.currentState);
        return message;
    }

    @Override
    public boolean isPermitted(TechGroupPermissions permissions) {
        return true;
    }
}

