/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.client.gui.diag;

import com.aem.sdesktop.client.controller.CommandResponseListener;
import com.aem.sdesktop.client.gui.diag.ProcessTableModel;
import com.aem.sdesktop.client.gui.diag.StringRowFilter;
import com.aem.sdesktop.interfaces.ClientController;
import com.aem.sdesktop.interfaces.ClientUserInterface;
import com.aem.shelp.common.Language;
import com.aem.shelp.util.TimerPanel;
import com.aem.shelp.util.filter.FilterInterface;
import com.aem.shelp.util.filter.FilterTablePanel;
import com.aem.shelp.util.treetable.TableUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import javax.swing.AbstractButton;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.RootPaneContainer;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import utils.message.Message;
import utils.osstats.OsStats;
import utils.osstats.Stats;
import utils.swing.SwingUtil;
import utils.swing.components.SHJTable;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.dialog.glassdialog.SHGlassOptionPane;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;
import utils.swing.renderers.AlignTableCellRendererWrapper;
import utils.swing.simplelist.SimpleList;

public class ProcessTablePanel
extends JPanel
implements ActionListener,
CommandResponseListener,
ListSelectionListener,
FilterInterface {
    final int[] alignments = new int[]{2, 4, 4, 4, 2, 2};
    private JButton killProcessButton;
    private JButton killNameButton;
    private JToggleButton repeatKillButton;
    private TimerPanel ageOfInfo;
    private FilterTablePanel filter;
    private ClientController con;
    private ClientUserInterface cui;
    private Stats.ProcessStatistic[] processStatistics;
    private boolean repeatKillProcess = false;
    private String repeatKillProcessName = null;
    private JPanel north = new JPanel();
    private JLabel terminating = new JLabel("");
    private boolean controlEnabled = false;
    private SHJTable processTable;
    private ProcessTableModel processModel;
    private SimpleList<Stats.ProcessStatistic> processList = new SimpleList();
    private final ProcessCellRenderer processRenderer;
    private final TableRowSorter<TableModel> tableRowSorter;
    private final StringRowFilter tableRowFilter;
    boolean first = true;

    public ProcessTablePanel(ClientController con, ClientUserInterface cui) {
        this.con = con;
        this.cui = cui;
        this.killProcessButton = new JButton(ImageLoader.getImageIcon((String)"images/svg/av/stop.svg,16"));
        this.killProcessButton.setToolTipText(Language.get("PROCESS_TERMINATE"));
        this.killNameButton = new JButton(ImageLoader.getImageIcon((String)"images/svg/av/stop-list.svg,16"));
        this.killNameButton.setToolTipText(Language.get("PROCESS_TERMINATE_NAME"));
        this.repeatKillButton = new JToggleButton(ImageLoader.getImageIcon((String)"images/svg/av/stop-repeat.svg,16"));
        this.repeatKillButton.setToolTipText(Language.get("PROCESS_TERMINATE_REPEAT"));
        this.ageOfInfo = new TimerPanel(false);
        this.ageOfInfo.setIcon(ImageLoader.getImageIcon((String)"images/svg/arrows/refresh.svg,16"));
        this.ageOfInfo.showZeroData(false);
        this.processTable = new SHJTable();
        this.processRenderer = new ProcessCellRenderer();
        this.processTable.setDefaultRenderer(Object.class, this.processRenderer);
        this.processTable.setDefaultRenderer(Byte.class, this.processRenderer);
        this.processTable.setDefaultRenderer(String.class, this.processRenderer);
        this.processModel = ProcessTableModel.getInstance(this.processList);
        this.processTable.setModel(this.processModel);
        this.processTable.getSelectionModel().addListSelectionListener(this);
        this.processTable.getTableHeader().setDefaultRenderer(new AlignTableCellRendererWrapper(this.processTable.getTableHeader().getDefaultRenderer(), this.alignments));
        this.processModel.initTableDimensions(this.processTable);
        this.tableRowFilter = new StringRowFilter();
        this.tableRowSorter = new TableRowSorter<TableModel>(this.processTable.getModel());
        this.tableRowSorter.setSortsOnUpdates(true);
        this.tableRowSorter.setRowFilter(this.tableRowFilter);
        this.processTable.setRowSorter(this.tableRowSorter);
        ProcessTableModel.ProcessSorter processComparator = new ProcessTableModel.ProcessSorter();
        for (int i = 0; i < this.processTable.getColumnModel().getColumnCount(); ++i) {
            this.tableRowSorter.setComparator(i, processComparator);
        }
        ArrayList<RowSorter.SortKey> sortKeys = new ArrayList<RowSorter.SortKey>();
        sortKeys.add(new RowSorter.SortKey(1, SortOrder.DESCENDING));
        this.tableRowSorter.setSortKeys(sortKeys);
        JScrollPane processTablePane = new JScrollPane(this.processTable);
        GbPanel buttonsPanel = new GbPanel();
        buttonsPanel.add((Component)this.killProcessButton, 0, 0, 1, 1, 0, 0, 17, 1, (Insets)new ScaledInsets(0, 10, 0, 10));
        buttonsPanel.add((Component)this.killNameButton, 1, 0, 1, 1, 0, 0, 17, 1);
        buttonsPanel.add((Component)this.repeatKillButton, 2, 0, 1, 1, 0, 0, 17, 1);
        SHButtonUI.SegmentedButtonGroup.createSegmentedButtonGroup((AbstractButton)this.killNameButton, (AbstractButton)this.repeatKillButton);
        this.setLayout(new BorderLayout());
        JPanel tablePart = new JPanel();
        tablePart.setLayout(new BorderLayout());
        tablePart.add((Component)processTablePane, "Center");
        this.filter = new FilterTablePanel(this.processTable, (FilterInterface)this);
        this.filter.setBorder(SHBorderFactory.createEmptyBorder((int)5, (int)5, (int)5, (int)0));
        this.filter.addCentralComponent(this.ageOfInfo);
        tablePart.add((Component)this.north, "North");
        this.north.setLayout(new BorderLayout());
        this.north.add((Component)this.filter, "East");
        this.north.add((Component)buttonsPanel, "West");
        this.add((Component)tablePart, "Center");
        this.killProcessButton.addActionListener(this);
        this.killNameButton.addActionListener(this);
        this.repeatKillButton.addActionListener(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProcessStatistics(final Stats.ProcessStatistic[] ps) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ProcessTablePanel.this.setProcessStatistics(ps);
                }
            });
            return;
        }
        this.processStatistics = ps;
        this.processList.startBatch();
        try {
            int size = this.processList.size();
            while (size > this.processStatistics.length) {
                this.processList.remove(--size);
            }
            for (int i = 0; i < this.processStatistics.length; ++i) {
                Stats.ProcessStatistic newStatistic = this.processStatistics[i];
                if (this.processList.size() > i) {
                    this.processList.set(i, newStatistic);
                    continue;
                }
                this.processList.add(newStatistic);
            }
        }
        finally {
            this.processList.endBatch();
        }
        if (this.repeatKillProcess) {
            this.killByName(this.repeatKillProcessName);
        }
        this.ageOfInfo.reset();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.updateEnabled();
    }

    private void updateEnabled() {
        boolean enabled = this.isEnabled();
        this.filter.setEnabled(enabled);
        this.processTable.setEnabled(enabled);
        boolean enableControlButtons = enabled && this.processTable.getSelectedRowCount() > 0 && this.controlEnabled;
        this.killProcessButton.setEnabled(enableControlButtons);
        this.killNameButton.setEnabled(enableControlButtons);
        this.repeatKillButton.setEnabled(enableControlButtons);
    }

    private Stats.ProcessStatistic getSelectedProcess() {
        Stats.ProcessStatistic result = this.processList.get(this.processTable.convertRowIndexToModel(this.processTable.getSelectedRow()));
        if (result != null) {
            System.out.println("[ProcessTablePanel] Selected process is " + result.name);
        }
        return result;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.killProcessButton)) {
            Stats.ProcessStatistic process = this.getSelectedProcess();
            boolean ret = SHGlassOptionPane.showOkCancelDialog((RootPaneContainer)SwingUtil.getRootPaneContainer((Component)this), (String)(Language.get("TERMINATE_PROCESS_MSG") + " " + process.name + " [" + process.id + "] ?"), (String)Language.get("TERMINATE_PROCESS_TITLE"), (Icon)ImageLoader.getImageIcon((String)"images/svg/dialogs/warning.svg,48"), (String)Language.get("DISCONNECTED_TERMINATE"));
            if (ret) {
                Message m = new Message(-1061158904);
                m.append(process.id);
                this.con.doAsyncRemoteCommand(this, m);
                this.killProcessButton.setEnabled(false);
            }
        } else if (e.getSource().equals(this.killNameButton)) {
            Stats.ProcessStatistic process = this.getSelectedProcess();
            boolean ret = SHGlassOptionPane.showOkCancelDialog((RootPaneContainer)SwingUtil.getRootPaneContainer((Component)this), (String)(Language.get("TERMINATE_PROCESS_NAME_MSG") + " '" + process.name + "' ?"), (String)Language.get("TERMINATE_PROCESS_NAME_TITLE"), (Icon)ImageLoader.getImageIcon((String)"images/svg/dialogs/warning.svg,48"), (String)Language.get("DISCONNECTED_TERMINATE"));
            if (ret) {
                this.killByName(process.name);
            }
        } else if (e.getSource().equals(this.repeatKillButton)) {
            if (this.repeatKillButton.isSelected()) {
                Stats.ProcessStatistic process = this.getSelectedProcess();
                boolean ret = SHGlassOptionPane.showOkCancelDialog((RootPaneContainer)SwingUtil.getRootPaneContainer((Component)this), (String)(Language.get("TERMINATE_PROCESS_REPEAT_MSG") + " '" + process.name + "' ?"), (String)Language.get("TERMINATE_PROCESS_REPEAT_TITLE"), (Icon)ImageLoader.getImageIcon((String)"images/svg/dialogs/warning.svg,48"), (String)Language.get("DISCONNECTED_TERMINATE"));
                if (ret) {
                    this.repeatKillProcess = true;
                    this.repeatKillProcessName = process.name;
                    this.repeatKillButton.setToolTipText(Language.get("TERMINATE_IN_ACTION") + " '" + this.repeatKillProcessName + "'");
                    this.terminating.setBorder(SHBorderFactory.createEmptyBorder((int)5, (int)5, (int)5, (int)5));
                    this.terminating.setHorizontalAlignment(0);
                    this.terminating.setText(Language.get("TERMINATING_CONTINUOUSLY") + " '" + process.name + "'");
                    this.terminating.setIcon(ImageLoader.getImageIcon((String)"images/svg/av/stop.svg,16"));
                    this.north.add((Component)this.terminating, "South");
                    this.north.revalidate();
                    this.north.repaint();
                    this.killByName(process.name);
                } else {
                    this.repeatKillProcess = false;
                    this.repeatKillButton.setSelected(false);
                    this.repeatKillButton.setToolTipText(Language.get("PROCESS_TERMINATE_REPEAT"));
                    this.north.remove(this.terminating);
                    this.doLayout();
                    this.repaint();
                }
            } else {
                this.repeatKillProcess = false;
                this.repeatKillButton.setSelected(false);
                this.repeatKillButton.setToolTipText(Language.get("PROCESS_TERMINATE_REPEAT"));
                this.north.remove(this.terminating);
                this.doLayout();
                this.repaint();
            }
        }
    }

    private void killByName(String name) {
        Message m = new Message(-1061158903);
        for (Stats.ProcessStatistic processStatistic : this.processStatistics) {
            if (!processStatistic.name.equals(name)) continue;
            m.append(processStatistic.id);
        }
        if (m.length() == 0) {
            return;
        }
        this.con.doAsyncRemoteCommand(this, m);
        this.killNameButton.setEnabled(false);
    }

    @Override
    public void response(Message m) {
        if (m.getType() == -1061158904 || m.getType() == -1061158896) {
            this.killProcessButton.setEnabled(true);
        }
        if (m.getType() == -1061158903 || m.getType() == -1061158895) {
            this.killNameButton.setEnabled(true);
        }
        if (m.getType() == -1061158896) {
            String error = (String)m.get(0);
            if (error == null) {
                error = Language.get("UNKNOWN");
            }
            SHGlassOptionPane.showMessageDialog((RootPaneContainer)SwingUtil.getRootPaneContainer((Component)this), (String)(Language.get("CANNOT_TERMINATE_MESSAGE") + "\n\t" + error), (String)Language.get("CANNOT_TERMINATE_TITLE"), (Icon)ImageLoader.getImageIcon((String)"images/svg/dialogs/warning.svg,48"));
        } else if (m.getType() == -1061158895) {
            // empty if block
        }
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.updateEnabled();
    }

    public static void main(String[] args) throws Throwable {
        Language.loadTranslations();
        SimpleHelpFrame frame = SimpleHelpFrame.getTestFrame();
        ProcessTablePanel panel = new ProcessTablePanel(null, null);
        panel.setControlEnabled(true);
        frame.getContentPane().add(panel);
        frame.setVisible(true);
        System.out.println("INITIED --------------\n\n");
        new PopThread(panel).start();
    }

    public void setControlEnabled(boolean enabled) {
        this.controlEnabled = enabled;
        this.updateEnabled();
    }

    @Override
    public void setFilters(String[] filters) {
        this.tableRowFilter.setFilters(filters);
        this.tableRowSorter.sort();
    }

    @Override
    public String[] getFilters() {
        return new String[0];
    }

    static class PopThread
    extends Thread {
        Stats stats = OsStats.getOsStats();
        private ProcessTablePanel panel;

        public PopThread(ProcessTablePanel panel) {
            this.panel = panel;
        }

        @Override
        public void run() {
            while (true) {
                this.stats.update();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        PopThread.this.panel.setProcessStatistics(PopThread.this.stats.getProcessStatistics());
                    }
                });
                try {
                    Thread.sleep(2000L);
                    continue;
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }

    class ProcessCellRenderer
    extends DefaultTableCellRenderer {
        private NumberFormat twoDecimalPlace = null;
        private NumberFormat oneDecimalPlace = null;
        private Border emptyBorder = SHBorderFactory.createEmptyBorder((int)0, (int)5, (int)0, (int)5);

        ProcessCellRenderer() {
            this.oneDecimalPlace = NumberFormat.getInstance();
            if (this.oneDecimalPlace instanceof DecimalFormat) {
                ((DecimalFormat)this.oneDecimalPlace).setDecimalSeparatorAlwaysShown(true);
                this.oneDecimalPlace.setMaximumFractionDigits(1);
                this.oneDecimalPlace.setMinimumFractionDigits(1);
            }
            this.twoDecimalPlace = NumberFormat.getInstance();
            if (this.twoDecimalPlace instanceof DecimalFormat) {
                ((DecimalFormat)this.twoDecimalPlace).setDecimalSeparatorAlwaysShown(true);
                this.twoDecimalPlace.setMaximumFractionDigits(2);
                this.twoDecimalPlace.setMinimumFractionDigits(2);
            }
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            JLabel label = (JLabel)component;
            label.setBorder(this.emptyBorder);
            int modelIndex = TableUtils.toModel(table, column);
            label.setHorizontalAlignment(ProcessTablePanel.this.alignments[modelIndex]);
            if (value instanceof Long) {
                double doubleValue = ((Long)value).doubleValue();
                String units = Language.get("BYTES");
                if (doubleValue > 1024.0) {
                    doubleValue /= 1024.0;
                    units = Language.get("KBYTES");
                }
                if (doubleValue > 1024.0) {
                    doubleValue /= 1024.0;
                    units = Language.get("MBYTES");
                }
                if (doubleValue > 1024.0) {
                    doubleValue /= 1024.0;
                    units = Language.get("GBYTES");
                }
                label.setText(this.twoDecimalPlace.format(doubleValue) + " " + units);
            } else if (value instanceof Integer) {
                byte cpu = ((Integer)value).byteValue();
                label.setText(this.oneDecimalPlace.format(cpu));
            }
            if (value != null) {
                label.setToolTipText(value.toString());
            }
            return component;
        }
    }
}

