/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.client.gui.diag;

import org.w3c.dom.Element;

class PortForward
implements Comparable {
    boolean toremote;
    String localport;
    String remoteport;
    long UID = System.currentTimeMillis() * 100000L + (long)(Math.random() * 100000.0);
    boolean switchedOn = false;

    public String toXML() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<PortForward uid=\"" + this.UID + "\" on=\"" + this.switchedOn + "\" toRemote=\"" + this.toremote + "\" localport=\"" + this.localport + "\" remoteport=\"" + this.remoteport + "\"/>\n");
        return buffer.toString();
    }

    public static PortForward fromXMLElement(Element portForwardElement) {
        PortForward portForward = new PortForward();
        portForward.UID = Long.parseLong(portForwardElement.getAttribute("uid"));
        portForward.switchedOn = Boolean.parseBoolean(portForwardElement.getAttribute("on"));
        portForward.toremote = Boolean.parseBoolean(portForwardElement.getAttribute("toRemote"));
        portForward.localport = portForwardElement.getAttribute("localport");
        portForward.remoteport = portForwardElement.getAttribute("remoteport");
        return portForward;
    }

    public boolean isSwitchedOn() {
        return this.switchedOn;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.toremote) {
            sb.append("LOCAL-");
            sb.append(this.localport);
            sb.append("-");
            sb.append(this.remoteport);
        } else {
            sb.append("REMOTE-");
            sb.append(this.remoteport);
            sb.append("-");
            sb.append(this.localport);
        }
        return sb.toString();
    }

    public int compareTo(Object arg0) {
        PortForward pf = (PortForward)arg0;
        return this.toString().compareTo(pf.toString());
    }

    public String getUniqueID() {
        if (this.toremote) {
            return "L-" + this.localport;
        }
        return "R-" + this.remoteport;
    }

    public int getClientFwdPort() {
        String tmp = this.localport;
        if (!this.toremote) {
            tmp = this.remoteport;
        }
        return Integer.parseInt(tmp.trim());
    }

    public String getTargetFwdHost() {
        String tmp = this.remoteport;
        if (!this.toremote) {
            tmp = this.localport;
        }
        tmp = tmp.replace(':', ' ');
        tmp = tmp.replace(';', ' ');
        tmp = tmp.replace('/', ' ');
        int index = (tmp = tmp.trim()).lastIndexOf(32);
        if (index == -1) {
            return null;
        }
        return tmp.substring(0, index).trim();
    }

    public int getTargetFwdPort() {
        String tmp = this.remoteport;
        if (!this.toremote) {
            tmp = this.localport;
        }
        tmp = tmp.replace(':', ' ');
        tmp = tmp.replace(';', ' ');
        tmp = tmp.replace('/', ' ');
        tmp = tmp.trim();
        int index = tmp.lastIndexOf(32);
        return Integer.parseInt(tmp.substring(index + 1));
    }
}

