/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.client.gui.diag;

import com.aem.CentralDebugging;
import com.aem.sdesktop.client.gui.CentrePanel;
import com.aem.sdesktop.client.gui.HintOverlayManager;
import com.aem.sdesktop.client.gui.terminal.TerminalUI;
import com.aem.sdesktop.interfaces.ClientController;
import com.aem.shelp.util.progress.SHProgressIcons;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.RenderingHints;
import java.nio.charset.StandardCharsets;
import javax.swing.JPanel;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.icons.InfiniteCircularProgressIcon;

public class ConsolePanel {
    private TerminalUI terminalUI;
    private HintOverlayManager.Hint centreHint;
    InfiniteCircularProgressIcon icon = SHProgressIcons.getCircularInfiniteGrayscale(SHProgressIcons.SIZE_16);
    private JPanel root = new JPanel(){

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            Graphics2D g2d = (Graphics2D)g;
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            int viewportWidth = this.getWidth() - SimpleHelpLookAndFeel.scale((int)16);
            int viewportHeight = this.getHeight();
            int leftX = 0;
            int topY = 0;
            CentrePanel.paintCentreHit(this, ConsolePanel.this.centreHint, g2d, viewportWidth, viewportHeight, leftX, topY, ConsolePanel.this.icon);
        }
    };

    public JPanel getRootComponent() {
        return this.root;
    }

    public ConsolePanel(ClientController con) {
        this.terminalUI = new TerminalUI(con);
        this.root.setLayout(new GridLayout(1, 1));
        this.root.add(this.terminalUI.getRootComponent());
    }

    public void setEnabled(boolean b) {
        this.root.setEnabled(b);
        this.terminalUI.setEnabled(b);
    }

    public void receivedTerminalOutput(byte[] data) {
        String stringData = new String(data, StandardCharsets.UTF_8);
        if (CentralDebugging.TERMINAL_VERBOSE) {
            System.out.println("[ConsolePanel] Received terminal string '" + stringData + "'");
        }
        this.terminalUI.addTerminalOutput(stringData);
    }

    public void grabFocus() {
        this.terminalUI.grabFocus();
    }

    public void setRemoteOS(int remoteOsBase, int remoteOsVariant) {
        this.terminalUI.setRemoteOS(remoteOsBase, remoteOsVariant);
    }

    public void setConnected(boolean connected) {
        if (connected) {
            this.terminalUI.updateWindowSize();
        }
    }

    public void updateHints(HintOverlayManager.Hint centreHint) {
        this.centreHint = centreHint;
        this.root.repaint();
    }
}

