/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.client.gui;

import com.aem.shelp.common.Language;
import java.awt.Insets;
import java.io.IOException;
import java.util.ResourceBundle;
import javax.swing.JComboBox;
import javax.swing.RootPaneContainer;
import utils.ostools.OS;
import utils.swing.cui.types.CUIField;
import utils.swing.cui.types.ResultPair;
import utils.swing.cui.types.fields.AbstractField;
import utils.swing.cui.types.fields.CheckBoxField;
import utils.swing.cui.types.fields.ComboBoxField;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.dialog.contents.FixedWidthCUIPanel;
import utils.swing.dialog.contents.FixedWidthComponent;
import utils.swing.dialog.glassdialog.AbstractGlassDialog;
import utils.swing.dialog.panels.AbstractDialogPanel;
import utils.swing.dialog.panels.OKCancelDialogPanel;

public class RunCommandUI
extends OKCancelDialogPanel
implements AbstractField.ChangeListener {
    public static final String[] XP_COMMANDS = new String[]{"cmd.exe /c appwiz.cpl", "Add or Remove Programs", null, "cleanmgr.exe", "Disk Cleanup", null, "cmd/exe /c compmgmt.msc", "Computer Management", null, "control.exe", "Control Panel", null, "cmd.exe /c devmgmt.msc", "Device Manager", null, "cmd.exe /c diskmgmt.msc", "Disk Management", null, "eventvwr", "Event Viewer", null, "explorer.exe", "Explorer", null, "cmd.exe /c firewall.cpl", "Windows Firewall", null, "cmd.exe", "Command Prompt", null, "cmd.exe /c %WINDOWS%\\system32\\dllcache\\msconfig", "System Configuration", null, "notepad.exe", "Notepad", null, "perfmon.exe", "Performance Monitor", null, "regedit.exe", "Registry Editor", null, "cmd.exe /c services.msc", "Services Control Panel", null, "taskmgr.exe", "Task Manager", null, "cmd.exe /c wscui.cpl", "Security Center", null};
    public static final String[] W7_LATER = new String[]{"cmd.exe /c appwiz.cpl", "Programs and Features", null, "cleanmgr.exe", "Disk Cleanup", null, "cmd.exe /c compmgmt.msc", "Computer Management", null, "control.exe", "Control Panel", null, "cmd.exe /c devmgmt.msc", "Device Manager", null, "cmd.exe /c diskmgmt.msc", "Disk Management", null, "eventvwr", "Event Viewer", null, "explorer.exe", "Explorer", null, "cmd.exe /c firewall.cpl", "Windows Firewall", null, "cmd.exe", "Command Prompt", null, "cmd.exe /c %WINDOWS%\\system32\\dllcache\\msconfig", "System Configuration", null, "notepad.exe", "Notepad", null, "perfmon.exe", "Performance Monitor", null, "regedit.exe", "Registry Editor", null, "cmd.exe /c services.msc", "Services Control Panel", null, "taskmgr.exe", "Task Manager", null, "cmd.exe /c wscui.cpl", "Security Center", null};
    static final String[] MAC_OS = new String[]{"open -a \"Activity Monitor.app\"", "Activity Monitor", null, "open -a \"Console.app\"", "Console", null, "open -a \"Disk Utility.app\"", "Disk Utility", null, "open -a \"System Information.app\"", "System Information", null, "open -a \"System Preferences.app\"", "System Preferences", null, "open -a \"Terminal.app\" .", "Terminal", null, "open ~/Library", "Finder - ~/Library", null, "open /Library", "Finder - /Library", null, "open /System", "Finder - /System", null};
    private final int remoteOSBase;
    private final int remoteOSType;
    private FixedWidthCUIPanel cuiPanel;
    private boolean elevate;
    private String command;

    public RunCommandUI(int remoteOSBase, int remoteOSType) {
        super(Language.get("LAUNCH"), Language.get("CANCEL"));
        this.remoteOSBase = remoteOSBase;
        this.remoteOSType = remoteOSType;
        this.setTitle(Language.get("ENTER_COMMAND_TO_RUN") + ":", false);
    }

    public void showDialog(RootPaneContainer rootPane) {
        String[] commands;
        this.cuiPanel = new FixedWidthCUIPanel();
        this.addFields();
        this.setContent((FixedWidthComponent)this.cuiPanel);
        AbstractGlassDialog dialog = new AbstractGlassDialog(rootPane, 450, (AbstractDialogPanel)this);
        dialog.setTitle(Language.get("RUN_COMMAND_TITLE"));
        dialog.showDialog();
        ResultPair[] filledOutResults = this.cuiPanel.getResults((ResourceBundle)Language.DEFLANG);
        this.command = filledOutResults[0].getValue();
        this.elevate = false;
        if (filledOutResults.length == 2) {
            this.elevate = filledOutResults[1].getValue().equals(Language.get("YES"));
        }
        if ((commands = this.getCommands()) != null) {
            for (int i = 0; i < commands.length; i += 3) {
                if (!commands[i + 1].equals(this.command)) continue;
                this.command = commands[i];
                break;
            }
        }
    }

    protected Insets getFieldInsets() {
        return new ScaledInsets(1, 1, 1, 3);
    }

    private boolean isWindows() {
        return 0 == this.remoteOSBase;
    }

    private boolean isMac() {
        return 1 == this.remoteOSBase;
    }

    private String[] getCommands() {
        if (0 == this.remoteOSBase) {
            if (OS.isVariantVistaOrAbove((int)this.remoteOSType)) {
                return W7_LATER;
            }
            return XP_COMMANDS;
        }
        if (1 == this.remoteOSBase) {
            return MAC_OS;
        }
        return null;
    }

    protected void addFields() {
        String[] commands = this.getCommands();
        String[] options = null;
        if (commands != null) {
            options = new String[commands.length / 3];
            for (int i = 0; i < commands.length; i += 3) {
                options[i / 3] = commands[i + 1];
            }
        }
        ComboBoxField applicationList = new ComboBoxField(Language.get("RUN_COMMAND_TITLE"), (AbstractField.ChangeListener)this, options);
        JComboBox c = (JComboBox)applicationList.getComponent();
        c.setEditable(true);
        c.setSelectedItem(null);
        if (this.isWindows() || this.isMac()) {
            CheckBoxField elevationField = new CheckBoxField(Language.get("RUN_COMMAND_ELEVATED"), this);
            elevationField.setDefaultCheckedState(false);
            this.cuiPanel.setFields(new CUIField[]{applicationList, elevationField});
            return;
        }
        this.cuiPanel.setFields(new CUIField[]{applicationList});
    }

    public String getCommandToRun() {
        return this.command;
    }

    public boolean getElevate() {
        return this.elevate;
    }

    public static void main(String[] args) throws IOException {
        Language.loadTranslations();
        SimpleHelpFrame frame = new SimpleHelpFrame();
        frame.setSize(550, 330);
        frame.setDefaultCloseOperation(3);
        frame.setVisible(true);
        RunCommandUI ui = new RunCommandUI(0, 3);
        ui.showDialog((RootPaneContainer)frame);
        System.out.println(ui.getCommandToRun());
    }

    protected boolean isValid() {
        return true;
    }

    public void changed(AbstractField source) {
    }
}

