/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.client.gui;

import com.aem.shelp.common.Language;
import com.aem.shelp.common.properties.SessionProperties;
import com.aem.shelp.util.RequestFocusListener;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.RootPaneContainer;
import javax.swing.UnsupportedLookAndFeelException;
import utils.swing.components.JWrapLabel;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHButtonUI;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.ScalingUtil;
import utils.swing.customlaf.SimpleHelpFrame;
import utils.swing.dialog.glassdialog.ScaledGlassDialog;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;

public class RebootDialog
extends ScaledGlassDialog
implements ActionListener {
    private JButton rebootButton;
    private JButton rebootSafeModeButton;
    private JButton cancelButton;
    private JWrapLabel descriptionLabel;
    private JLabel iconLabel;
    private JLabel titleLabel;
    private boolean remoteOSIsWindows;
    private boolean remoteOSIsLinux;
    private boolean showWarning;
    private boolean doRebootSafeMode = false;
    private boolean doReboot = false;
    private JCheckBox forceBox;
    private boolean force = false;

    public RebootDialog(RootPaneContainer rootPane, boolean remoteOSIsWindows, boolean remoteOSIsLinux, boolean showWarning) {
        super(rootPane, 380 + (showWarning ? 100 : 0) + 100, 210, true, true, false);
        this.setTitle(Language.get("REBOOT_TITLE"));
        this.remoteOSIsWindows = remoteOSIsWindows;
        this.remoteOSIsLinux = remoteOSIsLinux;
        this.showWarning = showWarning;
        try {
            this.force = SessionProperties.INSTANCE.getBooleanProp("f_rbt", false);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        this.initUI();
    }

    private void initUI() {
        GbPanel main = new GbPanel(new ScaledInsets(2, 2, 2, 2));
        main.setBorder(SHBorderFactory.createEmptyBorder((int)20, (int)20, (int)10, (int)10));
        this.rebootButton = new JButton(Language.get("RESTART"));
        this.rebootSafeModeButton = new JButton(Language.get("REBOOT_SAFE_MODE"));
        this.cancelButton = new JButton(Language.get("CANCEL"));
        this.forceBox = new JCheckBox(Language.get("FORCE_REBOOT"));
        this.forceBox.setSelected(this.force);
        this.titleLabel = new JWrapLabel("<html>" + Language.get("REBOOT_TITLE") + "</html>");
        this.titleLabel.setFont(this.titleLabel.getFont().deriveFont(1));
        this.descriptionLabel = this.showWarning ? new JWrapLabel("<html>" + Language.get("SG_REBOOT_WARNING_1") + " " + Language.get("SG_REBOOT_WARNING_2") + "</html>") : new JWrapLabel("<html>" + Language.get("REBOOT_DIALOG_WARNING") + "</html>");
        this.iconLabel = new JLabel(ImageLoader.getImageIcon((String)"images/svg/arrows/reboot.svg,48"));
        this.iconLabel.setBorder(SHBorderFactory.createEmptyBorder((int)0, (int)0, (int)0, (int)10));
        this.rebootButton.addActionListener(this);
        this.rebootSafeModeButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.rebootButton.addAncestorListener(new RequestFocusListener());
        this.rebootSafeModeButton.setVisible(this.remoteOSIsWindows || this.remoteOSIsLinux);
        GbPanel descriptionPanel = new GbPanel();
        descriptionPanel.add((Component)this.descriptionLabel, 0, 0, 1, 1, 100, 1, 10, 2);
        GbPanel panel = new GbPanel();
        panel.add((Component)this.rebootSafeModeButton, 0, 0, 1, 1, 1, 0, 17, 0, (Insets)new ScaledInsets(0, 0, 0, 10));
        panel.add((Component)this.cancelButton, 1, 0, 1, 1, 0, 0, 17, 0, (Insets)new ScaledInsets(0, 0, 0, 10));
        panel.add((Component)this.rebootButton, 2, 0, 1, 1, 0, 0, 17, 0, (Insets)new ScaledInsets(0, 0, 0, 0));
        SHButtonUI.makeButtonBlue((JButton)this.rebootButton);
        GbPanel buttonsPanel = new GbPanel();
        if (this.remoteOSIsWindows || this.remoteOSIsLinux) {
            buttonsPanel.add((Component)panel, 0, 0, 1, 1, 1, 1, 14, 2);
        } else {
            buttonsPanel.add((Component)panel, 0, 0, 1, 1, 1, 1, 14, 0);
        }
        int Y = 0;
        main.add((Component)this.iconLabel, 0, Y, 1, 2, 0, 0, 18, 0);
        main.add((Component)this.titleLabel, 1, Y++, 1, 1, 1, 0, 17, 2, (Insets)new ScaledInsets(3, 3, 10, 3));
        main.add((Component)descriptionPanel, 1, Y++, 1, 1, 1, 0, 17, 2);
        if (this.remoteOSIsWindows || this.remoteOSIsLinux) {
            main.add((Component)this.forceBox, 1, Y++, 1, 1, 1, 0, 17, 2, (Insets)new ScaledInsets(5, 0, 0, 0));
        }
        main.add((Component)buttonsPanel, 0, Y++, 2, 1, 1, 1, 10, 1);
        this.getContentPane().add((Component)main);
        this.setVisible(true);
    }

    public boolean force() {
        return this.force;
    }

    public boolean doReboot() {
        return this.doReboot;
    }

    public boolean doSafeModeReboot() {
        return this.doRebootSafeMode;
    }

    public static void main(String[] args) throws UnsupportedLookAndFeelException, IOException, InterruptedException {
        ScalingUtil.forceScalingPercentage((int)200);
        Language.loadTranslations();
        SimpleHelpFrame frame = new SimpleHelpFrame();
        frame.setDefaultCloseOperation(3);
        frame.setSize(500, 500);
        frame.setVisible(true);
        RebootDialog dialog = new RebootDialog((RootPaneContainer)frame, true, false, false);
        dialog = new RebootDialog((RootPaneContainer)frame, false, true, false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.rebootButton) {
            this.force = this.forceBox.isSelected();
            this.doReboot = true;
            if (this.remoteOSIsWindows || this.remoteOSIsLinux) {
                SessionProperties.INSTANCE.setPropAndSave("f_rbt", Boolean.toString(this.force));
            }
            this.setVisible(false);
        } else if (e.getSource() == this.cancelButton) {
            this.setVisible(false);
        } else if (e.getSource() == this.rebootSafeModeButton) {
            this.force = this.forceBox.isSelected();
            this.doRebootSafeMode = true;
            if (this.remoteOSIsWindows || this.remoteOSIsLinux) {
                SessionProperties.INSTANCE.setPropAndSave("f_rbt", Boolean.toString(this.force));
            }
            this.setVisible(false);
        }
    }
}

