/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.client.gui;

import com.aem.CentralDebugging;
import com.aem.tests.TestTreeModel;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import utils.progtools.Cleanable;
import utils.swing.customlaf.SimpleHelpFrame;

public class FasterScaledImagePanel
extends JPanel
implements Cleanable {
    public static final int SCALE_MODE_NONE = 0;
    public static final int SCALE_MODE_FIT_HEIGHT = 1;
    public static final int SCALE_MODE_FIT_ALL = 2;
    public static final int SCALE_MODE_CUSTOM = 3;
    private static final boolean SCALE_TO_ALLOW_FOR_SCROLL_BAR = true;
    private BufferedImage image;
    private BufferedImage subImage = null;
    private int scaleMode = 0;
    private double inUseScalingFactor = 1.0;
    private double requestedScale = 1.0;
    private JScrollPane scrollPane;
    private boolean drawGrayScale = false;
    private Rectangle cropArea = null;
    private double cachedInUseScalingFactor;
    private int cachedScaleMode;
    protected double yOffsetForScrollbar = 0.0;
    private double fixedScalingFactor = 1.0;
    private double previousImageWidth;
    private double previousImageHeight;
    private double previousViewPortWidth;
    private double previousViewPortHeight;
    private int previousScaleMode = 0;
    private double previousRequestedScale = 0.0;

    public FasterScaledImagePanel(JScrollPane pane) {
        this.scrollPane = pane;
    }

    public FasterScaledImagePanel(BufferedImage image, JScrollPane pane) {
        this(pane);
        this.setImage(image);
    }

    public int getScaleMode() {
        return this.scaleMode;
    }

    public double getRequestedScalingFactor() {
        return this.requestedScale;
    }

    public double getInUseScalingFactor() {
        return this.inUseScalingFactor;
    }

    public void setGrayScale(boolean grayScale) {
        this.drawGrayScale = grayScale;
        this.repaint();
    }

    public void setScaleMode(int mode) {
        this.scrollPane.setHorizontalScrollBarPolicy(30);
        this.scrollPane.setVerticalScrollBarPolicy(20);
        switch (mode) {
            case 0: {
                this.requestedScale = 1.0;
                this.notifyScalingFactorChange(this.requestedScale);
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                this.requestedScale = 0.0;
                this.notifyScalingFactorChange(this.requestedScale);
            }
        }
        this.scaleMode = mode;
        this.adjustSize();
    }

    @Override
    public Dimension getPreferredSize() {
        double ratio = this.getScalingRatio();
        if (this.cropArea == null) {
            if (this.image != null) {
                int imageWidth = (int)(ratio * (double)this.image.getWidth());
                int imageHeight = (int)(ratio * (double)this.image.getHeight());
                return new Dimension(imageWidth, imageHeight);
            }
            return new Dimension(0, 0);
        }
        int imageWidth = (int)(ratio * this.cropArea.getWidth());
        int imageHeight = (int)(ratio * this.cropArea.getHeight());
        return new Dimension(imageWidth, imageHeight);
    }

    public void setCustomScaleMode(double factor) {
        this.scaleMode = 3;
        this.requestedScale = factor;
        this.adjustSize();
    }

    public Rectangle getCropArea() {
        return this.cropArea;
    }

    public void setCropArea(Rectangle cropArea) {
        this.cropArea = cropArea;
        this.subImage = null;
        this.adjustSize();
    }

    private void adjustSize() {
        this.scrollPane.getViewport().revalidate();
        this.scrollPane.getViewport().repaint();
    }

    private static double getScaleForFitHeight(double imageWidth, double imageHeight, Dimension viewportSize) {
        double targetFactor = viewportSize.getHeight() / imageHeight;
        targetFactor = Math.min(targetFactor, 1.0);
        double fitAllFactor = Math.min(viewportSize.getWidth() / imageWidth, viewportSize.getHeight() / imageHeight);
        return (targetFactor - fitAllFactor) / (1.0 - fitAllFactor);
    }

    private double getResolutionPercentageToFitHeight(Dimension viewportSize) {
        BufferedImage imageToDraw = this.getImageToDraw();
        if (imageToDraw == null) {
            return 1.0;
        }
        double imageWidth = (double)imageToDraw.getWidth() * this.fixedScalingFactor;
        double imageHeight = (double)imageToDraw.getHeight() * this.fixedScalingFactor;
        double previousRequestedScale = this.requestedScale;
        viewportSize = new Dimension(viewportSize);
        if (!this.scrollPane.getHorizontalScrollBar().isVisible()) {
            double scrollBarHeight = this.scrollPane.getHorizontalScrollBar().getPreferredSize().getHeight();
            double imageRatio = imageWidth / imageHeight;
            double viewportRatio = viewportSize.getWidth() / viewportSize.getHeight();
            double factor = 1.0 - viewportRatio / imageRatio;
            double maxToScaleDownFrom = 0.05;
            double limitToReachPlateau = 0.02;
            double overflow = 2.0 * scrollBarHeight / viewportSize.getHeight();
            if (factor <= overflow && factor >= -maxToScaleDownFrom) {
                if (factor < 0.0) {
                    if ((factor = Math.abs(factor)) < maxToScaleDownFrom) {
                        factor = factor < limitToReachPlateau ? 1.0 : 1.0 - (factor - limitToReachPlateau) / (maxToScaleDownFrom - limitToReachPlateau);
                        factor = Math.max(factor, 0.0);
                        factor = Math.min(factor, 1.0);
                    }
                } else {
                    factor = 1.0;
                }
            } else {
                factor = 0.0;
            }
            if (factor > 0.0) {
                this.yOffsetForScrollbar = -Math.ceil(factor * scrollBarHeight);
                viewportSize.height = (int)((double)viewportSize.height + this.yOffsetForScrollbar);
            }
        } else {
            this.yOffsetForScrollbar = 0.0;
        }
        double targetFactor = Math.min(viewportSize.getHeight() / imageHeight, 1.0);
        this.requestedScale = FasterScaledImagePanel.getScaleForFitHeight(imageWidth, imageHeight, viewportSize);
        if (previousRequestedScale != this.requestedScale) {
            this.notifyScalingFactorChange(this.requestedScale);
        }
        return targetFactor;
    }

    protected double getScalingRatio() {
        BufferedImage imageToDraw = this.getImageToDraw();
        if (imageToDraw == null) {
            return 1.0;
        }
        double imageWidth = (double)imageToDraw.getWidth() * this.fixedScalingFactor;
        double imageHeight = (double)imageToDraw.getHeight() * this.fixedScalingFactor;
        Dimension viewportSize = this.scrollPane.getViewport().getSize();
        if (imageWidth == this.previousImageWidth && imageHeight == this.previousImageHeight && (double)viewportSize.width == this.previousViewPortWidth && (double)viewportSize.height == this.previousViewPortHeight && this.previousScaleMode == this.scaleMode && this.previousRequestedScale == this.requestedScale) {
            return this.inUseScalingFactor;
        }
        this.previousScaleMode = this.scaleMode;
        this.previousImageWidth = imageWidth;
        this.previousImageHeight = imageHeight;
        this.previousViewPortWidth = viewportSize.width;
        this.previousViewPortHeight = viewportSize.height;
        this.previousRequestedScale = this.requestedScale;
        if (CentralDebugging.SCR_VERBOSE_SCALING) {
            System.out.println("[CentrePanel] Scaling, resolutionPercentage = " + this.inUseScalingFactor);
        }
        if (CentralDebugging.SCR_VERBOSE_SCALING) {
            System.out.println("[CentrePanel] Scaling, image w, h = " + imageWidth + "," + imageHeight);
        }
        if (CentralDebugging.SCR_VERBOSE_SCALING) {
            System.out.println("[CentrePanel] Scaling, centre panel w, h = " + viewportSize.getWidth() + "," + viewportSize.getHeight());
        }
        this.yOffsetForScrollbar = 0.0;
        if (this.scaleMode == 1) {
            this.inUseScalingFactor = this.getResolutionPercentageToFitHeight(viewportSize);
        } else if (this.requestedScale < 1.0) {
            double viewportWidth = viewportSize.getWidth();
            double viewportHeight = viewportSize.getHeight();
            if (this.requestedScale < 0.0) {
                viewportWidth += this.requestedScale;
                viewportHeight += this.requestedScale;
            }
            double factor = Math.min(viewportWidth / imageWidth, viewportHeight / imageHeight);
            factor = Math.min(factor, 1.0);
            double step = 1.0 - factor;
            this.inUseScalingFactor = factor + step * Math.max(0.0, this.requestedScale);
        } else {
            this.inUseScalingFactor = this.requestedScale;
        }
        this.inUseScalingFactor *= this.fixedScalingFactor;
        if (CentralDebugging.SCR_VERBOSE_SCALING) {
            System.out.println("[CentrePanel] Scaling, resolutionFactor = " + this.inUseScalingFactor);
        }
        return this.inUseScalingFactor;
    }

    protected void notifyScalingFactorChange(double requestedFactor) {
    }

    protected void cacheResolutionSettings() {
        this.cachedInUseScalingFactor = this.getRequestedScalingFactor();
        this.cachedScaleMode = this.getScaleMode();
    }

    protected void restoreResolutionSettings() {
        if (this.cachedScaleMode == 3) {
            this.setCustomScaleMode(this.cachedInUseScalingFactor);
        } else {
            this.setScaleMode(this.cachedScaleMode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paintComponent(Graphics g) {
        Graphics2D g2d = (Graphics2D)g;
        super.paintComponent(g);
        BufferedImage imageToDraw = this.getImageToDraw();
        if (imageToDraw != null) {
            AffineTransform oldTransform = g2d.getTransform();
            Composite oldComposite = g2d.getComposite();
            Point translation = new Point();
            try {
                if (this.drawGrayScale) {
                    g2d.setComposite(AlphaComposite.getInstance(2, 0.6f));
                }
                g2d.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                double ratio = this.getScalingRatio();
                this.getTranslation(translation);
                g2d.translate(translation.x, translation.y);
                AffineTransform preScaleTransform = g2d.getTransform();
                g2d.scale(ratio, ratio);
                g.drawImage(imageToDraw, 0, 0, null);
                g2d.setTransform(preScaleTransform);
            }
            finally {
                g2d.setTransform(oldTransform);
                g2d.setComposite(oldComposite);
            }
        }
        this.drawRelativeInformation(g2d, 0, 0);
    }

    protected void drawRelativeInformation(Graphics2D g2d, int xoffset, int yoffset) {
    }

    private void getTranslation(Point pt) {
        double ratio = this.getScalingRatio();
        BufferedImage imageToDraw = this.getImageToDraw();
        if (imageToDraw == null) {
            return;
        }
        Dimension viewportSize = this.scrollPane.getViewport().getSize();
        double scaledImageWidth = ratio * (double)imageToDraw.getWidth();
        double scaledImageHeight = ratio * (double)imageToDraw.getHeight();
        if ((double)viewportSize.width > scaledImageWidth) {
            pt.x = (int)Math.max(((double)viewportSize.width - scaledImageWidth) / 2.0, 0.0);
        }
        if ((double)viewportSize.height > scaledImageHeight) {
            pt.y = (int)Math.max(((double)viewportSize.height - scaledImageHeight) / 2.0, 0.0);
        }
        pt.y = (int)((double)pt.y + this.yOffsetForScrollbar / 2.0);
    }

    public Point scaledToOriginal(Point point) {
        Point translation = new Point();
        this.getTranslation(translation);
        point.x -= translation.x;
        point.y -= translation.y;
        double ratio = this.getScalingRatio();
        point.x = (int)((double)point.x / ratio);
        point.y = (int)((double)point.y / ratio);
        if (this.cropArea != null) {
            point.x += this.cropArea.x;
            point.y += this.cropArea.y;
        }
        this.originalToScaled(new Point(point));
        return point;
    }

    public Point originalToScaled(Point point) {
        if (this.cropArea != null) {
            point.x -= this.cropArea.x;
            point.y -= this.cropArea.y;
        }
        double ratio = this.getScalingRatio();
        point.x = (int)((double)point.x * ratio);
        point.y = (int)((double)point.y * ratio);
        Point translation = new Point();
        this.getTranslation(translation);
        point.x += translation.x;
        point.y += translation.y;
        return point;
    }

    public Rectangle originalToScaled(Rectangle r) {
        Point origin = r.getLocation();
        Point extent = new Point(origin.x + r.width, origin.y + r.height);
        this.originalToScaled(origin);
        this.originalToScaled(extent);
        r.setLocation(origin);
        r.setSize(extent.x - origin.x, extent.y - origin.y);
        return r;
    }

    public Rectangle scaledToOriginal(Rectangle r) {
        Point origin = r.getLocation();
        Point extent = new Point(origin.x + r.width, origin.y + r.height);
        this.scaledToOriginal(origin);
        this.scaledToOriginal(extent);
        r.setLocation(origin);
        r.setSize(extent.x - origin.x, extent.y - origin.y);
        return r;
    }

    public Rectangle restrictToImageOrCropArea(Rectangle area) {
        if (this.image == null) {
            return area;
        }
        if (this.cropArea == null) {
            return new Rectangle(0, 0, this.image.getWidth(), this.image.getHeight()).intersection(area);
        }
        return this.cropArea.intersection(area);
    }

    public void setImage(BufferedImage image) {
        this.image = image;
        if (image != null) {
            image.setAccelerationPriority(1.0f);
        }
    }

    @Override
    public void setBackground(Color c) {
        super.setBackground(c);
        if (this.scrollPane != null) {
            this.scrollPane.getViewport().setBackground(Color.black);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        String[] example = TestTreeModel.getMachineDetails()[0];
        String screenShotImage = "/Users/gchristelis/Desktop/me.jpg";
        String name = example[0];
        BufferedImage test = ImageIO.read(new File(screenShotImage));
        BufferedImage bigScreen = new BufferedImage(test.getWidth(), test.getHeight(), 2);
        Graphics2D g2d = bigScreen.createGraphics();
        try {
            g2d.drawImage((Image)test, 0, 0, null);
        }
        finally {
            g2d.dispose();
        }
        SimpleHelpFrame frame = SimpleHelpFrame.getTestFrame();
        JScrollPane pane = new JScrollPane();
        final FasterScaledImagePanel imagePanel = new FasterScaledImagePanel(pane);
        imagePanel.setImage(bigScreen);
        imagePanel.setBackground(Color.black);
        imagePanel.setScaleMode(1);
        imagePanel.setFixedScalingFactor(2.0);
        pane.setViewportView(imagePanel);
        imagePanel.addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                System.out.println("Source:" + e.getPoint() + " -> " + imagePanel.scaledToOriginal(e.getPoint()));
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        JPanel allContent = new JPanel(new BorderLayout());
        allContent.add((Component)pane, "Center");
        final JSlider slider = new JSlider(50, 150, 100);
        slider.setMinorTickSpacing(1);
        slider.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                double d = slider.getValue();
                imagePanel.setCustomScaleMode(d /= 100.0);
            }
        });
        allContent.add((Component)slider, "South");
        final JToggleButton crop = new JToggleButton("Crop");
        crop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (crop.isSelected()) {
                    imagePanel.setCropArea(new Rectangle(800, 200, 500, 500));
                } else {
                    imagePanel.setCropArea(null);
                }
            }
        });
        allContent.add((Component)crop, "East");
        frame.getContentPane().add(allContent);
        frame.setVisible(true);
    }

    private BufferedImage getImageToDraw() {
        if (this.subImage != null) {
            return this.subImage;
        }
        if (this.cropArea != null) {
            return this.image.getSubimage(this.cropArea.x, this.cropArea.y, this.cropArea.width, this.cropArea.height);
        }
        return this.image;
    }

    public void setFixedScalingFactor(double fixedScalingFactor) {
        this.fixedScalingFactor = fixedScalingFactor;
    }

    public void cleanupNow() {
        this.image = null;
        this.subImage = null;
    }
}

