/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.client.controller;

import com.aem.CentralDebugging;
import com.aem.sdesktop.client.controller.Controller;
import com.aem.sdesktop.interfaces.ClientUserInterface;
import com.aem.sdesktop.interfaces.GC;
import com.aem.sdesktop.interfaces.MSG;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import utils.message.Message;
import utils.message.MessageReader;
import utils.message.MessageWriter;

public class TerminalController
extends Thread
implements GC,
MSG {
    Controller controller;
    ClientUserInterface gui;
    MessageReader min;
    MessageWriter mout;
    InputStream in;
    OutputStream out;

    public TerminalController(Controller controller, ClientUserInterface gui, MessageReader min, MessageWriter mout) {
        super("TerminalController");
        System.out.println("[TerminalController] Initialising terminal controller");
        this.controller = controller;
        this.gui = gui;
        this.min = min;
        this.mout = mout;
        this.start();
    }

    @Override
    public void run() {
        System.out.println("[TerminalController] Starting...");
        Message m = null;
        try {
            while (true) {
                m = this.min.read();
                this.handleMessage(m);
            }
        }
        catch (IOException e) {
            if (CentralDebugging.PRINT_STACK_ON_CONNECTION_FAIL) {
                System.out.println("(Terminal Controller) LAST MESSAGE:" + m);
                e.printStackTrace();
            } else {
                System.out.println("[TerminalController] " + e);
                System.out.println("(Terminal Controller) LAST MESSAGE:" + m);
            }
        }
        catch (Throwable e) {
            System.out.println("(Terminal Controller) LAST MESSAGE:" + m);
            e.printStackTrace();
        }
    }

    public void handleMessage(Message m) {
        int type = m.getType();
        System.out.println("[TerminalController] Received " + m);
        if (type == 655363) {
            byte[] dat = (byte[])m.get(0);
            try {
                this.gui.receivedTerminalOutput(dat);
            }
            catch (Throwable t) {
                System.out.println("[TerminalController] Received an unexpected error");
                t.printStackTrace();
            }
        } else {
            System.out.println("[TerminalController] Unrecognised terminal server message " + m);
        }
    }

    public void sendTerminalControl(byte[] dat) {
        this.sendTerminalControl(dat, 0, dat.length);
    }

    public void sendTerminalControl(char dat) {
        this.sendTerminalControl(new byte[]{(byte)dat});
    }

    public void setWinSize(int columns, int rows) {
        System.out.println("[TerminalController] Sending size c:" + columns + " x r:" + rows);
        Message m = new Message(655364);
        m.append(columns);
        m.append(rows);
        try {
            this.mout.write(m);
        }
        catch (Exception x) {
            System.out.println("[TerminalController] Unable to send win size: " + x);
        }
    }

    public void sendTerminalControl(byte[] dat, int offset, int length) {
        System.out.println("[TerminalController] Sending " + length + " control characters.");
        Message m = new Message(655362);
        m.append(dat, offset, length);
        try {
            this.mout.write(m);
        }
        catch (Exception x) {
            System.out.println("[TerminalController] Unable to send control data: " + x);
        }
    }
}

