/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdesktop.client.controller;

import com.aem.sdesktop.interfaces.ClientController;
import com.aem.sdesktop.interfaces.ClientUserInterface;
import com.aem.sdesktop.interfaces.GC;
import com.aem.sdesktop.interfaces.MSG;
import com.aem.sdesktop.server.controller.ImmediateFileTransferListener;
import com.aem.sdesktop.util.ClipboardUtil;
import com.aem.sdesktop.util.FTPUtil;
import com.aem.sdesktop.util.FTPUtilServer;
import com.aem.sdesktop.util.FileEntry;
import com.aem.utils.ObjectBuffer;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import utils.files.PathUtil;
import utils.files.RemoteFile;
import utils.message.Message;
import utils.message.MessageReader;
import utils.message.MessageWriter;
import utils.progtools.Cleanable;
import utils.swing.components.path.elements.FTPVolume;

public class FTPController
extends Thread
implements GC,
MSG {
    private final ClientController con;
    private final ClientUserInterface gui;
    private final MessageReader min;
    private final MessageWriter mout;
    private final MessageReader get_in;
    private final MessageWriter get_out;
    private final MessageReader put_in;
    private final MessageWriter put_out;
    private final MessageReader crc_serv_in;
    private final MessageWriter crc_serv_out;
    private final MessageReader crc_client_in;
    private final MessageWriter crc_client_out;
    private final FTPUtilServer utilserver;
    private final Object tlock = new Object();
    private int FTP_VERSION = -1;
    private boolean terminated = false;
    private final long maxFileTransferSize;
    private Getter getter;
    private Putter putter;
    private Error permission = null;
    private String tempdir = null;
    private String homedir = null;
    private FTPVolume[] volumes = null;
    private String sep = null;
    private final ObjectBuffer puts = new ObjectBuffer();
    private final ObjectBuffer gets = new ObjectBuffer();
    private final boolean[] put_cancel = new boolean[]{false};

    public void terminate() {
        this.terminated = true;
        try {
            this.gets.setError(new IOException("closed"));
            this.getter.interrupt();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            this.puts.setError(new IOException("closed"));
            this.putter.interrupt();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private int getEncodedVersion(double maj, double min) {
        return (int)(maj * 100000.0 + min * 100.0);
    }

    public void log(String msg, String details) {
    }

    public FTPController(ClientController con, ClientUserInterface gui, MessageReader min, MessageWriter mout, MessageReader get_in, MessageWriter get_out, MessageReader put_in, MessageWriter put_out, MessageReader crc_c_in, MessageWriter crc_c_out, MessageReader crc_s_in, MessageWriter crc_s_out, long maxFileTransferSize) {
        this.con = con;
        this.gui = gui;
        this.min = min;
        this.mout = mout;
        this.get_in = get_in;
        this.get_out = get_out;
        this.put_in = put_in;
        this.put_out = put_out;
        this.crc_serv_in = crc_s_in;
        this.crc_serv_out = crc_s_out;
        this.crc_client_in = crc_c_in;
        this.crc_client_out = crc_c_out;
        this.maxFileTransferSize = maxFileTransferSize;
        this.utilserver = new FTPUtilServer(this.crc_serv_in, this.crc_serv_out, this.crc_client_in, this.crc_client_out);
    }

    private void checkPermission() {
        if (this.permission != null) {
            try {
                this.gui.setTopLeftGreyOverlay("FILE_TRANSFERS_NOT_ALLOWED", 10000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw this.permission;
        }
    }

    @Override
    public void run() {
        this.getter = new Getter();
        this.getter.start();
        this.putter = new Putter();
        this.putter.start();
        this.getFTPVersion();
    }

    private int getFTPVersion() {
        if (this.FTP_VERSION == -1) {
            try {
                Message m = new Message(458774);
                m = this.doTransaction(m);
                if (m.getType() == -437977088) {
                    this.permission = new Error("File transfers not allowed");
                    this.checkPermission();
                }
                if (m.getType() == 458775) {
                    double maj = ((Number)m.get(0)).doubleValue();
                    double min = ((Number)m.get(1)).doubleValue();
                    this.FTP_VERSION = this.getEncodedVersion(maj, min);
                } else {
                    this.FTP_VERSION = this.getEncodedVersion(2.0, 1.0);
                }
            }
            catch (Exception e) {
                this.FTP_VERSION = 200100;
            }
            System.out.println("[FTPController] FTP Server version is " + this.FTP_VERSION);
        }
        return this.FTP_VERSION;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Message doTransaction(Message m) throws IOException {
        this.checkPermission();
        Object object = this.tlock;
        synchronized (object) {
            this.mout.write(m);
            return this.min.read();
        }
    }

    public void renameLocalFile(String ldir, String oldname, String newname) {
        new File(ldir + File.separatorChar + oldname).renameTo(new File(ldir + File.separatorChar + newname));
    }

    public void renameRemoteFile(String rdir, String oldname, String newname) {
        Message m = new Message(458788);
        m.append(rdir);
        m.append(oldname);
        m.append(newname);
        try {
            m = this.doTransaction(m);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void newLocalFolder(String ldir, String folder) {
        new File(ldir + File.separatorChar + folder).mkdirs();
    }

    public void newRemoteFolder(String rdir, String folder) {
        Message m = new Message(458787);
        m.append(rdir);
        m.append(folder);
        try {
            m = this.doTransaction(m);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public boolean deleteLocalFile(String dir, String file) {
        this.checkPermission();
        File f = new File(dir + File.separatorChar + file);
        return FTPUtil.deleteFiles(f);
    }

    public boolean deleteRemoteFile(String dir, String file) {
        this.checkPermission();
        if (this.getFTPVersion() < 200200) {
            return false;
        }
        Message m = new Message(458772);
        m.append(dir);
        m.append(file);
        try {
            m = this.doTransaction(m);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public int getRemoteCRC(String dir, String file, long start, long length) {
        this.checkPermission();
        Message m = new Message(458771);
        m.append(dir);
        m.append(file);
        m.append(start);
        m.append(length);
        try {
            m = this.doTransaction(m);
            return (Integer)m.get(0);
        }
        catch (IOException e) {
            return -1;
        }
    }

    private void getRemoteTempAndHomeDir() throws IOException {
        Message m = new Message(458784);
        m = this.doTransaction(m);
        this.tempdir = m.getNextString();
        this.homedir = m.getNextString();
    }

    public String getRemoteTempDir() {
        this.checkPermission();
        if (this.tempdir != null) {
            return this.tempdir;
        }
        try {
            this.getRemoteTempAndHomeDir();
            return this.tempdir;
        }
        catch (IOException e) {
            return "./";
        }
    }

    public String getRemoteEnv(String name) {
        this.checkPermission();
        Message m = new Message(458801);
        m.append(name);
        try {
            m = this.doTransaction(m);
            return m.getNextString();
        }
        catch (IOException e) {
            return null;
        }
    }

    public String getRemoteHomeDir() {
        this.checkPermission();
        if (this.homedir != null) {
            return this.homedir;
        }
        try {
            this.getRemoteTempAndHomeDir();
            return this.homedir;
        }
        catch (IOException e) {
            return "./";
        }
    }

    public String[] getRemoteClipboardFiles() {
        this.checkPermission();
        Message m = new Message(458786);
        try {
            m = this.doTransaction(m);
            String[] files = new String[m.length()];
            for (int i = 0; i < files.length; ++i) {
                files[i] = (String)m.get(i);
            }
            return files;
        }
        catch (IOException e) {
            return new String[0];
        }
    }

    public FTPVolume[] getRemoteVolumes() {
        this.checkPermission();
        if (this.volumes != null) {
            return this.volumes;
        }
        Message m = new Message(458753);
        try {
            System.out.println("[FTPController] Querying for remote volumes...");
            m = this.doTransaction(m);
            int count = m.length() / 4;
            this.volumes = new FTPVolume[count];
            for (int i = 0; i < count; ++i) {
                this.volumes[i] = new FTPVolume(m.getNextString(), m.getNextString(), m.getNextBoolean(), m.getNextBoolean());
                this.volumes[i].name = PathUtil.makePathNonWindows((String)this.volumes[i].name);
                this.volumes[i].path = PathUtil.makePathNonWindows((String)this.volumes[i].path);
            }
            return this.volumes;
        }
        catch (IOException e) {
            e.printStackTrace();
            return new FTPVolume[]{new FTPVolume("/")};
        }
    }

    public String getRemoteSeparator() {
        this.checkPermission();
        if (this.sep != null) {
            return this.sep;
        }
        Message m = new Message(458754);
        try {
            m = this.doTransaction(m);
            this.sep = (String)m.get(0);
            return this.sep;
        }
        catch (IOException e) {
            return "/";
        }
    }

    public long getFileSize(String path) {
        Message m = new Message(458791);
        m.append(path);
        try {
            m = this.doTransaction(m);
            return (Long)m.get(0);
        }
        catch (IOException e) {
            return -1L;
        }
    }

    public FileEntry[] getRemoteDir(RemoteFile dir) {
        this.checkPermission();
        Message m = new Message(458755);
        m.append(dir.getRemotePath());
        try {
            m = this.doTransaction(m);
            FileEntry[] files = new FileEntry[m.length()];
            for (int i = 0; i < files.length; ++i) {
                if (m.get(i) instanceof String) {
                    String name = (String)m.get(i);
                    if (name.toLowerCase().startsWith("|D:|")) {
                        String dirname = name.substring(4);
                        files[i] = new FileEntry(dirname, -1L, -1L, true, false, false, dir);
                        continue;
                    }
                    files[i] = new FileEntry(name, -1L, -1L, false, false, false, dir);
                    continue;
                }
                Message mm = (Message)m.get(i);
                files[i] = new FileEntry((String)mm.get(0), (Long)mm.get(1), (Long)mm.get(2), (Boolean)mm.get(3), mm.getAsBoolean(4), mm.getAsBoolean(5), dir);
                if (!files[i].folder) continue;
                files[i].size = -1L;
                if (files[i].lastmod != 0L) continue;
                files[i].lastmod = -1L;
            }
            return files;
        }
        catch (IOException e) {
            return new FileEntry[0];
        }
    }

    public int addFileGetRequestThenClip(int ID, String localdir, String remotedir, String remotefile, String[] clipfiles) {
        return this.addFileGetRequest(ID, localdir, remotedir, remotefile, clipfiles);
    }

    public int addFileGetRequest(int ID, String localdir, String remotedir, String remotefile) {
        return this.addFileGetRequest(ID, localdir, remotedir, remotefile, null);
    }

    private int addFileGetRequest(int ID, String localdir, String remotedir, String remotefile, String[] clipfiles) {
        this.checkPermission();
        Get get = new Get(ID);
        get.localdir = localdir;
        get.remotedir = remotedir;
        get.remotefile = remotefile;
        get.clipfiles = clipfiles;
        if (!this.gets.contains(get) && !this.getter.get.equals(get)) {
            System.out.println("[FTPController] File Get Request " + localdir + " <- " + remotedir + " [" + remotefile + "] added");
            this.gets.add(get);
            return get.ID;
        }
        System.out.println("[FTPController] File Get Request " + localdir + " <- " + remotedir + " [" + remotefile + "] ignored");
        return -1;
    }

    public int addFilePutRequestThenPaste(int ID, String localdir, String remotedir, String localfile, String[] clipboardfiles) {
        return this.addFilePutRequest(ID, localdir, remotedir, localfile, true, clipboardfiles);
    }

    public int addFilePutRequestThenClip(int ID, String localdir, String remotedir, String localfile, String[] clipboardfiles) {
        return this.addFilePutRequest(ID, localdir, remotedir, localfile, false, clipboardfiles);
    }

    public int addFilePutRequest(int ID, String localdir, String remotedir, String localfile) {
        return this.addFilePutRequest(ID, localdir, remotedir, localfile, false, null);
    }

    private int addFilePutRequest(int ID, String localdir, String remotedir, String localfile, boolean paste, String[] clipboardfiles) {
        this.checkPermission();
        Put put = new Put(ID);
        put.localdir = localdir;
        put.remotedir = remotedir;
        put.localfile = localfile;
        put.thenpaste = paste;
        put.clipboardfiles = clipboardfiles;
        if (!this.puts.contains(put) && !this.putter.put.equals(put)) {
            System.out.println("[FTPController] File Put Request " + localdir + " [" + localfile + "] -> " + remotedir + " added");
            this.puts.add(put);
            return put.ID;
        }
        System.out.println("[FTPController] File Put Request " + localdir + " [" + localfile + "] -> " + remotedir + " ignored");
        return -1;
    }

    public void cancelPut(int jobID) {
        System.out.println("[FTPController] Request to cancel put " + jobID);
        this.checkPermission();
        System.out.println("[FTPController] Ready to cancel put " + jobID);
        this.puts.remove(new PutIdObject(jobID));
        System.out.println("[FTPController] " + this.putter.put.ID + " vs " + jobID);
        if (this.putter.put.ID == jobID) {
            System.out.println("[FTPController] Cancelling current put " + jobID);
            this.put_cancel[0] = true;
        }
    }

    public void cancelGet(int jobID) {
        System.out.println("[FTPController] Request to cancel get " + jobID);
        this.checkPermission();
        System.out.println("[FTPController] Ready to cancel get " + jobID);
        this.gets.remove(new PutIdObject(jobID));
        System.out.println("[FTPController] " + this.getter.get.ID + " vs " + jobID);
        if (this.getter.get.ID == jobID) {
            System.out.println("[FTPController] Cancelling current get " + jobID);
            new DownloadCanceler().start();
        }
    }

    public void doImmediateFileGet(String remotedir, String remotefile, ImmediateFileTransferListener listener) throws IOException {
        Message m = new Message(458790);
        m.append("");
        m.append(remotedir);
        m.append(remotefile);
        this.get_out.write(m);
        FTPUtil.receiveFile(999999, this.get_in, this.gui, listener);
    }

    public void ftpJobFinished(int id) {
        if (!this.puts.hasNext()) {
            this.gui.updateFTPProgress(id, true, null, null, 0L, 0L, 0L);
        }
        this.gui.updateFTPJobFinished(id);
    }

    class Putter
    extends Thread
    implements Cleanable {
        Put put;

        Putter() {
            this.put = new Put(-1);
        }

        @Override
        public void run() {
            try {
                while (!FTPController.this.terminated) {
                    int i;
                    Message m;
                    this.put = new Put(-1);
                    this.put = (Put)FTPController.this.puts.next();
                    if (FTPController.this.getFTPVersion() < 200200) {
                        FTPUtil.putFile(this.put.ID, FTPController.this.getFTPVersion(), null, FTPController.this.put_out, this.put.localdir, this.put.remotedir, this.put.localfile, FTPController.this.put_cancel, FTPController.this.gui, FTPController.this.maxFileTransferSize);
                    } else {
                        FTPUtil.putFile(this.put.ID, FTPController.this.getFTPVersion(), FTPController.this.utilserver, FTPController.this.put_out, this.put.localdir, this.put.remotedir, this.put.localfile, FTPController.this.put_cancel, FTPController.this.gui, FTPController.this.maxFileTransferSize);
                    }
                    ((FTPController)FTPController.this).put_cancel[0] = false;
                    if (this.put.thenpaste) {
                        m = new Message(458777);
                        for (i = 0; i < this.put.clipboardfiles.length; ++i) {
                            m.append(this.put.clipboardfiles[i]);
                        }
                        FTPController.this.put_out.write(m);
                    } else if (this.put.clipboardfiles != null) {
                        m = new Message(458785);
                        for (i = 0; i < this.put.clipboardfiles.length; ++i) {
                            m.append(this.put.clipboardfiles[i]);
                        }
                        FTPController.this.put_out.write(m);
                    }
                    m = new Message(458792);
                    m.append(this.put.ID);
                    FTPController.this.put_out.write(m);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }

        public void cleanupNow() {
            FTPController.this.terminated = true;
            FTPController.this.puts.setError(new IOException("Cleanable request"));
        }
    }

    class Getter
    extends Thread
    implements Cleanable {
        Get get;

        Getter() {
            this.get = new Get(-1);
        }

        @Override
        public void run() {
            try {
                while (!FTPController.this.terminated) {
                    this.get = new Get(-1);
                    this.get = (Get)FTPController.this.gets.next();
                    Message m = new Message(458769);
                    m.append(this.get.localdir);
                    m.append(this.get.remotedir);
                    m.append(this.get.remotefile);
                    FTPController.this.get_out.write(m);
                    FTPUtil.receiveFile(this.get.ID, FTPController.this.get_in, FTPController.this.gui);
                    try {
                        if (this.get.clipfiles != null) {
                            ArrayList<File> files = new ArrayList<File>();
                            for (int i = 0; i < this.get.clipfiles.length; ++i) {
                                files.add(new File(this.get.clipfiles[i]));
                            }
                            ClipboardUtil.setClipboardAsFiles(files);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (!FTPController.this.gets.hasNext()) {
                        FTPController.this.gui.updateFTPProgress(this.get.ID, false, null, null, 0L, 0L, 0L);
                    }
                    FTPController.this.gui.updateFTPJobFinished(this.get.ID);
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }

        public void cleanupNow() {
            FTPController.this.terminated = true;
            FTPController.this.gets.setError(new IOException("Cleanable request"));
        }
    }

    private class DownloadCanceler
    extends Thread {
        private DownloadCanceler() {
        }

        @Override
        public void run() {
            try {
                Message m = new Message(458770);
                Message message = FTPController.this.doTransaction(m);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private class PutIdObject {
        final int ID;

        public PutIdObject(int ID) {
            this.ID = ID;
        }

        public boolean equals(Object o) {
            if (o instanceof Put) {
                Put put = (Put)o;
                return this.ID == put.ID;
            }
            Get put = (Get)o;
            return this.ID == put.ID;
        }
    }

    class Put {
        final int ID;
        String localdir;
        String remotedir;
        String localfile;
        boolean thenpaste = false;
        String[] clipboardfiles;

        public Put(int ID) {
            this.ID = ID;
        }

        public boolean equals(Object o) {
            if (o instanceof Put) {
                return this.equals((Put)o);
            }
            return super.equals(o);
        }

        public boolean equals(Put p) {
            return this.toString().equals(p.toString());
        }

        public String toString() {
            return "File Put Request " + this.localdir + " [" + this.localfile + "] -> " + this.remotedir;
        }
    }

    class Get {
        final int ID;
        String localdir;
        String remotedir;
        String remotefile;
        String[] clipfiles;

        public Get(int ID) {
            this.ID = ID;
        }

        public boolean equals(Object o) {
            if (o instanceof Get) {
                return this.equals((Get)o);
            }
            return super.equals(o);
        }

        public boolean equals(Get g) {
            return this.toString().equals(g.toString());
        }

        public String toString() {
            return "File Get Request " + this.localdir + " <- " + this.remotedir + " [" + this.remotefile + "]";
        }
    }
}

