/*
 * Decompiled with CFR 0.152.
 */
package com.aem.sdemo.ui;

import com.aem.nodelink.NodeLink;
import com.aem.nodelink.NodeLinkStatusListener;
import com.aem.sdemo.AttendeeInfo;
import com.aem.sdemo.ProxiedClientController;
import com.aem.sdemo.ui.DemoConfigPanel;
import com.aem.sdemo.ui.DemoURLPanel;
import com.aem.sdesktop.client.gui.SimpleTunePanel;
import com.aem.sdesktop.client.gui.TuneDialog;
import com.aem.sdesktop.server.gui.ConnectionSettings;
import com.aem.sdesktop.util.DualNodeLinkStatus;
import com.aem.shelp.common.CommonHelpUtil;
import com.aem.shelp.common.Language;
import com.aem.shelp.proxy.techclient.TechClient;
import com.aem.shelp.proxy.types.Customer;
import com.aem.shelp.util.swing.ShPopupMenuButton;
import com.jw.SHJWUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import utils.progtools.OnDemandThreadPool;
import utils.swing.components.RoundBorderPanel;
import utils.swing.components.SHJTable;
import utils.swing.customlaf.SHBorderFactory;
import utils.swing.customlaf.SHStyle;
import utils.swing.customlaf.ScaledInsets;
import utils.swing.customlaf.SimpleHelpLookAndFeel;
import utils.swing.images.ImageLoader;
import utils.swing.layout.GbPanel;
import utils.swing.simplelist.SimpleList;
import utils.swing.simplelist.jtable.SimpleTableModel;
import utils.swing.simplelist.jtable.TableStructure;
import utils.swing.simplelist.wrapper.SortWrapper;
import utils.switches.Switches;

public class DemoRunningPanel
extends JPanel
implements ActionListener,
NodeLinkStatusListener {
    private DemoHelpUtil util;
    private TechClient client;
    private ProxiedClientController con;
    private String demoName;
    private String demoPass;
    private String demoDesc;
    private boolean secure;
    private boolean isPrivate;
    private boolean acceptDetails;
    private Icon startScreenSharingIcon = ImageLoader.getImageIcon((String)"O[images/svg/technology/screen.svg,24 | images/svg/av/play.svg,16]");
    private Icon stopScreenSharingIcon = ImageLoader.getImageIcon((String)"O[images/svg/technology/screen.svg,24 | images/svg/av/stop.svg,16]");
    private GbPanel main = new GbPanel();
    private JLabel starting;
    private JButton tune;
    private JButton terminate;
    private JButton updatesOff;
    private ShPopupMenuButton updatesOn;
    private NodeLinkStatusListener listener;
    private RootPaneContainer rpc;
    private PollerThread pollerThread = null;
    private SimpleList<AttendeeInfo> attendeeList;
    private JTable attendeeTable;
    private JLabel updatesLabel;
    private String updatesStartText;
    private String updatesStopText;
    private DemoURLPanel demoUrlPanel;
    private DemoConfigPanel demoConfigPanel;
    private SimpleTunePanel detailsPanel;
    private OnDemandThreadPool threadPool;
    private TableModelListener headerChangeListener = new TableModelListener(){

        @Override
        public void tableChanged(TableModelEvent e) {
            String title = DemoRunningPanel.this.client.getAttendeeLimit() == Integer.MAX_VALUE ? Language.get("ATTENDEE_TABLE_NAME") + " (" + Integer.toString(DemoRunningPanel.this.attendeeList.size()) + ")" : Language.get("ATTENDEE_TABLE_NAME") + " (" + Integer.toString(DemoRunningPanel.this.attendeeList.size()) + " / " + DemoRunningPanel.this.client.getAttendeeLimit() + ")";
            DemoRunningPanel.this.attendeeTable.getColumnModel().getColumn(0).setHeaderValue(title);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DemoRunningPanel.this.attendeeTable.getTableHeader().repaint();
                }
            });
        }
    };

    public DemoRunningPanel(DemoConfigPanel demoConfigPanel, RootPaneContainer rpc, TechClient client, String name, String desc, String pass, boolean secure, boolean acceptDetails, boolean isPrivate, NodeLinkStatusListener listener) {
        this.demoConfigPanel = demoConfigPanel;
        this.threadPool = demoConfigPanel.getDemoThreadPool();
        this.rpc = rpc;
        this.client = client;
        this.demoName = name;
        this.demoPass = pass;
        this.demoDesc = desc;
        this.secure = secure;
        this.isPrivate = isPrivate;
        this.acceptDetails = acceptDetails;
        this.listener = listener;
        this.con = new ProxiedClientController(client, this.demoName);
        this.updatesStartText = Language.get("PRESENTATION_SHARE_SCREEN");
        this.updatesStopText = Language.get("PRESENTATION_NOSHARE_SCREEN");
        if (this.demoPass == null) {
            this.demoPass = "";
        }
        this.setLayout(new BorderLayout());
        this.add("Center", (Component)this.main);
        this.starting = new JLabel(Language.get("PLEASE_WAIT_PRESENTATION"), ImageLoader.getImageIcon((String)"images/svg/general/world.svg,24"), 0);
        this.main.add((Component)this.starting, 0, 0, 1, 1, 100, 100, 18, 0);
        System.out.println("[SDemo] creating new Demo connector");
        this.util = new DemoHelpUtil(rpc, client);
        try {
            System.out.println("[SDemo] initing Demo session");
            this.util.loadTranslations();
            System.out.println("[SDemo] launching Demo session");
            new Connect().start();
        }
        catch (Exception x) {
            System.out.println("[SDemo] Demo session failed to launch:");
            x.printStackTrace();
        }
    }

    private void initToDemoSession() {
        this.main.removeAll();
        this.updatesLabel = new JLabel(this.updatesStartText);
        JLabel tuneLabel = new JLabel(Language.get("PRESENTATION_TUNE_DESC"));
        JLabel terminateLabel = new JLabel(Language.get("PRESENTATION_END_DESC"));
        this.demoUrlPanel = new DemoURLPanel(this.secure);
        this.demoUrlPanel.setTechClient(this.client);
        this.demoUrlPanel.updateDemoURL(this.demoName);
        if (this.updatesOff == null) {
            this.updatesOn = new ShPopupMenuButton(Language.get("STOP_SHARE_SCREEN"), this.startScreenSharingIcon){

                @Override
                public JPopupMenu getPopupMenu() {
                    return DemoRunningPanel.this.getUpdatesMenu();
                }
            };
            Dimension dim = this.updatesOn.getPreferredSize();
            this.updatesOn.setPreferredSize(dim);
            this.updatesOn.setMinimumSize(dim);
            this.updatesOn.setMaximumSize(dim);
            this.updatesOn.addActionListener(this);
            this.updatesOn.setText(Language.get("SHARE_SCREEN"));
            this.updatesOn.setHorizontalAlignment(2);
            this.updatesOn.setEnabled(false);
            new DelayedEnableThread().start();
            this.updatesOff = new JButton(Language.get("STOP_SHARE_SCREEN"), this.stopScreenSharingIcon);
            this.updatesOff.setPreferredSize(dim);
            this.updatesOff.setMinimumSize(dim);
            this.updatesOff.setMaximumSize(dim);
            this.updatesOff.addActionListener(this);
            this.updatesOff.setHorizontalAlignment(2);
            this.updatesOff.setVisible(false);
            this.tune = new JButton(Language.get("CONNECTION_SETTINGS"), ImageLoader.getImageIcon((String)"images/svg/computing/sliders.svg,24"));
            this.tune.addActionListener(this);
            this.tune.setHorizontalAlignment(2);
            this.terminate = new JButton(Language.get("STOP_PRESENTATION"), ImageLoader.getImageIcon((String)"images/svg/general/remove.svg,24"));
            this.terminate.addActionListener(this);
            this.terminate.setHorizontalAlignment(2);
        }
        JLabel demoLabel = new JLabel(this.demoName, 0);
        demoLabel.setFont(this.getFont().deriveFont(SimpleHelpLookAndFeel.scale((float)24.0f)));
        JLabel presentationActive = new JLabel(Language.get("PRESENTATION_ACTIVE"), 0);
        JPanel paddy = new JPanel();
        GbPanel optionsPanel = new GbPanel(new ScaledInsets(2, 2, 2, 2));
        int Y = 0;
        optionsPanel.add((Component)demoLabel, 0, Y++, 1, 1, 1, 1, 17, 2);
        optionsPanel.add((Component)presentationActive, 0, Y++, 1, 1, 1, 1, 17, 2);
        optionsPanel.add((Component)this.demoUrlPanel.getRootComponent(), 0, Y++, 1, 1, 1, 1, 17, 2, (Insets)new ScaledInsets(20, 0, 0, 0));
        RoundBorderPanel buttonsPanel = new RoundBorderPanel();
        GridBagLayout gbl = new GridBagLayout();
        buttonsPanel.setLayout(gbl);
        gbl.setConstraints((Component)((Object)this.updatesOn), new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 2, (Insets)new ScaledInsets(0, 20, 0, 10), 0, 0));
        gbl.setConstraints(this.updatesOff, new GridBagConstraints(0, 0, 1, 1, 0.0, 1.0, 10, 2, (Insets)new ScaledInsets(0, 20, 0, 10), 0, 0));
        gbl.setConstraints(this.updatesLabel, new GridBagConstraints(1, 0, 1, 1, 100.0, 100.0, 10, 2, (Insets)new ScaledInsets(0, 0, 0, 10), 0, 0));
        if (Switches.SH_updatedConnectionTuning) {
            this.detailsPanel = new SimpleTunePanel(this.con, null, true);
            gbl.setConstraints((Component)((Object)this.detailsPanel), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 2, (Insets)new ScaledInsets(5, 20, 0, 10), 0, 0));
        } else {
            gbl.setConstraints(this.tune, new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 10, 2, (Insets)new ScaledInsets(5, 20, 0, 10), 0, 0));
            gbl.setConstraints(tuneLabel, new GridBagConstraints(1, 1, 1, 1, 100.0, 100.0, 10, 2, (Insets)new ScaledInsets(5, 0, 0, 10), 0, 0));
        }
        gbl.setConstraints(this.terminate, new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 2, (Insets)new ScaledInsets(20, 20, 0, 10), 0, 0));
        gbl.setConstraints(terminateLabel, new GridBagConstraints(1, 2, 1, 1, 100.0, 100.0, 10, 2, (Insets)new ScaledInsets(20, 0, 0, 10), 0, 0));
        buttonsPanel.add((Component)((Object)this.updatesOn));
        buttonsPanel.add(this.updatesOff);
        buttonsPanel.add(this.updatesLabel);
        if (Switches.SH_updatedConnectionTuning) {
            buttonsPanel.add((Component)((Object)this.detailsPanel));
        } else {
            buttonsPanel.add(this.tune);
            buttonsPanel.add(tuneLabel);
        }
        buttonsPanel.add(this.terminate);
        buttonsPanel.add(terminateLabel);
        optionsPanel.add((Component)buttonsPanel, 0, Y++, 1, 1, 1, 1, 17, 2);
        optionsPanel.add((Component)paddy, 0, Y++, 1, 1, 1, 1000, 17, 1);
        String title = this.client.getAttendeeLimit() == Integer.MAX_VALUE ? Language.get("ATTENDEE_TABLE_NAME") + " (0)" : Language.get("ATTENDEE_TABLE_NAME") + " (0 / " + this.client.getAttendeeLimit() + ")";
        TableStructure ts = TableStructure.createTableStructure(AttendeeInfo.class, new String[]{"name"}, new String[]{title});
        this.attendeeList = new SimpleList();
        SortWrapper<AttendeeInfo> sortedAttendeeList = new SortWrapper<AttendeeInfo>(this.attendeeList, SortWrapper.LEXICAL_COMPARATOR_IGNORE_CASE);
        SimpleTableModel slm = new SimpleTableModel(sortedAttendeeList, ts);
        this.attendeeTable = new SHJTable(0, ts.getColumnCount());
        slm.addTableModelListener(this.headerChangeListener);
        if (this.attendeeTable.getRowHeight() < SimpleHelpLookAndFeel.scale((int)18)) {
            this.attendeeTable.setRowHeight(SimpleHelpLookAndFeel.scale((int)22));
        }
        this.attendeeTable.setModel(slm);
        this.attendeeTable.setSelectionMode(0);
        ts.initTableDimensions(this.attendeeTable);
        JScrollPane regpane = new JScrollPane(this.attendeeTable);
        regpane.setBorder(SHBorderFactory.createLineBorder((Color)SHStyle.BORDER_COLOR));
        ts.initTableDimensions(this.attendeeTable);
        GbPanel attendeesPanel = new GbPanel();
        attendeesPanel.add((Component)regpane, 0, 0, 1, 1, 1, 1, 10, 1);
        this.main.add((Component)optionsPanel, 0, 0, 1, 1, 10, 0, 17, 1);
        this.main.add((Component)attendeesPanel, 1, 0, 1, 1, 100, 10, 10, 1);
        this.invalidate();
        this.revalidate();
        this.repaint();
        this.pollerThread = new PollerThread();
        this.pollerThread.start();
    }

    private JPopupMenu getUpdatesMenu() {
        int i;
        JPopupMenu logoutMenu = new JPopupMenu();
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] gs = ge.getScreenDevices();
        int minx = 0;
        int miny = 0;
        int maxx = 0;
        int maxy = 0;
        for (i = 0; i < gs.length; ++i) {
            Rectangle bounds = gs[i].getDefaultConfiguration().getBounds();
            if (i == 0) {
                minx = bounds.x;
                miny = bounds.y;
                maxx = bounds.x + bounds.width;
                maxy = bounds.y + bounds.height;
                continue;
            }
            minx = Math.min(minx, bounds.x);
            miny = Math.min(miny, bounds.y);
            maxx = Math.max(maxx, bounds.x + bounds.width);
            maxy = Math.max(maxy, bounds.y + bounds.height);
        }
        for (i = 0; i < gs.length; ++i) {
            DisplayMode dm = gs[i].getDisplayMode();
            int screenWidth = dm.getWidth();
            int screenHeight = dm.getHeight();
            String screenName = Language.get("SCREEN") + " " + (i + 1) + ": " + screenWidth + " x " + screenHeight;
            Rectangle bounds = gs[i].getDefaultConfiguration().getBounds();
            bounds.x -= minx;
            bounds.y -= miny;
            logoutMenu.add(new ScreenAction(screenName, bounds));
        }
        return logoutMenu;
    }

    public void stopPresentation() {
        System.out.println("Stopping presentation");
        this.pollerThread.die = true;
        try {
            this.util.cleanup();
        }
        catch (Throwable t) {
            System.out.println("[DemoRunningPanel] Cleanup failed?");
            t.printStackTrace();
        }
    }

    private void switchUpdatesOn(Rectangle screenArea) {
        try {
            System.out.println("[DemoRunningPanel] Requesting specific screen area for presentation: " + screenArea);
            this.updatesLabel.setText(this.updatesStopText);
            this.con.setContinuousRequestScreen(true);
            this.con.requestScreenAsPngs(screenArea, true);
            this.updatesOn.setVisible(false);
            this.updatesOff.setVisible(true);
        }
        catch (Exception x) {
            x.printStackTrace();
        }
    }

    private void switchUpdatesOff() {
        try {
            this.con.setContinuousRequestScreen(false);
            this.updatesLabel.setText(this.updatesStartText);
            this.updatesOff.setVisible(false);
            this.updatesOn.setVisible(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object o = e.getSource();
        if (o == this.tune) {
            if (Switches.SH_updatedConnectionTuning) {
                SimpleTunePanel.showDialog(this.rpc, this.con, null);
            } else {
                TuneDialog tune_dialog = new TuneDialog(null, this.rpc, this.con, true, 0L);
                tune_dialog.setVisible(true);
                this.con.requestScreenResend();
            }
        } else if (o == this.updatesOn.getSourceButton()) {
            this.threadPool.runAsync(new Runnable(){

                @Override
                public void run() {
                    DemoRunningPanel.this.switchUpdatesOn(null);
                }
            });
        } else if (o == this.updatesOff) {
            this.threadPool.runAsync(new Runnable(){

                @Override
                public void run() {
                    DemoRunningPanel.this.switchUpdatesOff();
                }
            });
        } else if (o == this.terminate) {
            this.threadPool.runAsync(new Runnable(){

                @Override
                public void run() {
                    DemoRunningPanel.this.demoConfigPanel.endPresentation(DemoRunningPanel.this.demoName);
                }
            });
        }
    }

    @Override
    public void linkDead(NodeLink link, String reason) {
    }

    @Override
    public void linkDown(NodeLink link, Throwable reason) {
    }

    @Override
    public void linkOK(NodeLink link) {
    }

    class DemoHelpUtil
    extends CommonHelpUtil {
        String host;
        int port;
        String codebase;

        DemoHelpUtil(RootPaneContainer rpc, TechClient client) {
            super(rpc, true);
            this.host = client.getHost();
            this.port = client.getPort();
            this.codebase = SHJWUtil.getUpdateURLProtocol() + "://" + this.host + ":" + this.port + "/";
        }

        @Override
        public String getCodeBase() {
            return this.codebase;
        }

        @Override
        public String getConnectURL() {
            return null;
        }

        @Override
        public String getHost() {
            return this.host;
        }

        @Override
        public int getPort() {
            return this.port;
        }

        @Override
        public Customer getDemoCustomerType() {
            Customer customer = new Customer(2);
            customer.setDetailsKeys(new String[]{"SDemoName", "SDemoPass", "SDemoDesc", "SDemoSecure", "SDemoPrivate", "SDemoDetails"});
            customer.setDetailsValues(new String[]{DemoRunningPanel.this.demoName, DemoRunningPanel.this.demoPass, DemoRunningPanel.this.demoDesc, DemoRunningPanel.this.secure + "", DemoRunningPanel.this.isPrivate + "", DemoRunningPanel.this.acceptDetails + ""});
            return customer;
        }

        @Override
        public String getDemoName() {
            return DemoRunningPanel.this.demoName;
        }

        @Override
        public void customerConnectedNotice(ConnectionSettings cSettings) {
            DemoRunningPanel.this.initToDemoSession();
        }

        @Override
        protected DualNodeLinkStatus initStatusListener() {
            return new DualNodeLinkStatus(DemoRunningPanel.this.listener, DemoRunningPanel.this);
        }
    }

    class PollerThread
    extends Thread {
        private boolean die;

        PollerThread() {
            super("PollerThread");
            this.die = false;
        }

        @Override
        public void run() {
            while (!this.die) {
                try {
                    Thread.sleep(3000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                try {
                    AttendeeInfo[] attendeeInfoForPresentation = DemoRunningPanel.this.client.getAttendeeInfoForPresentation(DemoRunningPanel.this.demoName);
                    DemoRunningPanel.this.attendeeList.setListContents(attendeeInfoForPresentation);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    class Connect
    extends Thread {
        Connect() {
        }

        @Override
        public void run() {
            DemoRunningPanel.this.util.startCustomer();
            System.out.println("[SDemo] Demo session launched");
        }
    }

    class ScreenAction
    extends AbstractAction {
        private Rectangle screenArea;

        ScreenAction(String text, Rectangle resolution) {
            super(text);
            this.screenArea = resolution;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DemoRunningPanel.this.switchUpdatesOn(this.screenArea);
        }
    }

    class DelayedEnableThread
    extends Thread {
        DelayedEnableThread() {
        }

        @Override
        public void run() {
            try {
                Thread.sleep(3000L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DemoRunningPanel.this.updatesOn.setEnabled(true);
                }
            });
            DemoRunningPanel.this.detailsPanel.load();
        }
    }
}

