/*
 * Decompiled with CFR 0.152.
 */
package com.aem.nodelink.ui;

import com.aem.nodelink.NodeLink;
import com.aem.nodelink.NodeLinkStatusListener;
import com.aem.nodelink.ui.NodeLinkStatusPanel;
import java.awt.BorderLayout;
import java.util.ResourceBundle;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class NodeLinkStatusLabel
extends JPanel
implements NodeLinkStatusListener {
    protected NodeLinkStatusPanel panel;
    protected JLabel label = new JLabel();
    protected boolean dead = false;

    public void quit() {
        if (this.panel != null) {
            this.panel.quit = true;
        }
    }

    public NodeLinkStatusLabel() {
        this.panel = new NodeLinkStatusPanel();
        this.setLayout(new BorderLayout());
        this.add("West", this.panel);
        this.add("Center", this.label);
        this.label.setText("");
    }

    public NodeLinkStatusLabel(ResourceBundle bundle) {
        this.panel = new NodeLinkStatusPanel(bundle);
        this.setLayout(new BorderLayout());
        this.add("West", this.panel);
        this.add("Center", this.label);
        this.label.setText("");
    }

    protected void update() {
        try {
            this.label.setText("  (" + this.panel.getToolTipText() + ")");
            this.repaint();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public void linkDown(NodeLink link, Throwable reason) {
        if (this.dead) {
            return;
        }
        this.panel.linkDown(link, reason);
        this.update();
    }

    @Override
    public void linkOK(NodeLink link) {
        if (this.dead) {
            return;
        }
        this.panel.linkOK(link);
        this.update();
    }

    @Override
    public void linkDead(NodeLink link, String msg) {
        this.dead = true;
        this.panel.linkDead(link, msg);
        this.update();
    }
}

