/*
 * Decompiled with CFR 0.152.
 */
package com.aem.nodelink.http;

import com.aem.nodelink.InfiniteLoop;
import com.aem.nodelink.Robustness;
import com.aem.nodelink.http.extend.HttpRequestProcessor;
import com.aem.nodelink.http.extend.HttpServerFactory;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.util.HashMap;

public class DefaultHttpServerFactory
implements HttpServerFactory {
    private static boolean VERBOSE = false;
    Object map_LOCK = new Object();
    HashMap map = new HashMap();
    Object ports_LOCK = new Object();
    HashMap ports = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void redirectUrlRequests(URL url, HttpRequestProcessor transport) throws Exception {
        String host = url.getHost();
        int port = url.getPort();
        if (port == -1) {
            port = 80;
        }
        String res = url.getPath();
        res = this.normaliseResource(res);
        Object object = this.map_LOCK;
        synchronized (object) {
            this.map.put(res, transport);
        }
        this.ensureListeningOn(port);
    }

    private String normaliseResource(String res) {
        if (!res.startsWith("/")) {
            res = "/" + res;
        }
        if (!res.endsWith("/")) {
            res = res + "/";
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void ensureListeningOn(int port) throws Exception {
        Object object = this.ports_LOCK;
        synchronized (object) {
            String key = "" + port;
            if (this.ports.get(key) == null) {
                PortServer ps = new PortServer(port);
                ps.start();
                this.ports.put(key, ps);
            }
        }
    }

    private class ConnectionServer
    extends Thread {
        Socket sock;
        OutputStream out;
        InputStream in;
        InetAddress addr;

        public ConnectionServer(Socket sock) throws Exception {
            this.sock = sock;
            this.addr = ((InetSocketAddress)sock.getRemoteSocketAddress()).getAddress();
            this.setName("DefaultHttpServerFactory$ConnectionServer");
            this.setDaemon(true);
            this.setPriority(10);
            sock.setSoTimeout(15000);
            this.out = new BufferedOutputStream(sock.getOutputStream());
            this.in = new BufferedInputStream(sock.getInputStream());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean loop = true;
            boolean OK = false;
            InfiniteLoop il = new InfiniteLoop();
            while (loop) {
                il.LOOP();
                try {
                    String head;
                    OK = true;
                    String s = this.nextLine();
                    OK = false;
                    if (Robustness.BROKEN_UNDERLYING_CONNECTION) {
                        this.sock.close();
                        Robustness.BROKEN_UNDERLYING_CONNECTION = false;
                    }
                    if (s == null) {
                        loop = false;
                        continue;
                    }
                    s = s.toLowerCase().trim();
                    if (VERBOSE) {
                        System.out.println("NEW REQUEST: " + s);
                    }
                    if (s.startsWith("get") || s.startsWith("head") || s.startsWith("post")) {
                        byte[] resp;
                        HttpRequestProcessor proc;
                        String head2;
                        if (s.endsWith("1.0")) {
                            loop = false;
                        }
                        s = s.substring(4, s.lastIndexOf("http")).trim();
                        if (VERBOSE) {
                            System.out.println("RESOURCE: " + s);
                        }
                        int contentLen = -1;
                        InfiniteLoop il2 = new InfiniteLoop();
                        while ((head2 = this.nextLine().trim()).length() > 0) {
                            il2.LOOP();
                            if (VERBOSE) {
                                System.out.println("HEADER: " + head2);
                            }
                            if (head2.toLowerCase().indexOf("content-length") == -1) continue;
                            contentLen = Integer.parseInt(head2.substring(head2.lastIndexOf(58) + 1).trim());
                        }
                        boolean isHead = s.startsWith("head");
                        if (isHead) {
                            this.respondHead(null, "application/octet-stream");
                            continue;
                        }
                        if (contentLen == -1) {
                            this.respondBad();
                            continue;
                        }
                        int n = s.indexOf(63);
                        if (n != -1) {
                            s = s.substring(0, n);
                        }
                        if ((n = s.indexOf(35)) != -1) {
                            s = s.substring(0, n);
                        }
                        s = DefaultHttpServerFactory.this.normaliseResource(s);
                        Object object = DefaultHttpServerFactory.this.map_LOCK;
                        synchronized (object) {
                            proc = (HttpRequestProcessor)DefaultHttpServerFactory.this.map.get(s);
                        }
                        if (proc.getLockObject() != null) {
                            object = proc.getLockObject();
                            synchronized (object) {
                                if (proc.isStreamProcessor()) {
                                    if (VERBOSE) {
                                        System.out.println("Processing HTTP STREAM request " + contentLen);
                                    }
                                    this.respondDatStream(proc.getStreamContentLength(), "application/octet-stream");
                                    proc.processHttpRequest(this.sock, this.in, this.out, false, this.addr);
                                } else {
                                    if (VERBOSE) {
                                        System.out.println("Processing HTTP request " + contentLen);
                                    }
                                    resp = proc.processHttpRequest(this.readBytes(this.in, contentLen), false, this.addr);
                                    if (VERBOSE) {
                                        System.out.println("Processed HTTP request " + resp.length);
                                    }
                                    this.respondDat(resp, "application/octet-stream");
                                }
                                continue;
                            }
                        }
                        if (proc.isStreamProcessor()) {
                            if (VERBOSE) {
                                System.out.println("Processing HTTP STREAM request " + contentLen);
                            }
                            this.respondDatStream(proc.getStreamContentLength(), "application/octet-stream");
                            proc.processHttpRequest(this.sock, this.in, this.out, false, this.addr);
                            continue;
                        }
                        if (VERBOSE) {
                            System.out.println("Processing HTTP request " + contentLen);
                        }
                        resp = proc.processHttpRequest(this.readBytes(this.in, contentLen), false, this.addr);
                        if (VERBOSE) {
                            System.out.println("Processed HTTP request " + resp.length);
                        }
                        this.respondDat(resp, "application/octet-stream");
                        continue;
                    }
                    InfiniteLoop il2 = new InfiniteLoop();
                    while ((head = this.nextLine().trim()).length() > 0) {
                        il2.LOOP();
                        if (!VERBOSE) continue;
                        System.out.println("HEADER: " + head);
                    }
                    this.respondBad();
                }
                catch (Exception e) {
                    try {
                        this.sock.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (e instanceof SocketTimeoutException || OK && e instanceof IOException || e instanceof IOException || e instanceof SocketException) {
                        // empty if block
                    }
                    loop = false;
                }
            }
            try {
                this.sock.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void respondDatStream(int len, String mime) throws IOException {
            this.write("HTTP/1.1 200 OK");
            this.write("Content-Type: " + mime);
            this.write("Content-Length: " + len);
            this.write("");
            this.out.flush();
        }

        private void respondDat(byte[] dat, String mime) throws IOException {
            this.write("HTTP/1.1 200 OK");
            this.write("Content-Type: " + mime);
            this.write("Content-Length: " + dat.length);
            this.write("");
            this.out.write(dat);
            this.out.flush();
        }

        private void respondHead(byte[] dat, String mime) throws IOException {
            this.write("HTTP/1.1 200 OK");
            this.write("Content-Type: " + mime);
            if (dat != null) {
                this.write("Content-Length: " + dat.length);
            }
            this.write("");
            this.out.flush();
        }

        private void respondBad() throws IOException {
            this.write("HTTP/1.1 501 Not Implemented");
        }

        private String nextLine() throws IOException {
            return new String(this.readLine(this.in), "ASCII");
        }

        private void write(String str) throws IOException {
            str = str + "\r\n";
            this.out.write(str.getBytes("ASCII"));
            this.out.flush();
            if (VERBOSE) {
                System.out.println("RESPONSE: " + str);
            }
        }

        private byte[] readLine(InputStream in) throws IOException {
            ByteArrayOutputStream bout = new ByteArrayOutputStream();
            int last = -1;
            int c = in.read();
            if (c == -1) {
                throw new IOException("End of stream");
            }
            InfiniteLoop il = new InfiniteLoop();
            while (c != 10 && c != -1) {
                il.LOOP();
                if (last != -1) {
                    bout.write(last);
                }
                last = c;
                c = in.read();
            }
            if (last != -1 && last != 13) {
                bout.write(last);
            }
            return bout.toByteArray();
        }

        private byte[] readBytes(InputStream in, int len) throws IOException {
            byte[] b = new byte[len];
            int red = 0;
            InfiniteLoop il = new InfiniteLoop();
            for (int tot = 0; tot < len; tot += red) {
                il.LOOP();
                red = in.read(b, tot, len - tot);
                if (red != -1) continue;
                throw new EOFException("End of stream");
            }
            return b;
        }
    }

    private class PortServer
    extends Thread {
        ServerSocket ssock;

        public PortServer(int port) throws Exception {
            this.setName("DefaultHttpServerFactory$PortServer");
            this.ssock = new ServerSocket(port);
            this.setDaemon(true);
            this.setPriority(10);
        }

        @Override
        public void run() {
            InfiniteLoop il = new InfiniteLoop();
            while (true) {
                il.LOOP();
                try {
                    Socket sock = this.ssock.accept();
                    new ConnectionServer(sock).start();
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

