/*
 * Decompiled with CFR 0.152.
 */
package com.aem.nodelink;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class ConnectionTrace
extends IOException {
    boolean graceful;
    boolean printed = false;

    public ConnectionTrace(boolean graceful, String s) {
        super(s);
        this.graceful = graceful;
    }

    public boolean wasGraceful() {
        return this.graceful;
    }

    public void printShort(PrintStream pout) {
        this.printed = true;
        pout.println("NL Connection Trace (" + this.getMessage() + ")");
    }

    @Override
    public void printStackTrace(PrintStream pout) {
        StackTraceElement elem;
        String method;
        StackTraceElement[] elems;
        boolean full = !this.printed;
        this.printed = true;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        PrintStream pp = new PrintStream(bout);
        pp.println("NL Connection Trace (" + this.getMessage() + "):");
        StackTraceElement[] stackTraceElementArray = elems = this.getStackTrace();
        int n = stackTraceElementArray.length;
        for (int i = 0; i < n && !(method = (elem = stackTraceElementArray[i]).getMethodName()).equals("invoke0") && !method.equals("invoke"); ++i) {
            pp.println("-- " + method + " " + elem.getFileName() + ":" + elem.getLineNumber() + " (" + elem.getClassName() + ")");
            if (!full) break;
        }
        pout.println(new String(bout.toByteArray()));
    }

    @Override
    public void printStackTrace() {
        this.printStackTrace(System.out);
    }

    public static void main(String[] args) throws Exception {
        ConnectionTrace trace = new ConnectionTrace(true, "test");
        trace.printStackTrace();
    }
}

