/*
 * Decompiled with CFR 0.152.
 */
package com.aem.gstore;

import com.aem.gstore.DataBlock;
import com.aem.gstore.GenCollator;
import com.aem.gstore.GenStore;
import com.aem.gstore.MachinesProcessor;
import com.aem.gstore.StorePacket;
import com.aem.gstore.StoreProcessor;
import java.util.HashMap;
import utils.progtools.TimeoutMap;
import utils.progtools.TimeoutMapListener;

public class MachinesCollator
implements StoreProcessor,
TimeoutMapListener<Long, GenCollator> {
    static final boolean alwaysTimeoutOnPacket = true;
    static final boolean timeoutToAllowStreamToFinish = true;
    static final int streamTimeoutMs = 250;
    int MAX_CONCURRENT = 50;
    int TIMEOUT = 30000;
    Object map_LOCK = new Object();
    HashMap<Long, Long> nextreqs = new HashMap();
    TimeoutMap<Long, GenCollator> map = new TimeoutMap(250);
    MachinesProcessor mproc;

    public MachinesCollator(MachinesProcessor proc, int maxConcurrentUploads, int uploadTimeoutMs) {
        this.MAX_CONCURRENT = maxConcurrentUploads;
        this.TIMEOUT = uploadTimeoutMs;
        this.mproc = proc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getNextReqFor(Long machineID) {
        Object object = this.map_LOCK;
        synchronized (object) {
            Long last = this.nextreqs.get(machineID);
            if (last == null) {
                return 0L;
            }
            return last;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialiseNextReqFor(Long machineID, long lastValid) {
        Object object = this.map_LOCK;
        synchronized (object) {
            this.nextreqs.put(machineID, lastValid);
            this.map.remove(machineID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNextReqFor(Long machineID, long lastValid) {
        Object object = this.map_LOCK;
        synchronized (object) {
            this.nextreqs.put(machineID, lastValid);
        }
    }

    public boolean claimDataTransferTicket(Long machineID) {
        return this.collatorForMachine(machineID) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GenCollator collatorForMachine(Long machineID) {
        Object object = this.map_LOCK;
        synchronized (object) {
            GenCollator collator = this.map.get(machineID);
            if (collator == null) {
                if (this.map.size() < this.MAX_CONCURRENT) {
                    collator = new GenCollator(this, machineID);
                    collator.restoreNextRequiredIndex(this.getNextReqFor(machineID));
                    this.map.put(machineID, collator, this.TIMEOUT, this);
                    if (GenStore.DEBUG_COLLATION_CONCURRENCY) {
                        System.out.println("[GenStoreCollators] GenStore concurrency tickets v" + this.map.size() + " for SG_" + machineID);
                    }
                } else if (GenStore.DEBUG_COLLATION_CONCURRENCY) {
                    System.out.println("[GenStoreCollators] GenStore concurrency limited (" + this.map.size() + ")");
                }
            }
            return collator;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getNextRequiredIndex(Long machineID) {
        Object object = this.map_LOCK;
        synchronized (object) {
            GenCollator collator = this.map.get(machineID);
            if (collator != null) {
                return collator.getNextRequiredIndex();
            }
            return this.getNextReqFor(machineID);
        }
    }

    public void receivedBlock(Long machineID, DataBlock db) {
        GenCollator collator = this.collatorForMachine(machineID);
        if (collator != null) {
            collator.receivedBlock(db);
            this.updateNextReqFor(machineID, collator.getNextRequiredIndex());
            if (GenStore.DEBUG_GENSTORE_UPDATES) {
                System.out.println("[GenStoreServer] Collator for " + machineID + " received " + db + " now at " + collator.getNextRequiredIndex() + " / " + this.getNextRequiredIndex(machineID));
            }
        }
        this.map.put(machineID, collator, 250L, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processStorePacket(StorePacket packet, GenCollator collator, Object userObject) {
        Long machineID = (Long)userObject;
        if (collator.isEmpty()) {
            Object object = this.map_LOCK;
            synchronized (object) {
            }
        }
        this.mproc.processStorePacket(packet, machineID);
    }

    @Override
    public void objectTimedOut(Long key, GenCollator val) {
        if (GenStore.DEBUG_COLLATION_TIMEOUTS) {
            System.out.println("[GenStoreCollators] Collation timed out for " + key + " has " + val.unfinishedPackets());
        }
        if (GenStore.DEBUG_COLLATION_CONCURRENCY) {
            System.out.println("[GenStoreCollators] GenStore concurrency tickets ^" + this.map.size() + "");
        }
    }
}

