/*
 * Decompiled with CFR 0.152.
 */
package bcutil;

import bcutil.BCUtil;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import utils.string.Base64;

public class SaltedHashPasswordUtil {
    public static String hashPassword(String password) throws IOException {
        return SaltedHashPasswordUtil.hashPasswordWithSalt(password, BCUtil.generateBase64Salt((int)24));
    }

    public static String hashPasswordWithSalt(String pword, String salt) throws IOException {
        byte[] saltBytes;
        byte[] passwordBytes;
        if (pword == null || salt == null) {
            return null;
        }
        try {
            passwordBytes = pword.getBytes("UnicodeBig");
        }
        catch (Exception x) {
            passwordBytes = pword.getBytes("UTF-8");
        }
        try {
            saltBytes = pword.getBytes("UnicodeBig");
        }
        catch (Exception x) {
            saltBytes = pword.getBytes("UTF-8");
        }
        MessageDigest digest = null;
        try {
            digest = MessageDigest.getInstance("SHA1");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            throw new IOException(e);
        }
        digest.update(saltBytes);
        digest.update(passwordBytes);
        byte[] result = digest.digest();
        return salt + ":" + Base64.byteArrayToBase64((byte[])result);
    }

    public static boolean checkHashMatchesPassword(String hashedPassword, String password) throws IOException {
        if (hashedPassword == null || password == null) {
            return false;
        }
        int colon = hashedPassword.indexOf(58);
        if (colon == -1) {
            return false;
        }
        String salt = hashedPassword.substring(0, colon);
        String newHash = SaltedHashPasswordUtil.hashPasswordWithSalt(password, salt);
        return hashedPassword.equals(newHash);
    }

    public static void main(String[] args) throws IOException {
        String hashedPassword = SaltedHashPasswordUtil.hashPassword("abcd1234");
        System.out.println(hashedPassword);
        System.out.println(SaltedHashPasswordUtil.checkHashMatchesPassword(hashedPassword, "password"));
        System.out.println(SaltedHashPasswordUtil.checkHashMatchesPassword(hashedPassword, "abcd1234"));
    }
}

