/*
 * Decompiled with CFR 0.152.
 */
package aurelienribon.slidinglayout;

import aurelienribon.slidinglayout.SLConfig;
import aurelienribon.slidinglayout.SLSide;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class SLKeyframe {
    private final SLConfig cfg;
    private final float duration;
    private final Map<SLSide, List<Component>> cmpsWithStartSide = new EnumMap<SLSide, List<Component>>(SLSide.class);
    private final Map<SLSide, List<Component>> cmpsWithEndSide = new EnumMap<SLSide, List<Component>>(SLSide.class);
    private final Map<Component, SLConfig.Tile> targetTiles = new HashMap<Component, SLConfig.Tile>();
    private final Map<Component, Float> delays = new HashMap<Component, Float>();
    private final List<Component> cmpsToAddAfterTransition = new ArrayList<Component>();
    private final List<Component> cmpsToRemoveAfterTransition = new ArrayList<Component>();
    private Callback callback;
    private SLSide sideForNewCmps = null;
    private SLSide sideForOldCmps = null;

    public SLKeyframe(SLConfig cfg, float duration) {
        this.cfg = cfg;
        this.duration = duration;
        for (SLSide s : SLSide.values()) {
            this.cmpsWithStartSide.put(s, new ArrayList());
            this.cmpsWithEndSide.put(s, new ArrayList());
        }
    }

    public SLKeyframe setStartSide(SLSide side, Component ... cmps) {
        this.cmpsWithStartSide.get((Object)side).addAll(Arrays.asList(cmps));
        return this;
    }

    public SLKeyframe setStartSideForNewCmps(SLSide side) {
        this.sideForNewCmps = side;
        return this;
    }

    public SLKeyframe setEndSide(SLSide side, Component ... cmps) {
        this.cmpsWithEndSide.get((Object)side).addAll(Arrays.asList(cmps));
        return this;
    }

    public SLKeyframe setEndSideForOldCmps(SLSide side) {
        this.sideForOldCmps = side;
        return this;
    }

    public SLKeyframe setDelay(float delay, Component ... cmps) {
        for (Component c : cmps) {
            this.delays.put(c, Float.valueOf(delay));
        }
        return this;
    }

    public SLKeyframe setDelayIncr(float delay, Component ... cmps) {
        float d = 0.0f;
        for (Component c : cmps) {
            this.delays.put(c, Float.valueOf(d += delay));
        }
        return this;
    }

    public SLKeyframe addDelay(float delay, Component ... cmps) {
        for (Component c : cmps) {
            this.delays.put(c, Float.valueOf(this.delays.get(c).floatValue() + delay));
        }
        return this;
    }

    public SLKeyframe addDelayIncr(float delay, Component ... cmps) {
        float d = 0.0f;
        for (Component c : cmps) {
            this.delays.put(c, Float.valueOf(this.delays.get(c).floatValue() + (d += delay)));
        }
        return this;
    }

    public SLKeyframe setCallback(Callback callback) {
        this.callback = callback;
        return this;
    }

    public float getDelay(Component cmp) {
        return this.delays.containsKey(cmp) ? this.delays.get(cmp).floatValue() : 0.0f;
    }

    public Callback getCallback() {
        return this.callback;
    }

    public float getDuration() {
        return this.duration;
    }

    void initialize(SLKeyframe prevKf) {
        this.cfg.placeAndRoute();
        HashMap<Component, SLConfig.Tile> startTiles = new HashMap<Component, SLConfig.Tile>();
        for (Component c : this.cfg.getCmps()) {
            this.targetTiles.put(c, this.cfg.getTile(c).clone());
        }
        ArrayList<Component> newCmps = new ArrayList<Component>();
        newCmps.addAll(this.cfg.getCmps());
        newCmps.removeAll(prevKf.cfg.getCmps());
        ArrayList<Component> oldCmps = new ArrayList<Component>();
        oldCmps.addAll(prevKf.cfg.getCmps());
        oldCmps.removeAll(this.cfg.getCmps());
        if (this.sideForNewCmps != null) {
            for (Component c : newCmps) {
                if (this.isPartOf(c, this.cmpsWithStartSide)) continue;
                this.cmpsWithStartSide.get((Object)this.sideForNewCmps).add(c);
            }
        }
        if (this.sideForOldCmps != null) {
            for (Component c : oldCmps) {
                if (this.isPartOf(c, this.cmpsWithEndSide)) continue;
                this.cmpsWithEndSide.get((Object)this.sideForOldCmps).add(c);
            }
        }
        for (Component c : newCmps) {
            if (this.isPartOf(c, this.cmpsWithStartSide)) {
                this.cfg.getPanel().add(c, new Integer(1));
                startTiles.put(c, this.cfg.getTile(c).clone());
                continue;
            }
            this.cmpsToAddAfterTransition.add(c);
            SLConfig.Tile t = this.cfg.getTile(c);
            c.setBounds(t.x, t.y, t.w, t.h);
            c.validate();
        }
        for (Component c : oldCmps) {
            if (this.isPartOf(c, this.cmpsWithEndSide)) {
                this.cmpsToRemoveAfterTransition.add(c);
                this.targetTiles.put(c, prevKf.cfg.getTile(c).clone());
                continue;
            }
            this.cfg.getPanel().remove(c);
        }
        for (SLSide s : SLSide.values()) {
            this.hideTiles(this.getTiles(this.cmpsWithStartSide.get((Object)s), startTiles), s);
            this.hideTiles(this.getTiles(this.cmpsWithEndSide.get((Object)s), this.targetTiles), s);
        }
        for (Component c : startTiles.keySet()) {
            SLConfig.Tile t = (SLConfig.Tile)startTiles.get(c);
            c.setBounds(t.x, t.y, t.w, t.h);
            c.validate();
        }
    }

    Set<Component> getCmps() {
        return this.targetTiles.keySet();
    }

    List<Component> getCmpsToAddAfterTransition() {
        return this.cmpsToAddAfterTransition;
    }

    List<Component> getCmpsToRemoveAfterTransition() {
        return this.cmpsToRemoveAfterTransition;
    }

    SLConfig.Tile getTarget(Component cmp) {
        return this.targetTiles.get(cmp);
    }

    SLConfig getCfg() {
        return this.cfg;
    }

    private boolean isPartOf(Component c, Map<SLSide, List<Component>> map) {
        for (SLSide s : SLSide.values()) {
            if (!map.get((Object)s).contains(c)) continue;
            return true;
        }
        return false;
    }

    private List<SLConfig.Tile> getTiles(List<Component> cmps, Map<Component, SLConfig.Tile> cmpsMap) {
        ArrayList<SLConfig.Tile> tiles = new ArrayList<SLConfig.Tile>();
        for (Component c : cmps) {
            tiles.add(cmpsMap.get(c));
        }
        return tiles;
    }

    private void hideTiles(List<SLConfig.Tile> tiles, SLSide side) {
        if (tiles.isEmpty()) {
            return;
        }
        int w = this.cfg.getPanel().getWidth();
        int h = this.cfg.getPanel().getHeight();
        switch (side) {
            case TOP: {
                int maxY = tiles.get((int)0).y + tiles.get((int)0).h;
                for (SLConfig.Tile t : tiles) {
                    maxY = Math.max(maxY, t.y + t.h);
                }
                for (SLConfig.Tile t : tiles) {
                    t.y -= maxY;
                }
                break;
            }
            case BOTTOM: {
                int minY = tiles.get((int)0).y;
                for (SLConfig.Tile t : tiles) {
                    minY = Math.min(minY, t.y);
                }
                for (SLConfig.Tile t : tiles) {
                    t.y += h - minY;
                }
                break;
            }
            case LEFT: {
                int maxX = tiles.get((int)0).x + tiles.get((int)0).w;
                for (SLConfig.Tile t : tiles) {
                    maxX = Math.max(maxX, t.x + t.w);
                }
                for (SLConfig.Tile t : tiles) {
                    t.x -= maxX;
                }
                break;
            }
            case RIGHT: {
                int minX = tiles.get((int)0).x;
                for (SLConfig.Tile t : tiles) {
                    minX = Math.min(minX, t.x);
                }
                for (SLConfig.Tile t : tiles) {
                    t.x += w - minX;
                }
                break;
            }
        }
    }

    public static interface Callback {
        public void done();
    }
}

