/*
 * Decompiled with CFR 0.152.
 */
package aurelienribon.slidinglayout;

import aurelienribon.slidinglayout.SLPanel;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SLConfig {
    private final SLPanel panel;
    private final Map<Component, Tile> tiles = new HashMap<Component, Tile>();
    private Grid rootGrid;
    private Grid currentGrid = this.rootGrid = new Grid();
    private int hgap = 0;
    private int vgap = 0;

    public SLConfig(SLPanel panel) {
        this.panel = panel;
    }

    public SLConfig gap(int hgap, int vgap) {
        this.hgap = hgap;
        this.vgap = vgap;
        return this;
    }

    public SLConfig col(float relativeWidth) {
        Column column = new Column();
        column.fixedWidth = false;
        column.relWidth = relativeWidth;
        column.w = 0;
        this.currentGrid.cols.add(column);
        return this;
    }

    public SLConfig col(int width) {
        Column column = new Column();
        column.fixedWidth = true;
        column.relWidth = 1.0f;
        column.w = width;
        this.currentGrid.cols.add(column);
        return this;
    }

    public SLConfig row(float relativeHeight) {
        Row row = new Row();
        row.fixedHeight = false;
        row.relHeight = relativeHeight;
        row.h = 0;
        this.currentGrid.rows.add(row);
        return this;
    }

    public SLConfig row(int height) {
        Row row = new Row();
        row.fixedHeight = true;
        row.relHeight = 1.0f;
        row.h = height;
        this.currentGrid.rows.add(row);
        return this;
    }

    public SLConfig beginGrid(int row, int col) {
        Grid grid = new Grid();
        grid.parent = this.currentGrid;
        grid.row = row;
        grid.col = col;
        this.currentGrid.tiles.add(grid);
        this.currentGrid = grid;
        return this;
    }

    public SLConfig endGrid() {
        this.currentGrid = this.currentGrid.parent;
        return this;
    }

    public SLConfig place(int row, int col, Component cmp) {
        Tile tile = new Tile();
        tile.parent = this.currentGrid;
        tile.row = row;
        tile.col = col;
        this.currentGrid.tiles.add(tile);
        this.tiles.put(cmp, tile);
        return this;
    }

    SLPanel getPanel() {
        return this.panel;
    }

    List<Component> getCmps() {
        return new ArrayList<Component>(this.tiles.keySet());
    }

    Tile getTile(Component cmp) {
        return this.tiles.get(cmp);
    }

    List<Tile> getTiles(List<Component> cmps) {
        ArrayList<Tile> ts = new ArrayList<Tile>();
        for (Component c : cmps) {
            ts.add(this.tiles.get(c));
        }
        return ts;
    }

    void placeAndRoute() {
        this.rootGrid.x = this.hgap;
        this.rootGrid.y = this.vgap;
        this.rootGrid.w = this.panel.getWidth() - this.hgap * 2;
        this.rootGrid.h = this.panel.getHeight() - this.vgap * 2;
        this.placeAndRoute(this.rootGrid);
    }

    private void placeAndRoute(Grid grid) {
        float totalRelHeight = 0.0f;
        int totalHeight = grid.h - this.vgap * (grid.rows.size() - 1);
        for (Row r : grid.rows) {
            if (r.fixedHeight) {
                totalHeight -= r.h;
                continue;
            }
            totalRelHeight += r.relHeight;
        }
        for (Row r : grid.rows) {
            if (r.fixedHeight) continue;
            r.h = (int)((float)totalHeight * r.relHeight / totalRelHeight);
        }
        float totalRelWidth = 0.0f;
        int totalWidth = grid.w - this.hgap * (grid.cols.size() - 1);
        for (Column c : grid.cols) {
            if (c.fixedWidth) {
                totalWidth -= c.w;
                continue;
            }
            totalRelWidth += c.relWidth;
        }
        for (Column c : grid.cols) {
            if (c.fixedWidth) continue;
            c.w = (int)((float)totalWidth * c.relWidth / totalRelWidth);
        }
        int x = grid.x;
        int y = grid.y;
        for (int iRow = 0; iRow < grid.rows.size(); ++iRow) {
            for (int iCol = 0; iCol < grid.cols.size(); ++iCol) {
                for (Tile t : grid.tiles) {
                    if (t.row != iRow || t.col != iCol) continue;
                    t.x = x;
                    t.y = y;
                    t.w = grid.cols.get((int)t.col).w;
                    t.h = grid.rows.get((int)t.row).h;
                    if (!(t instanceof Grid)) continue;
                    this.placeAndRoute((Grid)t);
                }
                x += grid.cols.get((int)iCol).w + this.hgap;
            }
            x = grid.x;
            y += grid.rows.get((int)iRow).h + this.vgap;
        }
    }

    private static class Column {
        public boolean fixedWidth;
        public float relWidth;
        public int w;

        private Column() {
        }
    }

    private static class Row {
        public boolean fixedHeight;
        public float relHeight;
        public int h;

        private Row() {
        }
    }

    private static class Grid
    extends Tile {
        public final List<Row> rows = new ArrayList<Row>();
        public final List<Column> cols = new ArrayList<Column>();
        public final List<Tile> tiles = new ArrayList<Tile>();

        private Grid() {
        }
    }

    static class Tile {
        public Grid parent;
        public int row;
        public int col;
        public int x;
        public int y;
        public int w;
        public int h;

        Tile() {
        }

        public Tile clone() {
            Tile t = new Tile();
            t.parent = this.parent;
            t.row = this.row;
            t.col = this.col;
            t.x = this.x;
            t.y = this.y;
            t.w = this.w;
            t.h = this.h;
            return t;
        }
    }
}

